/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.simple;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.contrib.table.model.ITableRendererSource;
import org.apache.tapestry.contrib.table.model.common.AbstractTableColumn;
import org.apache.tapestry.contrib.table.model.simple.ColumnComparator;
import org.apache.tapestry.contrib.table.model.simple.ITableColumnEvaluator;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnFormRendererSource;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnRendererSource;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableValueRendererSource;

public class SimpleTableColumn
extends AbstractTableColumn {
    public static final ITableRendererSource DEFAULT_COLUMN_RENDERER_SOURCE = new SimpleTableColumnRendererSource();
    public static final ITableRendererSource FORM_COLUMN_RENDERER_SOURCE = new SimpleTableColumnFormRendererSource();
    public static final ITableRendererSource DEFAULT_VALUE_RENDERER_SOURCE = new SimpleTableValueRendererSource();
    private String m_strDisplayName;
    private ITableColumnEvaluator m_objEvaluator;

    public SimpleTableColumn(String strColumnName) {
        this(strColumnName, strColumnName);
    }

    public SimpleTableColumn(String strColumnName, boolean bSortable) {
        this(strColumnName, strColumnName, bSortable);
    }

    public SimpleTableColumn(String strColumnName, ITableColumnEvaluator objEvaluator, boolean bSortable) {
        this(strColumnName, strColumnName, objEvaluator, bSortable);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName) {
        this(strColumnName, strDisplayName, false);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName, boolean bSortable) {
        this(strColumnName, strDisplayName, null, bSortable);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName, ITableColumnEvaluator objEvaluator, boolean bSortable) {
        super(strColumnName, bSortable, null);
        this.setComparator(new DefaultTableComparator());
        this.setDisplayName(strDisplayName);
        this.setColumnRendererSource(DEFAULT_COLUMN_RENDERER_SOURCE);
        this.setValueRendererSource(DEFAULT_VALUE_RENDERER_SOURCE);
        this.setEvaluator(objEvaluator);
    }

    public String getDisplayName() {
        return this.m_strDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.m_strDisplayName = displayName;
    }

    public ITableColumnEvaluator getEvaluator() {
        return this.m_objEvaluator;
    }

    public void setEvaluator(ITableColumnEvaluator evaluator) {
        this.m_objEvaluator = evaluator;
    }

    public void setColumnComparator(Comparator comparator) {
        this.setComparator(new ColumnComparator(this, comparator));
    }

    public Object getColumnValue(Object objRow) {
        ITableColumnEvaluator objEvaluator = this.getEvaluator();
        if (objEvaluator != null) {
            return objEvaluator.getColumnValue(this, objRow);
        }
        return objRow.toString();
    }

    public void loadSettings(IComponent objSettingsContainer) {
        String strDisplayName = objSettingsContainer.getMessages().getMessage(this.getColumnName(), null);
        if (strDisplayName != null) {
            this.setDisplayName(strDisplayName);
        }
        super.loadSettings(objSettingsContainer);
    }

    public class DefaultTableComparator
    implements Comparator,
    Serializable {
        public int compare(Object objRow1, Object objRow2) {
            Object objValue2;
            Object objValue1 = SimpleTableColumn.this.getColumnValue(objRow1);
            if (objValue1 == (objValue2 = SimpleTableColumn.this.getColumnValue(objRow2))) {
                return 0;
            }
            boolean bComparable1 = objValue1 instanceof Comparable;
            boolean bComparable2 = objValue2 instanceof Comparable;
            if (!bComparable1 && !bComparable2) {
                return 0;
            }
            if (!bComparable1) {
                return -1;
            }
            if (!bComparable2) {
                return 1;
            }
            return ((Comparable)objValue1).compareTo(objValue2);
        }
    }
}

