/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javassist.ClassPath;
import javassist.NotFoundException;

final class JarClassPath
implements ClassPath {
    ZipFile jarfile;

    JarClassPath(String pathname) throws NotFoundException {
        try {
            this.jarfile = new ZipFile(pathname);
            return;
        }
        catch (ZipException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new NotFoundException(pathname);
    }

    public InputStream openClassfile(String classname) throws NotFoundException {
        try {
            String jarname = classname.replace('.', '/') + ".class";
            ZipEntry ze = this.jarfile.getEntry(jarname);
            if (ze != null) {
                return this.jarfile.getInputStream(ze);
            }
            return null;
        }
        catch (ZipException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new NotFoundException("broken jar file?: " + this.jarfile.getName());
    }

    public void close() {
        try {
            this.jarfile.close();
            this.jarfile = null;
        }
        catch (IOException e) {}
    }

    public String toString() {
        return this.jarfile == null ? "<null>" : this.jarfile.toString();
    }
}

