/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.wml;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.Form;

public abstract class AbstractPostfield
extends AbstractFormComponent {
    public IForm getForm(IRequestCycle cycle) {
        IForm result = Form.get(cycle);
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Postfield.must-be-contained-by-go"), this, null, null);
        }
        this.setForm(result);
        return result;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        if (!rewinding && cycle.isRewinding()) {
            return;
        }
        String name = form.getElementId(this);
        if (rewinding) {
            this.rewind(cycle);
            return;
        }
        writer.beginEmpty("postfield");
        writer.attribute("name", name);
        String varName = this.getVarName();
        writer.attributeRaw("value", varName != null ? this.getEncodedVarName(varName) : "");
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    protected abstract void rewind(IRequestCycle var1);

    private String getEncodedVarName(String varName) {
        return "$(" + varName + ")";
    }

    public boolean isDisabled() {
        return false;
    }

    public abstract String getVarName();

    public abstract IBinding getValueBinding();

    public void updateValue(Object value) {
        this.getValueBinding().setObject(value);
    }

    public abstract IForm getForm();

    public abstract void setForm(IForm var1);

    public abstract String getName();

    public abstract void setName(String var1);
}

