/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.io.Serializable;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;

public class ComponentAddress
implements Serializable {
    private String _pageName;
    private String _idPath;

    public ComponentAddress(IComponent component) {
        this(component.getPage().getPageName(), component.getIdPath());
    }

    public ComponentAddress(String pageName, String idPath) {
        this._pageName = pageName;
        this._idPath = idPath;
    }

    public ComponentAddress(INamespace namespace, String pageName, String idPath) {
        this(namespace.constructQualifiedName(pageName), idPath);
    }

    public IComponent findComponent(IRequestCycle cycle) {
        IPage objPage = cycle.getPage(this._pageName);
        return objPage.getNestedComponent(this._idPath);
    }

    public String getIdPath() {
        return this._idPath;
    }

    public String getPageName() {
        return this._pageName;
    }

    public int hashCode() {
        int hash = this._pageName.hashCode() * 31;
        if (this._idPath != null) {
            hash += this._idPath.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        String idPath2;
        if (!(obj instanceof ComponentAddress)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ComponentAddress objAddress = (ComponentAddress)obj;
        if (!this.getPageName().equals(objAddress.getPageName())) {
            return false;
        }
        String idPath1 = this.getIdPath();
        return idPath1 == (idPath2 = objAddress.getIdPath()) || idPath1 != null && idPath1.equals(idPath2);
    }
}

