/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Location;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.AttributeType;
import org.apache.tapestry.parse.CloseToken;
import org.apache.tapestry.parse.ITemplateParserDelegate;
import org.apache.tapestry.parse.LocalizationToken;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.parse.TemplateParseException;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.util.IdAllocator;

public class TemplateParser {
    public static final String OGNL_EXPRESSION_PREFIX = "ognl:";
    public static final String LOCALIZATION_KEY_PREFIX = "message:";
    private static final String REMOVE_ID = "$remove$";
    private static final String CONTENT_ID = "$content$";
    public static final String LOCALIZATION_KEY_ATTRIBUTE_NAME = "key";
    public static final String RAW_ATTRIBUTE_NAME = "raw";
    public static final String JWCID_ATTRIBUTE_NAME = "jwcid";
    private static final String PROPERTY_NAME_PATTERN = "_?[a-zA-Z]\\w*";
    public static final String SIMPLE_ID_PATTERN = "^(_?[a-zA-Z]\\w*)$";
    public static final String IMPLICIT_ID_PATTERN = "^(_?[a-zA-Z]\\w*)?@(((_?[a-zA-Z]\\w*):)?(_?[a-zA-Z]\\w*))$";
    private static final int IMPLICIT_ID_PATTERN_ID_GROUP = 1;
    private static final int IMPLICIT_ID_PATTERN_TYPE_GROUP = 2;
    private static final int IMPLICIT_ID_PATTERN_LIBRARY_ID_GROUP = 4;
    private static final int IMPLICIT_ID_PATTERN_SIMPLE_TYPE_GROUP = 5;
    private Pattern _simpleIdPattern;
    private Pattern _implicitIdPattern;
    private PatternMatcher _patternMatcher;
    private IdAllocator _idAllocator = new IdAllocator();
    private ITemplateParserDelegate _delegate;
    private IResourceLocation _resourceLocation;
    private ILocation _templateLocation;
    private ILocation _currentLocation;
    private char[] _templateData;
    private List _stack = new ArrayList();
    private List _tokens = new ArrayList();
    private int _cursor;
    private int _blockStart;
    private int _line;
    private boolean _ignoring;
    private Map _attributes = new HashMap();
    protected TemplateTokenFactory _factory;
    private static final char[] COMMENT_START = new char[]{'<', '!', '-', '-'};
    private static final char[] COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] CLOSE_TAG = new char[]{'<', '/'};
    private static final int WAIT_FOR_ATTRIBUTE_NAME = 0;
    private static final int COLLECT_ATTRIBUTE_NAME = 1;
    private static final int ADVANCE_PAST_EQUALS = 2;
    private static final int WAIT_FOR_ATTRIBUTE_VALUE = 3;
    private static final int COLLECT_QUOTED_VALUE = 4;
    private static final int COLLECT_UNQUOTED_VALUE = 5;
    private static final String[] CONVERSIONS = new String[]{"&lt;", "<", "&gt;", ">", "&quot;", "\"", "&amp;", "&"};

    public TemplateParser() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this._simpleIdPattern = compiler.compile(SIMPLE_ID_PATTERN);
            this._implicitIdPattern = compiler.compile(IMPLICIT_ID_PATTERN);
        }
        catch (MalformedPatternException ex) {
            throw new ApplicationRuntimeException(ex);
        }
        this._patternMatcher = new Perl5Matcher();
        this._factory = new TemplateTokenFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateToken[] parse(char[] templateData, ITemplateParserDelegate delegate, IResourceLocation resourceLocation) throws TemplateParseException {
        TemplateToken[] result = null;
        try {
            this.beforeParse(templateData, delegate, resourceLocation);
            this.parse();
            result = this._tokens.toArray(new TemplateToken[this._tokens.size()]);
        }
        finally {
            this.afterParse();
        }
        return result;
    }

    protected void beforeParse(char[] templateData, ITemplateParserDelegate delegate, IResourceLocation resourceLocation) {
        this._templateData = templateData;
        this._resourceLocation = resourceLocation;
        this._templateLocation = new Location(resourceLocation);
        this._delegate = delegate;
        this._ignoring = false;
        this._line = 1;
    }

    protected void afterParse() {
        this._delegate = null;
        this._templateData = null;
        this._resourceLocation = null;
        this._templateLocation = null;
        this._currentLocation = null;
        this._stack.clear();
        this._tokens.clear();
        this._attributes.clear();
        this._idAllocator.clear();
    }

    protected void templateParseProblem(String message, ILocation location, int line, int cursor) throws TemplateParseException {
        throw new TemplateParseException(message, location);
    }

    protected void templateParseProblem(ApplicationRuntimeException exception, int line, int cursor) throws ApplicationRuntimeException {
        throw exception;
    }

    protected List getTokens() {
        if (this._tokens == null) {
            return Collections.EMPTY_LIST;
        }
        return this._tokens;
    }

    private boolean lookahead(char[] match) {
        try {
            for (int i = 0; i < match.length; ++i) {
                if (this._templateData[this._cursor + i] == match[i]) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    protected void parse() throws TemplateParseException {
        this._cursor = 0;
        this._blockStart = -1;
        int length = this._templateData.length;
        while (this._cursor < length) {
            if (this._templateData[this._cursor] != '<') {
                if (this._blockStart < 0 && !this._ignoring) {
                    this._blockStart = this._cursor;
                }
                this.advance();
                continue;
            }
            if (this.lookahead(CLOSE_TAG)) {
                this.closeTag();
                continue;
            }
            if (this.lookahead(COMMENT_START)) {
                this.skipComment();
                continue;
            }
            this.startTag();
        }
        this.addTextToken(this._templateData.length - 1);
    }

    private void skipComment() throws TemplateParseException {
        int length = this._templateData.length;
        int startLine = this._line;
        if (this._blockStart < 0 && !this._ignoring) {
            this._blockStart = this._cursor;
        }
        while (true) {
            if (this._cursor >= length) {
                this.templateParseProblem(Tapestry.format("TemplateParser.comment-not-ended", Integer.toString(startLine)), new Location(this._resourceLocation, startLine), startLine, this._cursor);
            }
            if (this.lookahead(COMMENT_END)) break;
            this.advance();
        }
        this._cursor += COMMENT_END.length;
        this.advanceOverWhitespace();
    }

    private void addTextToken(int end) {
        if (this._blockStart < 0) {
            return;
        }
        if (this._blockStart <= end) {
            TextToken token = this._factory.createTextToken(this._templateData, this._blockStart, end, this._templateLocation);
            this._tokens.add(token);
        }
        this._blockStart = -1;
    }

    private void startTag() throws TemplateParseException {
        int cursorStart = this._cursor;
        int length = this._templateData.length;
        String tagName = null;
        boolean endOfTag = false;
        boolean emptyTag = false;
        int startLine = this._line;
        Location startLocation = new Location(this._resourceLocation, startLine);
        this.tagBeginEvent(startLine, this._cursor);
        this.advance();
        while (this._cursor < length) {
            char ch = this._templateData[this._cursor];
            if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                tagName = new String(this._templateData, cursorStart + 1, this._cursor - cursorStart - 1);
                break;
            }
            this.advance();
        }
        String attributeName = null;
        int attributeNameStart = -1;
        int attributeValueStart = -1;
        int state = 0;
        char quoteChar = '\u0000';
        this._attributes.clear();
        while (!endOfTag) {
            if (this._cursor >= length) {
                String key = tagName == null ? "TemplateParser.unclosed-unknown-tag" : "TemplateParser.unclosed-tag";
                this.templateParseProblem(Tapestry.format(key, tagName, Integer.toString(startLine)), startLocation, startLine, cursorStart);
            }
            char ch = this._templateData[this._cursor];
            switch (state) {
                case 0: {
                    if (ch == '/') {
                        emptyTag = true;
                        this.advance();
                        break;
                    }
                    if (ch == '>') {
                        endOfTag = true;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    attributeNameStart = this._cursor;
                    state = 1;
                    this.advance();
                    break;
                }
                case 1: {
                    if (ch == '=' || ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeName = new String(this._templateData, attributeNameStart, this._cursor - attributeNameStart);
                        state = 2;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 2: {
                    if (ch == '/' || ch == '>') {
                        state = 0;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '=') {
                        state = 3;
                        quoteChar = '\u0000';
                        attributeValueStart = -1;
                        this.advance();
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (ch == '/' || ch == '>') {
                        this.templateParseProblem(Tapestry.format("TemplateParser.missing-attribute-value", tagName, Integer.toString(this._line), attributeName), this.getCurrentLocation(), this._line, this._cursor);
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '\'' || ch == '\"') {
                        quoteChar = ch;
                        state = 4;
                        this.advance();
                        attributeValueStart = this._cursor;
                        this.attributeBeginEvent(attributeName, this._line, attributeValueStart);
                        break;
                    }
                    state = 5;
                    attributeValueStart = this._cursor;
                    this.attributeBeginEvent(attributeName, this._line, attributeValueStart);
                    break;
                }
                case 4: {
                    String attributeValue;
                    if (ch == quoteChar) {
                        attributeValue = new String(this._templateData, attributeValueStart, this._cursor - attributeValueStart);
                        this._attributes.put(attributeName, attributeValue);
                        this.attributeEndEvent(this._cursor);
                        this.advance();
                        state = 0;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 5: {
                    String attributeValue;
                    if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeValue = new String(this._templateData, attributeValueStart, this._cursor - attributeValueStart);
                        this._attributes.put(attributeName, attributeValue);
                        this.attributeEndEvent(this._cursor);
                        state = 0;
                        break;
                    }
                    this.advance();
                }
            }
        }
        this.tagEndEvent(this._cursor);
        String localizationKey = this.findValueCaselessly(LOCALIZATION_KEY_ATTRIBUTE_NAME, this._attributes);
        String jwcId = this.findValueCaselessly(JWCID_ATTRIBUTE_NAME, this._attributes);
        if (localizationKey != null && tagName.equalsIgnoreCase("span") && jwcId == null) {
            if (this._ignoring) {
                this.templateParseProblem(Tapestry.format("TemplateParser.component-may-not-be-ignored", tagName, Integer.toString(startLine)), startLocation, startLine, cursorStart);
            }
            if (!emptyTag) {
                Tag tag = new Tag(tagName, startLine);
                tag._component = false;
                tag._removeTag = true;
                tag._ignoringBody = true;
                tag._mustBalance = true;
                this._stack.add(tag);
                this._ignoring = true;
            } else {
                this.advance();
                this.advanceOverWhitespace();
            }
            this.addTextToken(cursorStart - 1);
            boolean raw = this.checkBoolean(RAW_ATTRIBUTE_NAME, this._attributes);
            Map attributes = this.filter(this._attributes, new String[]{LOCALIZATION_KEY_ATTRIBUTE_NAME, RAW_ATTRIBUTE_NAME});
            LocalizationToken token = this._factory.createLocalizationToken(tagName, localizationKey, raw, attributes, startLocation);
            this._tokens.add(token);
            return;
        }
        if (jwcId != null) {
            this.processComponentStart(tagName, jwcId, emptyTag, startLine, cursorStart, startLocation);
            return;
        }
        if (!emptyTag) {
            Tag tag = new Tag(tagName, startLine);
            this._stack.add(tag);
        }
        if (this._blockStart < 0 && !this._ignoring) {
            this._blockStart = cursorStart;
        }
        this.advance();
    }

    protected void tagBeginEvent(int startLine, int cursorPosition) {
    }

    protected void tagEndEvent(int cursorPosition) {
    }

    protected void attributeBeginEvent(String attributeName, int startLine, int cursorPosition) {
    }

    protected void attributeEndEvent(int cursorPosition) {
    }

    private void processComponentStart(String tagName, String jwcId, boolean emptyTag, int startLine, int cursorStart, ILocation startLocation) throws TemplateParseException {
        boolean ignoreBody;
        if (jwcId.equalsIgnoreCase(CONTENT_ID)) {
            this.processContentTag(tagName, startLine, cursorStart, emptyTag);
            return;
        }
        boolean isRemoveId = jwcId.equalsIgnoreCase(REMOVE_ID);
        if (this._ignoring && !isRemoveId) {
            this.templateParseProblem(Tapestry.format("TemplateParser.component-may-not-be-ignored", tagName, Integer.toString(startLine)), startLocation, startLine, cursorStart);
        }
        String type = null;
        boolean allowBody = false;
        if (this._patternMatcher.matches(jwcId, this._implicitIdPattern)) {
            MatchResult match = this._patternMatcher.getMatch();
            jwcId = match.group(1);
            type = match.group(2);
            String libraryId = match.group(4);
            String simpleType = match.group(5);
            if (jwcId == null) {
                jwcId = this._idAllocator.allocateId("$" + simpleType);
            }
            try {
                allowBody = this._delegate.getAllowBody(libraryId, simpleType, startLocation);
            }
            catch (ApplicationRuntimeException e) {
                this.templateParseProblem(e, startLine, cursorStart);
            }
        } else if (!isRemoveId) {
            if (!this._patternMatcher.matches(jwcId, this._simpleIdPattern)) {
                this.templateParseProblem(Tapestry.format("TemplateParser.component-id-invalid", tagName, Integer.toString(startLine), jwcId), startLocation, startLine, cursorStart);
            }
            if (!this._delegate.getKnownComponent(jwcId)) {
                this.templateParseProblem(Tapestry.format("TemplateParser.unknown-component-id", tagName, Integer.toString(startLine), jwcId), startLocation, startLine, cursorStart);
            }
            try {
                allowBody = this._delegate.getAllowBody(jwcId, startLocation);
            }
            catch (ApplicationRuntimeException e) {
                this.templateParseProblem(e, startLine, cursorStart);
            }
        }
        boolean bl = ignoreBody = !emptyTag && (isRemoveId || !allowBody);
        if (this._ignoring && ignoreBody) {
            this.templateParseProblem(Tapestry.format("TemplateParser.nested-ignore", tagName, Integer.toString(startLine)), new Location(this._resourceLocation, startLine), startLine, cursorStart);
        }
        if (!emptyTag) {
            this.pushNewTag(tagName, startLine, isRemoveId, ignoreBody);
        }
        this.addTextToken(cursorStart - 1);
        if (!isRemoveId) {
            this.addOpenToken(tagName, jwcId, type, startLocation);
            if (emptyTag) {
                this._tokens.add(this._factory.createCloseToken(tagName, this.getCurrentLocation()));
            }
        }
        this.advance();
    }

    private void pushNewTag(String tagName, int startLine, boolean isRemoveId, boolean ignoreBody) {
        Tag tag = new Tag(tagName, startLine);
        tag._component = !isRemoveId;
        tag._removeTag = isRemoveId;
        this._ignoring = tag._ignoringBody = ignoreBody;
        tag._mustBalance = true;
        this._stack.add(tag);
    }

    private void processContentTag(String tagName, int startLine, int cursorStart, boolean emptyTag) throws TemplateParseException {
        if (this._ignoring) {
            this.templateParseProblem(Tapestry.format("TemplateParser.content-block-may-not-be-ignored", tagName, Integer.toString(startLine)), new Location(this._resourceLocation, startLine), startLine, cursorStart);
        }
        if (emptyTag) {
            this.templateParseProblem(Tapestry.format("TemplateParser.content-block-may-not-be-empty", tagName, Integer.toString(startLine)), new Location(this._resourceLocation, startLine), startLine, cursorStart);
        }
        this._tokens.clear();
        this._blockStart = -1;
        Tag tag = new Tag(tagName, startLine);
        tag._mustBalance = true;
        tag._content = true;
        this._stack.clear();
        this._stack.add(tag);
        this.advance();
    }

    private void addOpenToken(String tagName, String jwcId, String type, ILocation location) {
        OpenToken token = this._factory.createOpenToken(tagName, jwcId, type, location);
        this._tokens.add(token);
        if (this._attributes.isEmpty()) {
            return;
        }
        Iterator i = this._attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(JWCID_ATTRIBUTE_NAME)) continue;
            String value = (String)entry.getValue();
            this.addAttributeToToken(token, key, value);
        }
    }

    private void addAttributeToToken(OpenToken token, String name, String attributeValue) {
        int pos = attributeValue.indexOf(":");
        if (pos > 0) {
            String prefix = attributeValue.substring(0, pos + 1);
            if (prefix.equals(OGNL_EXPRESSION_PREFIX)) {
                token.addAttribute(name, AttributeType.OGNL_EXPRESSION, this.extractExpression(attributeValue.substring(pos + 1)));
                return;
            }
            if (prefix.equals(LOCALIZATION_KEY_PREFIX)) {
                token.addAttribute(name, AttributeType.LOCALIZATION_KEY, attributeValue.substring(pos + 1).trim());
                return;
            }
        }
        token.addAttribute(name, AttributeType.LITERAL, attributeValue);
    }

    private void closeTag() throws TemplateParseException {
        int stackPos;
        int cursorStart = this._cursor;
        int length = this._templateData.length;
        int startLine = this._line;
        ILocation startLocation = this.getCurrentLocation();
        this._cursor += CLOSE_TAG.length;
        int tagStart = this._cursor;
        while (true) {
            char ch;
            if (this._cursor >= length) {
                this.templateParseProblem(Tapestry.format("TemplateParser.incomplete-close-tag", Integer.toString(startLine)), startLocation, startLine, cursorStart);
            }
            if ((ch = this._templateData[this._cursor]) == '>') break;
            this.advance();
        }
        String tagName = new String(this._templateData, tagStart, this._cursor - tagStart);
        Tag tag = null;
        for (stackPos = this._stack.size() - 1; stackPos >= 0 && !(tag = (Tag)this._stack.get(stackPos)).match(tagName); --stackPos) {
            if (!tag._mustBalance) continue;
            this.templateParseProblem(Tapestry.format("TemplateParser.improperly-nested-close-tag", new Object[]{tagName, Integer.toString(startLine), tag._tagName, Integer.toString(tag._line)}), startLocation, startLine, cursorStart);
        }
        if (stackPos < 0) {
            this.templateParseProblem(Tapestry.format("TemplateParser.unmatched-close-tag", tagName, Integer.toString(startLine)), startLocation, startLine, cursorStart);
        }
        if (tag._content) {
            this.addTextToken(cursorStart - 1);
            this._cursor = length;
            this._stack.clear();
            return;
        }
        if (tag._component) {
            this.addTextToken(cursorStart - 1);
            this._tokens.add(this._factory.createCloseToken(tagName, this.getCurrentLocation()));
        } else if (this._blockStart < 0 && !tag._removeTag && !this._ignoring) {
            this._blockStart = cursorStart;
        }
        for (int i = this._stack.size() - 1; i >= stackPos; --i) {
            this._stack.remove(i);
        }
        this.advance();
        if (tag._removeTag) {
            this.advanceOverWhitespace();
        }
        if (tag._ignoringBody) {
            this._ignoring = false;
        }
    }

    private void advance() {
        int length = this._templateData.length;
        if (this._cursor >= length) {
            return;
        }
        char ch = this._templateData[this._cursor];
        ++this._cursor;
        if (ch == '\n') {
            ++this._line;
            this._currentLocation = null;
            return;
        }
        if (ch == '\r') {
            ++this._line;
            this._currentLocation = null;
            if (this._cursor < length && this._templateData[this._cursor] == '\n') {
                ++this._cursor;
            }
            return;
        }
    }

    private void advanceOverWhitespace() {
        int length = this._templateData.length;
        while (this._cursor < length) {
            char ch = this._templateData[this._cursor];
            if (!Character.isWhitespace(ch)) {
                return;
            }
            this.advance();
        }
    }

    private Map filter(Map input, String[] removeKeys) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        HashMap result = null;
        Iterator i = input.entrySet().iterator();
        block0: while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            for (int j = 0; j < removeKeys.length; ++j) {
                if (key.equalsIgnoreCase(removeKeys[j])) continue block0;
            }
            if (result == null) {
                result = new HashMap(input.size());
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    protected String findValueCaselessly(String key, Map map) {
        String result = (String)map.get(key);
        if (result != null) {
            return result;
        }
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String entryKey = (String)entry.getKey();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private String extractExpression(String input) {
        int inputLength = input.length();
        StringBuffer buffer = new StringBuffer(inputLength);
        int cursor = 0;
        block0: while (cursor < inputLength) {
            for (int i = 0; i < CONVERSIONS.length; i += 2) {
                String entity = CONVERSIONS[i];
                int entityLength = entity.length();
                String value = CONVERSIONS[i + 1];
                if (cursor + entityLength > inputLength || !input.substring(cursor, cursor + entityLength).equals(entity)) continue;
                buffer.append(value);
                cursor += entityLength;
                continue block0;
            }
            buffer.append(input.charAt(cursor));
            ++cursor;
        }
        return buffer.toString().trim();
    }

    private boolean checkBoolean(String key, Map map) {
        String value = this.findValueCaselessly(key, map);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    protected ILocation getCurrentLocation() {
        if (this._currentLocation == null) {
            this._currentLocation = new Location(this._resourceLocation, this._line);
        }
        return this._currentLocation;
    }

    private static class Tag {
        String _tagName;
        boolean _component;
        boolean _ignoringBody;
        boolean _removeTag;
        boolean _mustBalance;
        int _line;
        boolean _content;

        Tag(String tagName, int line) {
            this._tagName = tagName;
            this._line = line;
        }

        boolean match(String matchTagName) {
            return this._tagName.equalsIgnoreCase(matchTagName);
        }
    }

    protected static class TemplateTokenFactory {
        protected TemplateTokenFactory() {
        }

        public OpenToken createOpenToken(String tagName, String jwcId, String type, ILocation location) {
            return new OpenToken(tagName, jwcId, type, location);
        }

        public CloseToken createCloseToken(String tagName, ILocation location) {
            return new CloseToken(tagName, location);
        }

        public TextToken createTextToken(char[] templateData, int blockStart, int end, ILocation templateLocation) {
            return new TextToken(templateData, blockStart, end, templateLocation);
        }

        public LocalizationToken createLocalizationToken(String tagName, String localizationKey, boolean raw, Map attributes, ILocation startLocation) {
            return new LocalizationToken(tagName, localizationKey, raw, attributes, startLocation);
        }
    }
}

