/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapterFactory;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

public class Rmic
extends MatchingTask {
    private static final String FAIL_MSG = "Rmic failed; see the compiler error output for details.";
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private Path extdirs;
    private boolean verify = false;
    private boolean filtering = false;
    private boolean iiop = false;
    private String iiopopts;
    private boolean idl = false;
    private String idlopts;
    private boolean debug = false;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private Vector compileList = new Vector();
    private ClassLoader loader = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private FacadeTaskHelper facade;
    static /* synthetic */ Class class$java$rmi$Remote;

    public Rmic() {
        try {
            Class.forName("kaffe.rmi.rmic.RMIC");
            this.facade = new FacadeTaskHelper("kaffe");
        }
        catch (ClassNotFoundException cnfe) {
            this.facade = new FacadeTaskHelper("sun");
        }
    }

    public void setBase(File base) {
        this.baseDir = base;
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setSourceBase(File sourceBase) {
        this.sourceBase = sourceBase;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public void setStubVersion(String stubVersion) {
        this.stubVersion = stubVersion;
    }

    public String getStubVersion() {
        return this.stubVersion;
    }

    public void setFiltering(boolean filter) {
        this.filtering = filter;
    }

    public boolean getFiltering() {
        return this.filtering;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public void setIiop(boolean iiop) {
        this.iiop = iiop;
    }

    public boolean getIiop() {
        return this.iiop;
    }

    public void setIiopopts(String iiopopts) {
        this.iiopopts = iiopopts;
    }

    public String getIiopopts() {
        return this.iiopopts;
    }

    public void setIdl(boolean idl) {
        this.idl = idl;
    }

    public boolean getIdl() {
        return this.idl;
    }

    public void setIdlopts(String idlopts) {
        this.idlopts = idlopts;
    }

    public String getIdlopts() {
        return this.idlopts;
    }

    public Vector getFileList() {
        return this.compileList;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Vector getCompileList() {
        return this.compileList;
    }

    public void setCompiler(String compiler) {
        this.facade.setImplementation(compiler);
    }

    public String getCompiler() {
        this.facade.setMagicValue(this.getProject().getProperty("build.rmic"));
        return this.facade.getImplementation();
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument arg = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(arg);
        return arg;
    }

    public String[] getCurrentCompilerArgs() {
        this.getCompiler();
        return this.facade.getArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("base attribute must be set!", this.getLocation());
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("base does not exist!", this.getLocation());
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 3);
        }
        RmicAdapter adapter = RmicAdapterFactory.getRmic(this.getCompiler(), this);
        adapter.setRmic(this);
        Path classpath = adapter.getClasspath();
        this.loader = this.getProject().createClassLoader(classpath);
        try {
            if (this.classname == null) {
                DirectoryScanner ds = this.getDirectoryScanner(this.baseDir);
                String[] files = ds.getIncludedFiles();
                this.scanDir(this.baseDir, files, adapter.getMapper());
            } else {
                this.scanDir(this.baseDir, new String[]{this.classname.replace('.', File.separatorChar) + ".class"}, adapter.getMapper());
            }
            int fileCount = this.compileList.size();
            if (fileCount > 0) {
                this.log("RMI Compiling " + fileCount + " class" + (fileCount > 1 ? "es" : "") + " to " + this.baseDir, 2);
                if (!adapter.execute()) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
            }
            if (null != this.sourceBase && !this.baseDir.equals(this.sourceBase) && fileCount > 0) {
                if (this.idl) {
                    this.log("Cannot determine sourcefiles in idl mode, ", 1);
                    this.log("sourcebase attribute will be ignored.", 1);
                } else {
                    for (int j = 0; j < fileCount; ++j) {
                        this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(j), adapter);
                    }
                }
            }
        }
        finally {
            this.compileList.removeAllElements();
        }
    }

    private void moveGeneratedFile(File baseDir, File sourceBaseFile, String classname, RmicAdapter adapter) throws BuildException {
        String classFileName = classname.replace('.', File.separatorChar) + ".class";
        String[] generatedFiles = adapter.getMapper().mapFileName(classFileName);
        for (int i = 0; i < generatedFiles.length; ++i) {
            int pos;
            String sourceFileName;
            File oldFile;
            String generatedFile = generatedFiles[i];
            if (!generatedFile.endsWith(".class") || !(oldFile = new File(baseDir, sourceFileName = generatedFile.substring(0, pos = generatedFile.length() - ".class".length()) + ".java")).exists()) continue;
            File newFile = new File(sourceBaseFile, sourceFileName);
            try {
                if (this.filtering) {
                    this.fileUtils.copyFile(oldFile, newFile, new FilterSetCollection(this.getProject().getGlobalFilterSet()));
                } else {
                    this.fileUtils.copyFile(oldFile, newFile);
                }
                oldFile.delete();
                continue;
            }
            catch (IOException ioe) {
                String msg = "Failed to copy " + oldFile + " to " + newFile + " due to " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.getLocation());
            }
        }
    }

    protected void scanDir(File baseDir, String[] files, FileNameMapper mapper) {
        String[] newFiles = files;
        if (this.idl) {
            this.log("will leave uptodate test to rmic implementation in idl mode.", 3);
        } else if (this.iiop && this.iiopopts != null && this.iiopopts.indexOf("-always") > -1) {
            this.log("no uptodate test as -always option has been specified", 3);
        } else {
            SourceFileScanner sfs = new SourceFileScanner(this);
            newFiles = sfs.restrict(files, baseDir, baseDir, mapper);
        }
        for (int i = 0; i < newFiles.length; ++i) {
            String classname = newFiles[i].replace(File.separatorChar, '.');
            classname = classname.substring(0, classname.lastIndexOf(".class"));
            this.compileList.addElement(classname);
        }
    }

    public boolean isValidRmiRemote(String classname) {
        try {
            Class<?> testClass = this.loader.loadClass(classname);
            if (testClass.isInterface() && !this.iiop && !this.idl) {
                return false;
            }
            return this.isValidRmiRemote(testClass);
        }
        catch (ClassNotFoundException e) {
            this.log("Unable to verify class " + classname + ". It could not be found.", 1);
        }
        catch (NoClassDefFoundError e) {
            this.log("Unable to verify class " + classname + ". It is not defined.", 1);
        }
        catch (Throwable t) {
            this.log("Unable to verify class " + classname + ". Loading caused Exception: " + t.getMessage(), 1);
        }
        return false;
    }

    public Class getRemoteInterface(Class testClass) {
        Class<?>[] interfaces;
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = Rmic.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(testClass) && (interfaces = testClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!(class$java$rmi$Remote == null ? Rmic.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(interfaces[i])) continue;
                return interfaces[i];
            }
        }
        return null;
    }

    private boolean isValidRmiRemote(Class testClass) {
        return this.getRemoteInterface(testClass) != null;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String impl) {
            super.setImplementation(impl);
        }
    }
}

