/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class DependSet
extends MatchingTask {
    private Vector sourceFileSets = new Vector();
    private Vector sourceFileLists = new Vector();
    private Vector targetFileSets = new Vector();
    private Vector targetFileLists = new Vector();

    public void addSrcfileset(FileSet fs) {
        this.sourceFileSets.addElement(fs);
    }

    public void addSrcfilelist(FileList fl) {
        this.sourceFileLists.addElement(fl);
    }

    public void addTargetfileset(FileSet fs) {
        this.targetFileSets.addElement(fs);
    }

    public void addTargetfilelist(FileList fl) {
        this.targetFileLists.addElement(fl);
    }

    public void execute() throws BuildException {
        if (this.sourceFileSets.size() == 0 && this.sourceFileLists.size() == 0) {
            throw new BuildException("At least one <srcfileset> or <srcfilelist> element must be set");
        }
        if (this.targetFileSets.size() == 0 && this.targetFileLists.size() == 0) {
            throw new BuildException("At least one <targetfileset> or <targetfilelist> element must be set");
        }
        long now = new Date().getTime();
        if (Os.isFamily("windows")) {
            now += 2000L;
        }
        Vector<File> allTargets = new Vector<File>();
        long oldestTargetTime = 0L;
        File oldestTarget = null;
        Enumeration enumTargetSets = this.targetFileSets.elements();
        while (enumTargetSets.hasMoreElements()) {
            FileSet targetFS = (FileSet)enumTargetSets.nextElement();
            if (!targetFS.getDir(this.getProject()).exists()) continue;
            DirectoryScanner targetDS = targetFS.getDirectoryScanner(this.getProject());
            String[] targetFiles = targetDS.getIncludedFiles();
            for (int i = 0; i < targetFiles.length; ++i) {
                File dest = new File(targetFS.getDir(this.getProject()), targetFiles[i]);
                allTargets.addElement(dest);
                if (dest.lastModified() > now) {
                    this.log("Warning: " + targetFiles[i] + " modified in the future.", 1);
                }
                if (oldestTarget != null && dest.lastModified() >= oldestTargetTime) continue;
                oldestTargetTime = dest.lastModified();
                oldestTarget = dest;
            }
        }
        boolean upToDate = true;
        Enumeration enumTargetLists = this.targetFileLists.elements();
        while (enumTargetLists.hasMoreElements()) {
            FileList targetFL = (FileList)enumTargetLists.nextElement();
            String[] targetFiles = targetFL.getFiles(this.getProject());
            for (int i = 0; i < targetFiles.length; ++i) {
                File dest = new File(targetFL.getDir(this.getProject()), targetFiles[i]);
                if (!dest.exists()) {
                    this.log(targetFiles[i] + " does not exist.", 3);
                    upToDate = false;
                    continue;
                }
                allTargets.addElement(dest);
                if (dest.lastModified() > now) {
                    this.log("Warning: " + targetFiles[i] + " modified in the future.", 1);
                }
                if (oldestTarget != null && dest.lastModified() >= oldestTargetTime) continue;
                oldestTargetTime = dest.lastModified();
                oldestTarget = dest;
            }
        }
        if (oldestTarget != null) {
            this.log(oldestTarget + " is oldest target file", 3);
        } else {
            upToDate = false;
        }
        if (upToDate) {
            Enumeration enumSourceLists = this.sourceFileLists.elements();
            block4: while (upToDate && enumSourceLists.hasMoreElements()) {
                FileList sourceFL = (FileList)enumSourceLists.nextElement();
                String[] sourceFiles = sourceFL.getFiles(this.getProject());
                for (int i = 0; upToDate && i < sourceFiles.length; ++i) {
                    File src = new File(sourceFL.getDir(this.getProject()), sourceFiles[i]);
                    if (src.lastModified() > now) {
                        this.log("Warning: " + sourceFiles[i] + " modified in the future.", 1);
                    }
                    if (!src.exists()) {
                        this.log(sourceFiles[i] + " does not exist.", 3);
                        upToDate = false;
                        continue block4;
                    }
                    if (src.lastModified() <= oldestTargetTime) continue;
                    upToDate = false;
                    this.log(oldestTarget + " is out of date with respect to " + sourceFiles[i], 3);
                }
            }
        }
        if (upToDate) {
            Enumeration enumSourceSets = this.sourceFileSets.elements();
            while (upToDate && enumSourceSets.hasMoreElements()) {
                FileSet sourceFS = (FileSet)enumSourceSets.nextElement();
                DirectoryScanner sourceDS = sourceFS.getDirectoryScanner(this.getProject());
                String[] sourceFiles = sourceDS.getIncludedFiles();
                for (int i = 0; upToDate && i < sourceFiles.length; ++i) {
                    File src = new File(sourceFS.getDir(this.getProject()), sourceFiles[i]);
                    if (src.lastModified() > now) {
                        this.log("Warning: " + sourceFiles[i] + " modified in the future.", 1);
                    }
                    if (src.lastModified() <= oldestTargetTime) continue;
                    upToDate = false;
                    this.log(oldestTarget + " is out of date with respect to " + sourceFiles[i], 3);
                }
            }
        }
        if (!upToDate) {
            this.log("Deleting all target files. ", 3);
            Enumeration e = allTargets.elements();
            while (e.hasMoreElements()) {
                File fileToRemove = (File)e.nextElement();
                this.log("Deleting file " + fileToRemove.getAbsolutePath(), 3);
                fileToRemove.delete();
            }
        }
    }
}

