/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.TypeAdapter;

public class AntTypeDefinition {
    private String name;
    private Class clazz;
    private Class adapterClass;
    private Class adaptToClass;
    private String className;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            return;
        }
        if (this.classLoader == null) {
            this.classLoader = clazz.getClassLoader();
        }
        if (this.className == null) {
            this.className = clazz.getName();
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setAdapterClass(Class adapterClass) {
        this.adapterClass = adapterClass;
    }

    public void setAdaptToClass(Class adaptToClass) {
        this.adaptToClass = adaptToClass;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getExposedClass(Project project) {
        if (this.adaptToClass != null) {
            Class z = this.getTypeClass(project);
            if (z == null) {
                return null;
            }
            if (this.adaptToClass.isAssignableFrom(z)) {
                return z;
            }
        }
        if (this.adapterClass != null) {
            return this.adapterClass;
        }
        return this.getTypeClass(project);
    }

    public Class getTypeClass(Project project) {
        if (this.clazz != null) {
            return this.clazz;
        }
        try {
            this.clazz = this.classLoader == null ? Class.forName(this.className) : this.classLoader.loadClass(this.className);
        }
        catch (NoClassDefFoundError ncdfe) {
            project.log("Could not load a dependent class (" + ncdfe.getMessage() + ") for type " + this.name, 4);
        }
        catch (ClassNotFoundException cnfe) {
            project.log("Could not load class (" + this.className + ") for type " + this.name, 4);
        }
        return this.clazz;
    }

    public Object create(Project project) {
        return this.icreate(project);
    }

    private Object icreate(Project project) {
        Class c = this.getTypeClass(project);
        if (c == null) {
            return null;
        }
        Object o = this.createAndSet(project, c);
        if (o == null || this.adapterClass == null) {
            return o;
        }
        if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(o.getClass())) {
            return o;
        }
        TypeAdapter adapterObject = (TypeAdapter)this.createAndSet(project, this.adapterClass);
        if (adapterObject == null) {
            return null;
        }
        adapterObject.setProxy(o);
        return adapterObject;
    }

    public void checkClass(Project project) {
        if (this.clazz == null) {
            this.clazz = this.getTypeClass(project);
            if (this.clazz == null) {
                throw new BuildException("Unable to create class for " + this.getName());
            }
        }
        if (this.adapterClass != null) {
            boolean needToCheck = true;
            if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(this.clazz)) {
                needToCheck = false;
            }
            if (needToCheck) {
                TypeAdapter adapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
                if (adapter == null) {
                    throw new BuildException("Unable to create adapter object");
                }
                adapter.checkProxyClass(this.clazz);
            }
        }
    }

    private Object createAndSet(Project project, Class c) {
        try {
            Constructor ctor = null;
            boolean noArg = false;
            try {
                ctor = c.getConstructor(new Class[0]);
                noArg = true;
            }
            catch (NoSuchMethodException nse) {
                ctor = c.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntTypeDefinition.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                noArg = false;
            }
            Object o = null;
            o = noArg ? ctor.newInstance(new Object[0]) : ctor.newInstance(project);
            project.setProjectReference(o);
            return o;
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            throw new BuildException("Could not create type " + this.name + " due to " + t, t);
        }
        catch (NoClassDefFoundError ncdfe) {
            String msg = "Type " + this.name + ": A class needed by class " + c + " cannot be found: " + ncdfe.getMessage();
            throw new BuildException(msg, ncdfe);
        }
        catch (Throwable t) {
            throw new BuildException("Could not create type " + this.name + " due to " + t, t);
        }
    }

    public boolean sameDefinition(AntTypeDefinition other, Project project) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (!other.getTypeClass(project).equals(this.getTypeClass(project))) {
            return false;
        }
        if (!other.getExposedClass(project).equals(this.getExposedClass(project))) {
            return false;
        }
        if (other.adapterClass != this.adapterClass) {
            return false;
        }
        return other.adaptToClass == this.adaptToClass;
    }

    public boolean similarDefinition(AntTypeDefinition other, Project project) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (!this.extractClassname(this.adapterClass).equals(this.extractClassname(other.adapterClass))) {
            return false;
        }
        if (!this.extractClassname(this.adaptToClass).equals(this.extractClassname(other.adaptToClass))) {
            return false;
        }
        ClassLoader oldLoader = other.getClassLoader();
        ClassLoader newLoader = this.getClassLoader();
        return oldLoader != null && newLoader != null && oldLoader instanceof AntClassLoader && newLoader instanceof AntClassLoader && ((AntClassLoader)oldLoader).getClasspath().equals(((AntClassLoader)newLoader).getClasspath());
    }

    private String extractClassname(Class c) {
        if (c == null) {
            return "<null>";
        }
        return c.getClass().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

