/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.serverImpl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.bsf.debug.serverImpl.ObjectServer;
import org.apache.bsf.debug.util.DebugLog;

public class GatedListener
implements Runnable {
    private ServerSocket fServerSocket;
    private Socket fClientSocket;
    private Thread m_thread;
    private int m_port;
    private ObjectServer m_oserver;
    private boolean m_accept = true;
    private Object m_acceptLock = new Object();

    public GatedListener(ObjectServer objectServer, int n) {
        this.m_oserver = objectServer;
        this.m_port = n;
        this.m_thread = new Thread((Runnable)this, "JSDI Connection Thread");
        this.m_thread.start();
    }

    public void run() {
        int n = 3;
        while (this.m_accept) {
            try {
                this.accept();
            }
            catch (Exception exception) {
                if (exception instanceof SecurityException) {
                    DebugLog.stdoutPrintln("Security violation during socket operation.", 0);
                    exception.printStackTrace();
                    continue;
                }
                if (exception instanceof ProtocolException) {
                    DebugLog.stdoutPrintln("Client attempted to connect using unsupported protocol version", 0);
                    continue;
                }
                if (exception instanceof IOException) {
                    DebugLog.stdoutPrintln("Reason: I/O error opening socket.", 0);
                    continue;
                }
                if (n != 0) {
                    DebugLog.stdoutPrintln("**** Error in accept() - " + n + " retry attempts remaining.", 0);
                    --n;
                    continue;
                }
                DebugLog.stdoutPrintln("**** accept() failure. Please correct error and restart server.", 0);
                DebugLog.stdoutPrintln(exception.getMessage(), 0);
                this.m_accept = false;
            }
        }
    }

    private void accept() throws Exception {
        int n = -1;
        int n2 = -1;
        Object object = this.m_acceptLock;
        synchronized (object) {
            try {
                this.fServerSocket = new ServerSocket(this.m_port);
            }
            catch (Exception exception) {
                DebugLog.stdoutPrintln("**** Could not listen on port: " + this.m_port, 0);
                this.m_accept = false;
                throw exception;
            }
            try {
                DebugLog.stdoutPrintln("Listener accepting on port: " + this.m_port, 1);
                this.fClientSocket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return GatedListener.this.fServerSocket.accept();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                DebugLog.stdoutPrintln("Accept failed on port: " + this.m_port, 0);
                throw privilegedActionException.getException();
            }
            DebugLog.stdoutPrintln("Accepted a connection on port: " + this.m_port, 1);
            this.fServerSocket.close();
            this.fServerSocket = null;
            InputStream inputStream = this.fClientSocket.getInputStream();
            OutputStream outputStream = this.fClientSocket.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            if (n != 1 || n2 != 0) {
                dataOutputStream.writeInt(0);
                this.fClientSocket.close();
                this.fClientSocket = null;
                throw new ProtocolException("Protocol version mismatch!");
            }
            DebugLog.stdoutPrintln("Debug client attached on port: " + this.m_port, 1);
            this.m_oserver.setIOStreams(inputStream, outputStream, dataInputStream, dataOutputStream);
            this.m_oserver.awake();
            dataOutputStream.writeInt(1);
            this.m_acceptLock.wait();
            this.fClientSocket.close();
            this.fClientSocket = null;
        }
    }

    protected void awake() {
        Object object = this.m_acceptLock;
        synchronized (object) {
            this.m_acceptLock.notify();
        }
    }
}

