/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.Hibernate;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;

public class ArithmeticNode
extends AbstractSelectExpression {
    public Type getDataType() {
        AST first = this.getFirstChild();
        AST second = this.getFirstChild().getNextSibling();
        if (!(second instanceof SelectExpression)) {
            if (first instanceof SelectExpression) {
                return ((SelectExpression)first).getDataType();
            }
            return Hibernate.DOUBLE;
        }
        if (first instanceof SelectExpression) {
            Type x = ((SelectExpression)first).getDataType();
            Type y = ((SelectExpression)second).getDataType();
            if (x == Hibernate.DOUBLE || y == Hibernate.DOUBLE) {
                return Hibernate.DOUBLE;
            }
            if (x == Hibernate.FLOAT || y == Hibernate.FLOAT) {
                return Hibernate.FLOAT;
            }
            if (x == Hibernate.BIG_DECIMAL || y == Hibernate.BIG_DECIMAL) {
                return Hibernate.BIG_DECIMAL;
            }
            if (x == Hibernate.BIG_INTEGER || y == Hibernate.BIG_INTEGER) {
                return Hibernate.BIG_INTEGER;
            }
            if (x == Hibernate.LONG || y == Hibernate.LONG) {
                return Hibernate.LONG;
            }
            if (x == Hibernate.INTEGER || y == Hibernate.INTEGER) {
                return Hibernate.INTEGER;
            }
            return x;
        }
        return ((SelectExpression)second).getDataType();
    }

    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }
}

