/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.tacos.model.IKeyProvider;
import net.sf.tacos.model.ITreeContentProvider;
import net.sf.tacos.tree.ITreeManager;
import net.sf.tacos.tree.TreeIterator;
import net.sf.tacos.tree.TreeManager;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;

public abstract class Tree
extends BaseComponent {
    private Set state;
    private TreeIterator treeIterator;

    public TreeIterator getTreeIterator() {
        return this.treeIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.treeIterator = new TreeIter();
        try {
            super.renderComponent(writer, cycle);
        }
        finally {
            this.treeIterator = null;
            this.state = null;
        }
    }

    public void expansion(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Serializable key = (Serializable)params[0];
        Boolean expanded = (Boolean)params[1];
        this.getManager().setExpandedKey(key, expanded);
        this.setState(this.getState());
    }

    public boolean isExpanded(Object element) {
        return this.getManager().isExpanded(element);
    }

    private Collection sorted(Collection elements) {
        Comparator comp = this.getSorter();
        if (comp == null) {
            return elements;
        }
        ArrayList l = new ArrayList(elements);
        Collections.sort(l, comp);
        return l;
    }

    public ITreeManager getManager() {
        return new TreeManager(this.getState(), this.getContentProvider(), this.getKeyProvider());
    }

    public Set getState() {
        if (this.state == null) {
            IBinding stateBinding = this.getBinding("state");
            if (stateBinding != null) {
                this.state = (Set)stateBinding.getObject();
            }
            if (this.state == null) {
                this.state = new LinkedHashSet();
                if (stateBinding != null) {
                    stateBinding.setObject((Object)this.state);
                }
            }
        }
        return this.state;
    }

    public void setState(Set state) {
        this.state = state;
        IBinding stateBinding = this.getBinding("state");
        if (stateBinding != null) {
            stateBinding.setObject((Object)state);
        } else {
            Tapestry.fireObservedChange((IComponent)this, (String)"state", (Object)state);
        }
    }

    public abstract ITreeContentProvider getContentProvider();

    public abstract IKeyProvider getKeyProvider();

    public abstract Comparator getSorter();

    private final class TreeIter
    extends TreeIterator {
        private TreeIter() {
            super(Tree.this.sorted(Tree.this.getContentProvider().getElements()));
        }

        protected Collection getChildren(Object node) {
            if (!Tree.this.isExpanded(node)) {
                return Collections.EMPTY_LIST;
            }
            Collection coll = Tree.this.getContentProvider().getChildren(node);
            return Tree.this.sorted(coll);
        }
    }
}

