/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.partial;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractService;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.HTMLWriter;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.request.ResponseOutputStream;

public class PartialService
extends AbstractService
implements IEngineService {
    public static final String SERVICE_NAME = "partial";
    private static final String STATEFUL_OFF = "0";
    private static final String STATEFUL_ON = "1";
    private static ThreadLocal currentPartIds = new ThreadLocal();
    private static ThreadLocal currentPartWriters = new ThreadLocal();

    public String getName() {
        return SERVICE_NAME;
    }

    public ILink getLink(IRequestCycle cycle, IComponent component, Object[] parameters) {
        String stateful = cycle.getEngine().isStateful() ? STATEFUL_ON : STATEFUL_OFF;
        IPage renderPage = cycle.getPage();
        IPage componentPage = component.getPage();
        String[] context = new String[]{stateful, renderPage.getPageName(), componentPage.getPageName(), component.getIdPath()};
        return this.constructLink(cycle, SERVICE_NAME, context, parameters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException {
        HttpSession session;
        IDirect direct;
        RequestContext requestContext = cycle.getRequestContext();
        String[] serviceContext = this.getServiceContext(requestContext);
        String stateful = serviceContext[0];
        String renderPageName = serviceContext[1];
        String componentPageName = serviceContext[2];
        String componentPath = serviceContext[3];
        IPage renderPage = cycle.getPage(renderPageName);
        cycle.activate(renderPage);
        IPage componentPage = renderPage;
        if (!componentPageName.equals(renderPageName)) {
            componentPage = cycle.getPage(componentPageName);
        }
        IComponent component = componentPage.getNestedComponent(componentPath);
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"DirectService.component-wrong-type", (Object)component.getExtendedId()), (Object)component, null, (Throwable)ex);
        }
        if (stateful.equals(STATEFUL_ON) && direct.isStateful() && ((session = cycle.getRequestContext().getSession()) == null || session.isNew())) {
            throw new StaleSessionException(Tapestry.format((String)"DirectService.stale-session-exception", (Object)direct.getExtendedId()), direct.getPage());
        }
        currentPartIds.set(null);
        currentPartWriters.set(null);
        HashSet<String> partIds = null;
        if (serviceContext.length > 4) {
            partIds = new HashSet<String>();
            for (int i = 4; i < serviceContext.length; ++i) {
                partIds.add(serviceContext[i]);
            }
            currentPartIds.set(partIds);
        }
        try {
            Object[] parameters = this.getParameters(cycle);
            cycle.setServiceParameters(parameters);
            direct.trigger(cycle);
            if (partIds == null) {
                engine.renderResponse(cycle, output);
                Object var22_18 = null;
                currentPartIds.set(null);
                currentPartWriters.set(null);
                return;
            }
            currentPartIds.set(Collections.unmodifiableSet(partIds));
            HashMap<String, PartWriter> partWriters = new HashMap<String, PartWriter>();
            Iterator i = partIds.iterator();
            while (i.hasNext()) {
                String partId = (String)i.next();
                partWriters.put(partId, new PartWriter(partId));
            }
            currentPartWriters.set(partWriters);
            output.setDiscard(true);
            engine.renderResponse(cycle, output);
            output.setDiscard(false);
            output.setContentType("text/xml");
            String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><parts>";
            output.write(header.getBytes("utf-8"));
            HTMLWriter w = new HTMLWriter((OutputStream)output);
            Iterator i2 = partWriters.values().iterator();
            while (i2.hasNext()) {
                PartWriter pw = (PartWriter)i2.next();
                pw.write((IMarkupWriter)w);
            }
            w.flush();
            String footer = "</parts>";
            output.write(footer.getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            Object var22_20 = null;
            currentPartIds.set(null);
            currentPartWriters.set(null);
            throw throwable;
        }
        Object var22_19 = null;
        currentPartIds.set(null);
        currentPartWriters.set(null);
    }

    public static boolean isPartialRender() {
        return currentPartIds.get() != null;
    }

    public static Set getPartIds() {
        return (Set)currentPartIds.get();
    }

    public static IMarkupWriter getPartWriter(String partId) {
        Map parts = (Map)currentPartWriters.get();
        if (parts == null) {
            return null;
        }
        PartWriter p = (PartWriter)parts.get(partId);
        return p == null ? null : p.markupWriter;
    }

    private static class PartWriter {
        final String id;
        final StringWriter stringWriter;
        final IMarkupWriter markupWriter;

        public PartWriter(String partId) {
            this.id = partId;
            this.stringWriter = new StringWriter();
            this.markupWriter = new HTMLWriter(new PrintWriter(this.stringWriter));
        }

        public void write(IMarkupWriter writer) {
            writer.begin("part");
            writer.attribute("id", this.id);
            this.markupWriter.flush();
            writer.print(this.stringWriter.toString());
            writer.end();
        }
    }
}

