/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.EditList;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.StarTeamDiff;
import com.starbase.visdiff.DefaultDiffViewer;
import com.starbase.visdiff.DefaultDiffedDocument;
import com.starbase.visdiff.DiffViewer;
import com.starbase.visdiff.DiffWriter;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

class SplitDualDiffPane
extends JPanel {
    public static final int SHOW_DIFF_AND_MATCH = 0;
    public static final int SHOW_DIFF_ONLY = 1;
    public static final String SELECTION_PRESENT_PROPERTY = "selectionPresent";
    public static final String SPLIT_TYPE_PROPERTY = "splitType";
    public static final int GOTO_FIRST = 0;
    public static final int GOTO_LAST = 1;
    public static final int GOTO_NEXT = 2;
    public static final int GOTO_PREV = 3;
    public static final int SPLIT_NONE = 0;
    public static final int SPLIT_HORIZONTAL = 1;
    public static final int SPLIT_VERTICAL = 2;
    public static final int DISPLAY_LINES_MATCHES = 1;
    public static final int DISPLAY_LINES_ADDS = 2;
    public static final int DISPLAY_LINES_DELETES = 4;
    public static final int DISPLAY_LINES_MOVES = 8;
    public static final int DISPLAY_LINES_ALL_DIFFS = 14;
    public static final int DISPLAY_LINES_ALL = 15;
    public static final int DISPLAY_LINENUMBERS_NONE = 0;
    public static final int DISPLAY_LINENUMBERS_SOURCE = 1;
    public static final int DISPLAY_LINENUMBERS_TARGET = 2;
    public static final int DISPLAY_LINENUMBERS_BOTH = 3;
    public static final int DISPLAY_LINENUMBERS_SOURCE_BOTH = 4;
    public static final int DISPLAY_LINENUMBERS_TARGET_BOTH = 5;
    public static final int LEADING_WS_IGNORE = 1;
    public static final int LEADING_WS_EQUIV = 2;
    public static final int INTERIOR_WS_IGNORE = 4;
    public static final int INTERIOR_WS_EQUIV = 8;
    public static final int TRAILING_WS_IGNORE = 16;
    public static final int TRAILING_WS_EQUIV = 32;
    public static final int IGNORE_CASE = 256;
    private static final int DIFF_FLAG_MASK = 65535;
    public static final int PVCS_WS = 17;
    public static final int VSS_WS = 21;
    public static final int DIFF_W_WS = 21;
    public static final int DIFF_B_WS = 26;
    private int m_compareFlags = 0;
    private Color[][] m_colors = null;
    EditList m_list = null;
    private DiffViewer m_sourceDiff = null;
    private DiffViewer m_targetDiff = null;
    private DiffViewer m_lastActive = null;
    private JSplitPane m_combo = null;
    private JScrollBar m_vertScroll = null;
    private BoundedRangeModel m_slideBounds = null;
    private int m_splitType = 2;
    private boolean m_isSplitValid = false;
    private int m_lineNumberDisplayType = 3;
    private boolean m_hasDiffs = false;
    private boolean m_selectionPresent = false;
    private boolean m_sourceHasSelection = false;
    private boolean m_targetHasSelection = false;
    PropertyChangeSupport m_propSupport = new PropertyChangeSupport(this);

    public void closeAll() {
        this.setSourceTitle("");
        this.setTargetTitle("");
        this.setSource(null);
        this.setTarget(null);
        this.m_sourceDiff.setDocument(new DefaultDiffedDocument());
        this.m_targetDiff.setDocument(new DefaultDiffedDocument());
        this.validate();
    }

    public ParsedCharSequence getSource() {
        return this.m_sourceDiff.getSequence();
    }

    public void setSource(ParsedCharSequence parsedCharSequence) {
        this.m_sourceDiff.setSequence(parsedCharSequence);
    }

    public String getSourceTitle() {
        return this.m_sourceDiff.getTitle();
    }

    public void setSourceTitle(String string) {
        this.m_sourceDiff.setTitle(string);
    }

    public ParsedCharSequence getTarget() {
        return this.m_targetDiff.getSequence();
    }

    public void setTarget(ParsedCharSequence parsedCharSequence) {
        this.m_targetDiff.setSequence(parsedCharSequence);
    }

    public String getTargetTitle() {
        return this.m_targetDiff.getTitle();
    }

    public void setTargetTitle(String string) {
        this.m_targetDiff.setTitle(string);
    }

    public boolean hasDifferences() {
        return this.m_hasDiffs;
    }

    public void performDiff(int n) {
        StarTeamDiff starTeamDiff = new StarTeamDiff();
        try {
            long l = System.currentTimeMillis();
            this.m_list = starTeamDiff.diff(this.m_sourceDiff.getSequence(), this.m_targetDiff.getSequence(), new BasicCompare(this.getDiffFlags(), null));
            this.m_hasDiffs = this.m_list.length() != 0;
            long l2 = System.currentTimeMillis();
        }
        catch (DiffException diffException) {
            System.err.println("Internal Err DIF001");
        }
        this.performDiffWrite(n);
    }

    public void performDiffWrite(int n) {
        DefaultDiffedDocument defaultDiffedDocument = new DefaultDiffedDocument();
        DefaultDiffedDocument defaultDiffedDocument2 = new DefaultDiffedDocument();
        ParsedCharSequence parsedCharSequence = this.m_sourceDiff.getSequence();
        ParsedCharSequence parsedCharSequence2 = this.m_targetDiff.getSequence();
        this.m_sourceDiff.setDocument(defaultDiffedDocument);
        this.m_targetDiff.setDocument(defaultDiffedDocument2);
        DiffWriter diffWriter = new DiffWriter(defaultDiffedDocument, defaultDiffedDocument2, 8, parsedCharSequence, parsedCharSequence2, n == 1);
        try {
            long l = System.currentTimeMillis();
            diffWriter.write(this.m_list, parsedCharSequence.size(), parsedCharSequence2.size());
            long l2 = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            System.err.println("Internal error DFW002");
        }
        this.m_sourceDiff.setCaretPosition(0);
        this.m_targetDiff.setCaretPosition(0);
    }

    public boolean isVerticalSpaceCollapsed() {
        return false;
    }

    public void setVerticalSpaceCollapsed(boolean bl) {
    }

    public boolean isWhitespaceShown() {
        return false;
    }

    public void setWhitespaceShown(boolean bl) {
    }

    public void setPositionToMatch(int n) {
        int n2;
        int n3 = this.m_sourceDiff.getCurrentLine();
        switch (n) {
            case 2: {
                n2 = this.m_sourceDiff.getMatchAfter(n3);
                break;
            }
            case 3: {
                n2 = this.m_sourceDiff.getMatchBefore(n3);
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.m_sourceDiff.setCurrentLine(n2);
            this.m_targetDiff.setCurrentLine(n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setPositionToDiff(int n) {
        int n2;
        int n3 = this.m_sourceDiff.getCurrentLine();
        switch (n) {
            case 2: {
                n2 = this.m_sourceDiff.getDiffAfter(n3);
                break;
            }
            case 3: {
                n2 = this.m_sourceDiff.getDiffBefore(n3);
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.m_sourceDiff.setCurrentLine(n2);
            this.m_targetDiff.setCurrentLine(n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setSyncedPosition(int n) {
    }

    public int getMasterLineCount() {
        return 0;
    }

    public int getSplitType() {
        return this.m_splitType;
    }

    public void setSplitType(int n) {
        int n2 = this.m_splitType;
        if (n == 1) {
            this.m_splitType = n;
            this.m_combo.setOrientation(0);
            this.m_combo.setDividerLocation(0.5);
        } else if (n == 2) {
            this.m_splitType = n;
            this.m_combo.setOrientation(1);
            this.m_combo.setDividerLocation(0.5);
        } else if (n == 0) {
            // empty if block
        }
        this.m_propSupport.firePropertyChange(SPLIT_TYPE_PROPERTY, new Integer(n2), new Integer(this.m_splitType));
    }

    public void swapSources() {
        int n = this.m_combo.getDividerLocation();
        this.m_combo.setLeftComponent(null);
        this.m_combo.setRightComponent(null);
        DiffViewer diffViewer = this.m_sourceDiff;
        this.m_sourceDiff = this.m_targetDiff;
        this.m_targetDiff = diffViewer;
        this.m_combo.setLeftComponent((JComponent)((Object)this.m_sourceDiff));
        this.m_combo.setRightComponent((JComponent)((Object)this.m_targetDiff));
        this.validate();
    }

    public int getLineNumberDisplayType() {
        return this.m_lineNumberDisplayType;
    }

    public void setLineNumberDisplayType(int n) {
        switch (n) {
            case 0: {
                this.m_lineNumberDisplayType = n;
                this.m_sourceDiff.setNumberingVisible(false);
                this.m_targetDiff.setNumberingVisible(false);
                break;
            }
            case 1: {
                this.m_sourceDiff.setNumberingVisible(true);
                this.m_targetDiff.setNumberingVisible(false);
                this.m_lineNumberDisplayType = n;
                break;
            }
            case 2: {
                this.m_sourceDiff.setNumberingVisible(false);
                this.m_targetDiff.setNumberingVisible(true);
                this.m_lineNumberDisplayType = n;
                break;
            }
            case 3: {
                this.m_sourceDiff.setNumberingVisible(true);
                this.m_targetDiff.setNumberingVisible(true);
                this.m_lineNumberDisplayType = n;
                break;
            }
            case 4: {
                this.m_sourceDiff.setNumberingVisible(true);
                this.m_targetDiff.setNumberingVisible(false);
                this.m_lineNumberDisplayType = n;
                break;
            }
            case 5: {
                this.m_sourceDiff.setNumberingVisible(false);
                this.m_targetDiff.setNumberingVisible(true);
                this.m_lineNumberDisplayType = n;
                break;
            }
        }
    }

    public int getLineTypesDisplayed() {
        return 15;
    }

    public void setLineTypesDisplayed(int n) {
    }

    public int getCompareFlags() {
        return this.m_compareFlags;
    }

    public void setCompareFlags(int n) {
        this.m_compareFlags = n;
    }

    public int getDiffFlags() {
        return this.m_compareFlags & 0xFFFF;
    }

    public void setDiffTextColors(Color[][] colorArray) {
        this.m_colors = colorArray;
        int[] nArray = new int[]{0, 3, 1, 2, 4};
        int n = 0;
        while (n < nArray.length && n < colorArray.length) {
            this.m_sourceDiff.setDiffColor(nArray[n], colorArray[n][0]);
            this.m_targetDiff.setDiffColor(nArray[n], colorArray[n][0]);
            ++n;
        }
    }

    public void setTabSize(int n) {
        this.m_sourceDiff.setTabSize(n);
        this.m_sourceDiff.setTabSize(n);
    }

    private void setHasSourceSelection(boolean bl) {
        boolean bl2;
        this.m_sourceHasSelection = bl;
        boolean bl3 = bl2 = this.m_sourceHasSelection || this.m_targetHasSelection;
        if (bl2 != this.m_selectionPresent) {
            this.setSelectionPresent(bl2);
        }
    }

    private void setHasTargetSelection(boolean bl) {
        boolean bl2;
        this.m_targetHasSelection = bl;
        boolean bl3 = bl2 = this.m_sourceHasSelection || this.m_targetHasSelection;
        if (bl2 != this.m_selectionPresent) {
            this.setSelectionPresent(bl2);
        }
    }

    public boolean isSelectionPresent() {
        return this.m_selectionPresent;
    }

    public boolean find(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        bl3 = this.getLastActive().find(string, bl, bl2);
        return bl3;
    }

    public void editCut() {
        this.getLastActive().fireEditorAction("cut-to-clipboard");
    }

    public void editCopy() {
        this.getLastActive().fireEditorAction("copy-to-clipboard");
    }

    public void editPaste() {
        this.getLastActive().fireEditorAction("paste-from-clipboard");
    }

    public void editSelectAll() {
        this.getLastActive().fireEditorAction("select-all");
    }

    private void setLastActive(DiffViewer diffViewer) {
        this.m_lastActive = diffViewer;
    }

    private DiffViewer getLastActive() {
        return this.m_lastActive;
    }

    private void setSelectionPresent(boolean bl) {
        boolean bl2 = this.m_selectionPresent;
        if (bl2 != bl) {
            this.m_selectionPresent = bl;
            this.m_propSupport.firePropertyChange(SELECTION_PRESENT_PROPERTY, new Boolean(bl2), new Boolean(bl));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static /* synthetic */ void access$0(SplitDualDiffPane splitDualDiffPane, boolean bl) {
        splitDualDiffPane.setHasSourceSelection(bl);
    }

    static /* synthetic */ DiffViewer access$1(SplitDualDiffPane splitDualDiffPane) {
        return splitDualDiffPane.m_sourceDiff;
    }

    static /* synthetic */ void access$2(SplitDualDiffPane splitDualDiffPane, DiffViewer diffViewer) {
        splitDualDiffPane.setLastActive(diffViewer);
    }

    static /* synthetic */ void access$3(SplitDualDiffPane splitDualDiffPane, boolean bl) {
        splitDualDiffPane.setHasTargetSelection(bl);
    }

    static /* synthetic */ DiffViewer access$4(SplitDualDiffPane splitDualDiffPane) {
        return splitDualDiffPane.m_targetDiff;
    }

    static /* synthetic */ JScrollBar access$5(SplitDualDiffPane splitDualDiffPane) {
        return splitDualDiffPane.m_vertScroll;
    }

    public SplitDualDiffPane() {
        this.setLayout(new BoxLayout(this, 0));
        this.m_sourceDiff = new DefaultDiffViewer();
        this.m_targetDiff = new DefaultDiffViewer();
        this.m_lastActive = this.m_sourceDiff;
        this.m_sourceDiff.setTitle(" ");
        this.m_targetDiff.setTitle(" ");
        this.m_slideBounds = new DefaultBoundedRangeModel(0, 10, 0, 100);
        this.m_vertScroll = new JScrollBar(1);
        this.m_combo = new JSplitPane();
        this.m_combo.setLeftComponent((JComponent)((Object)this.m_sourceDiff));
        this.m_combo.setRightComponent((JComponent)((Object)this.m_targetDiff));
        SplitDualDiffPane splitDualDiffPane = this;
        if (splitDualDiffPane == null) {
            throw null;
        }
        this.m_sourceDiff.addPropertyChangeListener(new PropertyChangeListener(splitDualDiffPane){
            private final /* synthetic */ SplitDualDiffPane this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectionPresent")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    SplitDualDiffPane.access$0(this.this$0, bl);
                    SplitDualDiffPane.access$2(this.this$0, SplitDualDiffPane.access$1(this.this$0));
                }
            }
            {
                this.this$0 = splitDualDiffPane;
                this.constructor$0(splitDualDiffPane);
            }

            private final void constructor$0(SplitDualDiffPane splitDualDiffPane) {
            }
        });
        SplitDualDiffPane splitDualDiffPane2 = this;
        if (splitDualDiffPane2 == null) {
            throw null;
        }
        this.m_targetDiff.addPropertyChangeListener(new PropertyChangeListener(splitDualDiffPane2){
            private final /* synthetic */ SplitDualDiffPane this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectionPresent")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    SplitDualDiffPane.access$3(this.this$0, bl);
                    SplitDualDiffPane.access$2(this.this$0, SplitDualDiffPane.access$4(this.this$0));
                }
            }
            {
                this.this$0 = splitDualDiffPane;
                this.constructor$0(splitDualDiffPane);
            }

            private final void constructor$0(SplitDualDiffPane splitDualDiffPane) {
            }
        });
        SplitDualDiffPane splitDualDiffPane3 = this;
        if (splitDualDiffPane3 == null) {
            throw null;
        }
        ChangeListener changeListener = new ChangeListener(splitDualDiffPane3){
            private final /* synthetic */ SplitDualDiffPane this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                BoundedRangeModel boundedRangeModel2 = SplitDualDiffPane.access$5(this.this$0).getModel();
                int n = boundedRangeModel.getValue();
                int n2 = boundedRangeModel.getExtent();
                int n3 = boundedRangeModel.getMaximum();
                int n4 = boundedRangeModel.getMinimum();
                boolean bl = boundedRangeModel.getValueIsAdjusting();
                if (n3 != boundedRangeModel2.getMaximum() || n2 != boundedRangeModel2.getExtent()) {
                    boundedRangeModel2.setRangeProperties(n, n2, n4, n3, bl);
                } else {
                    boundedRangeModel2.setValue(n);
                }
            }
            {
                this.this$0 = splitDualDiffPane;
                this.constructor$0(splitDualDiffPane);
            }

            private final void constructor$0(SplitDualDiffPane splitDualDiffPane) {
            }
        };
        this.m_sourceDiff.getVerticalScrollModel().addChangeListener(changeListener);
        this.m_targetDiff.getVerticalScrollModel().addChangeListener(changeListener);
        SplitDualDiffPane splitDualDiffPane4 = this;
        if (splitDualDiffPane4 == null) {
            throw null;
        }
        this.m_vertScroll.getModel().addChangeListener(new ChangeListener(splitDualDiffPane4){
            private final /* synthetic */ SplitDualDiffPane this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                SplitDualDiffPane.access$1(this.this$0).getVerticalScrollModel().setValue(boundedRangeModel.getValue());
                SplitDualDiffPane.access$4(this.this$0).getVerticalScrollModel().setValue(boundedRangeModel.getValue());
            }
            {
                this.this$0 = splitDualDiffPane;
                this.constructor$0(splitDualDiffPane);
            }

            private final void constructor$0(SplitDualDiffPane splitDualDiffPane) {
            }
        });
        SplitDualDiffPane splitDualDiffPane5 = this;
        if (splitDualDiffPane5 == null) {
            throw null;
        }
        ChangeListener changeListener2 = new ChangeListener(splitDualDiffPane5){
            private final /* synthetic */ SplitDualDiffPane this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                int n = boundedRangeModel.getValue();
                if (boundedRangeModel != SplitDualDiffPane.access$1(this.this$0).getHorizontalScrollModel()) {
                    SplitDualDiffPane.access$1(this.this$0).getHorizontalScrollModel().setValue(n);
                }
                if (boundedRangeModel != SplitDualDiffPane.access$4(this.this$0).getHorizontalScrollModel()) {
                    SplitDualDiffPane.access$4(this.this$0).getHorizontalScrollModel().setValue(n);
                }
            }
            {
                this.this$0 = splitDualDiffPane;
                this.constructor$0(splitDualDiffPane);
            }

            private final void constructor$0(SplitDualDiffPane splitDualDiffPane) {
            }
        };
        this.m_sourceDiff.getHorizontalScrollModel().addChangeListener(changeListener2);
        this.m_targetDiff.getHorizontalScrollModel().addChangeListener(changeListener2);
        this.m_combo.setAlignmentY(0.0f);
        this.add(this.m_combo);
        this.m_vertScroll.setAlignmentY(0.0f);
        this.add(this.m_vertScroll);
    }
}

