/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.visdiff.DiffedDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class DiffContext
extends StyleContext
implements ViewFactory {
    private static final int MAX_TYPE = 5;
    int m_tabSize = 8;
    private boolean m_numbersOnly = false;
    Style[] m_diffStyles;
    transient Color[] m_diffColors;
    transient Font[] m_diffFonts;

    public void hackPurge() {
        this.m_diffColors = null;
        this.m_diffFonts = null;
    }

    public Color getForeground(int n) {
        if (this.m_diffColors == null) {
            this.m_diffColors = new Color[6];
        }
        if (n >= 0 && n < this.m_diffColors.length) {
            Color color = this.m_diffColors[n];
            if (color == null) {
                Style style = this.m_diffStyles[n];
                this.m_diffColors[n] = color = StyleConstants.getForeground(style);
            }
            return color;
        }
        return Color.black;
    }

    public Font getFontForType(int n) {
        if (this.m_diffFonts == null) {
            this.m_diffFonts = new Font[6];
        }
        if (n < this.m_diffFonts.length) {
            Font font = this.m_diffFonts[n];
            if (font == null) {
                Style style = this.m_diffStyles[n];
                this.m_diffFonts[n] = font = this.getFont(style);
            }
            return font;
        }
        return null;
    }

    protected int getTabSize() {
        return this.m_tabSize;
    }

    protected void setTabSize(int n) {
        if (n > 0) {
            this.m_tabSize = n;
        }
    }

    public boolean isNumberOnly() {
        return this.m_numbersOnly;
    }

    public void setNumberOnly(boolean bl) {
        this.m_numbersOnly = bl;
    }

    public View create(Element element) {
        DiffContext diffContext = this;
        if (diffContext == null) {
            throw null;
        }
        return diffContext.new DiffView(element);
    }

    public DiffContext() {
        Style style = this.getStyle("default");
        Style style2 = null;
        Style style3 = null;
        this.m_diffStyles = new Style[6];
        style2 = this.addStyle("same", style);
        StyleConstants.setFontFamily(style2, "Courier");
        StyleConstants.setFontSize(style2, 14);
        this.m_diffStyles[0] = style2;
        this.m_diffStyles[1] = style3 = this.addStyle("add", style2);
        this.m_diffStyles[2] = style3 = this.addStyle("del", style2);
        this.m_diffStyles[3] = style3 = this.addStyle("repl", style2);
        this.m_diffStyles[4] = style3 = this.addStyle("miss", style2);
        this.m_diffStyles[5] = style3 = this.addStyle("move", style2);
    }

    class DiffView
    extends PlainView {
        public float getPreferredSpan(int n) {
            float f = super.getPreferredSpan(n);
            if (n == 0 && this.isNumberOnly()) {
                f = 50.0f;
            }
            return f;
        }

        protected int getTabSize() {
            return DiffContext.this.m_tabSize;
        }

        protected void setTabSize(int n) {
            if (n > 0) {
                DiffContext.this.m_tabSize = n;
            }
        }

        private boolean isNumberOnly() {
            return DiffContext.this.m_numbersOnly;
        }

        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            DiffedDocument diffedDocument = (DiffedDocument)this.getDocument();
            int n5 = diffedDocument.getTypeAtOffset(n3);
            graphics.setColor(DiffContext.this.getForeground(n5));
            int n6 = n;
            if (!this.isNumberOnly()) {
                Segment segment = this.getLineBuffer();
                diffedDocument.getText(n3, n4 - n3, segment);
                n6 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            } else if ((n3 != 0 || diffedDocument.getLength() > 0) && n5 != 4) {
                int n7 = diffedDocument.getLocalLineAtOffset(n3) + 1;
                String string = Integer.toString(n7);
                graphics.drawString(string, n, n2);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n6 += fontMetrics.stringWidth(string);
            }
            if (n5 == 2 && n6 > n) {
                graphics.drawLine(n, n2 - 4, n6, n2 - 4);
            }
            return n6;
        }

        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            return this.drawUnselectedText(graphics, n, n2, n3, n4);
        }

        DiffView(Element element) {
            super(element);
        }
    }
}

