/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.swing.metalthemes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MetalThemeMenu
extends JMenu
implements ActionListener {
    MetalTheme[] m_themes;
    Component m_component;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        MetalTheme metalTheme = this.m_themes[Integer.parseInt(string)];
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            if (this.m_component == null) return;
        }
        catch (Exception exception) {
            System.out.println("Failed loading Metal");
            System.out.println(exception);
        }
    }

    public MetalThemeMenu(String string, MetalTheme[] metalThemeArray) {
        this(string, metalThemeArray, null);
    }

    public MetalThemeMenu(String string, MetalTheme[] metalThemeArray, Component component) {
        super(string);
        this.m_themes = metalThemeArray;
        this.m_component = component;
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = false;
        int n = 0;
        while (n < this.m_themes.length) {
            if (this.m_themes[n] != null) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.m_themes[n].getName());
                buttonGroup.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setActionCommand(n + "");
                jRadioButtonMenuItem.addActionListener(this);
                if (!bl) {
                    bl = true;
                    jRadioButtonMenuItem.setSelected(true);
                }
            }
            ++n;
        }
    }
}

