/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import System.Exception;
import com.starbase.util.FileAccess;
import com.starbase.util.FileBasedOptions;
import com.starbase.util.GUID;
import com.starbase.util.NativeFileAccess;
import com.starbase.util.OLEDate;
import com.starbase.util.PlatformEdge;
import com.starbase.util.UnixFileAccess;
import com.starbase.util.WintelOptions;
import com.starbase.util.WorkStationOptions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Platform {
    public static final String ONWINDOWSPROP = "onwin32";
    private static boolean m_bIsWin32 = false;
    private static WorkStationOptions m_options = null;
    private static FileAccess m_FileAccess = null;
    private static String m_optionsErrorMsg = null;
    private static boolean m_init = false;
    private static Object sync;

    public static boolean isWin32() {
        return m_bIsWin32;
    }

    public static boolean isDotNET() {
        return PlatformEdge.isDotNET();
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static WorkStationOptions getWSOptions() {
        return m_options;
    }

    public static final String getMachineName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "unknownhost";
        }
        return string;
    }

    public static final String getEOL() {
        return System.getProperty("line.separator");
    }

    public static final String getFilePathDelim() {
        return System.getProperty("file.separator");
    }

    public static boolean caseSensitiveFileNames() {
        return Platform.getWSOptions().getOption("casesensitive").equalsIgnoreCase("true");
    }

    public static String getTouchCmd() {
        return Platform.getWSOptions().getOption("touch");
    }

    public static String getSetReadOnlyCmd() {
        return Platform.getWSOptions().getOption("readonly");
    }

    public static String getSetWritableCmd() {
        return Platform.getWSOptions().getOption("writable");
    }

    public static GUID getWorkStationID() {
        Object object = sync;
        synchronized (object) {
            if (Platform.getWSOptions() == null) {
                throw new RuntimeException(m_optionsErrorMsg);
            }
            String string = Platform.getWSOptions().getOption("workstationid");
            if (string == null) {
                GUID gUID = new GUID();
                gUID.create();
                Platform.getWSOptions().setOption("workstationid", gUID.byteString());
                GUID gUID2 = gUID;
                Object var1_5 = null;
                return gUID2;
            }
            GUID gUID = new GUID(string);
            Object var1_6 = null;
            return gUID;
        }
    }

    public static double getFileLastModified(File file) throws IOException {
        long l = m_FileAccess.getLastModified(file.getAbsolutePath());
        return OLEDate.doubleFromLong(l);
    }

    public static void setFileLastModified(File file, double d) throws IOException {
        long l = OLEDate.longFromDouble(d);
        m_FileAccess.setLastModified(file.getAbsolutePath(), l);
    }

    public static final boolean getFileWritable(File file) {
        return file.canWrite();
    }

    public static void setFileWritable(File file, boolean bl) throws IOException {
        m_FileAccess.setCanWrite(file.getAbsolutePath(), bl);
    }

    public static boolean getFileExecutable(File file) throws IOException {
        return m_FileAccess.getIsExecutable(file.getAbsolutePath());
    }

    public static void setFileExecutable(File file, boolean bl) throws IOException {
        m_FileAccess.setIsExecutable(file.getAbsolutePath(), bl);
    }

    public static void printProps() {
        System.out.println("----------StarTeamProps----------");
        String string = Platform.getEOL();
        System.out.print("EOL: ");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\r': {
                    System.out.print("CR ");
                    break;
                }
                case '\n': {
                    System.out.print("LF ");
                    break;
                }
                default: {
                    System.out.print("0x" + Integer.toHexString(string.charAt(n)) + " ");
                    break;
                }
            }
            ++n;
        }
        System.out.println("");
        System.out.println("File path delim: " + Platform.getFilePathDelim());
        System.out.println("Case sensitive file names: " + Platform.caseSensitiveFileNames());
        System.out.println("----------JavaProps----------");
        System.out.println("java.version: " + System.getProperty("java.version"));
        System.out.println("java.vendor: " + System.getProperty("java.vendor"));
        System.out.println("java.vendor.url: " + System.getProperty("java.vendor.url"));
        System.out.println("java.home: " + System.getProperty("java.home"));
        System.out.println("java.class.path: " + System.getProperty("java.class.path"));
        System.out.println("----------OSProps----------");
        System.out.println("os.name: " + System.getProperty("os.name"));
        System.out.println("os.version: " + System.getProperty("os.version"));
        System.out.println("os.arch: " + System.getProperty("os.arch"));
        System.out.println("----------UserProps----------");
        System.out.println("user.name: " + System.getProperty("user.name"));
        System.out.println("user.home: " + System.getProperty("user.home"));
        System.out.println("user.dir: " + System.getProperty("user.dir"));
        System.out.println("SYSTEM PROPS:");
        System.getProperties().list(System.out);
        System.out.println("DONE SYSTEM PROPS.");
    }

    static {
        Object object = sync = new Object();
        synchronized (object) {
            if (!m_init) {
                if (System.getProperty(ONWINDOWSPROP) != null) {
                    m_bIsWin32 = true;
                } else {
                    String string = Platform.getOSName().toLowerCase();
                    String[] stringArray = new String[]{"windows", "win32"};
                    int n = 0;
                    while (n < stringArray.length) {
                        if (string.indexOf(stringArray[n]) >= 0) {
                            m_bIsWin32 = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (m_bIsWin32) {
                    m_options = new WintelOptions();
                    m_FileAccess = new NativeFileAccess();
                } else {
                    m_options = new FileBasedOptions();
                    m_FileAccess = null;
                    try {
                        try {
                            m_FileAccess = new NativeFileAccess();
                        }
                        catch (LinkageError linkageError) {
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (m_FileAccess == null) {
                        m_FileAccess = new UnixFileAccess();
                    }
                }
                m_init = true;
            }
        }
    }
}

