/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GUID {
    private static long _lastTick = System.currentTimeMillis();
    private byte[] m_data = new byte[16];
    private String m_stringRep = null;

    private synchronized long getTick() {
        long l = _lastTick;
        while (l == _lastTick) {
            l = System.currentTimeMillis();
        }
        _lastTick = l;
        return _lastTick;
    }

    private void fillFrom(int n, long l) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            this.m_data[n + n3] = (byte)(l >> n2 & 0xFFL);
            n2 += 8;
            ++n3;
        }
    }

    public void create() {
        byte[] byArray = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byArray = inetAddress.getAddress();
            int n = 0;
            while (n < 4) {
                this.m_data[n] = byArray[n];
                ++n;
            }
            this.fillFrom(4, this.getTick());
            this.fillFrom(8, this.getTick());
        }
        catch (UnknownHostException unknownHostException) {
            byArray = new byte[4];
            this.fillFrom(0, this.getTick());
            this.fillFrom(8, this.getTick());
        }
        this.m_stringRep = null;
    }

    public String byteString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            int n2 = this.m_data[n] & 0xFF;
            String string = Integer.toHexString(n2);
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] getData() {
        return this.m_data;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GUID)) {
            return false;
        }
        boolean bl = true;
        byte[] byArray = ((GUID)object).getData();
        int n = 0;
        while (n < 16 && bl) {
            if (this.m_data[n] != byArray[n]) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            n = n * 37 + this.m_data[n2];
            ++n2;
        }
        return n;
    }

    public String canonicalFormat() {
        if (this.m_stringRep == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int[] nArray = new int[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 10, 11, 12, 13, 14, 15};
            int n = 0;
            while (n < 16) {
                int n2 = this.m_data[nArray[n]] & 0xFF;
                String string = Integer.toHexString(n2);
                if (n2 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
                if (n == 3 || n == 5 || n == 7 || n == 9) {
                    stringBuffer.append("-");
                }
                ++n;
            }
            this.m_stringRep = stringBuffer.toString().toLowerCase();
        }
        return this.m_stringRep;
    }

    public String toString() {
        return this.canonicalFormat();
    }

    public String debugDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{GUID: ");
        stringBuffer.append(this.toString());
        stringBuffer.append("}");
        return stringBuffer.toString().toUpperCase();
    }

    public GUID() {
        int n = 0;
        while (n < 16) {
            this.m_data[n] = 0;
            ++n;
        }
        this.m_stringRep = null;
    }

    public GUID(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.GUID_SIZE_MUST_BE_16_FMT, new Object[]{new Integer(byArray.length)}));
        }
        this.m_data = byArray;
        this.m_stringRep = null;
    }

    public GUID(String string) {
        if (string.length() == 36) {
            int[] nArray = new int[]{6, 4, 2, 0, 11, 9, 16, 14, 19, 21, 24, 26, 28, 30, 32, 34};
            int n = 0;
            while (n < 16) {
                int n2 = nArray[n];
                this.m_data[n] = (byte)(Integer.parseInt(string.substring(n2, n2 + 2), 16) & 0xFF);
                ++n;
            }
        } else {
            int n = 0;
            while (n < string.length()) {
                this.m_data[n / 2] = (byte)(Integer.parseInt(string.substring(n, n + 2), 16) & 0xFF);
                n += 2;
            }
        }
        this.m_stringRep = null;
    }
}

