/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.BaseFileUtils;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class FileUtils {
    private static int FNM_FILE_NAME = 1;
    private static int FNM_NOESCAPE = 2;
    private static int FNM_PERIOD = 4;
    private static int FNM_LEADING_DIR = 8;
    private static int FNM_CASEFOLD = 16;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long cmp(File file, File file2) throws IOException {
        long l;
        InputStream inputStream;
        BufferedInputStream bufferedInputStream;
        block8: {
            long l2;
            block6: {
                block7: {
                    bufferedInputStream = null;
                    inputStream = null;
                    try {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        inputStream = new BufferedInputStream(new FileInputStream(file2));
                        int n = ((InputStream)bufferedInputStream).read();
                        int n2 = inputStream.read();
                        long l3 = 1L;
                        while (true) {
                            if (n == -1 || n2 == -1 || n != n2) {
                                if (n != -1 || n2 != -1) break;
                                l2 = -1L;
                                Object var5_9 = null;
                                if (bufferedInputStream == null) break block6;
                                break block7;
                            }
                            n = ((InputStream)bufferedInputStream).read();
                            n2 = inputStream.read();
                            ++l3;
                        }
                        l = l3;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                ((InputStream)bufferedInputStream).close();
            }
            if (inputStream == null) return l2;
            inputStream.close();
            return l2;
        }
        Object var5_10 = null;
        if (bufferedInputStream != null) {
            ((InputStream)bufferedInputStream).close();
        }
        if (inputStream == null) return l;
        inputStream.close();
        return l;
    }

    public static boolean isBinary(File file) throws IOException {
        return BaseFileUtils.isBinary(file);
    }

    public static int getFileLength(File file) throws IOException {
        return FileUtils.getFileLength(file.length());
    }

    private static int getFileLength(long l) throws IOException {
        long l2 = Integer.MAX_VALUE;
        if (l > l2) {
            throw new IOException(Res.formatKey(ResIDs.FILE_TOO_LARGE_FMT, new Object[]{new Long(l)}));
        }
        return (int)l;
    }

    private static int nextOccurance(int n, String string, String string2) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (string2.indexOf(c) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static boolean matchPatternList(String string, String string2, boolean bl) {
        String[] stringArray = FileUtils.parsePatternList(string2);
        return FileUtils.matchesAnyPattern(string, stringArray, bl);
    }

    public static boolean matchesAnyPattern(String string, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            if (FileUtils.match(stringArray[n], string, bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String[] parsePatternList(String string) {
        int n;
        int n2 = 0;
        char c = '\"';
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (!bl) {
            n = FileUtils.nextOccurance(n2, string, "\",; ");
            if (-1 == n) {
                string2 = string.substring(n2).trim();
                if (string2.length() != 0) {
                    vector.addElement(string2);
                }
                bl = true;
                continue;
            }
            if (c == string.charAt(n)) {
                int n3 = n + 1;
                if (-1 != (n = string.indexOf(c, n3))) {
                    string2 = string.substring(n3, n).trim();
                    if (string2.length() != 0) {
                        vector.addElement(string2);
                    }
                    n2 = n + 1;
                    continue;
                }
                bl = true;
                continue;
            }
            string2 = string.substring(n2, n).trim();
            if (string2.length() != 0) {
                vector.addElement(string2);
            }
            n2 = n + 1;
        }
        n = vector.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n4] = (String)enumeration.nextElement();
            ++n4;
        }
        return stringArray;
    }

    private static final char fixcase(char c, int n) {
        if ((n & FNM_CASEFOLD) != 0) {
            return Character.toLowerCase(c);
        }
        return c;
    }

    public static boolean match(String string, String string2, boolean bl) {
        int n = FNM_FILE_NAME;
        if (!bl) {
            n |= FNM_CASEFOLD;
        }
        char[] cArray = new char[string2.length() + 1];
        char[] cArray2 = new char[string.length() + 1];
        System.arraycopy(string2.toCharArray(), 0, cArray, 0, string2.length());
        System.arraycopy(string.toCharArray(), 0, cArray2, 0, string.length());
        return FileUtils.matchImpl(0, cArray2, 0, cArray, n);
    }

    private static boolean matchImpl(int n, char[] cArray, int n2, char[] cArray2, int n3) {
        boolean bl = FileUtils.matchReal(n, cArray, n2, cArray2, n3);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchReal(int n, char[] cArray, int n2, char[] cArray2, int n3) {
        char c;
        int n4 = n2;
        int n5 = n;
        while ((c = cArray[n5++]) != '\u0000') {
            c = FileUtils.fixcase(c, n3);
            block0 : switch (c) {
                case '?': {
                    if (cArray2[n4] == '\u0000') {
                        return false;
                    }
                    if ((n3 & FNM_FILE_NAME) != 0 && cArray2[n4] == '/') {
                        return false;
                    }
                    if ((n3 & FNM_PERIOD) == 0 || cArray2[n4] != '.' || n4 != n2 && ((n3 & FNM_FILE_NAME) == 0 || cArray2[n4 - 1] != '/')) break;
                    return false;
                }
                case '\\': {
                    if ((n3 & FNM_NOESCAPE) == 0) {
                        if ((c = cArray[n5++]) == '\u0000') {
                            return false;
                        }
                        c = FileUtils.fixcase(c, n3);
                    }
                    if (FileUtils.fixcase(cArray2[n4], n3) == c) break;
                    return false;
                }
                case '*': {
                    if ((n3 & FNM_PERIOD) != 0 && cArray2[n4] == '.' && (n4 == n2 || (n3 & FNM_FILE_NAME) != 0 && cArray2[n4 - 1] == '/')) {
                        return false;
                    }
                    c = cArray[n5++];
                    while (true) {
                        if (c != '?' && c != '*') {
                            if (c != '\u0000') break;
                            return true;
                        }
                        if ((n3 & FNM_FILE_NAME) != 0 && cArray2[n4] == '/') {
                            return false;
                        }
                        if (c == '?') {
                            if (cArray2[n4] == '\u0000') {
                                return false;
                            }
                            ++n4;
                        }
                        c = cArray[n5++];
                    }
                    char c2 = (n3 & FNM_NOESCAPE) == 0 && c == '\\' ? cArray[n5] : c;
                    c2 = FileUtils.fixcase(c2, n3);
                    --n5;
                    while (true) {
                        if (cArray2[n4] == '\u0000') {
                            return false;
                        }
                        if ((c == '[' || FileUtils.fixcase(cArray2[n4], n3) == c2) && FileUtils.matchImpl(n5, cArray, n4, cArray2, n3 & ~FNM_PERIOD)) {
                            return true;
                        }
                        ++n4;
                    }
                }
                case '[': {
                    char c2;
                    if (cArray2[n4] == '\u0000') {
                        return false;
                    }
                    if ((n3 & FNM_PERIOD) != 0 && cArray2[n4] == '.' && (n4 == n2 || (n3 & FNM_FILE_NAME) != 0 && cArray2[n4 - 1] == '/')) {
                        return false;
                    }
                    char c3 = c2 = cArray[n5] != '!' && cArray[n5] != '^' ? (char)'\u0000' : '\u0001';
                    if (c2 != '\u0000') {
                        // empty if block
                    }
                    int n6 = ++n5;
                    ++n5;
                    c = cArray[n6];
                    boolean bl = false;
                    while (!bl) {
                        boolean bl2;
                        char c4 = c;
                        char c5 = c;
                        if ((n3 & FNM_NOESCAPE) == 0 && c == '\\') {
                            if (cArray[n5] == '\u0000') {
                                return false;
                            }
                            c4 = c5 = cArray[n5++];
                        }
                        c4 = c5 = FileUtils.fixcase(c4, n3);
                        if (c == '\u0000') {
                            return false;
                        }
                        c = cArray[n5++];
                        c = FileUtils.fixcase(c, n3);
                        if ((n3 & FNM_FILE_NAME) != 0 && c == '/') {
                            return false;
                        }
                        if (c == '-' && cArray[n5] != ']') {
                            c5 = cArray[n5++];
                            if ((n3 & FNM_NOESCAPE) == 0 && c5 == '\\') {
                                c5 = cArray[n5++];
                            }
                            if (c5 == '\u0000') {
                                return false;
                            }
                            c5 = FileUtils.fixcase(c5, n3);
                            c = cArray[n5++];
                        }
                        char c6 = FileUtils.fixcase(cArray2[n4], n3);
                        boolean bl3 = FileUtils.fixcase(cArray2[n4], n3) >= c4;
                        boolean bl4 = bl2 = FileUtils.fixcase(cArray2[n4], n3) <= c5;
                        if (FileUtils.fixcase(cArray2[n4], n3) >= c4 && FileUtils.fixcase(cArray2[n4], n3) <= c5) {
                            bl = true;
                        }
                        if (bl || c != ']') continue;
                    }
                    if (!bl) {
                        if (c2 != '\u0000') break;
                        return false;
                    }
                    while (true) {
                        if (c == ']') {
                            if (c2 == '\u0000') break block0;
                            return false;
                        }
                        if (c == '\u0000') {
                            return false;
                        }
                        c = cArray[n5++];
                        if ((n3 & FNM_NOESCAPE) != 0 || c != '\\') continue;
                        if (cArray[n5] == '\u0000') {
                            return false;
                        }
                        ++n5;
                    }
                }
                default: {
                    if (c == FileUtils.fixcase(cArray2[n4], n3)) break;
                    return false;
                }
            }
            ++n4;
        }
        if (cArray2[n4] == '\u0000') {
            return true;
        }
        return (n3 & FNM_LEADING_DIR) != 0 && cArray2[n4] == '/';
    }

    public static final String fullyResolvedPath(String string, String string2) {
        return BaseFileUtils.fullyResolvedPath(string, string2);
    }

    public static final String getCanonicalPathName(String string, boolean bl) {
        return BaseFileUtils.getCanonicalPathName(string, bl);
    }

    public static final String getParent(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = (string = BaseFileUtils.getCanonicalPath(string, true, '\u0000')).lastIndexOf(string2);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != n || !FileUtils.isAbsolute(string)) {
            return string.substring(0, n);
        }
        if (n < string.length() - 1) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    public static final String getName(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = string.lastIndexOf(string2);
        if (n2 >= 0 && n2 < n - 1) {
            return string.substring(n2 + 1, n);
        }
        return string;
    }

    public static final boolean isAbsolute(String string) {
        return BaseFileUtils.isAbsolute(string);
    }

    public static final String getAbsolutePath(String string) {
        return BaseFileUtils.getAbsolutePath(string);
    }

    public static final String condensePath(String string, String string2, boolean bl) {
        return FileUtils.condenseFilePaths(string, string2, bl, "\\");
    }

    public static final String condenseFilePaths(String string, String string2, boolean bl, String string3) {
        String string4;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string5 = null;
        String string6 = FileUtils.getCanonicalPathName(string, bl);
        String string7 = FileUtils.getCanonicalPathName(string2, bl);
        StringTokenizer stringTokenizer = new StringTokenizer(string6, string3);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string7, string3);
        boolean bl5 = string6.startsWith("\\\\");
        boolean bl6 = bl4 = !bl5 && string6.startsWith("\\");
        if (!bl5 && string6.endsWith(":")) {
            if (string.endsWith(":")) {
                bl4 = true;
            } else {
                string6 = string6 + "\\";
            }
        }
        boolean bl7 = bl3 = !(bl2 = string7.startsWith("\\\\")) && string7.startsWith("\\");
        if (!bl2 && string7.endsWith(":")) {
            if (string2.endsWith(":")) {
                bl3 = true;
            } else {
                string7 = string7 + "\\";
            }
        }
        boolean bl8 = !(bl5 ^ bl2);
        boolean bl9 = bl4 || bl3;
        String string8 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string9 = string4 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
        if (bl5) {
            string8 = string8 + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "");
            string4 = string4 + (stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "");
        }
        boolean bl10 = FileUtils.pathsAreEqual(string8, string4, bl);
        if (new File(string6).isAbsolute() && new File(string7).isAbsolute() && bl8 && !bl9 && bl10) {
            Vector<String> vector = new Vector<String>();
            string5 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string8 = stringTokenizer.nextToken();
                String string10 = string4 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                if (FileUtils.pathsAreEqual(string8, string4, bl)) continue;
                vector.addElement("..");
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement("..");
                    stringTokenizer.nextElement();
                }
                if (string4 == null) break;
                vector.addElement(string4);
                break;
            }
            while (stringTokenizer2.hasMoreTokens()) {
                vector.addElement(stringTokenizer2.nextToken());
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string5 = string5 + enumeration.nextElement();
                string5 = string5 + (enumeration.hasMoreElements() ? string3 : "");
            }
        }
        return string5;
    }

    private static final boolean pathsAreEqual(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string == null && string2 == null) {
            bl2 = true;
        } else if (string != null && string2 != null) {
            bl2 = bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
        }
        return bl2;
    }

    private static String[] listAllFiles(String string) {
        return FileUtils.listAll(string, true, false);
    }

    private static String[] listAllDirs(String string) {
        return FileUtils.listAll(string, false, true);
    }

    private static String[] listAll(String string, boolean bl, boolean bl2) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null) {
                return new String[0];
            }
            return FileUtils.getMatching("*", string, stringArray, bl, bl2);
        }
        return new String[0];
    }

    private static boolean dosMatch(String string, String string2) {
        char[] cArray = FileUtils.namePart(string).toCharArray();
        char[] cArray2 = FileUtils.extPart(string).toCharArray();
        char[] cArray3 = FileUtils.namePart(string2).toCharArray();
        char[] cArray4 = FileUtils.extPart(string2).toCharArray();
        return FileUtils.dosmatchImpl(cArray, 0, cArray3, 0) && FileUtils.dosmatchImpl(cArray2, 0, cArray4, 0);
    }

    private static boolean dosmatchImpl(char[] cArray, int n, char[] cArray2, int n2) {
        int n3 = cArray.length;
        int n4 = cArray2.length;
        int n5 = n;
        int n6 = n2;
        while (n5 != n3) {
            char c;
            char c2;
            if (cArray[n5] == '*') {
                c2 = '\u0001';
                while (c2 != '\u0000') {
                    if (FileUtils.dosmatchImpl(cArray, n5 + 1, cArray2, n6)) {
                        return true;
                    }
                    if (n6 == n4) {
                        c2 = '\u0000';
                        continue;
                    }
                    ++n6;
                }
                return false;
            }
            if (cArray[n5] == '?') {
                return FileUtils.dosmatchImpl(cArray, n5 + 1, cArray2, n6) || n6 != n4 && FileUtils.dosmatchImpl(cArray, n5 + 1, cArray2, n6 + 1);
            }
            c2 = Character.toLowerCase(cArray[n5]);
            if (c2 != (c = Character.toLowerCase(cArray2[n6]))) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return n5 == n3 && n6 == n4;
    }

    private static String namePart(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static String extPart(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return "";
        }
        if (n2 == n - 1) {
            return "";
        }
        return string.substring(n2 + 1, n);
    }

    private static final String[] getWildCards(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (FileUtils.hasWildCard(stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray2[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray2;
    }

    private static final String[] getNonWildCards(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (!FileUtils.hasWildCard(stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray2[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray2;
    }

    private static final boolean hasWildCard(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        while (n3 < n && !bl) {
            c = string.charAt(n3);
            if (n2 != 92 && (c == '*' || c == '?')) {
                bl = true;
            }
            n2 = c;
            ++n3;
        }
        return bl;
    }

    private static String[] getMatching(String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        if (!string.equals("*")) {
            throw new IllegalArgumentException(Res.getString(ResIDs.CAN_ONLY_MATCH));
        }
        Vector<String> vector = new Vector<String>();
        File file = new File(string2);
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (bl2 && file2.isDirectory()) {
                vector.addElement(stringArray[n]);
            } else if (bl && file2.isFile()) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private FileUtils() {
    }
}

