/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

public class ByteOrder {
    public static final int readInt(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        return n + (n2 << 8) + (n3 << 16) + (n4 << 24);
    }

    public static final void writeInt(byte[] byArray, int n) {
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[3] = (byte)(n >>> 24 & 0xFF);
    }

    public static final double readDouble(byte[] byArray) {
        return Double.longBitsToDouble(ByteOrder.readLong(byArray));
    }

    public static final void writeDouble(byte[] byArray, double d) {
        ByteOrder.writeLong(byArray, Double.doubleToLongBits(d));
    }

    public static final long readLong(byte[] byArray) {
        long l = byArray[0] & 0xFF;
        long l2 = byArray[1] & 0xFF;
        long l3 = byArray[2] & 0xFF;
        long l4 = byArray[3] & 0xFF;
        long l5 = byArray[4] & 0xFF;
        long l6 = byArray[5] & 0xFF;
        long l7 = byArray[6] & 0xFF;
        long l8 = byArray[7] & 0xFF;
        return l + (l2 << 8) + (l3 << 16) + (l4 << 24) + (l5 << 32) + (l6 << 40) + (l7 << 48) + (l8 << 56);
    }

    public static final void writeLong(byte[] byArray, long l) {
        byArray[0] = (byte)((int)l & 0xFF);
        byArray[1] = (byte)((int)(l >>> 8) & 0xFF);
        byArray[2] = (byte)((int)(l >>> 16) & 0xFF);
        byArray[3] = (byte)((int)(l >>> 24) & 0xFF);
        byArray[4] = (byte)((int)(l >>> 32) & 0xFF);
        byArray[5] = (byte)((int)(l >>> 40) & 0xFF);
        byArray[6] = (byte)((int)(l >>> 48) & 0xFF);
        byArray[7] = (byte)((int)(l >>> 56) & 0xFF);
    }

    public static final void writeShort(byte[] byArray, int n) {
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
    }

    public static final short readShort(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        return (short)(n + (n2 << 8));
    }

    public static final byte[] intArrayToByteArray(int[] nArray) {
        int n = nArray == null ? 0 : nArray.length;
        byte[] byArray = new byte[n * 4];
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        while (n2 < n) {
            ByteOrder.writeInt(byArray2, nArray[n2]);
            int n3 = 0;
            while (n3 < 4) {
                byArray[n2 * 4 + n3] = byArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return byArray;
    }

    public static final int[] byteArrayToIntArray(byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        int n2 = n / 4;
        int[] nArray = new int[n2];
        byte[] byArray2 = new byte[4];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < 4) {
                byArray2[n4] = byArray[n3 * 4 + n4];
                ++n4;
            }
            nArray[n3] = ByteOrder.readInt(byArray2);
            ++n3;
        }
        return nArray;
    }
}

