/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.starteam.SDKRuntimeException;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;

public final class Assert {
    private static final boolean ON = true;

    public static final void isTrue(boolean bl, String string) {
        if (!bl) {
            Assert.report(new RuntimeException(string));
        }
    }

    public static final void notNull(Object object, String string) {
        if (object == null) {
            Assert.report(new NullPointerException(string));
        }
    }

    public static final void argIsTrue(boolean bl, String string) {
        if (!bl) {
            Assert.report(new IllegalArgumentException(string));
        }
    }

    public static final void argNotNull(Object object, String string) {
        if (object == null) {
            Assert.report(new IllegalArgumentException(string));
        }
    }

    private static final void report(RuntimeException runtimeException) {
        runtimeException.printStackTrace();
        throw runtimeException;
    }

    private static final void reporterror() {
        Exception exception = new Exception(Res.getString(ResIDs.ASSERTION_ERROR));
        exception.printStackTrace();
        throw new RuntimeException(Res.getString(ResIDs.ASSERTION_ERROR));
    }

    public static void internalError(String string) {
        throw new RuntimeException(Res.formatKey(ResIDs.INTERNAL_ERROR_FMT, new Object[]{string}));
    }

    public static void internalError(String string, Exception exception) {
        throw new SDKRuntimeException(Res.formatKey(ResIDs.INTERNAL_ERROR_FMT, new Object[]{string}), exception);
    }

    public static void nullArgument(String string) {
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NULL_ARGUMENT_FMT, new Object[]{string}));
    }

    public static void nullArgument(String string, String string2) {
        throw new IllegalArgumentException(Res.formatKey(ResIDs.NULL_NAMED_ARGUMENT_FMT, new Object[]{string, string2}));
    }
}

