/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.pickle.Res;
import com.starbase.starteam.vts.pickle.ResIDs;

public class EncryptionLevel {
    public static int getEncryptionAlgorithmCode(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == EncryptionAlgorithm.NULL) {
            return 0;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
            return 1;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
            return 2;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
            return 3;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            return 4;
        }
        String string = encryptionAlgorithm.toString();
        String string2 = Res.formatKey(ResIDs.ALG_NOT_SUPPORTED_FMT, new Object[]{string});
        throw new IllegalArgumentException(string2);
    }

    public static EncryptionAlgorithm getEncryptionAlgorithm(int n) {
        switch (n) {
            case 0: {
                return EncryptionAlgorithm.NULL;
            }
            case 1: {
                return EncryptionAlgorithm.RC4;
            }
            case 2: {
                return EncryptionAlgorithm.RC2_ECB;
            }
            case 3: {
                return EncryptionAlgorithm.RC2_CBC;
            }
            case 4: {
                return EncryptionAlgorithm.RC2_CFB;
            }
        }
        String string = "code=" + n;
        String string2 = Res.formatKey(ResIDs.ALG_NOT_SUPPORTED_FMT, new Object[]{string});
        throw new IllegalArgumentException(string2);
    }
}

