/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.BinaryCommand;
import com.starbase.starteam.vts.comm.Cipher;
import com.starbase.starteam.vts.comm.CmdServerReconnect;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandException;
import com.starbase.starteam.vts.comm.CommandExceptionDetected;
import com.starbase.starteam.vts.comm.Connection;
import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import java.io.IOException;
import java.net.Socket;

public class TcpIpConnection
extends Connection {
    protected Socket m_Socket = null;
    private Command m_command = null;

    public void commandNotInUse() {
        try {
            try {
                this.m_command.getReceiveFile().flushInput();
            }
            catch (CommandExceptionDetected commandExceptionDetected) {
                throw new SDKRuntimeException(Res.getString(ResIDs.PROBLEM_FLUSHING_INPUT), commandExceptionDetected);
            }
            catch (IOException iOException) {
                throw CommandException.forError(iOException);
            }
            Object var2_3 = null;
            super.commandNotInUse();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            super.commandNotInUse();
            throw throwable;
        }
    }

    public void connect() throws IOException {
        if (this.m_Socket != null) {
            Assert.internalError("TcpIpConnection.connect()");
        }
        this.internalConnect();
    }

    public void reconnect(GUID gUID) {
        try {
            this.internalConnect();
        }
        catch (IOException iOException) {
            throw CommandException.forError(iOException);
        }
        String string = this.getSessionName(gUID);
        byte[] byArray = this.getSessionBytes(gUID);
        CmdServerReconnect cmdServerReconnect = new CmdServerReconnect(gUID, string, byArray);
        cmdServerReconnect.execute(this, gUID, 0, 0);
    }

    private void internalConnect() throws IOException {
        Socket socket = new Socket(this.getHostName(), this.getPort());
        if (this.getProtocol() != 6) {
            throw new RuntimeException(Res.formatKey(ResIDs.INVALID_PROTOCOL_TYPE_FMT, new Object[]{new Integer(this.getProtocol())}));
        }
        BinaryCommand binaryCommand = new BinaryCommand(this.getServer(), socket);
        this.m_Socket = socket;
        this.m_command = binaryCommand;
    }

    public void disconnect() {
        if (this.m_Socket != null) {
            try {
                if (this.getEncrypter() != null) {
                    ((EncryptContext)this.getEncrypter()).dispose();
                }
                this.m_Socket.close();
                this.m_command = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_Socket = null;
        }
    }

    public Command prepareCommand(int n, int n2, Cipher cipher, Cipher cipher2, GUID gUID, int n3, int n4, int n5, int n6) throws IOException {
        ++this.m_commandCount;
        this.m_command.setRevisionLevel(this.getRevisionLevel());
        this.m_command.setCommandAPIRevisionLevel(this.getCommandAPIRevisionLevel());
        this.m_command.resetForNewCommand(this.getSessionTag(), 0, n, n2, this.getCompressionLevel(), cipher, cipher2, n5, gUID, n3, n4 & 0xFFFF | n6 & 0xFFFF0000, this.getCommandTime(), this.getCommandUserID());
        return this.m_command;
    }

    public void execCommand(Command command) throws IOException {
        if (command == null) {
            Assert.internalError("TcpIpConnection.execCommand(), command=null");
        }
        command.terminatePush();
    }

    public void terminateCommand(Command command) throws IOException {
        if (command == null) {
            Assert.internalError("TcpIpConnection.terminateCommand(), command=null");
        }
        command.terminatePop();
    }

    public void onCommandException(Exception exception) {
    }

    public TcpIpConnection(String string, int n, int n2, Server server) {
        super(string, n, n2, server);
    }
}

