/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.names;

import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Translations;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.names.EnumNames;
import com.starbase.starteam.names.Res;
import com.starbase.starteam.names.ResIDs;
import com.starbase.starteam.names.ResMan;
import com.starbase.util.GUID;

public class NameUtils
extends ResIDs {
    private static final String EMPTY = "";
    private static final String REQUIREMENT_GUID = "3f650429-d29a-4c7e-b086-4a60d853678d";
    private static final GUID s_requirementGUID = new GUID("3f650429-d29a-4c7e-b086-4a60d853678d");
    private static final String NEW_REVISION_COMMENT = "NewRevisionComment";
    static final String[] ALL_LANGUAGES = new String[]{"", "en", "es", "fr", "de", "ja", "th", "zh", "ar", "sv", "pt", "sr", "sq", "mk", "pl", "sl", "da", "sk", "sh", "cs", "iw", "it", "lv", "is", "lt", "ru", "fi", "ro", "ca", "uk", "et", "hu", "hr", "el", "ko", "bg", "no", "tr", "be", "hi", "nl"};

    public static Translations getTranslations(String string) {
        Translations translations = new Translations();
        String[] stringArray = ResMan.getSupportedLocales();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String string3 = ResMan.getString(string, string2);
            if (string3 != null) {
                translations.setTranslation(string2, string3);
            }
            ++n;
        }
        return translations;
    }

    private static boolean isRequirement(Type type) {
        if (type == null) {
            return false;
        }
        return s_requirementGUID.equals(type.getComponentGUID());
    }

    public static Translations getLocalizedEnumName(Property property, int n, String string) {
        return EnumNames.getLocalizedEnumName(property, n, string);
    }

    public static String getLocalizedTypeName(Type type, String string) {
        if (type == null) {
            return EMPTY;
        }
        TypeNames typeNames = type.getServer().getTypeNames();
        if (type.getName().equals("File")) {
            return Res.getString(ResIDs.TYPE_NAME_FILE);
        }
        if (type.getName().equals("ChangeRequest")) {
            return Res.getString(ResIDs.TYPE_NAME_CHANGEREQUEST);
        }
        if (type.getName().equals("Task")) {
            return Res.getString(ResIDs.TYPE_NAME_TASK);
        }
        if (type.getName().equals("Topic")) {
            return Res.getString(ResIDs.TYPE_NAME_TOPIC);
        }
        if (type.getName().equals("Audit")) {
            return Res.getString(ResIDs.TYPE_NAME_AUDIT);
        }
        if (type.getName().equals("Project")) {
            return Res.getString(ResIDs.TYPE_NAME_PROJECT);
        }
        if (type.getName().equals("View")) {
            return Res.getString(ResIDs.TYPE_NAME_VIEW);
        }
        if (type.getName().equals("Folder")) {
            return Res.getString(ResIDs.TYPE_NAME_FOLDER);
        }
        if (type.getName().equals("PromotionState")) {
            return Res.getString(ResIDs.TYPE_NAME_PROMOTION_STATE);
        }
        if (type.getName().equals("WorkRecord")) {
            return Res.getString(ResIDs.TYPE_NAME_WORKRECORD);
        }
        if (type.getName().equals("User")) {
            return Res.getString(ResIDs.TYPE_NAME_USER);
        }
        if (type.getName().equals("ProfileData")) {
            return Res.getString(ResIDs.TYPE_NAME_PROFILEDATA);
        }
        if (type.getName().equals("ItemReference")) {
            return Res.getString(ResIDs.TYPE_NAME_ITEMREFERENCE);
        }
        if (type.getName().equals("PromotionModel")) {
            return Res.getString(ResIDs.TYPE_NAME_PROMOTIONMODEL);
        }
        if (type.getName().equals("Label")) {
            return Res.getString(ResIDs.TYPE_NAME_LABEL);
        }
        if (type.getName().equals("TaskDependency")) {
            return Res.getString(ResIDs.TYPE_NAME_TASKDEPENDENCY);
        }
        if (type.getName().equals("ProfileType")) {
            return Res.getString(ResIDs.TYPE_NAME_PROFILETYPE);
        }
        if (NameUtils.isRequirement(type)) {
            return Res.getString(ResIDs.TYPE_NAME_REQUIREMENT);
        }
        return string;
    }

    public static Translations getLocalizedPropertyName(Property property, String string) {
        if (property == null) {
            return new Translations();
        }
        return NameUtils.getLocalizedPropertyNameForType(property.getType(), property.getName(), string);
    }

    public static Translations getLocalizedPropertyNameForType(Type type, String string, String string2) {
        TypeNames typeNames = type.getServer().getTypeNames();
        if (type.getName().equals("File")) {
            return NameUtils.getLocalizedFilePropertyName(type, string, string2);
        }
        if (type.getName().equals("ChangeRequest")) {
            return NameUtils.getLocalizedChangeRequestPropertyName(type, string, string2);
        }
        if (type.getName().equals("Task")) {
            return NameUtils.getLocalizedTaskPropertyName(type, string, string2);
        }
        if (type.getName().equals("Topic")) {
            return NameUtils.getLocalizedTopicPropertyName(type, string, string2);
        }
        if (type.getName().equals("Audit")) {
            return NameUtils.getLocalizedAuditPropertyName(type, string, string2);
        }
        if (type.getName().equals("Project")) {
            return NameUtils.getLocalizedProjectPropertyName(type, string, string2);
        }
        if (type.getName().equals("Folder")) {
            return NameUtils.getLocalizedFolderPropertyName(type, string, string2);
        }
        if (NameUtils.isRequirement(type)) {
            return NameUtils.getLocalizedRequirementPropertyName(type, string, string2);
        }
        if (type.getName().equals("WorkRecord")) {
            return NameUtils.getWorkRecord(type, string, string2);
        }
        if (type.getName().equals("User")) {
            return NameUtils.getUser(type, string, string2);
        }
        if (type.getName().equals("ProfileData")) {
            return NameUtils.getProfileData(type, string, string2);
        }
        if (type.getName().equals("PromotionModel")) {
            return NameUtils.getPromotionModel(type, string, string2);
        }
        if (type.getName().equals("PromotionState")) {
            return NameUtils.getPromotionState(type, string, string2);
        }
        if (type.getName().equals("Label")) {
            return NameUtils.getLabel(type, string, string2);
        }
        if (type.getName().equals("View")) {
            return NameUtils.getView(type, string, string2);
        }
        if (type.getName().equals("TaskDependency")) {
            return NameUtils.getTaskDependency(type, string, string2);
        }
        if (type.getName().equals("ProfileType")) {
            return NameUtils.getProfileType(type, string, string2);
        }
        if (type.getName().equals("ItemReference")) {
            return NameUtils.getItemReference(type, string, string2);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedTaskPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.TASK_WBS_CODE)) {
            return NameUtils.getTranslations(ResIDs.TASK_MS_WBS_CODE);
        }
        if (string.equals(propertyNames.TASK_ATTENTION_NOTES)) {
            return NameUtils.getTranslations(ResIDs.TASK_ATTENTION_NOTES);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_START)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_START);
        }
        if (string.equals(propertyNames.MY_LOCK)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MY_LOCK);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_HOURS_VARIANCE)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_HOURS_VARIANCE);
        }
        if (string.equals(propertyNames.TASK_DURATION)) {
            return NameUtils.getTranslations(ResIDs.TASK_TASK_DURATION);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.TASK_RESOURCE_IDS)) {
            return NameUtils.getTranslations(ResIDs.TASK_RESOURCE_IDS);
        }
        if (string.equals(propertyNames.FLAG)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.TASK_RESPONSIBILITY)) {
            return NameUtils.getTranslations(ResIDs.TASK_RESPONSIBILITY);
        }
        if (string.equals(propertyNames.TASK_CONSTRAINT_DATE)) {
            return NameUtils.getTranslations(ResIDs.TASK_CONSTRAINT_DATE);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.SHARE_STATE)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHARE_STATE);
        }
        if (string.equals(propertyNames.EXCLUSIVE_LOCKER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_LOCKED_BY);
        }
        if (string.equals(propertyNames.TASK_PRIORITY)) {
            return NameUtils.getTranslations(ResIDs.TASK_PRIORITY);
        }
        if (string.equals(propertyNames.TASK_RESOURCE_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TASK_RESOURCE_COUNT);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_FINISH)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_FINISH);
        }
        if (string.equals(propertyNames.TASK_ACTUAL_START)) {
            return NameUtils.getTranslations(ResIDs.TASK_ACTUAL_START);
        }
        if (string.equals(propertyNames.TASK_ACTUAL_FINISH)) {
            return NameUtils.getTranslations(ResIDs.TASK_ACTUAL_FINISH);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_HOURS)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_HOURS);
        }
        if (string.equals(propertyNames.TASK_IS_MY_TASK)) {
            return NameUtils.getTranslations(ResIDs.TASK_IS_MY_TASK);
        }
        if (string.equals(propertyNames.ATTACHMENT_IDS)) {
            return NameUtils.getTranslations(ResIDs.TASK_ATTACHMENT_IDS);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_START_VARIANCE)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_START_VARIANCE);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.TASK_PARENT_ID)) {
            return NameUtils.getTranslations(ResIDs.TASK_PARENT_TASK_ID);
        }
        if (string.equals(propertyNames.TASK_UNIQUE_ID)) {
            return NameUtils.getTranslations(ResIDs.TASK_MS_TASK_UNIQUE_ID);
        }
        if (string.equals(propertyNames.TASK_STATUS)) {
            return NameUtils.getTranslations(ResIDs.TASK_STATUS);
        }
        if (string.equals(propertyNames.TASK_NOTES)) {
            return NameUtils.getTranslations(ResIDs.TASK_NOTES);
        }
        if (string.equals(propertyNames.READ_STATUS)) {
            return NameUtils.getTranslations(ResIDs.TASK_READ_STATUS);
        }
        if (string.equals(propertyNames.TASK_CHILDREN_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TASK_CHILDREN_COUNT);
        }
        if (string.equals(propertyNames.TASK_CONSTRAINT_TYPE)) {
            return NameUtils.getTranslations(ResIDs.TASK_CONSTRAINT_TYPE);
        }
        if (string.equals(propertyNames.TASK_WORK_DEPENDENCY_LAST_UPDATE)) {
            return NameUtils.getTranslations(ResIDs.TASK_LAST_WORK_DEPENDENCY_UPDATE);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(NEW_REVISION_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NEW_REVISION_COMMENT);
        }
        if (string.equals(propertyNames.NON_EXCLUSIVE_LOCKERS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NON_EXCLUSIVE_LOCKERS);
        }
        if (string.equals(propertyNames.TASK_RESOURCE_NAMES)) {
            return NameUtils.getTranslations(ResIDs.TASK_RESOURCE_NAMES);
        }
        if (string.equals(propertyNames.READ_STATUS_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.TASK_READ_STATUS_USER_LIST);
        }
        if (string.equals(propertyNames.TASK_TYPE)) {
            return NameUtils.getTranslations(ResIDs.TASK_TASK_TYPE);
        }
        if (string.equals(propertyNames.TASK_ESTIMATED_FINISH_VARIANCE)) {
            return NameUtils.getTranslations(ResIDs.TASK_ESTIMATED_FINISH_VARIANCE);
        }
        if (string.equals(propertyNames.TASK_ACTUAL_HOURS)) {
            return NameUtils.getTranslations(ResIDs.TASK_ACTUAL_HOURS);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.TASK_PERCENT_COMPLETE)) {
            return NameUtils.getTranslations(ResIDs.TASK_PERCENT_COMPLETE);
        }
        if (string.equals(propertyNames.TASK_NAME)) {
            return NameUtils.getTranslations(ResIDs.TASK_TASK_NAME);
        }
        if (string.equals(propertyNames.ATTACHMENT_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TASK_ATTACHMENT_COUNT);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.TASK_IS_REPLICATED)) {
            return NameUtils.getTranslations(ResIDs.TASK_IS_REPLICATED);
        }
        if (string.equals(propertyNames.FLAG_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG_USER_LIST);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.TASK_ORIGIN)) {
            return NameUtils.getTranslations(ResIDs.TASK_TASK_ORIGIN);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.TASK_MSPROJECT_FILENAME)) {
            return NameUtils.getTranslations(ResIDs.TASK_MS_PROJECT_FILE_NAME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.TASK_MILESTONE)) {
            return NameUtils.getTranslations(ResIDs.TASK_MILESTONE);
        }
        if (string.equals(propertyNames.TASK_WORKRECORD_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TASK_WORK_RECORD_COUNT);
        }
        if (string.equals(propertyNames.CONFIGURATION_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CONFIGURATION_TIME);
        }
        if (string.equals(propertyNames.TASK_MSPROJECT_LAST_UPDATE)) {
            return NameUtils.getTranslations(ResIDs.TASK_LAST_MS_PROJECT_UPDATE);
        }
        if (string.equals(propertyNames.TASK_GUID)) {
            return NameUtils.getTranslations(ResIDs.TASK_MS_TASK_GUID);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.TASK_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.TASK_TASK_NUMBER);
        }
        if (string.equals(propertyNames.TASK_NEEDS_ATTENTION)) {
            return NameUtils.getTranslations(ResIDs.TASK_NEEDS_ATTENTION);
        }
        if (string.equals(propertyNames.ATTACHMENT_NAMES)) {
            return NameUtils.getTranslations(ResIDs.TASK_ATTACHMENT_NAMES);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals(propertyNames.READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_READ_ONLY);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedAuditPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        boolean bl = type.getServer().getSupportedFeatures().hasNewAuditProperties();
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.AUDIT_ITEM_1_INFO)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_ITEM_1_INFO);
        }
        if (string.equals(propertyNames.AUDIT_DESCRIPTOR)) {
            return bl ? NameUtils.getTranslations(ResIDs.AUDIT_ITEM_1) : NameUtils.getTranslations(ResIDs.AUDIT_ITEM);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_1_REVISION_TIME)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_1_REVISION_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_3_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_3_OBJECT_ID);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_2_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_2_OBJECT_ID);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.AUDIT_PROJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_PROJECT);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.AUDIT_CLASS3_NAME)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_CLASS_NAME_3);
        }
        if (string.equals(propertyNames.AUDIT_DESCRIPTOR3)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_ITEM_3);
        }
        if (string.equals(propertyNames.AUDIT_CLASS_NAME)) {
            return bl ? NameUtils.getTranslations(ResIDs.AUDIT_CLASS_NAME_1) : NameUtils.getTranslations(ResIDs.AUDIT_CLASS_NAME);
        }
        if (string.equals(propertyNames.VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_VIEW);
        }
        if (string.equals(propertyNames.AUDIT_CLASS2_NAME)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_CLASS_NAME_2);
        }
        if (string.equals(propertyNames.AUDIT_DESCRIPTOR2)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_ITEM_2);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.AUDIT_ITEM_3_INFO)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_ITEM_3_INFO);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_3_REVISION_TIME)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_3_REVISION_TIME);
        }
        if (string.equals(propertyNames.AUDIT_ITEM_2_INFO)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_ITEM_2_INFO);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_2_REVISION_TIME)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_2_REVISION_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.AUDIT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_1_OBJECT_ID);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.AUDIT_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_USER);
        }
        if (string.equals(propertyNames.AUDIT_FOLDER)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_FOLDER);
        }
        if (string.equals(propertyNames.AUDIT_EVENT_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_EVENT);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_3_CLASS_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_3_CLASS_ID);
        }
        if (string.equals(propertyNames.AUDIT_TARGET_2_CLASS_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_2_CLASS_ID);
        }
        if (string.equals(propertyNames.AUDIT_CLASS_ID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_TARGET_1_CLASS_ID);
        }
        if (string.equals(propertyNames.AUDIT_FOLDER_VMID)) {
            return NameUtils.getTranslations(ResIDs.AUDIT_FOLDER_VMID);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedFilePropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.MY_LOCK)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MY_LOCK);
        }
        if (string.equals(propertyNames.FILE_LOCAL_SIZE)) {
            return NameUtils.getTranslations(ResIDs.FILE_WORKING_FILE_SIZE);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.FILE_PVCS_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FILE_PVCS_REVISION);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.ROOT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FILE_ROOT_OBJECT_ID);
        }
        if (string.equals(propertyNames.DOTNOTATION_ID)) {
            return NameUtils.getTranslations(ResIDs.FILE_DOT_NOTATION_ID);
        }
        if (string.equals(propertyNames.FILE_PROJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FILE_PROJECT_ID);
        }
        if (string.equals(propertyNames.BRANCH_ON_CHANGE)) {
            return NameUtils.getTranslations(ResIDs.FILE_BRANCH_ON_CHANGE);
        }
        if (string.equals(propertyNames.FLAG)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG);
        }
        if (string.equals(propertyNames.FILE_ARCHIVE_PATH)) {
            return NameUtils.getTranslations(ResIDs.FILE_ARCHIVE_PATH);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.FILE_SYNC_SIZE)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_LOCAL_SIZE);
        }
        if (string.equals(propertyNames.FILE_SYNC_MD5)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_MD5);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.FILE_MD5_CHECKSUM)) {
            return NameUtils.getTranslations(ResIDs.FILE_MD5_CHECKSUM);
        }
        if (string.equals(propertyNames.SHARE_STATE)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHARE_STATE);
        }
        if (string.equals(propertyNames.PARENT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FILE_PARENT_ID);
        }
        if (string.equals(propertyNames.EXCLUSIVE_LOCKER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_LOCKED_BY);
        }
        if (string.equals(propertyNames.VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.FILE_VIEW);
        }
        if (string.equals(propertyNames.FILE_SIZE)) {
            return NameUtils.getTranslations(ResIDs.FILE_SIZE);
        }
        if (string.equals(propertyNames.FILE_ENCODING)) {
            return NameUtils.getTranslations(ResIDs.FILE_FILE_TYPE);
        }
        if (string.equals(propertyNames.FILE_LOCAL_TIMESTAMP)) {
            return NameUtils.getTranslations(ResIDs.FILE_WORKING_FILE_TIME_STAMP);
        }
        if (string.equals(propertyNames.FILE_CONTENT_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FILE_CONTENT_REVISION);
        }
        if (string.equals(propertyNames.FILE_STATUS)) {
            return NameUtils.getTranslations(ResIDs.FILE_STATUS);
        }
        if (string.equals(propertyNames.FILE_SYNC_TIME)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_LOCAL_TIME_STAMP);
        }
        if (string.equals(propertyNames.FILE_COMPRESSION_LEVEL)) {
            return NameUtils.getTranslations(ResIDs.FILE_COMPRESSION_LEVEL);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.FILE_SYNC_CONTENT_VERSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_CONTENT_VERSION);
        }
        if (string.equals(propertyNames.FILE_SYNC_ON_ROOT_PATH)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_ON_PATH_TO_ROOT);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.FILE_FILE_TIME_AT_CHECKIN)) {
            return NameUtils.getTranslations(ResIDs.FILE_FILE_TIME_STAMP_AT_CHECK_IN);
        }
        if (string.equals(propertyNames.FILE_VIEW_VERSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_REVISION);
        }
        if (string.equals(propertyNames.FILE_LOCAL_FILE_EXISTS)) {
            return NameUtils.getTranslations(ResIDs.FILE_WORKING_FILE_EXISTS);
        }
        if (string.equals(propertyNames.PATH_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FILE_PARENT_REVISION);
        }
        if (string.equals(propertyNames.FILE_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.FILE_DESCRIPTION);
        }
        if (string.equals(propertyNames.FILE_SYNC_OBJECT_VERSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_BRANCH_VERSION);
        }
        if (string.equals(propertyNames.FILE_SYNC_KNOWN)) {
            return NameUtils.getTranslations(ResIDs.FILE_SYNC_KNOWN);
        }
        if (string.equals(propertyNames.FILE_VAULT_BRANCH_VERSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_VAULT_BRANCH_VERSION);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(NEW_REVISION_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NEW_REVISION_COMMENT);
        }
        if (string.equals(propertyNames.NON_EXCLUSIVE_LOCKERS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NON_EXCLUSIVE_LOCKERS);
        }
        if (string.equals(propertyNames.PARENT_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FILE_PARENT_BRANCH_REVISION);
        }
        if (string.equals(propertyNames.FILE_EOL_CHARACTER)) {
            return NameUtils.getTranslations(ResIDs.FILE_EOL_CHARACTER);
        }
        if (string.equals(propertyNames.FILE_PATH)) {
            return NameUtils.getTranslations(ResIDs.FILE_PATH);
        }
        if (string.equals(propertyNames.BRANCH_STATE)) {
            return NameUtils.getTranslations(ResIDs.FILE_BRANCH_STATE);
        }
        if (string.equals(propertyNames.FILE_ARCHIVE_TYPE)) {
            return NameUtils.getTranslations(ResIDs.FILE_ARCHIVE_TYPE);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.FLAG_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG_USER_LIST);
        }
        if (string.equals(propertyNames.FILE_STORAGE_TYPE)) {
            return NameUtils.getTranslations(ResIDs.FILE_STORAGE_TYPE);
        }
        if (string.equals(propertyNames.FILE_FOLDER)) {
            return NameUtils.getTranslations(ResIDs.FILE_FOLDER);
        }
        if (string.equals(propertyNames.FILE_NAME)) {
            return NameUtils.getTranslations(ResIDs.FILE_NAME);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.FILE_EXTENSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_EXTENSION);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.CONFIGURATION_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CONFIGURATION_TIME);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.FILE_EXECUTABLE)) {
            return NameUtils.getTranslations(ResIDs.FILE_EXECUTABLE);
        }
        if (string.equals(propertyNames.FILE_SYNC_PATH_VERSION)) {
            return NameUtils.getTranslations(ResIDs.FILE_REVISION_ON_DISK);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals(propertyNames.READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_READ_ONLY);
        }
        if (string.equals(propertyNames.FILE_LOCAL_EXECUTABLE)) {
            return NameUtils.getTranslations(ResIDs.FILE_LOCAL_EXECUTABLE);
        }
        if (string.equals(propertyNames.FILE_LOCAL_NAME)) {
            return NameUtils.getTranslations(ResIDs.FILE_LOCAL_NAME);
        }
        if (string.equals(propertyNames.FILE_LOCAL_PATH)) {
            return NameUtils.getTranslations(ResIDs.FILE_LOCAL_PATH);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedRequirementPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals("RevisedDescription")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_REVISED_DESCRIPTION);
        }
        if (string.equals("ChildType")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_CHILD_TYPE);
        }
        if (string.equals("ResponsibleCount")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_RESPONSIBLECOUNT);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.FLAG_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG_USER_LIST);
        }
        if (string.equals("Status")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_STATUS);
        }
        if (string.equals("Disabled")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_DISABLED);
        }
        if (string.equals(propertyNames.READ_STATUS_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_READ_STATUS_USER_LIST);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals("Name")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_NAME);
        }
        if (string.equals("ResponsibleNames")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_RESPONSIBLE_NAMES);
        }
        if (string.equals("ReviewedByIDs")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_REVIEWED_BY);
        }
        if (string.equals(propertyNames.ATTACHMENT_IDS)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_ATTACHMENT_IDS);
        }
        if (string.equals("ResponsibleIDs")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_RESPONSIBLEIDS);
        }
        if (string.equals("HighEffort")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_HIGH_EFFORT);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals("Description")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_DESCRIPTION);
        }
        if (string.equals("RequirementNumber")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_NUMBER);
        }
        if (string.equals(propertyNames.SHARE_STATE)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHARE_STATE);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals("ExpectedEffort")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_EXPECTED_EFFORT);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals("Owner")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_OWNER);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals("ChildrenCount")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_CHILDREN_COUNT);
        }
        if (string.equals(propertyNames.NON_EXCLUSIVE_LOCKERS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NON_EXCLUSIVE_LOCKERS);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.EXCLUSIVE_LOCKER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_LOCKED_BY);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.FLAG)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG);
        }
        if (string.equals(propertyNames.READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_READ_ONLY);
        }
        if (string.equals(propertyNames.MY_LOCK)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MY_LOCK);
        }
        if (string.equals(propertyNames.CONFIGURATION_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CONFIGURATION_TIME);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals("Comments")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_COMMENTS);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals("Notes")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_NOTES);
        }
        if (string.equals("LowEffort")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_LOW_EFFORT);
        }
        if (string.equals(propertyNames.CR_EXTERNAL_REFERENCE)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_EXTERNAL_REFERENCE);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals("AmIResponsible")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_AM_I_RESPONSIBLE);
        }
        if (string.equals("ParentRequirementID")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_PARENT_REQUIREMENT_ID);
        }
        if (string.equals(NEW_REVISION_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NEW_REVISION_COMMENT);
        }
        if (string.equals("AmbiguitiesFound")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_AMBIGUITIES_FOUND);
        }
        if (string.equals(propertyNames.ATTACHMENT_COUNT)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_ATTACHMENT_COUNT);
        }
        if (string.equals("Type")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_TYPE);
        }
        if (string.equals("Priority")) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_PRIORITY);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.ATTACHMENT_NAMES)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_ATTACHMENT_NAMES);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.READ_STATUS)) {
            return NameUtils.getTranslations(ResIDs.REQUIREMENT_READ_STATUS);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedChangeRequestPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.CR_CATEGORY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_CATEGORY);
        }
        if (string.equals(propertyNames.MY_LOCK)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MY_LOCK);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.CR_SYNOPSIS)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_SYNOPSIS);
        }
        if (string.equals(propertyNames.ROOT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ROOT_OBJECT_ID);
        }
        if (string.equals(propertyNames.CR_FIX)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_FIX);
        }
        if (string.equals(propertyNames.DOTNOTATION_ID)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_DOT_NOTATION_ID);
        }
        if (string.equals(propertyNames.BRANCH_ON_CHANGE)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_BRANCH_ON_CHANGE);
        }
        if (string.equals(propertyNames.FLAG)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.CR_LAST_BUILD_TESTED)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_LAST_BUILD_TESTED);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.CR_RESOLVED_ON)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_RESOLVED_ON);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.SHARE_STATE)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHARE_STATE);
        }
        if (string.equals(propertyNames.PARENT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_PARENT_ID);
        }
        if (string.equals(propertyNames.EXCLUSIVE_LOCKER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_LOCKED_BY);
        }
        if (string.equals(propertyNames.VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_VIEW);
        }
        if (string.equals(propertyNames.CR_SEVERITY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_SEVERITY);
        }
        if (string.equals(propertyNames.CR_ENTERED_ON)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ENTERED_ON);
        }
        if (string.equals(propertyNames.ATTACHMENT_IDS)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ATTACHMENT_IDS);
        }
        if (string.equals(propertyNames.CR_STATUS)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_STATUS);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CR_ENTERED_BY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ENTERED_BY);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.PATH_REVISION)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_PARENT_REVISION);
        }
        if (string.equals(propertyNames.CR_PLATFORM)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_PLATFORM);
        }
        if (string.equals(propertyNames.CR_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_DESCRIPTION);
        }
        if (string.equals(propertyNames.CR_VERIFIED_ON)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_VERIFIED_ON);
        }
        if (string.equals(propertyNames.CR_COMPONENT)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_COMPONENT);
        }
        if (string.equals(propertyNames.READ_STATUS)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_READ_STATUS);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(NEW_REVISION_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NEW_REVISION_COMMENT);
        }
        if (string.equals(propertyNames.NON_EXCLUSIVE_LOCKERS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NON_EXCLUSIVE_LOCKERS);
        }
        if (string.equals(propertyNames.READ_STATUS_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_READ_STATUS_USER_LIST);
        }
        if (string.equals(propertyNames.PARENT_REVISION)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_PARENT_BRANCH_REVISION);
        }
        if (string.equals(propertyNames.CR_WORK_AROUND)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_WORK_AROUND);
        }
        if (string.equals(propertyNames.CR_ADDRESSED_IN_VIEW)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ADDRESSED_IN_VIEW);
        }
        if (string.equals(propertyNames.CR_PRIORITY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_PRIORITY);
        }
        if (string.equals(propertyNames.CR_EXTERNAL_REFERENCE)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_EXTERNAL_REFERENCE);
        }
        if (string.equals(propertyNames.BRANCH_STATE)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_BRANCH_STATE);
        }
        if (string.equals(propertyNames.CR_TYPE)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_TYPE);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.ATTACHMENT_COUNT)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ATTACHMENT_COUNT);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.CR_RESPONSIBILITY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_RESPONSIBILITY);
        }
        if (string.equals(propertyNames.CR_CLOSED_ON)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_CLOSED_ON);
        }
        if (string.equals(propertyNames.FLAG_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG_USER_LIST);
        }
        if (string.equals(propertyNames.CR_FOLDER)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_FOLDER);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.CR_TEST_COMMAND)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_TEST_COMMAND);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.CR_ADDRESSED_IN)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ADDRESSED_IN);
        }
        if (string.equals(propertyNames.CONFIGURATION_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CONFIGURATION_TIME);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.CR_CHANGE_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_CR_NUMBER);
        }
        if (string.equals(propertyNames.CR_ADDRESSED_BY)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ADDRESSED_BY);
        }
        if (string.equals(propertyNames.ATTACHMENT_NAMES)) {
            return NameUtils.getTranslations(ResIDs.CHANGEREQUEST_ATTACHMENT_NAMES);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals(propertyNames.READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_READ_ONLY);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedProjectPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.PROJECT_COMPACTION)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_COMPACT_DATA);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_REQUIRED)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_REQUIRED);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SHOW_CR_IN_PROGRESS)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_CR_INPROGRESS);
        }
        if (string.equals(propertyNames.PROJECT_ENCRYPTION)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_ENCRYPTION_METHOD);
        }
        if (string.equals(propertyNames.PROJECT_CONFIGSOURCE2)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_CONFIG_SOURCE_2);
        }
        if (string.equals(propertyNames.PROJECT_CONFIGSOURCE1)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_CONFIG_SOURCE_1);
        }
        if (string.equals(propertyNames.PROJECT_MARK_UNLOCKED_FILES_READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_MARK_UNLOCKED_FILES_READONLY);
        }
        if (string.equals(propertyNames.PROJECT_DEFAULT_VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_DEFAULT_VIEW_ID);
        }
        if (string.equals(propertyNames.PROJECT_NAME)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_NAME);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.PROJECT_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_DESCRIPTION);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.PROJECT_FORCE_CHECKIN_REASON)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_FORCE_CHECKIN_REASON);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SELECT_CR)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_SELECTCR);
        }
        if (string.equals(propertyNames.PROJECT_REQUIRE_LOCK_FOR_CHECKIN)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_REQUIRE_CHECKIN_LOCK);
        }
        if (string.equals(propertyNames.PROJECT_USE_KEYWORDS)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_USE_KEYWORDS);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SELECT_TASK)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_SELECT_TASK);
        }
        if (string.equals(propertyNames.PROJECT_KEYWORD_EXTENSIONS)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_KEYWORDS_FILE_EXTENSIONS);
        }
        if (string.equals(propertyNames.PROJECT_TYPE)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROJECT_TYPE);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SHOW_TASK_IN_PROGRESS)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_TASK_INPROGRESS);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SHOW_CR_OPEN)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_CR_OPEN);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.PROJECT_MAIL)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_ENABLE_MAIL);
        }
        if (string.equals(propertyNames.PROJECT_PROCESS_SHOW_TASK_READY)) {
            return NameUtils.getTranslations(ResIDs.PROJECT_PROCESS_TASK_READY);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedTopicPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.FLAG_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG_USER_LIST);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.TOPIC_STATUS)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_STATUS);
        }
        if (string.equals(propertyNames.READ_STATUS_USER_LIST)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_READ_STATUS_USER_LIST);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.ATTACHMENT_IDS)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_ATTACHMENT_IDS);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.TOPIC_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_CONTENT);
        }
        if (string.equals(propertyNames.SHARE_STATE)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHARE_STATE);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.TOPIC_CHILDREN_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_CHILDREN_COUNT);
        }
        if (string.equals(propertyNames.TOPIC_TITLE)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_TITLE);
        }
        if (string.equals(propertyNames.NON_EXCLUSIVE_LOCKERS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NON_EXCLUSIVE_LOCKERS);
        }
        if (string.equals(propertyNames.TOPIC_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_TOPIC_NUMBER);
        }
        if (string.equals(propertyNames.RECIPIENT_IDS)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_RECIPIENT_IDS);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.RECIPIENT_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_RECIPIENT_COUNT);
        }
        if (string.equals(propertyNames.EXCLUSIVE_LOCKER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_LOCKED_BY);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.FLAG)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FLAG);
        }
        if (string.equals(propertyNames.RECIPIENT_NAMES)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_RECIPIENT_NAMES);
        }
        if (string.equals(propertyNames.READ_ONLY)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_READ_ONLY);
        }
        if (string.equals(propertyNames.MY_LOCK)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MY_LOCK);
        }
        if (string.equals(propertyNames.CONFIGURATION_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CONFIGURATION_TIME);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.AM_I_RECIPIENT)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_AM_I_RECIPIENT);
        }
        if (string.equals(NEW_REVISION_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_NEW_REVISION_COMMENT);
        }
        if (string.equals(propertyNames.ATTACHMENT_COUNT)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_ATTACHMENT_COUNT);
        }
        if (string.equals(propertyNames.TOPIC_TYPE)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_TYPE);
        }
        if (string.equals(propertyNames.TOPIC_PRIORITY)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_PRIORITY);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.ATTACHMENT_NAMES)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_ATTACHMENT_NAMES);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.READ_STATUS)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_READ_STATUS);
        }
        if (string.equals(propertyNames.TOPIC_PARENT)) {
            return NameUtils.getTranslations(ResIDs.TOPIC_PARENT_TOPIC_ID);
        }
        return new Translations(string2);
    }

    private static Translations getLocalizedFolderPropertyName(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DOTNOTATION)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DOT_NOTATION);
        }
        if (string.equals(propertyNames.COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENT);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.PARENT_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_PARENT_BRANCH_REVISION);
        }
        if (string.equals(propertyNames.DOTNOTATION_ID)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_DOT_NOTATION_ID);
        }
        if (string.equals(propertyNames.FOLDER_NAME)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_NAME);
        }
        if (string.equals(propertyNames.FOLDER_EXCLUDE_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_EXCLUDE_FLAGS);
        }
        if (string.equals(propertyNames.ROOT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_ROOT_OBJECT_ID);
        }
        if (string.equals(propertyNames.PATH_REVISION)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_PARENT_REVISION);
        }
        if (string.equals(propertyNames.VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_VIEW);
        }
        if (string.equals(propertyNames.FOLDER_WORKING_FOLDER)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_WORKING_FOLDER);
        }
        if (string.equals(propertyNames.FOLDER_CREATE_PROJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_CREATING_PROJECT);
        }
        if (string.equals(propertyNames.FOLDER_EXCLUDE_SPEC)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_EXCLUDE_SPEC);
        }
        if (string.equals(propertyNames.PARENT_OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_PARENT_ID);
        }
        if (string.equals(propertyNames.FOLDER_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.FOLDER_DESCRIPTION);
        }
        return new Translations(string2);
    }

    private static Translations getWorkRecord(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.WORKRECORD_HOURS)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_HOURS);
        }
        if (string.equals(propertyNames.WORKRECORD_DATE)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_WORK_DATE);
        }
        if (string.equals(propertyNames.WORKRECORD_TASK_ID)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_TASK_ID);
        }
        if (string.equals(propertyNames.WORKRECORD_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_COMMENT);
        }
        if (string.equals(propertyNames.WORKRECORD_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_USER_ID);
        }
        if (string.equals(propertyNames.WORKRECORD_REMAINING_HOURS)) {
            return NameUtils.getTranslations(ResIDs.WORKRECORD_REMAINING_HOURS);
        }
        return new Translations(string2);
    }

    private static Translations getUser(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.USER_PAGER)) {
            return NameUtils.getTranslations(ResIDs.USER_PAGER);
        }
        if (string.equals(propertyNames.USER_FAX)) {
            return NameUtils.getTranslations(ResIDs.USER_FAX);
        }
        if (string.equals(propertyNames.USER_FULL_NAME)) {
            return NameUtils.getTranslations(ResIDs.USER_FULL_NAME);
        }
        if (string.equals(propertyNames.USER_PHONE)) {
            return NameUtils.getTranslations(ResIDs.USER_PHONE);
        }
        if (string.equals(propertyNames.USER_ADDRESS)) {
            return NameUtils.getTranslations(ResIDs.USER_E_MAIL_ADDRESS);
        }
        if (string.equals(propertyNames.USER_VOICE_MAIL)) {
            return NameUtils.getTranslations(ResIDs.USER_VOICEMAIL);
        }
        if (string.equals(propertyNames.USER_EMAIL_ADDRESS)) {
            return NameUtils.getTranslations(ResIDs.USER_E_MAIL_ADDRESS);
        }
        return new Translations(string2);
    }

    private static Translations getProfileData(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_VIEW_ID);
        }
        if (string.equals("ProjectID")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_PROJECT_ID);
        }
        if (string.equals("UserID")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_USER_ID);
        }
        if (string.equals("GroupID")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_GROUP_ID);
        }
        if (string.equals("ProfileClass")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_PROFILE_CLASS);
        }
        if (string.equals("Priority")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_PRIORITY);
        }
        if (string.equals("ProfileTypeID")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_PROFILE_TYPE_ID);
        }
        if (string.equals("FolderItemID")) {
            return NameUtils.getTranslations(ResIDs.PROFILEDATA_FOLDER_ITEM_ID);
        }
        return new Translations(string2);
    }

    private static Translations getPromotionModel(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_DESCRIPTION);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_STATE_COUNT)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_STATE_COUNT);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_NAME)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_NAME);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_STATE_IDS)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_STATE_IDS);
        }
        return new Translations(string2);
    }

    private static Translations getLabel(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.LABEL_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.LABEL_DESCRIPTION);
        }
        if (string.equals(propertyNames.LABEL_PROJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.LABEL_PROJECT);
        }
        if (string.equals(propertyNames.LABEL_NAME)) {
            return NameUtils.getTranslations(ResIDs.LABEL_NAME);
        }
        if (string.equals(propertyNames.LABEL_VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.LABEL_VIEW);
        }
        if (string.equals(propertyNames.LABEL_LABEL_TIME)) {
            return NameUtils.getTranslations(ResIDs.LABEL_LABEL_TIME);
        }
        if (string.equals(propertyNames.LABEL_MEMBER_ID)) {
            return NameUtils.getTranslations(ResIDs.LABEL_MEMBER_ID);
        }
        if (string.equals(propertyNames.LABEL_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.LABEL_FLAGS);
        }
        return new Translations(string2);
    }

    private static Translations getView(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.VIEW_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.VIEW_DESCRIPTION);
        }
        if (string.equals(propertyNames.VIEW_PROJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.VIEW_PROJECT_ID);
        }
        if (string.equals(propertyNames.VIEW_ROOT_MEMBER_ID)) {
            return NameUtils.getTranslations(ResIDs.VIEW_ROOT_MEMBER_ID);
        }
        if (string.equals(propertyNames.VIEW_BASECONFIG_TYPE)) {
            return NameUtils.getTranslations(ResIDs.VIEW_BASE_CONFIG_TYPE);
        }
        if (string.equals(propertyNames.VIEW_DELETE_COMPLETE)) {
            return NameUtils.getTranslations(ResIDs.VIEW_DELETECOMPLETE);
        }
        if (string.equals(propertyNames.VIEW_NAME)) {
            return NameUtils.getTranslations(ResIDs.VIEW_NAME);
        }
        if (string.equals(propertyNames.VIEW_PARENT_VIEW_ID)) {
            return NameUtils.getTranslations(ResIDs.VIEW_PARENT_VIEW_ID);
        }
        if (string.equals(propertyNames.VIEW_SHARE_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.VIEW_SHARE_FLAGS);
        }
        if (string.equals(propertyNames.VIEW_PROMOTION_ID)) {
            return NameUtils.getTranslations(ResIDs.VIEW_PROMOTIONID);
        }
        if (string.equals(propertyNames.VIEW_WORKING_FOLDER)) {
            return NameUtils.getTranslations(ResIDs.VIEW_WORKING_FOLDER);
        }
        if (string.equals(propertyNames.VIEW_BASECONFIG_DATA)) {
            return NameUtils.getTranslations(ResIDs.VIEW_BASE_CONFIG_DATA);
        }
        if (string.equals(propertyNames.VIEW_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.VIEW_FLAGS);
        }
        return new Translations(string2);
    }

    private static Translations getTaskDependency(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.COMMENT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_COMMENTID);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.SHORT_COMMENT)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_SHORT_COMMENT);
        }
        if (string.equals(propertyNames.REVISION_NUMBER)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_VERSION);
        }
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.REVISION_FLAGS)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_REVISION_FLAGS);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_DESCRIPTION);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_STATE_COUNT)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_STATE_COUNT);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_NAME)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_NAME);
        }
        if (string.equals(propertyNames.PROMOTIONMODEL_STATE_IDS)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONMODEL_STATE_IDS);
        }
        if (string.equals(propertyNames.TASKDEPENDENCY_LAG_TIME)) {
            return NameUtils.getTranslations(ResIDs.TASKDEPENDENCY_LAG_TIME);
        }
        if (string.equals(propertyNames.TASKDEPENDENCY_TYPE)) {
            return NameUtils.getTranslations(ResIDs.TASKDEPENDENCY_PREDECESSOR_TYPE);
        }
        if (string.equals(propertyNames.TASKDEPENDENCY_TASK_ID)) {
            return NameUtils.getTranslations(ResIDs.TASKDEPENDENCY_TASK_ID);
        }
        if (string.equals(propertyNames.TASKDEPENDENCY_PREDECESSOR_ID)) {
            return NameUtils.getTranslations(ResIDs.TASKDEPENDENCY_PREDECESSOR_ID);
        }
        return new Translations(string2);
    }

    private static Translations getPromotionState(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.PROMOTIONSTATE_NAME)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONSTATE_NAME);
        }
        if (string.equals(propertyNames.PROMOTIONSTATE_LABEL_ID)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONSTATE_LABEL_ID);
        }
        if (string.equals(propertyNames.PROMOTIONSTATE_DESCRIPTION)) {
            return NameUtils.getTranslations(ResIDs.PROMOTIONSTATE_DESCRIPTION);
        }
        return new Translations(string2);
    }

    private static Translations getProfileType(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.OBJECT_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_OBJECT_ID);
        }
        if (string.equals("Name")) {
            return NameUtils.getTranslations(ResIDs.PROFILETYPE_NAME);
        }
        if (string.equals("Description")) {
            return NameUtils.getTranslations(ResIDs.PROFILETYPE_DESCRIPTION);
        }
        if (string.equals("Security")) {
            return NameUtils.getTranslations(ResIDs.PROFILETYPE_SECURITY);
        }
        return new Translations(string2);
    }

    private static Translations getItemReference(Type type, String string, String string2) {
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        if (string.equals(propertyNames.CREATED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_TIME);
        }
        if (string.equals(propertyNames.DELETED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_TIME);
        }
        if (string.equals(propertyNames.END_MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_END_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.MODIFIED_TIME)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_TIME);
        }
        if (string.equals(propertyNames.FOLDER_PATH)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_FOLDER_PATH);
        }
        if (string.equals(propertyNames.MODIFIED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_MODIFIED_BY);
        }
        if (string.equals(propertyNames.DELETED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_DELETED_BY);
        }
        if (string.equals(propertyNames.CREATED_USER_ID)) {
            return NameUtils.getTranslations(ResIDs.GENERIC_CREATED_BY);
        }
        if (string.equals("Item ID")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_ITEM_ID);
        }
        if (string.equals("Folder Item ID")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_FOLDER_ITEM_ID);
        }
        if (string.equals("View Path")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_VIEW_PATH);
        }
        if (string.equals("Flags")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_FLAGS);
        }
        if (string.equals("Derived Count")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_DERIVED_COUNT);
        }
        if (string.equals("Item Revision")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_ITEM_REVISION);
        }
        if (string.equals("Project Name")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_PROJECT_NAME);
        }
        if (string.equals("Project ID")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_PROJECT_ID);
        }
        if (string.equals("View ID")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_VIEW_ID);
        }
        if (string.equals("Item Object ID")) {
            return NameUtils.getTranslations(ResIDs.ITEMREFERENCE_ITEM_OBJECT_ID);
        }
        return new Translations(string2);
    }
}

