/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.names;

import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Translations;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.names.NameUtils;
import com.starbase.starteam.names.ResIDs;
import com.starbase.util.GUID;

class EnumNames {
    private static final String EMPTY = "";
    private static final String REQUIREMENT_GUID = "3f650429-d29a-4c7e-b086-4a60d853678d";
    private static final GUID s_requirementGUID = new GUID("3f650429-d29a-4c7e-b086-4a60d853678d");
    private static final String NO = "No";
    private static final String YES = "Yes";
    private static final String NOT_SHARED = "Not Shared";
    private static final String ROOT_SHARE = "Root Share";
    private static final String DERIVED_SHARE = "DerivedShare";
    private static final String PENDING = "Pending";
    private static final String IN_PROGRESS = "In Progress";
    private static final String NOT_LOCKED_BY_ME = "Not Locked By Me";
    private static final String EXCLUSIVELY_LOCKED_BY_ME = "Exclusively Locked By Me";
    private static final String NON_EXCLUSIVELY_LOCKED_BY_ME = "Non-exclusively Locked By Me";
    private static final String HIGH = "High";
    private static final String MEDIUM = "Medium";
    private static final String LOW = "Low";
    private static final String READ = "Read";
    private static final String UNREAD = "Unread";
    private static final String MODIFIED = "Modified";
    private static final String BRANCHED = "Branched";
    private static final String LABEL_CREATED = "Label Created";
    private static final String LABEL_MODIFIED = "Label Modified";
    private static final String LABEL_DELETED = "Label Deleted";
    private static final String LABEL_FROZEN = "Label Frozen";
    private static final String LABEL_UNFROZEN = "Label Unfrozen";
    private static final String LABEL_ATTACHED = "Label Attached";
    private static final String LABEL_MOVED = "Label Moved";
    private static final String LABEL_DETACHED = "Label Detached";
    private static final String PROMOTION_MODEL_MODIFIED = "Promotion Model Modified";
    private static final String NOT_BRANCHED = "Not Branched";
    private static final String ROOT = "Root";
    private static final String DEFERRED = "Deferred";

    private static boolean isRequirement(Type type) {
        if (type == null) {
            return false;
        }
        return s_requirementGUID.equals(type.getComponentGUID());
    }

    static Translations getLocalizedEnumName(Property property, int n, String string) {
        if (property == null) {
            return new Translations(EMPTY);
        }
        Type type = property.getType();
        TypeNames typeNames = type.getServer().getTypeNames();
        if (type.getName().equals("File")) {
            return EnumNames.getFileEnumName(property, n, string);
        }
        if (type.getName().equals("ChangeRequest")) {
            return EnumNames.getChangeRequestEnumName(property, n, string);
        }
        if (type.getName().equals("Task")) {
            return EnumNames.getTaskEnumName(property, n, string);
        }
        if (type.getName().equals("Topic")) {
            return EnumNames.getTopicEnumName(property, n, string);
        }
        if (type.getName().equals("Audit")) {
            return EnumNames.getAuditEnumName(property, n, string);
        }
        if (type.getName().equals("Folder")) {
            return EnumNames.getFolderEnumName(property, n, string);
        }
        if (type.getName().equals("TaskDependency")) {
            return EnumNames.getTaskDependencyEnumName(property, n, string);
        }
        if (type.getName().equals("Project")) {
            return EnumNames.getProjectEnumName(property, n, string);
        }
        if (EnumNames.isRequirement(type)) {
            return EnumNames.getRequirementEnumName(property, n, string);
        }
        return new Translations(string);
    }

    private static Translations getTaskEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.TASK_IS_MY_TASK)) {
            if (n == propertyEnums.TASK_IS_MY_TASK_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.TASK_IS_MY_TASK_NO);
            }
            if (n == propertyEnums.TASK_IS_MY_TASK_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.TASK_IS_MY_TASK_YES);
            }
        } else if (string2.equals(propertyNames.SHARE_STATE)) {
            if (n == propertyEnums.SHARE_STATE_NOT_SHARED) {
                return EnumNames.enumName(property, string, NOT_SHARED, ResIDs.SHARE_STATE_NOT_SHARED);
            }
            if (n == propertyEnums.SHARE_STATE_ROOT_SHARE) {
                return EnumNames.enumName(property, string, ROOT_SHARE, ResIDs.SHARE_STATE_ROOT_SHARE);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, DERIVED_SHARE, ResIDs.TASK_SHARESTATE_DERIVEDSHARE);
            }
        } else if (string2.equals(propertyNames.TASK_TYPE)) {
            if (n == propertyEnums.TASK_TYPE_FIXED_DURATION) {
                return EnumNames.enumName(property, string, "Fixed Duration", ResIDs.TASK_TYPE_FIXED_DURATION);
            }
            if (n == propertyEnums.TASK_TYPE_FIXED_UNITS) {
                return EnumNames.enumName(property, string, "Fixed Units", ResIDs.TASK_TYPE_FIXED_UNITS);
            }
            if (n == propertyEnums.TASK_TYPE_FIXED_WORK) {
                return EnumNames.enumName(property, string, "Fixed Work", ResIDs.TASK_TYPE_FIXED_WORK);
            }
        } else if (string2.equals(propertyNames.TASK_CONSTRAINT_TYPE)) {
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_AS_LATE_AS_POSSIBLE) {
                return EnumNames.enumName(property, string, "As Late As Possible", ResIDs.TASK_CONSTRAINT_TYPE_AS_LATE_AS_POSSIBLE);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_AS_SOON_AS_POSSIBLE) {
                return EnumNames.enumName(property, string, "As Soon As Possible", ResIDs.TASK_CONSTRAINT_TYPE_AS_SOON_AS_POSSIBLE);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_FINISH_NO_EARLIER_THAN) {
                return EnumNames.enumName(property, string, "Finish No Earlier Than", ResIDs.TASK_CONSTRAINT_TYPE_FINISH_NO_EARLIER_THAN);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_FINISH_NO_LATER_THAN) {
                return EnumNames.enumName(property, string, "Finish No Later Than", ResIDs.TASK_CONSTRAINT_TYPE_FINISH_NO_LATER_THAN);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_MUST_FINISH_ON) {
                return EnumNames.enumName(property, string, "Must Finish On", ResIDs.TASK_CONSTRAINT_TYPE_MUST_FINISH_ON);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_MUST_START_ON) {
                return EnumNames.enumName(property, string, "Must Start On", ResIDs.TASK_CONSTRAINT_TYPE_MUST_START_ON);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_START_NO_EARLIER_THAN) {
                return EnumNames.enumName(property, string, "Start No Earlier Than", ResIDs.TASK_CONSTRAINT_TYPE_START_NO_EARLIER_THAN);
            }
            if (n == propertyEnums.TASK_CONSTRAINT_TYPE_START_NO_LATER_THAN) {
                return EnumNames.enumName(property, string, "Start No Later Than", ResIDs.TASK_CONSTRAINT_TYPE_START_NO_LATER_THAN);
            }
        } else if (string2.equals(propertyNames.FLAG)) {
            if (n == propertyEnums.FLAG_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FLAG_NO);
            }
            if (n == propertyEnums.FLAG_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FLAG_YES);
            }
        } else if (string2.equals(propertyNames.TASK_STATUS)) {
            if (n == propertyEnums.TASK_STATUS_PENDING) {
                return EnumNames.enumName(property, string, PENDING, ResIDs.TASK_STATUS_PENDING);
            }
            if (n == propertyEnums.TASK_STATUS_READY_TO_START) {
                return EnumNames.enumName(property, string, "Ready To Start", ResIDs.TASK_STATUS_READY_TO_START);
            }
            if (n == propertyEnums.TASK_STATUS_IN_PROGRESS) {
                return EnumNames.enumName(property, string, IN_PROGRESS, ResIDs.TASK_STATUS_IN_PROGRESS);
            }
            if (n == propertyEnums.TASK_STATUS_FINISHED) {
                return EnumNames.enumName(property, string, "Finished", ResIDs.TASK_STATUS_FINISHED);
            }
            if (n == propertyEnums.TASK_STATUS_CLOSED) {
                return EnumNames.enumName(property, string, "Closed", ResIDs.TASK_STATUS_CLOSED);
            }
            if (n == propertyEnums.TASK_STATUS_HOLD) {
                return EnumNames.enumName(property, string, "Hold", ResIDs.TASK_STATUS_HOLD);
            }
        } else if (string2.equals(propertyNames.READ_ONLY)) {
            if (n == propertyEnums.READ_ONLY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.READ_ONLY_NO);
            }
            if (n == propertyEnums.READ_ONLY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.READ_ONLY_YES);
            }
        } else if (string2.equals(propertyNames.MY_LOCK)) {
            if (n == propertyEnums.MY_LOCK_NOT_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NOT_LOCKED_BY_ME, ResIDs.MY_LOCK_NOT_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NON_EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME);
            }
        } else if (string2.equals(propertyNames.TASK_MILESTONE)) {
            if (n == propertyEnums.TASK_MILESTONE_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.TASK_MILESTONE_NO);
            }
            if (n == propertyEnums.TASK_MILESTONE_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.TASK_MILESTONE_YES);
            }
        } else if (string2.equals(propertyNames.TASK_NEEDS_ATTENTION)) {
            if (n == propertyEnums.TASK_NEEDS_ATTENTION_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.TASK_NEEDS_ATTENTION_NO);
            }
            if (n == propertyEnums.TASK_NEEDS_ATTENTION_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.TASK_NEEDS_ATTENTION_YES);
            }
        } else if (string2.equals(propertyNames.TASK_ORIGIN)) {
            if (n == propertyEnums.TASK_ORIGIN_STARTEAM) {
                return EnumNames.enumName(property, string, "StarTeam", ResIDs.TASK_ORIGIN_STARTEAM);
            }
            if (n == propertyEnums.TASK_ORIGIN_MSPROJECT) {
                return EnumNames.enumName(property, string, "MSProject", ResIDs.TASK_ORIGIN_MSPROJECT);
            }
        } else if (string2.equals(propertyNames.TASK_PRIORITY)) {
            if (n == propertyEnums.TASK_PRIORITY_DO_NOT_LEVEL) {
                return EnumNames.enumName(property, string, "Do Not Level", ResIDs.TASK_PRIORITY_DO_NOT_LEVEL);
            }
            if (n == propertyEnums.TASK_PRIORITY_HIGHEST) {
                return EnumNames.enumName(property, string, "Highest", ResIDs.TASK_PRIORITY_HIGHEST);
            }
            if (n == propertyEnums.TASK_PRIORITY_VERY_HIGH) {
                return EnumNames.enumName(property, string, "Very High", ResIDs.TASK_PRIORITY_VERY_HIGH);
            }
            if (n == propertyEnums.TASK_PRIORITY_HIGHER) {
                return EnumNames.enumName(property, string, "Higher", ResIDs.TASK_PRIORITY_HIGHER);
            }
            if (n == propertyEnums.TASK_PRIORITY_HIGH) {
                return EnumNames.enumName(property, string, HIGH, ResIDs.TASK_PRIORITY_HIGH);
            }
            if (n == propertyEnums.TASK_PRIORITY_MEDIUM) {
                return EnumNames.enumName(property, string, MEDIUM, ResIDs.TASK_PRIORITY_MEDIUM);
            }
            if (n == propertyEnums.TASK_PRIORITY_LOW) {
                return EnumNames.enumName(property, string, LOW, ResIDs.TASK_PRIORITY_LOW);
            }
            if (n == propertyEnums.TASK_PRIORITY_LOWER) {
                return EnumNames.enumName(property, string, "Lower", ResIDs.TASK_PRIORITY_LOWER);
            }
            if (n == propertyEnums.TASK_PRIORITY_VERY_LOW) {
                return EnumNames.enumName(property, string, "Very Low", ResIDs.TASK_PRIORITY_VERY_LOW);
            }
            if (n == propertyEnums.TASK_PRIORITY_LOWEST) {
                return EnumNames.enumName(property, string, "Lowest", ResIDs.TASK_PRIORITY_LOWEST);
            }
        } else if (string2.equals(propertyNames.READ_STATUS)) {
            if (n == propertyEnums.READ_STATUS_READ) {
                return EnumNames.enumName(property, string, READ, ResIDs.READ_STATUS_READ);
            }
            if (n == propertyEnums.READ_STATUS_UNREAD) {
                return EnumNames.enumName(property, string, UNREAD, ResIDs.READ_STATUS_UNREAD);
            }
        }
        return new Translations(string);
    }

    private static Translations enumName(Property property, String string, String string2, String string3) {
        String string4 = string;
        if (string4 != null && string4.equals(string2)) {
            return NameUtils.getTranslations(string3);
        }
        return new Translations(string4);
    }

    private static Translations getAuditEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.AUDIT_EVENT_ID)) {
            if (n == propertyEnums.AUDIT_EVENT_ID_CREATED) {
                return EnumNames.enumName(property, string, "Created", ResIDs.AUDIT_EVENT_ID_CREATED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_MODIFIED) {
                return EnumNames.enumName(property, string, MODIFIED, ResIDs.AUDIT_EVENT_ID_MODIFIED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_BRANCHED) {
                return EnumNames.enumName(property, string, BRANCHED, ResIDs.AUDIT_EVENT_ID_BRANCHED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_DELETED) {
                return EnumNames.enumName(property, string, "Deleted", ResIDs.AUDIT_EVENT_ID_DELETED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_MOVED_FROM) {
                return EnumNames.enumName(property, string, "Moved From", ResIDs.AUDIT_EVENT_ID_MOVED_FROM);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_MOVED_TO) {
                return EnumNames.enumName(property, string, "Moved To", ResIDs.AUDIT_EVENT_ID_MOVED_TO);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_SHARED) {
                return EnumNames.enumName(property, string, "Shared", ResIDs.AUDIT_EVENT_ID_SHARED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_ADDED) {
                return EnumNames.enumName(property, string, "Added", ResIDs.AUDIT_EVENT_ID_ADDED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_CHECKED_IN) {
                return EnumNames.enumName(property, string, "Checked In", ResIDs.AUDIT_EVENT_ID_CHECKED_IN);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_CHECKED_OUT) {
                return EnumNames.enumName(property, string, "Checked Out", ResIDs.AUDIT_EVENT_ID_CHECKED_OUT);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_LOCKED) {
                return EnumNames.enumName(property, string, "Locked", ResIDs.AUDIT_EVENT_ID_LOCKED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_UNLOCKED) {
                return EnumNames.enumName(property, string, "Unlocked", ResIDs.AUDIT_EVENT_ID_UNLOCKED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_LOCK_BROKEN) {
                return EnumNames.enumName(property, string, "Lock Broken", ResIDs.AUDIT_EVENT_ID_LOCK_BROKEN);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_VAULT_CONVERTED) {
                return EnumNames.enumName(property, string, "Vault Converted", ResIDs.AUDIT_EVENT_ID_VAULT_CONVERTED);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_ITEM_OVERWRITTEN) {
                return EnumNames.enumName(property, string, "Item Overwritten", ResIDs.AUDIT_EVENT_ID_ITEM_OVERWRITTEN);
            }
            if (n == propertyEnums.AUDIT_EVENT_ID_COMMENT_EDITED) {
                return EnumNames.enumName(property, string, "Comment Edited", ResIDs.AUDIT_EVENT_ID_COMMENT_EDITED);
            }
            if (n == 23) {
                return EnumNames.enumName(property, string, LABEL_CREATED, ResIDs.AUDIT_EVENTID_LABEL_CREATED);
            }
            if (n == 24) {
                return EnumNames.enumName(property, string, LABEL_MODIFIED, ResIDs.AUDIT_EVENTID_LABEL_MODIFIED);
            }
            if (n == 25) {
                return EnumNames.enumName(property, string, LABEL_DELETED, ResIDs.AUDIT_EVENTID_LABEL_DELETED);
            }
            if (n == 26) {
                return EnumNames.enumName(property, string, LABEL_FROZEN, ResIDs.AUDIT_EVENTID_LABEL_FROZEN);
            }
            if (n == 27) {
                return EnumNames.enumName(property, string, LABEL_UNFROZEN, ResIDs.AUDIT_EVENTID_LABEL_UNFROZEN);
            }
            if (n == 28) {
                return EnumNames.enumName(property, string, LABEL_ATTACHED, ResIDs.AUDIT_EVENTID_LABEL_ATTACHED);
            }
            if (n == 29) {
                return EnumNames.enumName(property, string, LABEL_MOVED, ResIDs.AUDIT_EVENTID_LABEL_MOVED);
            }
            if (n == 30) {
                return EnumNames.enumName(property, string, LABEL_DETACHED, ResIDs.AUDIT_EVENTID_LABEL_DETACHED);
            }
            if (n == 31) {
                return EnumNames.enumName(property, string, PROMOTION_MODEL_MODIFIED, ResIDs.AUDIT_EVENTID_PROMOTION_MODEL_MODIFIED);
            }
            if (n == 81) {
                return EnumNames.enumName(property, string, "Promotion Status Modified", ResIDs.AUDIT_EVENTID_PROMOTION_STATUS_MODIFIED);
            }
            if (n == 49) {
                return EnumNames.enumName(property, string, LABEL_CREATED, ResIDs.AUDIT_EVENTID_LABEL_CREATED);
            }
            if (n == 50) {
                return EnumNames.enumName(property, string, LABEL_MODIFIED, ResIDs.AUDIT_EVENTID_LABEL_MODIFIED);
            }
            if (n == 51) {
                return EnumNames.enumName(property, string, LABEL_DELETED, ResIDs.AUDIT_EVENTID_LABEL_DELETED);
            }
            if (n == 52) {
                return EnumNames.enumName(property, string, LABEL_FROZEN, ResIDs.AUDIT_EVENTID_LABEL_FROZEN);
            }
            if (n == 53) {
                return EnumNames.enumName(property, string, LABEL_UNFROZEN, ResIDs.AUDIT_EVENTID_LABEL_UNFROZEN);
            }
            if (n == 54) {
                return EnumNames.enumName(property, string, LABEL_ATTACHED, ResIDs.AUDIT_EVENTID_LABEL_ATTACHED);
            }
            if (n == 55) {
                return EnumNames.enumName(property, string, LABEL_MOVED, ResIDs.AUDIT_EVENTID_LABEL_MOVED);
            }
            if (n == 56) {
                return EnumNames.enumName(property, string, LABEL_DETACHED, ResIDs.AUDIT_EVENTID_LABEL_DETACHED);
            }
            if (n == 80) {
                return EnumNames.enumName(property, string, PROMOTION_MODEL_MODIFIED, ResIDs.AUDIT_EVENTID_PROMOTION_MODEL_MODIFIED);
            }
        }
        return new Translations(string);
    }

    private static Translations getFileEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.FILE_LOCAL_EXECUTABLE)) {
            if (n == 0) {
                return EnumNames.enumName(property, string, NO, ResIDs.FILE_WORKINGFILEEXECUTABLE_NO);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, YES, ResIDs.FILE_WORKINGFILEEXECUTABLE_YES);
            }
        } else if (string2.equals(propertyNames.FILE_STATUS)) {
            if (n == propertyEnums.FILE_STATUS_CURRENT) {
                return EnumNames.enumName(property, string, "Current", ResIDs.FILE_STATUS_CURRENT);
            }
            if (n == propertyEnums.FILE_STATUS_MODIFIED) {
                return EnumNames.enumName(property, string, MODIFIED, ResIDs.FILE_STATUS_MODIFIED);
            }
            if (n == propertyEnums.FILE_STATUS_OUT_OF_DATE) {
                return EnumNames.enumName(property, string, "Out of Date", ResIDs.FILE_STATUS_OUT_OF_DATE);
            }
            if (n == propertyEnums.FILE_STATUS_MERGE) {
                return EnumNames.enumName(property, string, "Merge", ResIDs.FILE_STATUS_MERGE);
            }
            if (n == propertyEnums.FILE_STATUS_UNKNOWN) {
                return EnumNames.enumName(property, string, "Unknown", ResIDs.FILE_STATUS_UNKNOWN);
            }
            if (n == propertyEnums.FILE_STATUS_NOT_IN_VIEW) {
                return EnumNames.enumName(property, string, "Not in View", ResIDs.FILE_STATUS_NOT_IN_VIEW);
            }
            if (n == propertyEnums.FILE_STATUS_MISSING) {
                return EnumNames.enumName(property, string, "Missing", ResIDs.FILE_STATUS_MISSING);
            }
        } else if (string2.equals(propertyNames.BRANCH_STATE)) {
            if (n == propertyEnums.BRANCH_STATE_NOT_BRANCHED) {
                return EnumNames.enumName(property, string, NOT_BRANCHED, ResIDs.BRANCH_STATE_NOT_BRANCHED);
            }
            if (n == propertyEnums.BRANCH_STATE_BRANCHED) {
                return EnumNames.enumName(property, string, BRANCHED, ResIDs.BRANCH_STATE_BRANCHED);
            }
            if (n == propertyEnums.BRANCH_STATE_ROOT) {
                return EnumNames.enumName(property, string, ROOT, ResIDs.BRANCH_STATE_ROOT);
            }
        } else if (string2.equals(propertyNames.FILE_COMPRESSION_LEVEL)) {
            if (n == propertyEnums.FILE_COMPRESSION_LEVEL_NONE) {
                return EnumNames.enumName(property, string, "None", ResIDs.FILE_COMPRESSION_LEVEL_NONE);
            }
            if (n == propertyEnums.FILE_COMPRESSION_LEVEL_MAXIMIZE_SPEED) {
                return EnumNames.enumName(property, string, "Maximize Speed", ResIDs.FILE_COMPRESSION_LEVEL_MAXIMIZE_SPEED);
            }
            if (n == propertyEnums.FILE_COMPRESSION_LEVEL_DEFAULT) {
                return EnumNames.enumName(property, string, "Default", ResIDs.FILE_COMPRESSION_LEVEL_DEFAULT);
            }
            if (n == propertyEnums.FILE_COMPRESSION_LEVEL_MAXIMIZE_COMPRESSION) {
                return EnumNames.enumName(property, string, "Maximize Compression", ResIDs.FILE_COMPRESSION_LEVEL_MAXIMIZE_COMPRESSION);
            }
        } else if (string2.equals(propertyNames.FILE_STORAGE_TYPE)) {
            if (n == propertyEnums.FILE_STORAGE_TYPE_FULL_VERSIONS) {
                return EnumNames.enumName(property, string, "Full Versions", ResIDs.FILE_STORAGE_TYPE_FULL_VERSIONS);
            }
            if (n == propertyEnums.FILE_STORAGE_TYPE_DELTA) {
                return EnumNames.enumName(property, string, "Delta", ResIDs.FILE_STORAGE_TYPE_DELTA);
            }
        } else if (string2.equals(propertyNames.BRANCH_ON_CHANGE)) {
            if (n == propertyEnums.BRANCH_ON_CHANGE_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.BRANCH_ON_CHANGE_NO);
            }
            if (n == propertyEnums.BRANCH_ON_CHANGE_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.BRANCH_ON_CHANGE_YES);
            }
        } else if (string2.equals(propertyNames.SHARE_STATE)) {
            if (n == propertyEnums.SHARE_STATE_NOT_SHARED) {
                return EnumNames.enumName(property, string, NOT_SHARED, ResIDs.SHARE_STATE_NOT_SHARED);
            }
            if (n == propertyEnums.SHARE_STATE_ROOT_SHARE) {
                return EnumNames.enumName(property, string, ROOT_SHARE, ResIDs.SHARE_STATE_ROOT_SHARE);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, DERIVED_SHARE, ResIDs.FILE_SHARESTATE_DERIVEDSHARE);
            }
        } else if (string2.equals(propertyNames.FILE_EXECUTABLE)) {
            if (n == propertyEnums.FILE_EXECUTABLE_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FILE_EXECUTABLE_NO);
            }
            if (n == propertyEnums.FILE_EXECUTABLE_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FILE_EXECUTABLE_YES);
            }
        } else if (string2.equals(propertyNames.FLAG)) {
            if (n == propertyEnums.FLAG_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FLAG_NO);
            }
            if (n == propertyEnums.FLAG_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FLAG_YES);
            }
        } else if (string2.equals(propertyNames.READ_ONLY)) {
            if (n == propertyEnums.READ_ONLY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.READ_ONLY_NO);
            }
            if (n == propertyEnums.READ_ONLY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.READ_ONLY_YES);
            }
        } else if (string2.equals(propertyNames.MY_LOCK)) {
            if (n == propertyEnums.MY_LOCK_NOT_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NOT_LOCKED_BY_ME, ResIDs.MY_LOCK_NOT_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NON_EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME);
            }
        } else if (string2.equals(propertyNames.FILE_SYNC_ON_ROOT_PATH)) {
            if (n == propertyEnums.FILE_SYNC_ON_ROOT_PATH_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FILE_SYNC_ON_ROOT_PATH_NO);
            }
            if (n == propertyEnums.FILE_SYNC_ON_ROOT_PATH_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FILE_SYNC_ON_ROOT_PATH_YES);
            }
        } else if (string2.equals(propertyNames.FILE_ENCODING)) {
            if (n == propertyEnums.FILE_ENCODING_BINARY) {
                return EnumNames.enumName(property, string, "Binary", ResIDs.FILE_ENCODING_BINARY);
            }
            if (n == propertyEnums.FILE_ENCODING_ASCII) {
                return EnumNames.enumName(property, string, "ASCII", ResIDs.FILE_ENCODING_ASCII);
            }
            if (n == propertyEnums.FILE_ENCODING_UNICODE) {
                return EnumNames.enumName(property, string, "Unicode", ResIDs.FILE_ENCODING_UNICODE);
            }
        } else if (string2.equals(propertyNames.FILE_LOCAL_FILE_EXISTS)) {
            if (n == propertyEnums.FILE_LOCAL_FILE_EXISTS_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FILE_LOCAL_FILE_EXISTS_NO);
            }
            if (n == propertyEnums.FILE_LOCAL_FILE_EXISTS_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FILE_LOCAL_FILE_EXISTS_YES);
            }
        } else if (string2.equals(propertyNames.FILE_ARCHIVE_TYPE)) {
            if (n == propertyEnums.FILE_ARCHIVE_TYPE_NATIVE) {
                return EnumNames.enumName(property, string, "Native", ResIDs.FILE_ARCHIVE_TYPE_NATIVE);
            }
            if (n == propertyEnums.FILE_ARCHIVE_TYPE_PVCS) {
                return EnumNames.enumName(property, string, "PVCS", ResIDs.FILE_ARCHIVE_TYPE_PVCS);
            }
            if (n == propertyEnums.FILE_ARCHIVE_TYPE_VSS) {
                return EnumNames.enumName(property, string, "VSS", ResIDs.FILE_ARCHIVE_TYPE_VSS);
            }
        } else if (string2.equals(propertyNames.FILE_SYNC_KNOWN)) {
            if (n == propertyEnums.FILE_SYNC_KNOWN_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FILE_SYNC_KNOWN_NO);
            }
            if (n == propertyEnums.FILE_SYNC_KNOWN_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FILE_SYNC_KNOWN_YES);
            }
        }
        return new Translations(string);
    }

    private static Translations getRequirementEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals("Status")) {
            if (n == 0) {
                return EnumNames.enumName(property, string, "Submitted", ResIDs.REQUIREMENT_STATUS_SUBMITTED);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, PENDING, ResIDs.REQUIREMENT_STATUS_PENDING);
            }
            if (n == 2) {
                return EnumNames.enumName(property, string, "Accepted", ResIDs.REQUIREMENT_STATUS_ACCEPTED);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, "Draft", ResIDs.REQUIREMENT_STATUS_DRAFT);
            }
            if (n == 4) {
                return EnumNames.enumName(property, string, DEFERRED, ResIDs.REQUIREMENT_STATUS_DEFERRED);
            }
            if (n == 5) {
                return EnumNames.enumName(property, string, "Review", ResIDs.REQUIREMENT_STATUS_REVIEW);
            }
            if (n == 6) {
                return EnumNames.enumName(property, string, "Complete", ResIDs.REQUIREMENT_STATUS_COMPLETE);
            }
            if (n == 7) {
                return EnumNames.enumName(property, string, "ReadyForCCB", ResIDs.REQUIREMENT_STATUS_READYFORCCB);
            }
            if (n == 8) {
                return EnumNames.enumName(property, string, "Rejected", ResIDs.REQUIREMENT_STATUS_REJECTED);
            }
            if (n == 9) {
                return EnumNames.enumName(property, string, "Approved", ResIDs.REQUIREMENT_STATUS_APPROVED);
            }
        } else if (string2.equals("Disabled")) {
            if (n == 1) {
                return EnumNames.enumName(property, string, YES, ResIDs.REQUIREMENT_DISABLED_YES);
            }
            if (n == 0) {
                return EnumNames.enumName(property, string, NO, ResIDs.REQUIREMENT_DISABLED_NO);
            }
        } else if (string2.equals(propertyNames.SHARE_STATE)) {
            if (n == propertyEnums.SHARE_STATE_NOT_SHARED) {
                return EnumNames.enumName(property, string, NOT_SHARED, ResIDs.SHARE_STATE_NOT_SHARED);
            }
            if (n == propertyEnums.SHARE_STATE_ROOT_SHARE) {
                return EnumNames.enumName(property, string, ROOT_SHARE, ResIDs.SHARE_STATE_ROOT_SHARE);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, DERIVED_SHARE, ResIDs.REQUIREMENT_SHARESTATE_DERIVEDSHARE);
            }
        } else if (string2.equals(propertyNames.FLAG)) {
            if (n == propertyEnums.FLAG_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FLAG_NO);
            }
            if (n == propertyEnums.FLAG_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FLAG_YES);
            }
        } else if (string2.equals(propertyNames.READ_ONLY)) {
            if (n == propertyEnums.READ_ONLY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.READ_ONLY_NO);
            }
            if (n == propertyEnums.READ_ONLY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.READ_ONLY_YES);
            }
        } else if (string2.equals(propertyNames.MY_LOCK)) {
            if (n == propertyEnums.MY_LOCK_NOT_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NOT_LOCKED_BY_ME, ResIDs.MY_LOCK_NOT_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NON_EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME);
            }
        } else if (string2.equals("AmIResponsible")) {
            if (n == 0) {
                return EnumNames.enumName(property, string, NO, ResIDs.REQUIREMENT_AMIRESPONSIBLE_NO);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, YES, ResIDs.REQUIREMENT_AMIRESPONSIBLE_YES);
            }
        } else if (string2.equals("Type")) {
            if (n == 0) {
                return EnumNames.enumName(property, string, "Business Requirement", ResIDs.REQUIREMENT_TYPE_BUSINESS_REQUIREMENT);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, "Business Specification", ResIDs.REQUIREMENT_TYPE_BUSINESS_SPECIFICATION);
            }
            if (n == 2) {
                return EnumNames.enumName(property, string, "Hardware Requirement", ResIDs.REQUIREMENT_TYPE_HARDWARE_REQUIREMENT);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, "Hardware Specification", ResIDs.REQUIREMENT_TYPE_HARDWARE_SPECIFICATION);
            }
            if (n == 4) {
                return EnumNames.enumName(property, string, "Human Resources", ResIDs.REQUIREMENT_TYPE_HUMAN_RESOURCES);
            }
            if (n == 5) {
                return EnumNames.enumName(property, string, "Information Technology", ResIDs.REQUIREMENT_TYPE_INFORMATION_TECHNOLOGY);
            }
            if (n == 6) {
                return EnumNames.enumName(property, string, "Software Requirement", ResIDs.REQUIREMENT_TYPE_SOFTWARE_REQUIREMENT);
            }
            if (n == 7) {
                return EnumNames.enumName(property, string, "Software Specification", ResIDs.REQUIREMENT_TYPE_SOFTWARE_SPECIFICATION);
            }
        } else if (string2.equals("Priority")) {
            if (n == 0) {
                return EnumNames.enumName(property, string, "Unassigned", ResIDs.REQUIREMENT_PRIORITY_UNASSIGNED);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, "Essential", ResIDs.REQUIREMENT_PRIORITY_ESSENTIAL);
            }
            if (n == 2) {
                return EnumNames.enumName(property, string, "Useful", ResIDs.REQUIREMENT_PRIORITY_USEFUL);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, "Desirable", ResIDs.REQUIREMENT_PRIORITY_DESIRABLE);
            }
        } else if (string2.equals("ChildType")) {
            if (n == 0) {
                return EnumNames.enumName(property, string, "Requirement", ResIDs.REQUIREMENT_CHILD_TYPE_REQUIREMENT);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, "Child Requirement", ResIDs.REQUIREMENT_CHILD_TYPE_CHILD_REQUIREMENT);
            }
        } else if (string2.equals(propertyNames.READ_STATUS)) {
            if (n == propertyEnums.READ_STATUS_READ) {
                return EnumNames.enumName(property, string, READ, ResIDs.READ_STATUS_READ);
            }
            if (n == propertyEnums.READ_STATUS_UNREAD) {
                return EnumNames.enumName(property, string, UNREAD, ResIDs.READ_STATUS_UNREAD);
            }
        }
        return new Translations(string);
    }

    private static Translations getChangeRequestEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.CR_STATUS)) {
            if (n == propertyEnums.CR_STATUS_NEW) {
                return EnumNames.enumName(property, string, "New", ResIDs.CR_STATUS_NEW);
            }
            if (n == propertyEnums.CR_STATUS_OPEN) {
                return EnumNames.enumName(property, string, "Open", ResIDs.CR_STATUS_OPEN);
            }
            if (n == propertyEnums.CR_STATUS_IN_PROGRESS) {
                return EnumNames.enumName(property, string, IN_PROGRESS, ResIDs.CR_STATUS_IN_PROGRESS);
            }
            if (n == propertyEnums.CR_STATUS_CANNOT_REPRODUCE) {
                return EnumNames.enumName(property, string, "Cannot Reproduce", ResIDs.CR_STATUS_CANNOT_REPRODUCE);
            }
            if (n == propertyEnums.CR_STATUS_AS_DESIGNED) {
                return EnumNames.enumName(property, string, "As Designed", ResIDs.CR_STATUS_AS_DESIGNED);
            }
            if (n == propertyEnums.CR_STATUS_FIXED) {
                return EnumNames.enumName(property, string, "Fixed", ResIDs.CR_STATUS_FIXED);
            }
            if (n == propertyEnums.CR_STATUS_DOCUMENTED) {
                return EnumNames.enumName(property, string, "Documented", ResIDs.CR_STATUS_DOCUMENTED);
            }
            if (n == propertyEnums.CR_STATUS_IS_DUPLICATE) {
                return EnumNames.enumName(property, string, "Is Duplicate", ResIDs.CR_STATUS_IS_DUPLICATE);
            }
            if (n == propertyEnums.CR_STATUS_DEFERRED) {
                return EnumNames.enumName(property, string, DEFERRED, ResIDs.CR_STATUS_DEFERRED);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_CANNOT_REPRODUCE) {
                return EnumNames.enumName(property, string, "Verified Cannot Reproduce", ResIDs.CR_STATUS_VERIFIED_CANNOT_REPRODUCE);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_AS_DESIGNED) {
                return EnumNames.enumName(property, string, "Verified As Designed", ResIDs.CR_STATUS_VERIFIED_AS_DESIGNED);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_FIXED) {
                return EnumNames.enumName(property, string, "Verified Fixed", ResIDs.CR_STATUS_VERIFIED_FIXED);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_DOCUMENTED) {
                return EnumNames.enumName(property, string, "Verified Documented", ResIDs.CR_STATUS_VERIFIED_DOCUMENTED);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_IS_DUPLICATE) {
                return EnumNames.enumName(property, string, "Verified Is Duplicate", ResIDs.CR_STATUS_VERIFIED_IS_DUPLICATE);
            }
            if (n == propertyEnums.CR_STATUS_VERIFIED_DEFERRED) {
                return EnumNames.enumName(property, string, "Verified Deferred", ResIDs.CR_STATUS_VERIFIED_DEFERRED);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_CANNOT_REPRODUCE) {
                return EnumNames.enumName(property, string, "Closed Cannot Reproduce", ResIDs.CR_STATUS_CLOSED_CANNOT_REPRODUCE);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_AS_DESIGNED) {
                return EnumNames.enumName(property, string, "Closed As Designed", ResIDs.CR_STATUS_CLOSED_AS_DESIGNED);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_FIXED) {
                return EnumNames.enumName(property, string, "Closed Fixed", ResIDs.CR_STATUS_CLOSED_FIXED);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_DOCUMENTED) {
                return EnumNames.enumName(property, string, "Closed Documented", ResIDs.CR_STATUS_CLOSED_DOCUMENTED);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_IS_DUPLICATE) {
                return EnumNames.enumName(property, string, "Closed Is Duplicate", ResIDs.CR_STATUS_CLOSED_IS_DUPLICATE);
            }
            if (n == propertyEnums.CR_STATUS_CLOSED_DEFERRED) {
                return EnumNames.enumName(property, string, "Closed Deferred", ResIDs.CR_STATUS_CLOSED_DEFERRED);
            }
        } else if (string2.equals(propertyNames.BRANCH_STATE)) {
            if (n == propertyEnums.BRANCH_STATE_NOT_BRANCHED) {
                return EnumNames.enumName(property, string, NOT_BRANCHED, ResIDs.BRANCH_STATE_NOT_BRANCHED);
            }
            if (n == propertyEnums.BRANCH_STATE_BRANCHED) {
                return EnumNames.enumName(property, string, BRANCHED, ResIDs.BRANCH_STATE_BRANCHED);
            }
            if (n == propertyEnums.BRANCH_STATE_ROOT) {
                return EnumNames.enumName(property, string, ROOT, ResIDs.BRANCH_STATE_ROOT);
            }
        } else if (string2.equals(propertyNames.BRANCH_ON_CHANGE)) {
            if (n == propertyEnums.BRANCH_ON_CHANGE_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.BRANCH_ON_CHANGE_NO);
            }
            if (n == propertyEnums.BRANCH_ON_CHANGE_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.BRANCH_ON_CHANGE_YES);
            }
        } else if (string2.equals(propertyNames.SHARE_STATE)) {
            if (n == propertyEnums.SHARE_STATE_NOT_SHARED) {
                return EnumNames.enumName(property, string, NOT_SHARED, ResIDs.SHARE_STATE_NOT_SHARED);
            }
            if (n == propertyEnums.SHARE_STATE_ROOT_SHARE) {
                return EnumNames.enumName(property, string, ROOT_SHARE, ResIDs.SHARE_STATE_ROOT_SHARE);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, DERIVED_SHARE, ResIDs.CHANGEREQUEST_SHARESTATE_DERIVEDSHARE);
            }
        } else if (string2.equals(propertyNames.FLAG)) {
            if (n == propertyEnums.FLAG_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FLAG_NO);
            }
            if (n == propertyEnums.FLAG_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FLAG_YES);
            }
        } else if (string2.equals(propertyNames.CR_PLATFORM)) {
            if (n == propertyEnums.CR_PLATFORM_ALL) {
                return EnumNames.enumName(property, string, "All", ResIDs.CR_PLATFORM_ALL);
            }
            if (n == 1) {
                return EnumNames.enumName(property, string, "Windows 95", ResIDs.CHANGEREQUEST_PLATFORM_WINDOWS_95);
            }
            if (n == 2) {
                return EnumNames.enumName(property, string, "Windows 98", ResIDs.CHANGEREQUEST_PLATFORM_WINDOWS_98);
            }
            if (n == propertyEnums.CR_PLATFORM_WINDOWS_NT) {
                return EnumNames.enumName(property, string, "Windows NT", ResIDs.CR_PLATFORM_WINDOWS_NT);
            }
            if (n == propertyEnums.CR_PLATFORM_MACOS) {
                return EnumNames.enumName(property, string, "MacOS", ResIDs.CR_PLATFORM_MACOS);
            }
            if (n == propertyEnums.CR_PLATFORM_UNIX) {
                return EnumNames.enumName(property, string, "Unix", ResIDs.CR_PLATFORM_UNIX);
            }
            if (n == propertyEnums.CR_PLATFORM_OTHER) {
                return EnumNames.enumName(property, string, "Other", ResIDs.CR_PLATFORM_OTHER);
            }
            if (n == 7) {
                return EnumNames.enumName(property, string, "Windows 2000", ResIDs.CHANGEREQUEST_PLATFORM_WINDOWS_2000);
            }
            if (n == 8) {
                return EnumNames.enumName(property, string, "Windows XP", ResIDs.CHANGEREQUEST_PLATFORM_WINDOWS_XP);
            }
        } else if (string2.equals(propertyNames.CR_SEVERITY)) {
            if (n == propertyEnums.CR_SEVERITY_LOW) {
                return EnumNames.enumName(property, string, LOW, ResIDs.CR_SEVERITY_LOW);
            }
            if (n == propertyEnums.CR_SEVERITY_MEDIUM) {
                return EnumNames.enumName(property, string, MEDIUM, ResIDs.CR_SEVERITY_MEDIUM);
            }
            if (n == propertyEnums.CR_SEVERITY_HIGH) {
                return EnumNames.enumName(property, string, HIGH, ResIDs.CR_SEVERITY_HIGH);
            }
        } else if (string2.equals(propertyNames.READ_ONLY)) {
            if (n == propertyEnums.READ_ONLY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.READ_ONLY_NO);
            }
            if (n == propertyEnums.READ_ONLY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.READ_ONLY_YES);
            }
        } else if (string2.equals(propertyNames.MY_LOCK)) {
            if (n == propertyEnums.MY_LOCK_NOT_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NOT_LOCKED_BY_ME, ResIDs.MY_LOCK_NOT_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NON_EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME);
            }
        } else if (string2.equals(propertyNames.CR_TYPE)) {
            if (n == propertyEnums.CR_TYPE_DEFECT) {
                return EnumNames.enumName(property, string, "Defect", ResIDs.CR_TYPE_DEFECT);
            }
            if (n == propertyEnums.CR_TYPE_SUGGESTION) {
                return EnumNames.enumName(property, string, "Suggestion", ResIDs.CR_TYPE_SUGGESTION);
            }
        } else if (string2.equals(propertyNames.CR_PRIORITY)) {
            if (n == propertyEnums.CR_PRIORITY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.CR_PRIORITY_NO);
            }
            if (n == propertyEnums.CR_PRIORITY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.CR_PRIORITY_YES);
            }
        } else if (string2.equals(propertyNames.READ_STATUS)) {
            if (n == propertyEnums.READ_STATUS_READ) {
                return EnumNames.enumName(property, string, READ, ResIDs.READ_STATUS_READ);
            }
            if (n == propertyEnums.READ_STATUS_UNREAD) {
                return EnumNames.enumName(property, string, UNREAD, ResIDs.READ_STATUS_UNREAD);
            }
        }
        return new Translations(string);
    }

    private static Translations getTopicEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.TOPIC_STATUS)) {
            if (n == propertyEnums.TOPIC_STATUS_ACTIVE) {
                return EnumNames.enumName(property, string, "Active", ResIDs.TOPIC_STATUS_ACTIVE);
            }
            if (n == propertyEnums.TOPIC_STATUS_INACTIVE) {
                return EnumNames.enumName(property, string, "Inactive", ResIDs.TOPIC_STATUS_INACTIVE);
            }
        } else if (string2.equals(propertyNames.SHARE_STATE)) {
            if (n == propertyEnums.SHARE_STATE_NOT_SHARED) {
                return EnumNames.enumName(property, string, NOT_SHARED, ResIDs.SHARE_STATE_NOT_SHARED);
            }
            if (n == propertyEnums.SHARE_STATE_ROOT_SHARE) {
                return EnumNames.enumName(property, string, ROOT_SHARE, ResIDs.SHARE_STATE_ROOT_SHARE);
            }
            if (n == 3) {
                return EnumNames.enumName(property, string, DERIVED_SHARE, ResIDs.TOPIC_SHARESTATE_DERIVEDSHARE);
            }
        } else if (string2.equals(propertyNames.FLAG)) {
            if (n == propertyEnums.FLAG_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.FLAG_NO);
            }
            if (n == propertyEnums.FLAG_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.FLAG_YES);
            }
        } else if (string2.equals(propertyNames.READ_ONLY)) {
            if (n == propertyEnums.READ_ONLY_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.READ_ONLY_NO);
            }
            if (n == propertyEnums.READ_ONLY_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.READ_ONLY_YES);
            }
        } else if (string2.equals(propertyNames.MY_LOCK)) {
            if (n == propertyEnums.MY_LOCK_NOT_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NOT_LOCKED_BY_ME, ResIDs.MY_LOCK_NOT_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME);
            }
            if (n == propertyEnums.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME) {
                return EnumNames.enumName(property, string, NON_EXCLUSIVELY_LOCKED_BY_ME, ResIDs.MY_LOCK_NON_EXCLUSIVELY_LOCKED_BY_ME);
            }
        } else if (string2.equals(propertyNames.AM_I_RECIPIENT)) {
            if (n == propertyEnums.AM_I_RECIPIENT_NO) {
                return EnumNames.enumName(property, string, NO, ResIDs.AM_I_RECIPIENT_NO);
            }
            if (n == propertyEnums.AM_I_RECIPIENT_YES) {
                return EnumNames.enumName(property, string, YES, ResIDs.AM_I_RECIPIENT_YES);
            }
        } else if (string2.equals(propertyNames.TOPIC_TYPE)) {
            if (n == propertyEnums.TOPIC_TYPE_TOPIC) {
                return EnumNames.enumName(property, string, "Topic", ResIDs.TOPIC_TYPE_TOPIC);
            }
            if (n == propertyEnums.TOPIC_TYPE_RESPONSE) {
                return EnumNames.enumName(property, string, "Response", ResIDs.TOPIC_TYPE_RESPONSE);
            }
        } else if (string2.equals(propertyNames.TOPIC_PRIORITY)) {
            if (n == propertyEnums.TOPIC_PRIORITY_LOW) {
                return EnumNames.enumName(property, string, LOW, ResIDs.TOPIC_PRIORITY_LOW);
            }
            if (n == propertyEnums.TOPIC_PRIORITY_NORMAL) {
                return EnumNames.enumName(property, string, "Normal", ResIDs.TOPIC_PRIORITY_NORMAL);
            }
            if (n == propertyEnums.TOPIC_PRIORITY_HIGH) {
                return EnumNames.enumName(property, string, HIGH, ResIDs.TOPIC_PRIORITY_HIGH);
            }
        } else if (string2.equals(propertyNames.READ_STATUS)) {
            if (n == propertyEnums.READ_STATUS_READ) {
                return EnumNames.enumName(property, string, READ, ResIDs.READ_STATUS_READ);
            }
            if (n == propertyEnums.READ_STATUS_UNREAD) {
                return EnumNames.enumName(property, string, UNREAD, ResIDs.READ_STATUS_UNREAD);
            }
        }
        return new Translations(string);
    }

    private static Translations getFolderEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.FOLDER_EXCLUDE_FLAGS)) {
            if (n == propertyEnums.FOLDER_EXCLUDE_FLAGS_NO_EXCLUDE_LIST) {
                return EnumNames.enumName(property, string, "No Exclude List", ResIDs.FOLDER_EXCLUDE_FLAGS_NO_EXCLUDE_LIST);
            }
            if (n == propertyEnums.FOLDER_EXCLUDE_FLAGS_LOCAL_EXCLUDE_LIST) {
                return EnumNames.enumName(property, string, "Local Exclude List", ResIDs.FOLDER_EXCLUDE_FLAGS_LOCAL_EXCLUDE_LIST);
            }
            if (n == propertyEnums.FOLDER_EXCLUDE_FLAGS_INHERIT_AND_LOCAL_EXCLUDE_LIST) {
                return EnumNames.enumName(property, string, "Inherit and Local Exclude List", ResIDs.FOLDER_EXCLUDE_FLAGS_INHERIT_AND_LOCAL_EXCLUDE_LIST);
            }
        }
        return new Translations(string);
    }

    private static Translations getTaskDependencyEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.TASKDEPENDENCY_TYPE)) {
            if (n == propertyEnums.TASKDEPENDENCY_TYPE_FS) {
                return EnumNames.enumName(property, string, "FS", ResIDs.TASKDEPENDENCY_TYPE_FS);
            }
            if (n == propertyEnums.TASKDEPENDENCY_TYPE_SS) {
                return EnumNames.enumName(property, string, "SS", ResIDs.TASKDEPENDENCY_TYPE_SS);
            }
            if (n == propertyEnums.TASKDEPENDENCY_TYPE_FF) {
                return EnumNames.enumName(property, string, "FF", ResIDs.TASKDEPENDENCY_TYPE_FF);
            }
            if (n == propertyEnums.TASKDEPENDENCY_TYPE_SF) {
                return EnumNames.enumName(property, string, "SF", ResIDs.TASKDEPENDENCY_TYPE_SF);
            }
        }
        return new Translations(string);
    }

    private static Translations getProjectEnumName(Property property, int n, String string) {
        String string2 = property.getName();
        PropertyNames propertyNames = property.getType().getServer().getPropertyNames();
        PropertyEnums propertyEnums = property.getType().getServer().getPropertyEnums();
        if (string2.equals(propertyNames.PROJECT_ENCRYPTION)) {
            if (n == propertyEnums.PROJECT_ENCRYPTION_NONE) {
                return EnumNames.enumName(property, string, "None", ResIDs.PROJECT_ENCRYPTION_NONE);
            }
            if (n == propertyEnums.PROJECT_ENCRYPTION_RC4) {
                return EnumNames.enumName(property, string, "RSA R4 Stream Cipher (Fast)", ResIDs.PROJECT_ENCRYPTION_RC4);
            }
            if (n == propertyEnums.PROJECT_ENCRYPTION_RC2_ECB) {
                return EnumNames.enumName(property, string, "RSA R2 Block Cipher (Electronic Codebook)", ResIDs.PROJECT_ENCRYPTION_RC2_ECB);
            }
            if (n == propertyEnums.PROJECT_ENCRYPTION_RC2_CBC) {
                return EnumNames.enumName(property, string, "RSA R2 Block Cipher (Cipher Block Chaining)", ResIDs.PROJECT_ENCRYPTION_RC2_CBC);
            }
            if (n == propertyEnums.PROJECT_ENCRYPTION_RC2_CFB) {
                return EnumNames.enumName(property, string, "RSA R2 Block Cipher (Cipher Feedback)", ResIDs.PROJECT_ENCRYPTION_RC2_CFB);
            }
        } else if (string2.equals(propertyNames.PROJECT_TYPE)) {
            if (n == propertyEnums.PROJECT_TYPE_STARTEAM) {
                return EnumNames.enumName(property, string, "StarTeam", ResIDs.PROJECT_TYPE_STARTEAM);
            }
            if (n == propertyEnums.PROJECT_TYPE_PVCS) {
                return EnumNames.enumName(property, string, "PVCS", ResIDs.PROJECT_TYPE_PVCS);
            }
            if (n == propertyEnums.PROJECT_TYPE_VISUAL_SOURCESAFE) {
                return EnumNames.enumName(property, string, "Visual SourceSafe", ResIDs.PROJECT_TYPE_VISUAL_SOURCESAFE);
            }
        }
        return new Translations(string);
    }

    EnumNames() {
    }
}

