/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.ServerModeOption;
import com.starbase.starteam.commandline.ServerSpecOption;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.util.Assert;
import java.io.IOException;

class SetServerMode
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.SERVER_MODE_DESCRIPTION);
    }

    String name() {
        return "server-mode";
    }

    boolean treatNoFilesAsAll() {
        return false;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        commonSpec.addOption(new ServerSpecOption("ServerSpec", true));
        commonSpec.addOption(new ServerModeOption("ServerMode", true));
        commonSpec.removeOption("Project");
        commonSpec.removeOption("CaseSensitiveFolders");
        commonSpec.removeViewConfigOptions();
        commonSpec.removeOption("Recurse");
        commonSpec.removeOption("Rootpath");
        commonSpec.removeOption("Folderpath");
        commonSpec.removeOption("StatusFilter");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private boolean isLockMode() {
        if (this.getIsOptionOn("ServerMode")) {
            String string = this.getStringOption("ServerMode");
            return string.toLowerCase().equals("lock");
        }
        return false;
    }

    private boolean isExLockMode() {
        if (this.getIsOptionOn("ServerMode")) {
            String string = this.getStringOption("ServerMode");
            return string.toLowerCase().equalsIgnoreCase("exlock");
        }
        return false;
    }

    private String getServerSpec() {
        return this.getStringOption("ServerSpec");
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("SetServerMode.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Assert.internalError("SetServerMode.processOneFile()");
    }

    void processNoFiles() throws IOException {
        Assert.internalError("SetServerMode.processNoFile()");
    }

    protected int runCommandImpl(String[] stringArray) throws IOException {
        try {
            block14: {
                boolean bl = this.parseArguments(stringArray);
                if (this.showLogo()) {
                    CommonCommand.printStartupMsg();
                }
                if (this.showHelp()) {
                    this.showUsage();
                    return 0;
                }
                if (this.showNetMonitor()) {
                    NetMonitor.on();
                }
                if (!bl) {
                    this.reportBadOptions(this.getSpec().errorMessage());
                    return 1;
                }
                this.cacheUnusedUserFileList();
                this._ProjectSpecifier = new StarTeamURL(this.getServerSpec());
                this.resolveUserName();
                this.resolvePassword();
                boolean bl2 = this.openServer();
                if (!bl2) {
                    this.confirm(Res.formatKey(ResIDs.UNABLE_TO_CONNECT_ERROR_MSG, new Object[]{this.getHostName(), new Integer(this.getPort())}), null);
                    return 1;
                }
                try {
                    this.getServer().logOn(this.getUserName(), this.getPassword());
                }
                catch (ServerException serverException) {
                    if (serverException.getClassName().equals("CStServerException") && serverException.getErrorCode() == 1004) break block14;
                    throw serverException;
                }
            }
            if (this.isLockMode()) {
                this.getServer().getAdministration().lockServer();
                this.message(Res.getString(ResIDs.SERVER_MODE_LOCKED_MSG));
            } else if (this.isExLockMode()) {
                if (this.getServer().getSupportedFeatures().hasServerExclusiveLock()) {
                    this.getServer().getAdministration().lockServerExclusively();
                    this.message(Res.getString(ResIDs.SERVER_MODE_EXLOCKED_MSG));
                }
            } else {
                this.getServer().getAdministration().unlockServer();
                this.message(Res.getString(ResIDs.SERVER_MODE_UNLOCKED_MSG));
            }
            return 0;
        }
        catch (Throwable throwable) {
            this.reportError(throwable);
            NetMonitor.kill();
            return 1;
        }
    }

    SetServerMode() {
    }
}

