/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommandLineQuitException;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import java.io.IOException;

class MakeDirs
extends CommonCommand {
    public String description() {
        return Res.getString(ResIDs.MAKE_DIRS_DESCRIPTION);
    }

    public String name() {
        return "local-mkdir";
    }

    public boolean treatNoFilesAsAll() {
        return true;
    }

    public boolean iterateOnLocalFiles() {
        return false;
    }

    public boolean iterateOnServerFiles() {
        return false;
    }

    public boolean ignoreUserFileList() {
        return true;
    }

    public int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        commonSpec.removeOption("StatusFilter");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    public void processLocalFile(Folder folder, String string) throws IOException {
    }

    public void processOneFile(Folder folder, File file) throws IOException {
    }

    private void createFolder(Folder folder) throws IOException {
        try {
            String string = folder.getPath();
            java.io.File file = new java.io.File(string);
            if (!file.exists()) {
                boolean bl = file.mkdirs();
                if (file.isDirectory()) {
                    this.message(Res.formatKey(ResIDs.MAKE_DIRS_FOLDER_CREATED_MSG, new Object[]{folder.getName(), string}));
                } else {
                    this.confirm(Res.formatKey(ResIDs.MAKE_DIRS_UNABLE_TO_CREATE_ERROR_MSG, new Object[]{string}));
                }
            } else if (!file.isDirectory()) {
                this.confirm(Res.formatKey(ResIDs.MAKE_DIRS_FILE_ALREADY_EXISTS_ERROR_MSG, new Object[]{string}));
            }
        }
        catch (CommandLineQuitException commandLineQuitException) {
            throw commandLineQuitException;
        }
        catch (Throwable throwable) {
            this.reportError(throwable);
        }
    }

    public void processFolder(Folder folder, boolean bl) throws IOException {
        this.createFolder(folder);
        if (bl) {
            Folder[] folderArray = folder.getSubFolders();
            int n = folderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Folder folder2 = folderArray[n2];
                this.processFolder(folder2, bl);
                ++n2;
            }
        }
    }

    public void processNoFiles() {
    }
}

