/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Status;
import com.starbase.starteam.User;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.FileUtils;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import java.io.IOException;

class List
extends CommonCommand {
    private String m_cwd;

    String description() {
        return Res.getString(ResIDs.LIST_DESCRIPTION);
    }

    String name() {
        return "list";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return true;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        commonSpec.addOption(new Option("ShowSubFolders", false));
        commonSpec.addOption(new Option("ShortList", false));
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    protected void preOperation() throws IOException {
        if (this.shortListing()) {
            this.m_cwd = new java.io.File(".").getCanonicalPath();
        }
    }

    protected boolean showSubFolders() {
        return this.getIsOptionOn("ShowSubFolders");
    }

    protected boolean shortListing() {
        return this.getIsOptionOn("ShortList");
    }

    protected void reportFolder(Folder folder) throws IOException {
        if (this.showSubFolders() && !this.shortListing()) {
            this.message("                                                               " + folder.getName() + folder.getServer().getClientContext().getFilePathDelimiter());
        }
    }

    private String filePathDisplay(String string) {
        if (string.startsWith(this.m_cwd)) {
            if (this.m_cwd.length() < string.length()) {
                return string.substring(this.m_cwd.length() + 1);
            }
            return ".";
        }
        return string;
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        String string2 = folder.getFilePath(string);
        java.io.File file = new java.io.File(string2);
        if (this.shortListing()) {
            this.message("N " + this.filePathDisplay(file.getCanonicalPath()));
        } else {
            this.show(string, "", Status.name(4), this.readWriteStr(string2), FileUtils.getFileLength(file), new OLEDate(Platform.getFileLastModified(file)));
        }
    }

    private String shortStatus(int n) {
        if (n == 0) {
            return "C";
        }
        if (n == 1) {
            return "G";
        }
        if (n == 2) {
            return "I";
        }
        if (n == 3) {
            return "M";
        }
        if (n == 5) {
            return "O";
        }
        if (n == 4) {
            return "N";
        }
        if (n == 6) {
            return "U";
        }
        return "?";
    }

    void showFolderInfo(Folder folder) {
        if (!this.shortListing()) {
            super.showFolderInfo(folder);
        }
    }

    void processOneFile(Folder folder, File file) throws IOException {
        String string;
        OLEDate oLEDate = file.getContentModificationTime();
        User user = file.getServer().getUser(file.getLocker());
        String string2 = string = user == null ? "" : user.getName();
        if (this.shortListing()) {
            this.message(this.shortStatus(file.getStatus()) + " " + this.filePathDisplay(file.getFullName()));
        } else {
            this.show(file.getName(), string, Status.name(file.getStatus()), this.readWriteStr(file.getFullName()), file.getSize(), oLEDate);
        }
    }

    private String readWriteStr(String string) {
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            return "  ";
        }
        boolean bl = file.canRead();
        boolean bl2 = file.canWrite();
        return (bl ? "r" : "-") + (bl2 ? "w" : "-");
    }

    private String padRight(String string, int n) {
        return this.trunc(string + this.pad(n - string.length()), n);
    }

    private String padLeft(String string, int n) {
        return this.trunc(this.pad(n - string.length()) + string, n);
    }

    private String trunc(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    private String pad(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void show(String string, String string2, String string3, String string4, int n, OLEDate oLEDate) {
        this.message(this.padRight(string3, 11) + " " + this.padRight(string2, 13) + " " + string4 + " " + this.padRight(oLEDate.localString(3, 1), 24) + " " + this.padLeft("" + n, 8) + " " + string);
    }

    void processNoFiles() {
    }

    List() {
    }
}

