/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.PositiveIntegerOption;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.TimeOption;
import com.starbase.util.OLEDate;
import java.io.IOException;

class ApplyLabel
extends CommonCommand {
    private Label[] m_cachedLabels = null;
    private Label m_applyToLabel = null;

    String description() {
        return Res.getString(ResIDs.APPLY_LABELS_DESCRIPTION);
    }

    String name() {
        return "apply-label";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        commonSpec.addOption(new PositiveIntegerOption("VersionNumber", false, false, object));
        commonSpec.addOption(new TimeOption("VersionDate", false, object));
        commonSpec.addOption(new Option("VersionLabel", false, object));
        commonSpec.addOption(new Option("ApplyLabel", 1, Integer.MAX_VALUE));
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private boolean applyToTip() {
        return !this.applyToTime() && !this.applyToViewVersion() && !this.applyToLabel();
    }

    private boolean applyToTime() {
        return this.getIsOptionOn("VersionDate");
    }

    private boolean applyToViewVersion() {
        return this.getIsOptionOn("VersionNumber");
    }

    private boolean applyToLabel() {
        return this.getIsOptionOn("VersionLabel");
    }

    private OLEDate getApplyToDate() {
        if (this.getIsOptionOn("VersionDate")) {
            return new OLEDate(this.getTimeOption("VersionDate").getTime());
        }
        return null;
    }

    private int getApplyToVersion() {
        if (this.getIsOptionOn("VersionNumber")) {
            return this.getIntegerOption("VersionNumber");
        }
        return -1;
    }

    private String getApplyToLabelName() {
        if (this.getIsOptionOn("VersionLabel")) {
            return this.getStringOption("VersionLabel");
        }
        return null;
    }

    private Label getApplyToLabel() {
        return this.m_applyToLabel;
    }

    private String[] getLabelNames() {
        return this.getStringOptionList("ApplyLabel");
    }

    protected void preOperation() throws IOException {
        String[] stringArray = this.getLabelNames();
        String string = this.getApplyToLabelName();
        if (string != null) {
            this.m_applyToLabel = this.findLabel(string);
            if (this.m_applyToLabel == null) {
                throw new IOException(Res.formatKey(ResIDs.APPLY_LABELS_LABEL_NOT_FOUND_ERROR_MSG, new Object[]{string}));
            }
        }
        if (stringArray != null) {
            this.m_cachedLabels = new Label[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                Label label = this.findLabel(stringArray[n]);
                if (label == null) {
                    throw new IOException(Res.formatKey(ResIDs.APPLY_LABELS_LABEL_MISSING_ERROR_MSG, new Object[]{stringArray[n]}));
                }
                this.m_cachedLabels[n] = label;
                ++n;
            }
        }
    }

    void processLocalFile(Folder folder, String string) throws IOException {
    }

    void processOneFile(Folder folder, File file) throws IOException {
        String string = file.getFullName();
        String string2 = file.getName();
        File file2 = file;
        file2 = this.applyToTime() ? (File)file.getFromHistoryByDate(new OLEDate(this.getApplyToDate())) : (this.applyToViewVersion() ? (File)file.getFromHistoryByVersion(this.getApplyToVersion()) : (this.applyToLabel() ? (File)file.getFromHistoryByLabelID(this.getApplyToLabel().getID()) : file));
        if (file2 != null) {
            this.applyLabels(file2);
            this.message(Res.formatKey(ResIDs.APPLY_LABELS_LABELED_MSG, new Object[]{string2}));
        } else {
            this.message(Res.formatKey(ResIDs.APPLY_LABELS_SKIPPED_MSG, new Object[]{string2}));
        }
    }

    private void applyLabels(File file) throws IOException {
        if (this.m_cachedLabels != null) {
            int n = 0;
            while (n < this.m_cachedLabels.length) {
                Label label = this.m_cachedLabels[n];
                if (label != null) {
                    label.moveItem(file, file.getObjectID(), file.getModifiedTime());
                    label.update();
                }
                ++n;
            }
        }
    }

    void processNoFiles() throws IOException {
    }

    ApplyLabel() {
    }
}

