/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.TimeOption;
import com.starbase.util.OLEDate;
import java.io.IOException;

class AddView
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.ADD_VIEW_DESCRIPTION);
    }

    String name() {
        return "add-view";
    }

    boolean treatNoFilesAsAll() {
        return false;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    private String getViewName() {
        return this.getStringOption("ViewName");
    }

    private String getViewDescription() {
        String string = this.getStringOption("ViewDescription");
        return string != null ? string : "";
    }

    private String getLocalPath() {
        return this.getStringOption("ViewRoot");
    }

    private boolean isReadOnly() {
        return this.getIsOptionOn("ViewReadOnly");
    }

    private boolean isVariant() {
        if (!this.getIsOptionOn("ViewDerive")) {
            return true;
        }
        return this.getIsOptionOn("ViewBranchAll") || this.getIsOptionOn("ViewBranchNone");
    }

    private boolean isBranchAll() {
        return this.getIsOptionOn("ViewBranchAll");
    }

    private Folder getRootFolder() {
        return this._Folder;
    }

    private OLEDate getViewTime() {
        return new OLEDate(this.getTimeOption("ViewDate").getTime());
    }

    private Label getLabel() throws IOException {
        return this.findLabel(this.getStringOption("ViewLabel"));
    }

    private PromotionState getPromotionState() throws IOException {
        return this.findPromotionState(this.getStringOption("ViewPromotionState"));
    }

    private ViewConfiguration getConfiguration() throws IOException {
        if (this.isReadOnly() || this.isVariant()) {
            if (this.getIsOptionOn("ViewLabel")) {
                Label label = this.getLabel();
                if (label == null) {
                    throw new IOException(Res.formatKey(ResIDs.ADD_VIEW_LABEL_NOT_FOUND_ERROR_MSG, new Object[]{this.getStringOption("ViewLabel")}));
                }
                return ViewConfiguration.createFromLabel(label.getID());
            }
            if (this.getIsOptionOn("ViewPromotionState")) {
                PromotionState promotionState = this.getPromotionState();
                if (promotionState == null) {
                    throw new IOException(Res.formatKey(ResIDs.ADD_VIEW_PROMOTION_STATE_NOT_FOUND_ERROR_MSG, new Object[]{this.getStringOption("ViewPromotionState")}));
                }
                return ViewConfiguration.createFromPromotionState(promotionState.getID());
            }
            if (this.getIsOptionOn("ViewDate")) {
                return ViewConfiguration.createFromTime(this.getViewTime());
            }
        }
        return ViewConfiguration.createTip();
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        commonSpec.addOption(new Option("ViewName", true));
        commonSpec.addOption(new Option("ViewDescription", false));
        commonSpec.addOption(new Option("ViewRoot", true));
        Object object = new Object();
        commonSpec.addOption(new Option("ViewDerive", false, object));
        Object object2 = new Object();
        commonSpec.addOption(new Option("ViewReadOnly", false, object2, object));
        commonSpec.addOption(new Option("ViewBranchAll", false, object2, object));
        commonSpec.addOption(new Option("ViewBranchNone", false, object2, object));
        Object object3 = new Object();
        commonSpec.addOption(new Option("ViewLabel", false, object3, object2));
        commonSpec.addOption(new Option("ViewPromotionState", false, object3, object2));
        commonSpec.addOption(new TimeOption("ViewDate", false, object3, object2));
        commonSpec.removeViewConfigOptions();
        commonSpec.removeOption("StatusFilter");
        commonSpec.removeOption("Recurse");
        commonSpec.removeOption("CaseSensitiveFolders");
        commonSpec.removeOption("Rootpath");
        commonSpec.removeOption("Folderpath");
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    void processNoFiles() throws IOException {
        View view = new View(this.getView(), this.isVariant(), this.isReadOnly(), this.getViewName(), this.getViewDescription(), this.getIsOptionOn("ViewDerive") ? this.getRootFolder() : new Folder(this.getView().getServer()), this.getLocalPath(), this.getConfiguration(), this.isBranchAll());
        view.update();
        this.message(Res.formatKey(ResIDs.ADD_VIEW_ADDED_VIEW_MSG, new Object[]{this.getViewName()}));
    }

    void processLocalFile(Folder folder, String string) throws IOException {
    }

    void processOneFile(Folder folder, File file) throws IOException {
    }

    AddView() {
    }
}

