/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.util.Assert;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class XMLConfigParser
extends DefaultHandler {
    private String currentCategory = "";
    private int depth = 0;

    public abstract void handleOption(String var1, String var2, String var3);

    private void expected(String string, String string2) {
        throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_EXPECTED_BEGINNING_TAG_FMT, new Object[]{string, string2}));
    }

    private void missingAttribute(String string) {
        throw new RuntimeException(Res.formatKey(ResIDs.MISSING_REQUIRED_ATTRIBUTE_FMT, new Object[]{string}));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.depth == 1) {
            if (string3.equals("category")) {
                String string4 = attributes.getValue("name");
                if (string4 == null) {
                    this.missingAttribute("name");
                }
                this.currentCategory = string4;
            } else {
                this.expected("category", string3);
            }
        } else if (this.depth == 2) {
            if (string3.equals("option")) {
                String string5;
                String string6 = attributes.getValue("name");
                if (string6 == null) {
                    this.missingAttribute("name");
                }
                if ((string5 = attributes.getValue("value")) == null) {
                    this.missingAttribute("value");
                }
                this.handleOption(this.currentCategory, string6, string5);
            } else {
                this.expected("option", string3);
            }
        } else if (this.depth == 0) {
            if (string3.equals("StarTeamClientOptions")) {
                String string7 = attributes.getValue("version");
                if (string7 == null || !string7.equals("1.0")) {
                    throw new RuntimeException(Res.formatKey(ResIDs.UNSUPPORTED_CONFIGOPTIONS_VERSION_FMT, new Object[]{string7}));
                }
            } else {
                this.expected("StarTeamClientOptions", string3);
            }
        } else {
            throw new RuntimeException(Res.formatKey(ResIDs.SUB_ELEMENT_NOT_ALLOWED_FMT, new Object[]{string3}));
        }
        ++this.depth;
    }

    public void endElement(String string, String string2, String string3) {
        --this.depth;
    }

    public void load(File file) throws IOException {
        XMLConfigParser xMLConfigParser = this;
        synchronized (xMLConfigParser) {
            try {
                this.depth = 0;
                this.currentCategory = "";
                SAXParserFactory sAXParserFactory = null;
                SAXParser sAXParser = null;
                sAXParserFactory = SAXParserFactory.newInstance();
                sAXParser = sAXParserFactory.newSAXParser();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)this);
                ((InputStream)bufferedInputStream).close();
            }
            catch (SAXException sAXException) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.BAD_CONFIGOPTIONS_FILE_FMT, new Object[]{file.getPath()}));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Assert.internalError("XMLConfigParser.load()", parserConfigurationException);
            }
        }
    }
}

