/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Task;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;
import java.util.Date;

public class WorkRecord {
    private int m_ID = -1;
    private int m_workerID;
    private OLEDate m_workDate = this.getMidnight(new OLEDate(0.0));
    private double m_hoursWorked;
    private double m_hoursRemaining;
    private String m_notes = "";
    private Task m_task;
    private boolean m_isDirty = false;

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public int getID() {
        return this.m_ID;
    }

    void pokeID(int n) {
        this.m_ID = n;
    }

    public int getWorkPerformedBy() {
        return this.m_workerID;
    }

    public void setWorkPerformedBy(int n) {
        if (n != this.m_workerID) {
            this.m_workerID = n;
            this.m_isDirty = true;
        }
    }

    public OLEDate getDateWorkBegan() {
        return this.m_workDate;
    }

    public void setDateWorkBegan(OLEDate oLEDate) {
        OLEDate oLEDate2;
        if (oLEDate == null) {
            Assert.nullArgument("OLEDate");
        }
        if (!(oLEDate2 = oLEDate.getUTCNoon()).equals(this.m_workDate)) {
            this.m_workDate = oLEDate2;
            this.m_isDirty = true;
        }
    }

    public double getHoursWorked() {
        return this.m_hoursWorked;
    }

    public void setHoursWorked(double d) {
        if (d != this.m_hoursWorked) {
            this.m_hoursWorked = d;
            this.m_isDirty = true;
        }
    }

    public double getHoursRemaining() {
        return this.m_hoursRemaining;
    }

    public void setHoursRemaining(double d) {
        if (d != this.m_hoursRemaining) {
            this.m_hoursRemaining = d;
            this.m_isDirty = true;
        }
    }

    public String getNotes() {
        return this.m_notes;
    }

    public void setNotes(String string) {
        if (string == null) {
            Assert.nullArgument("String");
        }
        if (!string.equals(this.m_notes)) {
            this.m_notes = string;
            this.m_isDirty = true;
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof WorkRecord && ((WorkRecord)object).getID() == this.getID();
    }

    public int hashCode() {
        return this.getID();
    }

    static WorkRecord read(Command command, Task task) throws IOException {
        WorkRecord workRecord = new WorkRecord(task);
        workRecord.readGuts(command);
        return workRecord;
    }

    void readGuts(Command command) throws IOException {
        this.m_workerID = command.readInt();
        this.m_workDate = new OLEDate(command.readTime());
        this.m_hoursWorked = command.readTime();
        this.m_hoursRemaining = command.readTime();
        command.readInt();
        this.m_notes = command.readString();
        this.m_ID = command.readInt();
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_workerID);
        command.writeTime(this.m_workDate.getDoubleValue());
        command.writeTime(this.m_hoursWorked);
        command.writeTime(this.m_hoursRemaining);
        if (!this.m_task.isNew()) {
            int n = this.m_task.getInt(this.m_task.getPropertyNames().OBJECT_ID);
            command.writeInt(n);
        } else {
            command.writeInt(-1);
        }
        command.writeString(this.m_notes);
        command.writeInt(this.m_ID);
    }

    private OLEDate getMidnight(OLEDate oLEDate) {
        Date date = oLEDate.createDate();
        return new OLEDate(new Date(date.getYear(), date.getMonth(), date.getDate()));
    }

    WorkRecord(Task task) {
        this.m_task = task;
    }

    public WorkRecord(Task task, int n) {
        this.m_task = task;
        this.m_workerID = n;
    }
}

