/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Project;
import com.starbase.starteam.Project_Cmd_GetViews;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource_Data;
import com.starbase.starteam.View;
import com.starbase.starteam.View_Cache;
import java.util.Enumeration;
import java.util.Vector;

class View_CacheRefCollection {
    protected Server m_server = null;
    protected Project m_project = null;
    protected Type m_type = null;
    protected View_Cache m_cache = null;
    protected Object m_repository = null;
    protected Vector m_refs = new Vector();
    protected long m_timestampIDs = 0L;
    protected long m_timestampProperties = 0L;

    protected synchronized void populateViews() {
        if (this.m_timestampIDs == 0L) {
            this.refreshDirtyViews();
        }
    }

    public synchronized void populate() {
        this.populateViews();
        this.populateProperties();
    }

    public synchronized boolean isRefreshRequired() {
        return this.isRefreshViewsRequired() || this.isRefreshPropertiesRequired();
    }

    public synchronized void refresh() {
        this.refreshViews();
        this.refreshProperties();
    }

    public synchronized View[] toArray() {
        Vector vector = this.getRefs();
        int n = vector.size();
        View[] viewArray = new View[n];
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2] = (View)vector.elementAt(n2);
            ++n2;
        }
        return viewArray;
    }

    public synchronized void clear() {
        this.m_refs.removeAllElements();
        this.m_timestampIDs = 0L;
        this.m_timestampProperties = 0L;
    }

    public synchronized void discard() {
        View_Cache view_Cache = this.getCache();
        Enumeration enumeration = this.getRefs().elements();
        while (enumeration.hasMoreElements()) {
            View view = (View)enumeration.nextElement();
            view_Cache.discard(view.getCachedObject().getID());
        }
        this.clear();
    }

    public Server getServer() {
        return this.m_server;
    }

    public Project getProject() {
        return this.m_project;
    }

    public View_Cache getCache() {
        return this.m_cache;
    }

    public Vector getRefs() {
        return this.m_refs;
    }

    protected boolean isRefreshViewsRequired() {
        return this.m_timestampIDs == 0L || !this.m_cache.isMPXAvailable() || this.m_cache.isRefreshIDsRequired(this.m_timestampIDs);
    }

    protected void refreshViews() {
        if (this.isRefreshViewsRequired()) {
            this.refreshDirtyViews();
        }
    }

    private void refreshDirtyViews() {
        long l;
        Project_Cmd_GetViews.execute(this.m_server, this.m_project, this, true);
        this.m_timestampIDs = l = this.m_server.getServerCacheManager().getTimestamp();
        this.m_timestampProperties = 0L;
    }

    protected void updateView(int n, String string, String string2) {
        TypedResource_Data typedResource_Data = (TypedResource_Data)this.m_cache.getCached(n);
        if (typedResource_Data != null) {
            int n2;
            TypedResource_Data typedResource_Data2 = null;
            int n3 = typedResource_Data.indexForName(this.m_type.getServer().getPropertyNames().VIEW_NAME);
            if (!typedResource_Data.get(n3).equals(string)) {
                if (typedResource_Data2 == null) {
                    typedResource_Data2 = (TypedResource_Data)typedResource_Data.copy();
                }
                typedResource_Data2.put(n3, string);
            }
            if (!typedResource_Data.get(n2 = typedResource_Data.indexForName(this.m_type.getServer().getPropertyNames().VIEW_DESCRIPTION)).equals(string2)) {
                if (typedResource_Data2 == null) {
                    typedResource_Data2 = (TypedResource_Data)typedResource_Data.copy();
                }
                typedResource_Data2.put(n2, string2);
            }
            if (typedResource_Data2 != null) {
                this.m_cache.set(typedResource_Data2);
            }
        }
    }

    protected void addView(int n, String string, String string2, String string3, boolean bl) {
        View view = this.newView(n, string, string2, string3);
        this.m_refs.addElement(view);
        if (bl && this.m_cache.getCached(n) == null) {
            TypedResource_Data typedResource_Data = view.getData();
            this.m_cache.set(typedResource_Data);
        }
    }

    protected View newView(int n, String string, String string2, String string3) {
        View view = new View(this.m_server, this.m_project, n, string, string2);
        view.setFullName(string3);
        return view;
    }

    protected void populateProperties() {
        this.refreshProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isRefreshPropertiesRequired() {
        View_Cache view_Cache;
        View_Cache view_Cache2 = view_Cache = this.getCache();
        synchronized (view_Cache2) {
            if (!view_Cache.isMPXAvailable()) {
                return true;
            }
            long l = view_Cache.getLastModified();
            if (this.m_timestampProperties <= l) return view_Cache.isRefreshRequired(this.getRefs());
            return false;
        }
    }

    protected void refreshProperties() {
        View_Cache view_Cache = this.m_cache;
        synchronized (view_Cache) {
            boolean bl = this.m_cache.isMPXAvailable();
            Vector vector = new Vector();
            if (bl && this.m_timestampProperties > this.m_cache.getLastModified()) {
                Object var2_4 = null;
                return;
            }
            View_CacheRefCollection.copyInto(this.getRefs(), vector);
            this.m_cache.refresh(this.m_project, vector);
            if (bl) {
                this.m_timestampProperties = this.m_server.getServerCacheManager().getTimestamp();
            }
        }
    }

    static void copyInto(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
    }

    public View_CacheRefCollection(Project project) {
        this.m_server = project.getServer();
        this.m_project = project;
        this.m_type = this.m_server.typeForName(this.m_server.getTypeNames().VIEW);
        this.m_cache = this.m_server.getServerCacheManager().getViewCache(this.m_server);
    }
}

