/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ResIDs;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class Translations {
    private static final String EMPTY = "";
    private static final Locale INVARIANT = new Locale("", "", "");
    private String m_default = "";
    private Hashtable m_values = new Hashtable();

    public String getDefault() {
        return this.m_default;
    }

    public void setDefault(String string) {
        if (string == null) {
            Assert.nullArgument("String", "value");
        }
        this.m_default = string;
    }

    public Locale[] getLocales() {
        Locale[] localeArray = new Locale[this.m_values.size()];
        Enumeration enumeration = this.m_values.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            localeArray[n++] = (Locale)enumeration.nextElement();
        }
        return localeArray;
    }

    public String[] getLocaleNames() {
        Locale[] localeArray = this.getLocales();
        String[] stringArray = new String[localeArray.length];
        int n = 0;
        while (n < localeArray.length) {
            stringArray[n] = Translations.toString(localeArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void removeLocale(Locale locale) {
        if (locale == null) {
            Assert.nullArgument("Locale", "locale");
        }
        if (locale.equals(INVARIANT)) {
            throw new IllegalArgumentException(ResIDs.CANNOT_REMOVE_DEFAULT_LOCALE);
        }
        this.m_values.remove(locale);
    }

    public void removeLocale(String string) {
        if (string == null) {
            Assert.nullArgument("String", "locale");
        }
        this.removeLocale(Translations.parseLocale(string));
    }

    public String setTranslation(Locale locale, String string) {
        if (locale == null) {
            Assert.nullArgument("Locale", "locale");
        }
        if (string == null) {
            Assert.nullArgument("String", "value");
        }
        if (locale.equals(INVARIANT)) {
            String string2 = this.getDefault();
            this.m_default = string;
            return string2;
        }
        return this.m_values.put(locale, string);
    }

    public String setTranslation(String string, String string2) {
        if (string == null) {
            Assert.nullArgument("String", "locale");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "value");
        }
        return this.setTranslation(Translations.parseLocale(string), string2);
    }

    public String getTranslation(Locale locale) {
        if (locale == null) {
            Assert.nullArgument("Locale", "locale");
        }
        if (locale.equals(INVARIANT)) {
            return this.getDefault();
        }
        return (String)this.m_values.get(locale);
    }

    public String getTranslation(String string) {
        if (string == null) {
            Assert.nullArgument("String", "locale");
        }
        return this.getTranslation(Translations.parseLocale(string));
    }

    public String translate(Locale locale) {
        Locale locale2 = this.closestDefined(locale);
        return this.getTranslation(locale2);
    }

    public Locale closestDefined(Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            return INVARIANT;
        }
        String string = (String)this.m_values.get(locale2);
        if (string != null) {
            return locale2;
        }
        locale2 = new Locale(locale.getLanguage(), locale.getCountry(), EMPTY);
        string = (String)this.m_values.get(locale2);
        if (string != null) {
            return locale2;
        }
        locale2 = new Locale(locale.getLanguage(), EMPTY, EMPTY);
        string = (String)this.m_values.get(locale2);
        if (string != null) {
            return locale2;
        }
        return INVARIANT;
    }

    public String translate(String string) {
        if (string == null) {
            return this.getDefault();
        }
        return this.translate(Translations.parseLocale(string));
    }

    public String translate() {
        return this.translate(Locale.getDefault());
    }

    public static String toString(Locale locale) {
        if (locale == null) {
            return EMPTY;
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        boolean bl = string.length() != 0;
        boolean bl2 = string2.length() != 0;
        boolean bl3 = string3.length() != 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl2 || bl && bl3) {
            stringBuffer.append('-').append(string2);
        }
        if (bl3 && (bl || bl2)) {
            stringBuffer.append('-').append(string3);
        }
        return stringBuffer.toString();
    }

    public static Locale parseLocale(String string) {
        if (string == null) {
            return INVARIANT;
        }
        String string2 = EMPTY;
        String string3 = EMPTY;
        String string4 = EMPTY;
        int n = string.indexOf(45);
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            int n2 = string.indexOf(45, n + 1);
            if (n2 == -1) {
                string3 = string.substring(n + 1);
            } else {
                string3 = string.substring(n + 1, n2);
                string4 = string.substring(n2 + 1);
            }
        }
        return new Locale(string2, string3, string4);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(this.getDefault() + string);
        Locale[] localeArray = this.getLocales();
        int n = 0;
        while (n < localeArray.length) {
            stringBuffer.append("    [\"" + localeArray[n].getLanguage() + "\", \"" + localeArray[n].getCountry() + "\", \"" + localeArray[n].getVariant() + "\"]: \"" + this.getTranslation(localeArray[n]) + "\"");
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toDebugString();
    }

    public boolean isEqualTo(Translations translations) {
        return this.eq2(translations.m_default, this.m_default) && this.eq2(translations.m_values, this.m_values);
    }

    private boolean eq2(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private boolean eq2(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null) {
            return hashtable2 == null;
        }
        if (hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            Locale locale = (Locale)enumeration.nextElement();
            String string2 = (String)hashtable.get(locale);
            if (this.eq2(string2, string = (String)hashtable2.get(locale))) continue;
            return false;
        }
        return true;
    }

    public Translations copy() {
        Translations translations = new Translations();
        translations.m_default = this.m_default;
        translations.m_values = (Hashtable)this.m_values.clone();
        return translations;
    }

    public Translations() {
    }

    public Translations(String string) {
        this.setDefault(string);
    }
}

