/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.FileBasedStatusManager;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.starteam.SyncDB;
import com.starbase.starteam.SyncDirsEnumeration;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import com.starbase.util.Platform;
import com.starbase.util.UTF8;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class StatusMethod {
    private static final String INI_DEFAULT = "0";
    private static final String INI_PERFOLDER = "2";
    private static final String INI_CENTRAL = "1";
    private static Hashtable m_workStations = new Hashtable();
    private static String m_workStationID = null;
    private static Object m_sync = new Object();
    public static final StatusMethod DEFAULT = new StatusMethod("Default", "0");
    public static final StatusMethod CENTRAL = new StatusMethod("Central", "1");
    public static final StatusMethod PER_FOLDER = new StatusMethod("Per folder", "2");
    private static StatusMethod m_defaultMethod = CENTRAL;
    private static FileBasedStatusManager m_localSync = new FileBasedStatusManager(50000);
    private static String m_centralPath = null;
    private static FileBasedStatusManager m_centralSync = null;
    private String m_name = null;
    private String m_iniFileValue = null;

    public String getDisplayName() {
        if (this == DEFAULT) {
            return Res.getString(ResIDs.STATUS_METHOD_DEFAULT_DISPLAY_NAME);
        }
        if (this == CENTRAL) {
            return Res.getString(ResIDs.STATUS_METHOD_CENTRAL_DISPLAY_NAME);
        }
        if (this == PER_FOLDER) {
            return Res.getString(ResIDs.STATUS_METHOD_PERFOLDER_DISPLAY_NAME);
        }
        Assert.internalError("StatusMethod.getDisplayName(), name=" + this);
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    String getINIFileValue() {
        return this.m_iniFileValue;
    }

    static StatusMethod fromINIFileValue(String string) {
        String string2 = string.trim();
        if (string2.equals(INI_DEFAULT)) {
            return DEFAULT;
        }
        if (string2.equals(INI_CENTRAL)) {
            return CENTRAL;
        }
        if (string2.equals(INI_PERFOLDER)) {
            return PER_FOLDER;
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.UNKNOWN_STATUS_METHOD_CODE_FMT, new Object[]{string2}));
    }

    public static StatusMethod getDefaultStatusMethod() {
        return m_defaultMethod;
    }

    public static void setDefaultStatusMethod(StatusMethod statusMethod) {
        Object object = m_sync;
        synchronized (object) {
            if (statusMethod == null) {
                Assert.nullArgument("StatusMethod");
            }
            if (statusMethod == DEFAULT) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.STATUS_METHOD_IS_DEFAULT_FMT, new Object[]{"DEFAULT"}));
            }
            m_defaultMethod = statusMethod;
        }
    }

    public static void setCentralStatusDirectory(String string) throws IOException {
        Object object = m_sync;
        synchronized (object) {
            if (string == null) {
                Assert.nullArgument("String", "path");
            }
            if (!m_centralPath.equals(string)) {
                m_centralSync.setLocation(new File(string));
                m_centralPath = string;
                m_workStations.clear();
            }
        }
    }

    public static String getCentralStatusDirectory() {
        return m_centralPath;
    }

    public static FileBasedStatusManager getDefaultStatusManager() {
        return m_defaultMethod.getStatusManager();
    }

    public static FileBasedStatusManager getCentralStatusManager() {
        return CENTRAL.getStatusManager();
    }

    public static FileBasedStatusManager getPerFolderStatusManager() {
        return PER_FOLDER.getStatusManager();
    }

    public static FileBasedStatusManager getStatusManagerForView(View view) {
        Server server = view.getServer();
        server.getSupportedFeatures().verifyHasClientManagedFileStatus();
        GUID gUID = server.getClientContext().getWorkStationID();
        if (m_workStationID.equals(gUID.canonicalFormat())) {
            StatusMethod statusMethod = view.getStatusMethodOverride();
            return statusMethod.getStatusManager();
        }
        return StatusMethod.getWorkStationManager(gUID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileBasedStatusManager getStatusManager() {
        Object object = m_sync;
        synchronized (object) {
            if (this == DEFAULT) {
                if (m_defaultMethod == PER_FOLDER) {
                    return m_localSync;
                }
                if (m_defaultMethod == CENTRAL) {
                    return m_centralSync;
                }
                Assert.internalError("StatusMethod.getFileBasedStatusManager(), default=" + m_defaultMethod);
                return null;
            }
            if (this == PER_FOLDER) {
                return m_localSync;
            }
            if (this == CENTRAL) {
                return m_centralSync;
            }
            Assert.internalError("StatusMethod.getFileBasedStatusManager(), method=" + this);
            return null;
        }
    }

    public static Enumeration getSourceDirs(File file) throws IOException {
        Object object = m_sync;
        synchronized (object) {
            SyncDirsEnumeration syncDirsEnumeration = new SyncDirsEnumeration(file);
            Object var2_3 = null;
            return syncDirsEnumeration;
        }
    }

    public static void deleteSyncDB(File file, String string) {
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(UTF8.StringToUtf8(string));
        byte[] byArray = mD5.getData();
        String string2 = SyncDB.makeSubDirName(byArray);
        File file2 = new File(file, string2);
        String string3 = SyncDB.byteString(byArray);
        File file3 = new File(file2, string3 + ".sdb");
        File file4 = new File(file2, string3 + ".lck");
        file4.delete();
        file3.delete();
        String[] stringArray = file2.list();
        if (stringArray != null && stringArray.length == 0) {
            file2.delete();
        }
    }

    public static int getSourceDirsCount(File file) {
        String[] stringArray;
        int n = 0;
        if (file != null && file.isDirectory() && (stringArray = file.list()) != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String[] stringArray2;
                String string = stringArray[n2];
                File file2 = new File(file, string);
                if (file2.isDirectory() && StatusMethod.validDirName(string) && (stringArray2 = file2.list()) != null) {
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        String string2 = stringArray2[n3];
                        if (StatusMethod.validDBName(string2)) {
                            ++n;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    private static File getManagerPath(GUID gUID) {
        return new File(new File(m_centralPath, "wsids"), gUID.canonicalFormat());
    }

    private static FileBasedStatusManager getWorkStationManager(GUID gUID) {
        FileBasedStatusManager fileBasedStatusManager = (FileBasedStatusManager)m_workStations.get(gUID);
        if (fileBasedStatusManager == null) {
            fileBasedStatusManager = new FileBasedStatusManager(10000, StatusMethod.getManagerPath(gUID));
            m_workStations.put(gUID, fileBasedStatusManager);
        }
        return fileBasedStatusManager;
    }

    private static boolean validHex(char c) {
        return '0' <= c && '9' >= c || 'a' <= c && 'f' >= c;
    }

    static boolean validDirName(String string) {
        if (string.length() == 3) {
            int n = 0;
            while (n < 3) {
                if (!StatusMethod.validHex(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    static boolean validDBName(String string) {
        if (string.length() == 36 && string.endsWith(".sdb")) {
            int n = 0;
            while (n < 32) {
                if (!StatusMethod.validHex(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    private StatusMethod() {
    }

    private StatusMethod(String string, String string2) {
        this.m_name = string;
        this.m_iniFileValue = string2;
    }

    static {
        try {
            StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
            starTeamClientOptions.reloadIfNeeded();
            m_defaultMethod = starTeamClientOptions.getDefaultStatusMethod();
            if (m_defaultMethod == null) {
                m_defaultMethod = CENTRAL;
            }
            if ((m_centralPath = starTeamClientOptions.getCentralStatusDirectory()) == null) {
                m_centralPath = ConfigFiles.getDefaultCentralStatusDirectory().getPath();
            }
            m_centralSync = new FileBasedStatusManager(50000, new File(m_centralPath));
            m_workStationID = Platform.getWorkStationID().canonicalFormat();
        }
        catch (IOException iOException) {
            throw new SDKRuntimeException(Res.getString(ResIDs.CENTRAL_STATUS_REPOSITORY_ERROR), iOException);
        }
    }
}

