/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import java.util.StringTokenizer;

public class StarTeamURL {
    private static final char HOST_DELIM = '@';
    private static final char PORT_DELIM = ':';
    private static final char PASSWORD_DELIM = ':';
    private static final char FORWARD_SLASH = '/';
    private static final char BACK_SLASH = '\\';
    private static final String URL_PREFIX = "starteam:";
    private static final String EMPTY_STRING = "";
    private String m_Source = null;
    private String m_UserName = null;
    private String m_Password = null;
    private String m_HostName = null;
    private String m_Port = null;
    private int m_Protocol = 6;
    private String m_ProjectName = null;
    private String m_Path = null;

    public String getSource() {
        return this.m_Source;
    }

    public String getUserName() {
        return this.m_UserName;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public String getPort() {
        return this.m_Port;
    }

    public int getProtocol() {
        return this.m_Protocol;
    }

    public String getProjectName() {
        return this.m_ProjectName;
    }

    public String getPath() {
        return this.m_Path;
    }

    public StringTokenizer getFolders() {
        String string = this.m_Path != null ? this.m_Path : EMPTY_STRING;
        return new StringTokenizer(string, "/\\");
    }

    private void setProtocol(String string) {
        this.m_Protocol = string.equals("xml") ? 7 : 6;
    }

    private final void parse(String string) {
        this.reset();
        if (string.regionMatches(true, 0, URL_PREFIX, 0, URL_PREFIX.length())) {
            if (string.length() > URL_PREFIX.length()) {
                String string2 = string.substring(URL_PREFIX.length());
                String string3 = null;
                int n = string2.indexOf("//");
                if (n > 0) {
                    string3 = this.leftSplit(string2, n);
                    this.parseFromHost(this.trimFrontSlash(this.rightSplit(string2, n + 1)));
                } else {
                    string3 = EMPTY_STRING;
                    this.parseFromHost(this.trimFrontSlash(string2));
                }
                this.setProtocol(string3);
            }
        } else {
            this.parseFromHost(string);
        }
    }

    private final void reset() {
        this.m_UserName = null;
        this.m_Password = null;
        this.m_HostName = null;
        this.m_Port = null;
        this.m_Protocol = 6;
        this.m_ProjectName = null;
        this.m_Path = null;
    }

    private final void parseFromHost(String string) {
        int n = this.nextSlash(string);
        int n2 = string.length();
        switch (n) {
            case -1: {
                this.parseUserAndHost(string);
                break;
            }
            case 0: {
                if (n2 <= 1) break;
                this.parseFromProject(string.substring(1));
                break;
            }
            default: {
                this.parseUserAndHost(string.substring(0, n));
                if (n == n2 - 1) break;
                this.parseFromProject(string.substring(n + 1));
                break;
            }
        }
    }

    private final void parseUserAndHost(String string) {
        int n = string.indexOf(64);
        if (n == -1) {
            this.parseHostPort(string);
        } else {
            this.parseUserPassword(this.leftSplit(string, n));
            this.parseHostPort(this.rightSplit(string, n));
        }
    }

    private String trimFrontSlash(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2 && this.isSlash(string.charAt(n))) {
            ++n;
        }
        if (n == n2) {
            return EMPTY_STRING;
        }
        return string.substring(n);
    }

    private boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    private int nextSlash(String string) {
        int n = string.indexOf(47);
        int n2 = string.indexOf(92);
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        return n < n2 ? n : n2;
    }

    private String leftSplit(String string, int n) {
        int n2 = string.length();
        if (n == 0) {
            return null;
        }
        if (n < 0 || n >= n2) {
            return string;
        }
        return string.substring(0, n);
    }

    private String rightSplit(String string, int n) {
        int n2 = string.length();
        if (n < 0 || n >= n2) {
            return null;
        }
        return string.substring(n + 1);
    }

    private final void parseUserPassword(String string) {
        if (string != null && string.length() != 0) {
            int n = string.indexOf(58);
            this.m_UserName = this.leftSplit(string, n);
            this.m_Password = this.rightSplit(string, n);
        }
    }

    private final void parseHostPort(String string) {
        if (string != null && string.length() != 0) {
            int n = string.indexOf(58);
            this.m_HostName = this.leftSplit(string, n);
            this.m_Port = this.rightSplit(string, n);
        }
    }

    private void parseFromProject(String string) {
        if (string != null) {
            int n = this.nextSlash(string);
            this.m_ProjectName = this.leftSplit(string, n);
            this.m_Path = this.rightSplit(string, n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("From Source: " + this.m_Source + string);
        stringBuffer.append("Username: " + this.getUserName() + string);
        stringBuffer.append("Password: " + this.getPassword() + string);
        stringBuffer.append("Hostname: " + this.getHostName() + string);
        stringBuffer.append("Port: " + this.getPort() + string);
        stringBuffer.append("Project: " + this.getProjectName() + string);
        stringBuffer.append("Path:" + this.getPath() + string);
        stringBuffer.append("Folders:" + string);
        StringTokenizer stringTokenizer = this.getFolders();
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append("   " + stringTokenizer.nextElement() + string);
        }
        stringBuffer.append("------done-------" + string);
        return stringBuffer.toString();
    }

    public StarTeamURL(String string) {
        this.m_Source = string;
        this.parse(string);
    }
}

