/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.Folder;
import com.starbase.starteam.IConfigOptions;
import com.starbase.starteam.IniConfigOptions;
import com.starbase.starteam.Item;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.StatusMethod;
import com.starbase.starteam.View;
import com.starbase.starteam.XMLConfigOptions;
import com.starbase.util.Assert;
import com.starbase.util.Platform;
import com.starbase.util.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class StarTeamClientOptions {
    private static final String EMPTY = "";
    private static final String ID_YES = Integer.toString(1);
    private static final String ID_NO = Integer.toString(0);
    private static final String DEFAULT_ID = Integer.toString(-1);
    private static final int DEFAULT_NEW_ITEM_INTERVAL = 600;
    private static final int DEFAULT_SELECTED_ITEM_INTERVAL = 45;
    private static final int DEFAULT_REFRESH_MIN_TIME = 5;
    private static final int DEFAULT_REFRESH_MAX_TIME = 30;
    private static final int DEFAULT_LOG_THRESHOLD = 10;
    private static String VIEW_STATUS_KEY = "Project Component::ViewStatusMethodOverrides\\";
    private static String VIEWKEY = "Project Component::ViewWorkingFolderOverrides\\";
    private static String FOLDERKEY = "Project Component::WorkingFolderOverrides\\";
    private static String FOLDER_VISIBLE_KEY = "Project Component::FolderVisibleOverrides\\";
    private static String PROCESS_ITEM_KEY = "Project Component::ProcessActiveItem\\";
    private static StarTeamClientOptions m_singletonOptions = null;
    private static Object m_initSync = new Object();
    public static final String CHANGE_CHECK_NEW_ITEM_ACTIVATED = "Change Component::Check New Item Activated";
    public static final String CHANGE_CHECK_NEW_ITEM_INTERVAL = "Change Component::Check New Item Interval";
    public static final String CHANGE_READ_ON_SELECT_CHANGE_ACTIVATED = "Change Component::Read On Select Change Activated";
    public static final String CHANGE_SELECTED_ITEM_TIMER_ACTIVATED = "Change Component::Selected Item Timer Activated";
    public static final String CHANGE_SELECTED_ITEM_TIMER_INTERVAL = "Change Component::Selected Item Timer Interval";
    public static final String FILE_CLEAR_LOCKS_ON_CHECK_IN = "File Component::Clear Locks On Check-In";
    public static final String FILE_COMPARE_OPTIONS = "File Component::Compare Options";
    public static final String FILE_COMPARE_PATH = "File Component::Compare Path";
    public static final String FILE_EDITOR_PATH = "File Component::Editor Path";
    public static final String FILE_EDITOR_OPTIONS = "File Component::Editor Options";
    public static final String FILE_LOCALDIRECTORYWATCH = "File Component::LocalDirectoryWatch";
    public static final String FILE_LOCK_FILES_EXCLUSIVELY_ON_CHECK_OUT = "File Component::Lock Files Exclusively On Check-Out";
    public static final String FILE_MARK_UNLOCKED_FILES_READ_ONLY = "File Component::Mark Unlocked Files Read Only";
    public static final String FILE_MERGE_OPTIONS = "File Component::Merge Options";
    public static final String FILE_MERGE_PATH = "File Component::Merge Path";
    public static final String FILE_OPTIMIZE_FOR_SLOW_CONNECTIONS = "File Component::Optimize For Slow Connections";
    public static final String FILE_POPUP_VISMERGE_ALWAYS = "File Component::Popup VisMerge Always";
    public static final String FILE_USE_ALTERNATE_COMPARE = "File Component::Use Alternate Compare";
    public static final String FILE_USE_ALTERNATE_EDITOR = "File Component::Use Alternate Editor";
    public static final String FILE_USE_ALTERNATE_MERGE = "File Component::Use Alternate Merge";
    public static final String FILE_USE_MD5_TO_CALCULATE_STATUS = "File Component::Use MD5 To Calculate Status";
    public static final String FILE_USE_MODIFIED_TIME_STAMP = "File Component::Use Modified Time Stamp";
    public static final String FILE_PERFORM_EOL_CONVERSION = "File Component::Perform EOL Conversion";
    public static final String FILE_DEFAULT_EOL = "File Component::Default EOL";
    public static final String FILE_DEFAULT_ENCODING = "File Component::Default Encoding";
    public static final String FILE_USE_NON_EXCLUSIVE_LOCKS_IN_INTEGRATIONS = "File Component::Use Non-Exclusive Locks In Integrations";
    public static final String FILE_DEFAULT_STATUS_METHOD = "File Component::DefaultStatusMethod";
    public static final String FILE_CENTRAL_STATUS_DIRECTORY = "File Component::CentralStatusDir";
    public static final String TASK_CHECK_NEW_ITEM_ACTIVATED = "Task Component::Check New Item Activated";
    public static final String TASK_CHECK_NEW_ITEM_INTERVAL = "Task Component::Check New Item Interval";
    public static final String TASK_READ_ON_SELECT_CHANGE_ACTIVATED = "Task Component::Read On Select Change Activated";
    public static final String TASK_SELECTED_ITEM_TIMER_ACTIVATED = "Task Component::Selected Item Timer Activated";
    public static final String TASK_SELECTED_ITEM_TIMER_INTERVAL = "Task Component::Selected Item Timer Interval";
    public static final String TOPIC_CHECK_NEW_ITEM_ACTIVATED = "Topic Component::Check New Item Activated";
    public static final String TOPIC_CHECK_NEW_ITEM_INTERVAL = "Topic Component::Check New Item Interval";
    public static final String TOPIC_READ_ON_SELECT_CHANGE_ACTIVATED = "Topic Component::Read On Select Change Activated";
    public static final String TOPIC_SELECTED_ITEM_TIMER_ACTIVATED = "Topic Component::Selected Item Timer Activated";
    public static final String TOPIC_SELECTED_ITEM_TIMER_INTERVAL = "Topic Component::Selected Item Timer Interval";
    public static final String WORKSPACE_AUTO_REFRESH = "Workspace::Auto Refresh";
    public static final String WORKSPACE_CHANGE_SCOPE_FOLDER = "Workspace::Change Scope Folder";
    public static final String WORKSPACE_CONFIRM_DELETE = "Workspace::Confirm Delete";
    public static final String WORKSPACE_CONFIRM_MOVE = "Workspace::Confirm Move";
    public static final String WORKSPACE_FALCON = "Workspace::Falcon";
    public static final String WORKSPACE_FOLDER_CONTEXT = "Workspace::Folder Context";
    public static final String WORKSPACE_HISTORY_UTC = "Workspace::History UTC";
    public static final String WORKSPACE_INSTANT_REFRESH = "Workspace::Instant Refresh";
    public static final String WORKSPACE_INSTANT_REFRESH_MAX_TIME = "Workspace::Instant Refresh Max Time";
    public static final String WORKSPACE_INSTANT_REFRESH_MIN_TIME = "Workspace::Instant Refresh Min Time";
    public static final String WORKSPACE_LOG_COMMAND_DETAILS = "Workspace::Log Command Details";
    public static final String WORKSPACE_LOG_COMMANDS = "Workspace::Log Commands";
    public static final String WORKSPACE_LOG_ERRORS = "Workspace::Log Errors";
    public static final String WORKSPACE_LOG_EVENTS = "Workspace::Log Events";
    public static final String WORKSPACE_LOG_OUTPUT_PATH = "Workspace::Log Output Path";
    public static final String WORKSPACE_LOG_THRESHOLD = "Workspace::Log Threshold";
    public static final String WORKSPACE_LOG_UI_OPERATIONS = "Workspace::Log UI Operations";
    public static final String WORKSPACE_MAINTAIN_GROUP_STATE = "Workspace::Maintain Group State";
    public static final String WORKSPACE_REFRESH_TIME = "Workspace::Refresh Time";
    public static final String WORKSPACE_REPORT_OUTPUT_PATH = "Workspace::Report Output Path";
    public static final String WORKSPACE_RESTORE_SHORTCUTS = "Workspace::Restore Shortcuts";
    public static final String WORKSPACE_SHOW_STATUSBAR = "Workspace::Show StatusBar";
    public static final String WORKSPACE_SHOW_TOOLBARS = "Workspace::Show Toolbars";
    public static final String WORKSPACE_SHOW_VIRTUAL_MEETING_OPTIONS = "Workspace::Show Virtual Meeting Options";
    public static final String WORKSPACE_WARNINGS = "Workspace::Warnings";
    private IConfigOptions m_impl = null;
    private File m_file = null;
    private long m_lastMod = -1L;

    public static StarTeamClientOptions getDefault() throws IOException {
        if (m_singletonOptions == null) {
            Object object = m_initSync;
            synchronized (object) {
                if (m_singletonOptions == null) {
                    StarTeamClientOptions starTeamClientOptions = new StarTeamClientOptions();
                    starTeamClientOptions.loadDefault();
                    m_singletonOptions = starTeamClientOptions;
                }
            }
        }
        return m_singletonOptions;
    }

    public static File getDefaultFile() throws IOException {
        return ConfigFiles.getStarTeamINI();
    }

    public void loadDefault() throws IOException {
        this.load(StarTeamClientOptions.getDefaultFile());
    }

    public void save() throws IOException {
        this.m_impl.save(this.m_file);
        this.m_lastMod = this.m_file.lastModified();
    }

    public void saveTo(File file) throws IOException {
        this.m_file = file;
        this.m_impl.save(this.m_file);
        this.m_lastMod = this.m_file.lastModified();
    }

    static void convert(File file, File file2) throws IOException {
        IniConfigOptions iniConfigOptions = new IniConfigOptions();
        iniConfigOptions.load(file);
        XMLConfigOptions xMLConfigOptions = new XMLConfigOptions();
        Enumeration enumeration = iniConfigOptions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = StarTeamClientOptions.getCategoryPart(string);
            String string3 = StarTeamClientOptions.getOptionPart(string);
            String string4 = iniConfigOptions.getOption(string);
            xMLConfigOptions.setOption(string2, string3, string4);
        }
        xMLConfigOptions.save(file2);
    }

    public void load(File file) throws IOException {
        IConfigOptions iConfigOptions = null;
        if (file.exists()) {
            iConfigOptions = XMLUtils.isXML(file) ? new XMLConfigOptions() : new IniConfigOptions();
            iConfigOptions.load(file);
            this.m_lastMod = file.lastModified();
        } else {
            iConfigOptions = new XMLConfigOptions();
            this.m_lastMod = -1L;
        }
        this.m_impl = iConfigOptions;
        this.m_file = file;
    }

    public void reload() throws IOException {
        if (this.m_file != null && this.m_file.exists()) {
            this.load(this.m_file);
        }
    }

    public void reloadIfNeeded() throws IOException {
        long l;
        if (this.m_file != null && this.m_file.exists() && (l = this.m_file.lastModified()) != this.m_lastMod) {
            this.reload();
        }
    }

    public String getComponentOption(String string, String string2, String string3) {
        String string4 = null;
        string4 = this.m_impl.getOption(string, string2);
        if (string4 == null) {
            string4 = string3;
        }
        return string4;
    }

    public void setComponentOption(String string, String string2, String string3) {
        this.m_impl.setOption(string, string2, string3);
    }

    private static String getCategoryPart(String string) {
        String string2 = null;
        int n = string.indexOf("::");
        string2 = n < 0 ? EMPTY : (n == string.length() - 2 ? string.substring(0, n) : string.substring(0, n));
        return string2;
    }

    private static String getOptionPart(String string) {
        String string2 = null;
        int n = string.indexOf("::");
        string2 = n < 0 ? string : (n == string.length() - 2 ? EMPTY : string.substring(n + 2));
        return string2;
    }

    public String getOption(String string, String string2) {
        String string3 = StarTeamClientOptions.getCategoryPart(string);
        String string4 = StarTeamClientOptions.getOptionPart(string);
        return this.getComponentOption(string3, string4, string2);
    }

    public void setOption(String string, String string2) {
        if (string == null) {
            Assert.nullArgument("String", "optionName");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "value");
        }
        if (string.indexOf(61) != -1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.OPTION_NAME_WITH_EQUAL_SIGN_FMT, new Object[]{string}));
        }
        String string3 = StarTeamClientOptions.getCategoryPart(string);
        String string4 = StarTeamClientOptions.getOptionPart(string);
        this.m_impl.setOption(string3, string4, string2);
    }

    private void removeOption(String string) {
        String string2 = StarTeamClientOptions.getCategoryPart(string);
        String string3 = StarTeamClientOptions.getOptionPart(string);
        this.m_impl.setOption(string2, string3, null);
    }

    public void setViewStatusMethodOverride(View view, StatusMethod statusMethod) {
        if (statusMethod == null) {
            Assert.nullArgument("StatusMethod");
        }
        String string = VIEW_STATUS_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\Method";
        this.setOption(string, statusMethod.getINIFileValue());
    }

    public StatusMethod getViewStatusMethodOverride(View view) {
        String string = VIEW_STATUS_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\Method";
        String string2 = this.getOption(string, null);
        if (string2 == null) {
            return null;
        }
        return StatusMethod.fromINIFileValue(string2);
    }

    public void setCentralStatusDirectory(String string) {
        this.setOption(FILE_CENTRAL_STATUS_DIRECTORY, string);
    }

    public String getCentralStatusDirectory() throws IOException {
        return this.getOption(FILE_CENTRAL_STATUS_DIRECTORY, ConfigFiles.getDefaultCentralStatusDirectory().getPath());
    }

    public void setDefaultStatusMethod(StatusMethod statusMethod) {
        if (statusMethod == null) {
            Assert.nullArgument("StatusMethod");
        }
        if (statusMethod == StatusMethod.DEFAULT) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.STATUS_METHOD_IS_DEFAULT_FMT, new Object[]{"DEFAULT"}));
        }
        this.setOption(FILE_DEFAULT_STATUS_METHOD, statusMethod.getINIFileValue());
    }

    public StatusMethod getDefaultStatusMethod() {
        String string = this.getOption(FILE_DEFAULT_STATUS_METHOD, null);
        if (string == null) {
            return StatusMethod.CENTRAL;
        }
        return StatusMethod.fromINIFileValue(string);
    }

    public void setProcessItem(Item item) throws IOException {
        View view = item.getView();
        String string = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        String string2 = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        this.setOption(string, Integer.toString(item.getItemID()));
        this.setOption(string2, Integer.toString(item.getType().getClassID()));
    }

    public void clearProcessItem(View view) throws IOException {
        String string = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        String string2 = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        this.setOption(string, DEFAULT_ID);
        this.setOption(string2, DEFAULT_ID);
    }

    public int getProcessItemID(View view) throws IOException {
        String string = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ItemID";
        String string2 = this.getOption(string, null);
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public int getProcessItemClassID(View view) throws IOException {
        String string = PROCESS_ITEM_KEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID() + "\\ClassID";
        String string2 = this.getOption(string, null);
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void setViewAlternatePath(View view, String string) {
        String string2 = this.getViewKey(view) + "\\Path";
        this.setOption(string2, string);
    }

    public void setViewAlternatePathEnabled(View view, boolean bl) {
        String string = this.getViewKey(view) + "\\Enable";
        this.setOption(string, bl ? ID_YES : ID_NO);
    }

    public void setFolderAlternatePath(Folder folder, String string) {
        String string2 = this.getFolderKey(FOLDERKEY, folder) + "\\Path";
        this.setOption(string2, string);
    }

    public void setFolderAlternatePathEnabled(Folder folder, boolean bl) {
        String string = this.getFolderKey(FOLDERKEY, folder) + "\\Enable";
        this.setOption(string, bl ? ID_YES : ID_NO);
    }

    public void setFolderUserVisible(Folder folder, boolean bl) {
        String string = this.getFolderKey(FOLDER_VISIBLE_KEY, folder) + "\\Visible";
        if (bl) {
            this.removeOption(string);
        } else {
            this.setOption(string, ID_NO);
        }
    }

    public String getViewAlternatePath(View view) {
        String string = this.getViewKey(view) + "\\Path";
        return this.getOption(string, null);
    }

    public boolean getViewAlternatePathEnabled(View view) {
        String string = this.getViewKey(view) + "\\Enable";
        return this.getBooleanProp(string, true);
    }

    public String getFolderAlternatePath(Folder folder) {
        String string = this.getFolderKey(FOLDERKEY, folder) + "\\Path";
        return this.getOption(string, null);
    }

    public boolean getFolderAlternatePathEnabled(Folder folder) {
        String string = this.getFolderKey(FOLDERKEY, folder) + "\\Enable";
        return this.getBooleanProp(string, true);
    }

    public boolean getFolderUserVisible(Folder folder) {
        String string = this.getFolderKey(FOLDER_VISIBLE_KEY, folder) + "\\Visible";
        return this.getBooleanProp(string, true);
    }

    private boolean getBooleanProp(String string, boolean bl) {
        String string2 = this.getOption(string, null);
        if (string2 == null) {
            return bl;
        }
        return !string2.trim().equals(ID_NO);
    }

    private void setBooleanProp(String string, boolean bl) {
        this.setOption(string, bl ? ID_YES : ID_NO);
    }

    private int getNumberProp(String string, int n) {
        String string2 = this.getOption(string, null);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private void setNumberProp(String string, int n) {
        this.setOption(string, Integer.toString(n));
    }

    private String getTextProp(String string, String string2) {
        String string3 = this.getOption(string, null);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private void setTextProp(String string, String string2) {
        this.setOption(string, string2);
    }

    private String getViewKey(View view) {
        return VIEWKEY + view.getServer().getRepositoryID().toString().toLowerCase() + "\\" + view.getID();
    }

    private String getFolderKey(String string, Folder folder) {
        return string + folder.getServer().getRepositoryID().toString().toLowerCase() + "\\" + folder.getItemID();
    }

    public boolean getChangeCheckNewItemActivated() {
        return this.getBooleanProp(CHANGE_CHECK_NEW_ITEM_ACTIVATED, true);
    }

    public void setChangeCheckNewItemActivated(boolean bl) {
        this.setBooleanProp(CHANGE_CHECK_NEW_ITEM_ACTIVATED, bl);
    }

    public int getChangeCheckNewItemInterval() {
        return this.getNumberProp(CHANGE_CHECK_NEW_ITEM_INTERVAL, 600);
    }

    public void setChangeCheckNewItemInterval(int n) {
        this.setNumberProp(CHANGE_CHECK_NEW_ITEM_INTERVAL, n);
    }

    public boolean getChangeReadOnSelectChangeActivated() {
        return this.getBooleanProp(CHANGE_READ_ON_SELECT_CHANGE_ACTIVATED, false);
    }

    public void setChangeReadOnSelectChangeActivated(boolean bl) {
        this.setBooleanProp(CHANGE_READ_ON_SELECT_CHANGE_ACTIVATED, bl);
    }

    public boolean getChangeSelectedItemTimerActivated() {
        return this.getBooleanProp(CHANGE_SELECTED_ITEM_TIMER_ACTIVATED, false);
    }

    public void setChangeSelectedItemTimerActivated(boolean bl) {
        this.setBooleanProp(CHANGE_SELECTED_ITEM_TIMER_ACTIVATED, bl);
    }

    public int getChangeSelectedItemTimerInterval() {
        return this.getNumberProp(CHANGE_SELECTED_ITEM_TIMER_INTERVAL, 45);
    }

    public void setChangeSelectedItemTimerInterval(int n) {
        this.setNumberProp(CHANGE_SELECTED_ITEM_TIMER_INTERVAL, n);
    }

    public boolean getFileClearLocksOnCheckIn() {
        return this.getBooleanProp(FILE_CLEAR_LOCKS_ON_CHECK_IN, false);
    }

    public void setFileClearLocksOnCheckIn(boolean bl) {
        this.setBooleanProp(FILE_CLEAR_LOCKS_ON_CHECK_IN, bl);
    }

    public String getFileCompareOptions() {
        return this.getTextProp(FILE_COMPARE_OPTIONS, EMPTY);
    }

    public void setFileCompareOptions(String string) {
        this.setTextProp(FILE_COMPARE_OPTIONS, string);
    }

    public String getFileComparePath() {
        return this.getTextProp(FILE_COMPARE_PATH, EMPTY);
    }

    public void setFileComparePath(String string) {
        this.setTextProp(FILE_COMPARE_PATH, string);
    }

    public String getFileDefaultEncoding() {
        return this.getTextProp(FILE_DEFAULT_ENCODING, System.getProperty("file.encoding"));
    }

    public void setFileDefaultEncoding(String string) {
        this.setTextProp(FILE_DEFAULT_ENCODING, string);
    }

    public String getFileEditorPath() {
        return this.getTextProp(FILE_EDITOR_PATH, EMPTY);
    }

    public void setFileEditorPath(String string) {
        this.setTextProp(FILE_EDITOR_PATH, string);
    }

    public String getFileEditorOptions() {
        return this.getTextProp(FILE_EDITOR_OPTIONS, EMPTY);
    }

    public void setFileEditorOptions(String string) {
        this.setTextProp(FILE_EDITOR_OPTIONS, string);
    }

    public boolean getFileLocalDirectoryWatch() {
        return this.getBooleanProp(FILE_LOCALDIRECTORYWATCH, true);
    }

    public void setFileLocalDirectoryWatch(boolean bl) {
        this.setBooleanProp(FILE_LOCALDIRECTORYWATCH, bl);
    }

    public boolean getFileLockFilesExclusivelyOnCheckOut() {
        return this.getBooleanProp(FILE_LOCK_FILES_EXCLUSIVELY_ON_CHECK_OUT, false);
    }

    public void setFileLockFilesExclusivelyOnCheckOut(boolean bl) {
        this.setBooleanProp(FILE_LOCK_FILES_EXCLUSIVELY_ON_CHECK_OUT, bl);
    }

    public boolean getFileMarkUnlockedFilesReadOnly() {
        return this.getBooleanProp(FILE_MARK_UNLOCKED_FILES_READ_ONLY, false);
    }

    public void setFileMarkUnlockedFilesReadOnly(boolean bl) {
        this.setBooleanProp(FILE_MARK_UNLOCKED_FILES_READ_ONLY, bl);
    }

    public String getFileMergeOptions() {
        return this.getTextProp(FILE_MERGE_OPTIONS, EMPTY);
    }

    public void setFileMergeOptions(String string) {
        this.setTextProp(FILE_MERGE_OPTIONS, string);
    }

    public String getFileMergePath() {
        return this.getTextProp(FILE_MERGE_PATH, EMPTY);
    }

    public void setFileMergePath(String string) {
        this.setTextProp(FILE_MERGE_PATH, string);
    }

    public boolean getFileOptimizeForSlowConnections() {
        return this.getBooleanProp(FILE_OPTIMIZE_FOR_SLOW_CONNECTIONS, false);
    }

    public void setFileOptimizeForSlowConnections(boolean bl) {
        this.setBooleanProp(FILE_OPTIMIZE_FOR_SLOW_CONNECTIONS, bl);
    }

    public boolean getFilePopupVisMergeAlways() {
        return this.getBooleanProp(FILE_POPUP_VISMERGE_ALWAYS, true);
    }

    public void setFilePopupVisMergeAlways(boolean bl) {
        this.setBooleanProp(FILE_POPUP_VISMERGE_ALWAYS, bl);
    }

    public boolean getFileUseAlternateCompare() {
        return this.getBooleanProp(FILE_USE_ALTERNATE_COMPARE, false);
    }

    public void setFileUseAlternateCompare(boolean bl) {
        this.setBooleanProp(FILE_USE_ALTERNATE_COMPARE, bl);
    }

    public boolean getFileUseAlternateEditor() {
        return this.getBooleanProp(FILE_USE_ALTERNATE_EDITOR, false);
    }

    public void setFileUseAlternateEditor(boolean bl) {
        this.setBooleanProp(FILE_USE_ALTERNATE_EDITOR, bl);
    }

    public boolean getFileUseAlternateMerge() {
        return this.getBooleanProp(FILE_USE_ALTERNATE_MERGE, false);
    }

    public void setFileUseAlternateMerge(boolean bl) {
        this.setBooleanProp(FILE_USE_ALTERNATE_MERGE, bl);
    }

    public boolean getFileUseMD5ToCalculateStatus() {
        return this.getBooleanProp(FILE_USE_MD5_TO_CALCULATE_STATUS, false);
    }

    public void setFileUseMD5ToCalculateStatus(boolean bl) {
        this.setBooleanProp(FILE_USE_MD5_TO_CALCULATE_STATUS, bl);
    }

    public boolean getFileUseModifiedTimeStamp() {
        return this.getBooleanProp(FILE_USE_MODIFIED_TIME_STAMP, false);
    }

    public void setFileUseModifiedTimeStamp(boolean bl) {
        this.setBooleanProp(FILE_USE_MODIFIED_TIME_STAMP, bl);
    }

    public boolean getFilePerformEOLConversion() {
        return this.getBooleanProp(FILE_PERFORM_EOL_CONVERSION, false);
    }

    public void setFilePerformEOLConversion(boolean bl) {
        this.setBooleanProp(FILE_PERFORM_EOL_CONVERSION, bl);
    }

    public String getFileDefaultEOL() {
        return this.getTextProp(FILE_DEFAULT_EOL, "CRLF");
    }

    public void setFileDefaultEOL(String string) {
        this.setTextProp(FILE_DEFAULT_EOL, string);
    }

    public boolean getFileUseNonExclusiveLocksInIntegrations() {
        return this.getBooleanProp(FILE_USE_NON_EXCLUSIVE_LOCKS_IN_INTEGRATIONS, true);
    }

    public void setFileUseNonExclusiveLocksInIntegrations(boolean bl) {
        this.setBooleanProp(FILE_USE_NON_EXCLUSIVE_LOCKS_IN_INTEGRATIONS, bl);
    }

    public boolean getTaskCheckNewItemActivated() {
        return this.getBooleanProp(TASK_CHECK_NEW_ITEM_ACTIVATED, true);
    }

    public void setTaskCheckNewItemActivated(boolean bl) {
        this.setBooleanProp(TASK_CHECK_NEW_ITEM_ACTIVATED, bl);
    }

    public int getTaskCheckNewItemInterval() {
        return this.getNumberProp(TASK_CHECK_NEW_ITEM_INTERVAL, 600);
    }

    public void setTaskCheckNewItemInterval(int n) {
        this.setNumberProp(TASK_CHECK_NEW_ITEM_INTERVAL, n);
    }

    public boolean getTaskReadOnSelectChangeActivated() {
        return this.getBooleanProp(TASK_READ_ON_SELECT_CHANGE_ACTIVATED, false);
    }

    public void setTaskReadOnSelectChangeActivated(boolean bl) {
        this.setBooleanProp(TASK_READ_ON_SELECT_CHANGE_ACTIVATED, bl);
    }

    public boolean getTaskSelectedItemTimerActivated() {
        return this.getBooleanProp(TASK_SELECTED_ITEM_TIMER_ACTIVATED, false);
    }

    public void setTaskSelectedItemTimerActivated(boolean bl) {
        this.setBooleanProp(TASK_SELECTED_ITEM_TIMER_ACTIVATED, bl);
    }

    public int getTaskSelectedItemTimerInterval() {
        return this.getNumberProp(TASK_SELECTED_ITEM_TIMER_INTERVAL, 45);
    }

    public void setTaskSelectedItemTimerInterval(int n) {
        this.setNumberProp(TASK_SELECTED_ITEM_TIMER_INTERVAL, n);
    }

    public boolean getTopicCheckNewItemActivated() {
        return this.getBooleanProp(TOPIC_CHECK_NEW_ITEM_ACTIVATED, true);
    }

    public void setTopicCheckNewItemActivated(boolean bl) {
        this.setBooleanProp(TOPIC_CHECK_NEW_ITEM_ACTIVATED, bl);
    }

    public int getTopicCheckNewItemInterval() {
        return this.getNumberProp(TOPIC_CHECK_NEW_ITEM_INTERVAL, 600);
    }

    public void setTopicCheckNewItemInterval(int n) {
        this.setNumberProp(TOPIC_CHECK_NEW_ITEM_INTERVAL, n);
    }

    public boolean getTopicReadOnSelectChangeActivated() {
        return this.getBooleanProp(TOPIC_READ_ON_SELECT_CHANGE_ACTIVATED, false);
    }

    public void setTopicReadOnSelectChangeActivated(boolean bl) {
        this.setBooleanProp(TOPIC_READ_ON_SELECT_CHANGE_ACTIVATED, bl);
    }

    public boolean getTopicSelectedItemTimerActivated() {
        return this.getBooleanProp(TOPIC_SELECTED_ITEM_TIMER_ACTIVATED, false);
    }

    public void setTopicSelectedItemTimerActivated(boolean bl) {
        this.setBooleanProp(TOPIC_SELECTED_ITEM_TIMER_ACTIVATED, bl);
    }

    public int getTopicSelectedItemTimerInterval() {
        return this.getNumberProp(TOPIC_SELECTED_ITEM_TIMER_INTERVAL, 45);
    }

    public void setTopicSelectedItemTimerInterval(int n) {
        this.setNumberProp(TOPIC_SELECTED_ITEM_TIMER_INTERVAL, n);
    }

    public boolean getWorkspaceAutoRefresh() {
        return this.getBooleanProp(WORKSPACE_AUTO_REFRESH, false);
    }

    public void setWorkspaceAutoRefresh(boolean bl) {
        this.setBooleanProp(WORKSPACE_AUTO_REFRESH, bl);
    }

    public boolean getWorkspaceChangeScopeFolder() {
        return this.getBooleanProp(WORKSPACE_CHANGE_SCOPE_FOLDER, false);
    }

    public void setWorkspaceChangeScopeFolder(boolean bl) {
        this.setBooleanProp(WORKSPACE_CHANGE_SCOPE_FOLDER, bl);
    }

    public boolean getWorkspaceConfirmDelete() {
        return this.getBooleanProp(WORKSPACE_CONFIRM_DELETE, true);
    }

    public void setWorkspaceConfirmDelete(boolean bl) {
        this.setBooleanProp(WORKSPACE_CONFIRM_DELETE, bl);
    }

    public boolean getWorkspaceConfirmMove() {
        return this.getBooleanProp(WORKSPACE_CONFIRM_MOVE, true);
    }

    public void setWorkspaceConfirmMove(boolean bl) {
        this.setBooleanProp(WORKSPACE_CONFIRM_MOVE, bl);
    }

    public boolean getWorkspaceFalcon() {
        return this.getBooleanProp(WORKSPACE_FALCON, true);
    }

    public void setWorkspaceFalcon(boolean bl) {
        this.setBooleanProp(WORKSPACE_FALCON, bl);
    }

    public boolean getWorkspaceFolderContext() {
        return this.getBooleanProp(WORKSPACE_FOLDER_CONTEXT, true);
    }

    public void setWorkspaceFolderContext(boolean bl) {
        this.setBooleanProp(WORKSPACE_FOLDER_CONTEXT, bl);
    }

    public boolean getWorkspaceHistoryUTC() {
        return this.getBooleanProp(WORKSPACE_HISTORY_UTC, false);
    }

    public void setWorkspaceHistoryUTC(boolean bl) {
        this.setBooleanProp(WORKSPACE_HISTORY_UTC, bl);
    }

    public boolean getWorkspaceInstantRefresh() {
        return this.getBooleanProp(WORKSPACE_INSTANT_REFRESH, true);
    }

    public void setWorkspaceInstantRefresh(boolean bl) {
        this.setBooleanProp(WORKSPACE_INSTANT_REFRESH, bl);
    }

    public int getWorkspaceInstantRefreshMaxTime() {
        return this.getNumberProp(WORKSPACE_INSTANT_REFRESH_MAX_TIME, 30);
    }

    public void setWorkspaceInstantRefreshMaxTime(int n) {
        this.setNumberProp(WORKSPACE_INSTANT_REFRESH_MAX_TIME, n);
    }

    public int getWorkspaceInstantRefreshMinTime() {
        return this.getNumberProp(WORKSPACE_INSTANT_REFRESH_MIN_TIME, 5);
    }

    public void setWorkspaceInstantRefreshMinTime(int n) {
        this.setNumberProp(WORKSPACE_INSTANT_REFRESH_MIN_TIME, n);
    }

    public boolean getWorkspaceLogCommandDetails() {
        return this.getBooleanProp(WORKSPACE_LOG_COMMAND_DETAILS, false);
    }

    public void setWorkspaceLogCommandDetails(boolean bl) {
        this.setBooleanProp(WORKSPACE_LOG_COMMAND_DETAILS, bl);
    }

    public boolean getWorkspaceLogCommands() {
        return this.getBooleanProp(WORKSPACE_LOG_COMMANDS, false);
    }

    public void setWorkspaceLogCommands(boolean bl) {
        this.setBooleanProp(WORKSPACE_LOG_COMMANDS, bl);
    }

    public boolean getWorkspaceLogErrors() {
        return this.getBooleanProp(WORKSPACE_LOG_ERRORS, true);
    }

    public void setWorkspaceLogErrors(boolean bl) {
        this.setBooleanProp(WORKSPACE_LOG_ERRORS, bl);
    }

    public boolean getWorkspaceLogEvents() {
        return this.getBooleanProp(WORKSPACE_LOG_EVENTS, false);
    }

    public void setWorkspaceLogEvents(boolean bl) {
        this.setBooleanProp(WORKSPACE_LOG_EVENTS, bl);
    }

    public String getWorkspaceLogOutputPath() {
        return this.getTextProp(WORKSPACE_LOG_OUTPUT_PATH, EMPTY);
    }

    public void setWorkspaceLogOutputPath(String string) {
        this.setTextProp(WORKSPACE_LOG_OUTPUT_PATH, string);
    }

    public int getWorkspaceLogThreshold() {
        return this.getNumberProp(WORKSPACE_LOG_THRESHOLD, 10);
    }

    public void setWorkspaceLogThreshold(int n) {
        this.setNumberProp(WORKSPACE_LOG_THRESHOLD, n);
    }

    public boolean getWorkspaceLogUIOperations() {
        return this.getBooleanProp(WORKSPACE_LOG_UI_OPERATIONS, false);
    }

    public void setWorkspaceLogUIOperations(boolean bl) {
        this.setBooleanProp(WORKSPACE_LOG_UI_OPERATIONS, bl);
    }

    public boolean getWorkspaceMaintainGroupState() {
        return this.getBooleanProp(WORKSPACE_MAINTAIN_GROUP_STATE, true);
    }

    public void setWorkspaceMaintainGroupState(boolean bl) {
        this.setBooleanProp(WORKSPACE_MAINTAIN_GROUP_STATE, bl);
    }

    public boolean getWorkspaceRefreshTime() {
        return this.getBooleanProp(WORKSPACE_REFRESH_TIME, false);
    }

    public void setWorkspaceRefreshTime(boolean bl) {
        this.setBooleanProp(WORKSPACE_REFRESH_TIME, bl);
    }

    public String getWorkspaceReportOutputPath() {
        return this.getTextProp(WORKSPACE_REPORT_OUTPUT_PATH, EMPTY);
    }

    public void setWorkspaceReportOutputPath(String string) {
        this.setTextProp(WORKSPACE_REPORT_OUTPUT_PATH, string);
    }

    public boolean getWorkspaceRestoreShortcuts() {
        return this.getBooleanProp(WORKSPACE_RESTORE_SHORTCUTS, true);
    }

    public void setWorkspaceRestoreShortcuts(boolean bl) {
        this.setBooleanProp(WORKSPACE_RESTORE_SHORTCUTS, bl);
    }

    public boolean getWorkspaceShowStatusBar() {
        return this.getBooleanProp(WORKSPACE_SHOW_STATUSBAR, true);
    }

    public void setWorkspaceShowStatusBar(boolean bl) {
        this.setBooleanProp(WORKSPACE_SHOW_STATUSBAR, bl);
    }

    public boolean getWorkspaceShowToolbars() {
        return this.getBooleanProp(WORKSPACE_SHOW_TOOLBARS, true);
    }

    public void setWorkspaceShowToolbars(boolean bl) {
        this.setBooleanProp(WORKSPACE_SHOW_TOOLBARS, bl);
    }

    public boolean getWorkspaceShowVirtualMeetingOptions() {
        return this.getBooleanProp(WORKSPACE_SHOW_VIRTUAL_MEETING_OPTIONS, false);
    }

    public void setWorkspaceShowVirtualMeetingOptions(boolean bl) {
        this.setBooleanProp(WORKSPACE_SHOW_VIRTUAL_MEETING_OPTIONS, bl);
    }

    public boolean getWorkspaceWarnings() {
        return this.getBooleanProp(WORKSPACE_WARNINGS, true);
    }

    public void setWorkspaceWarnings(boolean bl) {
        this.setBooleanProp(WORKSPACE_WARNINGS, bl);
    }

    private void setDefaults() {
        this.m_impl = new XMLConfigOptions();
        this.setOption(CHANGE_CHECK_NEW_ITEM_ACTIVATED, ID_YES);
        this.setOption(CHANGE_CHECK_NEW_ITEM_INTERVAL, Integer.toString(600));
        this.setOption(CHANGE_READ_ON_SELECT_CHANGE_ACTIVATED, ID_NO);
        this.setOption(CHANGE_SELECTED_ITEM_TIMER_ACTIVATED, ID_NO);
        this.setOption(CHANGE_SELECTED_ITEM_TIMER_INTERVAL, Integer.toString(45));
        this.setOption(FILE_CLEAR_LOCKS_ON_CHECK_IN, ID_NO);
        this.setOption(FILE_COMPARE_OPTIONS, EMPTY);
        this.setOption(FILE_COMPARE_PATH, EMPTY);
        this.setOption(FILE_EDITOR_OPTIONS, EMPTY);
        this.setOption(FILE_EDITOR_PATH, EMPTY);
        this.setOption(FILE_LOCALDIRECTORYWATCH, ID_YES);
        this.setOption(FILE_LOCK_FILES_EXCLUSIVELY_ON_CHECK_OUT, ID_NO);
        this.setOption(FILE_MARK_UNLOCKED_FILES_READ_ONLY, ID_NO);
        this.setOption(FILE_MERGE_OPTIONS, EMPTY);
        this.setOption(FILE_MERGE_PATH, EMPTY);
        this.setOption(FILE_OPTIMIZE_FOR_SLOW_CONNECTIONS, ID_NO);
        this.setOption(FILE_POPUP_VISMERGE_ALWAYS, ID_YES);
        this.setOption(FILE_USE_ALTERNATE_COMPARE, ID_NO);
        this.setOption(FILE_USE_ALTERNATE_EDITOR, ID_NO);
        this.setOption(FILE_USE_ALTERNATE_MERGE, ID_NO);
        this.setOption(FILE_USE_MD5_TO_CALCULATE_STATUS, ID_NO);
        this.setOption(FILE_USE_MODIFIED_TIME_STAMP, ID_NO);
        this.setOption(FILE_PERFORM_EOL_CONVERSION, ID_NO);
        this.setOption(FILE_DEFAULT_EOL, StarTeamClientOptions.getDefaultEOL());
        this.setOption(FILE_USE_NON_EXCLUSIVE_LOCKS_IN_INTEGRATIONS, ID_YES);
        this.setOption(TASK_CHECK_NEW_ITEM_ACTIVATED, ID_YES);
        this.setOption(TASK_CHECK_NEW_ITEM_INTERVAL, Integer.toString(600));
        this.setOption(TASK_READ_ON_SELECT_CHANGE_ACTIVATED, ID_NO);
        this.setOption(TASK_SELECTED_ITEM_TIMER_ACTIVATED, ID_NO);
        this.setOption(TASK_SELECTED_ITEM_TIMER_INTERVAL, Integer.toString(45));
        this.setOption(TOPIC_CHECK_NEW_ITEM_ACTIVATED, ID_YES);
        this.setOption(TOPIC_CHECK_NEW_ITEM_INTERVAL, Integer.toString(600));
        this.setOption(TOPIC_READ_ON_SELECT_CHANGE_ACTIVATED, ID_NO);
        this.setOption(TOPIC_SELECTED_ITEM_TIMER_ACTIVATED, ID_NO);
        this.setOption(TOPIC_SELECTED_ITEM_TIMER_INTERVAL, Integer.toString(45));
        this.setOption(WORKSPACE_AUTO_REFRESH, ID_NO);
        this.setOption(WORKSPACE_CHANGE_SCOPE_FOLDER, ID_NO);
        this.setOption(WORKSPACE_CONFIRM_DELETE, ID_YES);
        this.setOption(WORKSPACE_CONFIRM_MOVE, ID_YES);
        this.setOption(WORKSPACE_FALCON, ID_YES);
        this.setOption(WORKSPACE_FOLDER_CONTEXT, ID_YES);
        this.setOption(WORKSPACE_HISTORY_UTC, ID_NO);
        this.setOption(WORKSPACE_INSTANT_REFRESH, ID_YES);
        this.setOption(WORKSPACE_INSTANT_REFRESH_MAX_TIME, Integer.toString(30));
        this.setOption(WORKSPACE_INSTANT_REFRESH_MIN_TIME, Integer.toString(5));
        this.setOption(WORKSPACE_LOG_COMMAND_DETAILS, ID_NO);
        this.setOption(WORKSPACE_LOG_COMMANDS, ID_NO);
        this.setOption(WORKSPACE_LOG_ERRORS, ID_YES);
        this.setOption(WORKSPACE_LOG_EVENTS, ID_NO);
        this.setOption(WORKSPACE_LOG_OUTPUT_PATH, EMPTY);
        this.setOption(WORKSPACE_LOG_THRESHOLD, Integer.toString(10));
        this.setOption(WORKSPACE_LOG_UI_OPERATIONS, ID_NO);
        this.setOption(WORKSPACE_MAINTAIN_GROUP_STATE, ID_YES);
        this.setOption(WORKSPACE_REFRESH_TIME, ID_NO);
        this.setOption(WORKSPACE_REPORT_OUTPUT_PATH, EMPTY);
        this.setOption(WORKSPACE_RESTORE_SHORTCUTS, ID_YES);
        this.setOption(WORKSPACE_SHOW_STATUSBAR, ID_YES);
        this.setOption(WORKSPACE_SHOW_TOOLBARS, ID_YES);
        this.setOption(WORKSPACE_SHOW_VIRTUAL_MEETING_OPTIONS, ID_NO);
        this.setOption(WORKSPACE_WARNINGS, ID_YES);
    }

    private static String getDefaultEOL() {
        String string = Platform.getEOL();
        if (string.equals("\r")) {
            return "CR";
        }
        if (string.equals("\r\n")) {
            return "CRLF";
        }
        if (string.equals("\n")) {
            return "LF";
        }
        return "CRLF";
    }

    public StarTeamClientOptions() {
        this.setDefaults();
        this.m_file = null;
    }
}

