/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.BinaryServerList;
import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.DuplicateServerListEntryException;
import com.starbase.starteam.IServerList;
import com.starbase.starteam.MPXClientSettings;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.XMLServerList;
import com.starbase.util.QuickSort;
import com.starbase.util.SortCompare;
import com.starbase.util.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class ServerList {
    private ServerInfo[] m_servers = new ServerInfo[0];
    private IServerList m_marshaller = new XMLServerList();

    public void removeAll() {
        int n = 0;
        while (n < this.m_servers.length) {
            this.m_servers[n].setOwner(null);
            ++n;
        }
        this.m_servers = new ServerInfo[0];
    }

    public void loadFrom(File file) throws IOException {
        IServerList iServerList = null;
        iServerList = XMLUtils.isXML(file) ? new XMLServerList() : new BinaryServerList();
        ServerInfo[] serverInfoArray = iServerList.load(file);
        int n = 0;
        while (n < serverInfoArray.length) {
            serverInfoArray[n].setOwner(this);
            ++n;
        }
        this.sort(serverInfoArray);
        this.m_servers = serverInfoArray;
        this.m_marshaller = iServerList;
        File file2 = ServerList.getStarTeamXML(file);
        if (file2.exists()) {
            MPXClientSettings mPXClientSettings = new MPXClientSettings();
            mPXClientSettings.loadFrom(file2);
            int n2 = 0;
            while (n2 < this.m_servers.length) {
                ServerInfo serverInfo = this.m_servers[n2];
                serverInfo.setMPXProfileName(mPXClientSettings.getProfileName(serverInfo));
                ++n2;
            }
        }
    }

    public static File getDefaultFile() throws IOException {
        return ConfigFiles.getServerList();
    }

    protected static File getStarTeamXML(File file) throws IOException {
        File file2 = ConfigFiles.getStarTeamXML();
        return new File(file.getParent(), file2.getName());
    }

    private void sort(ServerInfo[] serverInfoArray) {
        ServerList serverList = this;
        if (serverList == null) {
            throw null;
        }
        QuickSort.sortArray(serverInfoArray, new SortCompare(serverList){
            private final /* synthetic */ ServerList this$0;

            public int compare(Object object, Object object2) {
                ServerInfo serverInfo = (ServerInfo)object;
                ServerInfo serverInfo2 = (ServerInfo)object2;
                String string = serverInfo.getDescription().toLowerCase();
                String string2 = serverInfo2.getDescription().toLowerCase();
                return string.compareTo(string2);
            }
            {
                this.this$0 = serverList;
                this.constructor$0(serverList);
            }

            private final void constructor$0(ServerList serverList) {
            }
        });
    }

    public ServerInfo[] getSocketBasedServers() {
        Vector<ServerInfo> vector = new Vector<ServerInfo>();
        int n = 0;
        while (n < this.m_servers.length) {
            if (this.m_servers[n].m_connectionType == 6 || this.m_servers[n].m_connectionType == 7) {
                vector.addElement(this.m_servers[n]);
            }
            ++n;
        }
        ServerInfo[] serverInfoArray = new ServerInfo[vector.size()];
        n = 0;
        while (n < vector.size()) {
            serverInfoArray[n] = (ServerInfo)vector.elementAt(n);
            ++n;
        }
        return serverInfoArray;
    }

    public ServerInfo[] getServers() {
        return this.m_servers;
    }

    public void addServer(ServerInfo serverInfo) throws DuplicateServerListEntryException {
        if (this.descriptionExists(serverInfo.getDescription())) {
            throw new DuplicateServerListEntryException(Res.formatKey(ResIDs.DUPLICATE_SERVER_INFO_FMT, new Object[]{serverInfo.getDescription()}));
        }
        if (serverInfo.getOwner() != null) {
            throw new IllegalArgumentException(Res.getString(ResIDs.SERVER_INFO_OWNER));
        }
        ServerInfo[] serverInfoArray = new ServerInfo[this.m_servers.length + 1];
        System.arraycopy(this.m_servers, 0, serverInfoArray, 0, this.m_servers.length);
        serverInfoArray[serverInfoArray.length - 1] = serverInfo;
        this.m_servers = serverInfoArray;
        serverInfo.setOwner(this);
        this.sort(this.m_servers);
    }

    public void removeServer(ServerInfo serverInfo) {
        if (this.contains(serverInfo)) {
            ServerInfo[] serverInfoArray = new ServerInfo[this.m_servers.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < this.m_servers.length) {
                if (this.m_servers[n2] != serverInfo) {
                    serverInfoArray[n] = this.m_servers[n2];
                    ++n;
                }
                ++n2;
            }
            this.m_servers = serverInfoArray;
            serverInfo.setOwner(null);
        }
    }

    public boolean contains(ServerInfo serverInfo) {
        boolean bl = false;
        int n = 0;
        while (n < this.m_servers.length) {
            if (this.m_servers[n] == serverInfo) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public boolean descriptionExists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.m_servers.length) {
            if (this.m_servers[n].getDescription().equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public ServerInfo find(String string) {
        int n = 0;
        while (n < this.m_servers.length) {
            if (this.m_servers[n].getDescription().equalsIgnoreCase(string)) {
                return this.m_servers[n];
            }
            ++n;
        }
        return null;
    }

    public void saveTo(File file) throws IOException {
        this.m_marshaller.save(this.m_servers, file);
        File file2 = ServerList.getStarTeamXML(file);
        MPXClientSettings mPXClientSettings = new MPXClientSettings();
        if (file2.exists()) {
            mPXClientSettings.loadFrom(file2);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.m_servers.length) {
            ServerInfo serverInfo = this.m_servers[n];
            String string = mPXClientSettings.getProfileName(serverInfo);
            String string2 = serverInfo.getMPXProfileName();
            if (string2.length() != 0) {
                if (!string2.equals(string)) {
                    mPXClientSettings.setProfileName(serverInfo, string2);
                    bl = true;
                }
            } else if (string.length() != 0) {
                mPXClientSettings.removeProfile(serverInfo);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            mPXClientSettings.saveTo(file2);
        }
    }

    static void convert(File file, File file2) throws IOException {
        BinaryServerList binaryServerList = new BinaryServerList();
        XMLServerList xMLServerList = new XMLServerList();
        ServerInfo[] serverInfoArray = binaryServerList.load(file);
        xMLServerList.save(serverInfoArray, file2);
    }
}

