/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.DuplicateServerListEntryException;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerList;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ServerInfo {
    int m_connectionType;
    String m_host;
    String m_endpoint;
    String m_description;
    boolean m_compression;
    EncryptionAlgorithm m_encryption;
    private String m_MPXProfileName = "";
    String m_userName = "";
    boolean m_savePassword = false;
    boolean m_autoLogin = false;
    byte[] m_password = new byte[0];
    private ServerList m_owner = null;

    Server createServer() {
        if (this.m_connectionType != 6 && this.m_connectionType != 7) {
            throw new RuntimeException(Res.formatKey(ResIDs.PROTOCOL_NOT_SUPPORTED_FMT, new Object[]{new Integer(this.m_connectionType)}));
        }
        int n = 0;
        try {
            n = Integer.parseInt(this.m_endpoint);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SDKRuntimeException(Res.formatKey(ResIDs.INVALID_PORT_FMT, new Object[]{this.m_endpoint}), numberFormatException);
        }
        Server server = new Server(this.m_host, n, this.m_encryption, this.m_compression);
        return server;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) throws DuplicateServerListEntryException {
        if (this.m_owner != null && this.m_owner.descriptionExists(string)) {
            throw new DuplicateServerListEntryException(Res.formatKey(ResIDs.DUPLICATE_SERVER_INFO_FMT, new Object[]{string}));
        }
        this.m_description = string;
    }

    public ServerList getOwner() {
        return this.m_owner;
    }

    void setOwner(ServerList serverList) {
        this.m_owner = serverList;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    public String getEndpoint() {
        return this.m_endpoint;
    }

    public void setEndpoint(String string) {
        this.m_endpoint = string;
    }

    public EncryptionAlgorithm getEncryption() {
        return this.m_encryption;
    }

    public void setEncryption(EncryptionAlgorithm encryptionAlgorithm) {
        this.m_encryption = encryptionAlgorithm;
    }

    public boolean isCompression() {
        return this.m_compression;
    }

    public void setCompression(boolean bl) {
        this.m_compression = bl;
    }

    public int getConnectionType() {
        return this.m_connectionType;
    }

    public void setConnectionType(int n) {
        this.m_connectionType = n;
    }

    public String getMPXProfileName() {
        return this.m_MPXProfileName;
    }

    public void setMPXProfileName(String string) {
        if (string == null) {
            string = "";
        }
        this.m_MPXProfileName = string;
    }

    public String toString() {
        return this.getDescription();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" Description: " + this.getDescription() + string);
        stringBuffer.append(" Host: " + this.getHost() + string);
        stringBuffer.append(" MPXProfileName: " + this.getMPXProfileName() + string);
        stringBuffer.append(" Endpoint: " + this.getEndpoint() + string);
        stringBuffer.append(" ConnectionType: " + this.getConnectionType() + string);
        stringBuffer.append(" UserName: " + this.m_userName + string);
        stringBuffer.append(" Compression: " + this.isCompression() + string);
        stringBuffer.append(" Encryption: " + this.getEncryption() + string);
        stringBuffer.append(" SavePassword: " + this.m_savePassword + string);
        stringBuffer.append(" AutoLogin: " + this.m_autoLogin + string);
        try {
            stringBuffer.append(" Password: " + new String(this.m_password, "8859_1") + string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringBuffer.append(" Password.length=" + this.m_password.length + string);
        }
        return stringBuffer.toString();
    }

    static ServerInfo read(InputStream inputStream) throws IOException {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.readGuts(inputStream);
        return serverInfo;
    }

    void writeGuts(OutputStream outputStream) throws IOException {
        ServerInfo.writeInt(this.m_connectionType, outputStream);
        ServerInfo.writeString(this.m_host, outputStream);
        ServerInfo.writeString(this.m_endpoint, outputStream);
        ServerInfo.writeString(this.m_description, outputStream);
        ServerInfo.writeString(this.m_userName, outputStream);
        ServerInfo.writeInt(this.m_compression ? 1 : 0, outputStream);
        ServerInfo.writeInt(ServerInfo.codeForAlgorithm(this.m_encryption), outputStream);
        ServerInfo.writeInt(this.m_savePassword ? 1 : 0, outputStream);
        ServerInfo.writeInt(this.m_autoLogin ? 1 : 0, outputStream);
        if (this.m_savePassword) {
            outputStream.write(this.m_password.length);
            outputStream.write(this.m_password);
        }
    }

    private void readGuts(InputStream inputStream) throws IOException {
        this.m_connectionType = ServerInfo.readInt(inputStream);
        this.m_host = ServerInfo.readString(inputStream);
        this.m_endpoint = ServerInfo.readString(inputStream);
        this.m_description = ServerInfo.readString(inputStream);
        this.m_userName = ServerInfo.readString(inputStream);
        this.m_compression = ServerInfo.readInt(inputStream) != 0;
        this.m_encryption = ServerInfo.algorithmForCode(ServerInfo.readInt(inputStream));
        this.m_savePassword = ServerInfo.readInt(inputStream) != 0;
        this.m_autoLogin = ServerInfo.readInt(inputStream) != 0;
        this.m_password = new byte[0];
        if (this.m_savePassword) {
            int n = ServerInfo.readOrDie(inputStream) & 0xFF;
            this.m_password = new byte[n];
            ServerInfo.readBytes(inputStream, this.m_password);
        }
    }

    static EncryptionAlgorithm algorithmForCode(int n) {
        EncryptionAlgorithm encryptionAlgorithm;
        if (n == 0) {
            encryptionAlgorithm = EncryptionAlgorithm.NULL;
        } else if (n == 1) {
            encryptionAlgorithm = EncryptionAlgorithm.RC4;
        } else if (n == 2) {
            encryptionAlgorithm = EncryptionAlgorithm.RC2_ECB;
        } else if (n == 3) {
            encryptionAlgorithm = EncryptionAlgorithm.RC2_CBC;
        } else if (n == 4) {
            encryptionAlgorithm = EncryptionAlgorithm.RC2_CFB;
        } else {
            String string = "code=" + n;
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ENCRYPTION_FMT, new Object[]{string}));
        }
        return encryptionAlgorithm;
    }

    static int codeForAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        int n;
        if (encryptionAlgorithm == EncryptionAlgorithm.NULL) {
            n = 0;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
            n = 1;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
            n = 2;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
            n = 3;
        } else if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            n = 4;
        } else {
            String string = encryptionAlgorithm.toString();
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ENCRYPTION_FMT, new Object[]{string}));
        }
        return n;
    }

    static int readInt(InputStream inputStream) throws IOException {
        int n = (ServerInfo.readOrDie(inputStream) & 0xFF) + ((ServerInfo.readOrDie(inputStream) & 0xFF) << 8) + ((ServerInfo.readOrDie(inputStream) & 0xFF) << 16) + ((ServerInfo.readOrDie(inputStream) & 0xFF) << 24);
        return n;
    }

    static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write((n & 0xFF00) >> 8);
        outputStream.write((n & 0xFF0000) >> 16);
        outputStream.write((n & 0xFF000000) >> 24);
    }

    private static String readString(InputStream inputStream) throws IOException {
        int n = ServerInfo.readOrDie(inputStream) & 0xFF;
        byte[] byArray = new byte[n];
        ServerInfo.readBytes(inputStream, byArray);
        return new String(byArray);
    }

    private static void writeString(String string, OutputStream outputStream) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray.length & 0xFF);
        outputStream.write(byArray);
    }

    private static void readBytes(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(ServerInfo.readOrDie(inputStream) & 0xFF);
            ++n;
        }
    }

    private static int readOrDie(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private ServerInfo() {
        this.m_owner = null;
    }

    public ServerInfo(String string, int n, String string2, String string3, boolean bl, EncryptionAlgorithm encryptionAlgorithm) {
        this.m_connectionType = n;
        this.m_host = string2;
        this.m_endpoint = string3;
        this.m_description = string;
        this.m_compression = bl;
        this.m_encryption = encryptionAlgorithm;
    }
}

