/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.MergeSort;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;

abstract class PropertySortCollection
implements MergeSort.MergeSortCollection {
    private ItemList m_items;
    private GroupSortInfo m_info;
    private Property m_prop;
    private int m_len;
    protected boolean m_bAscending = true;

    public String getGroupName(int n) {
        return Res.formatKey(ResIDs.PROPERTY_DISPLAY_NAME_AND_VALUE_PAIR_FMT, new Object[]{this.m_prop.getDisplayName(), this.getValueDisplay(n)});
    }

    public boolean sameForGrouping(int n) {
        return this.compare(n, n - 1) == 0;
    }

    public int length() {
        return this.m_len;
    }

    public abstract void swap(int var1, int var2);

    public abstract void copySequence(int var1, int var2);

    public abstract void setFromScratchpad(int var1, int var2);

    public abstract void saveToScratchpad(int var1, int var2);

    public abstract int compareScratchpad(int var1, int var2);

    public abstract int compare(int var1, int var2);

    protected ItemList getItemList() {
        return this.m_items;
    }

    protected GroupSortInfo getGroupSortInfo() {
        return this.m_info;
    }

    protected Property getProperty() {
        return this.m_prop;
    }

    protected String getValueDisplay(int n) {
        Item item = this.m_items.getAt(n);
        return item.getDisplayValue(this.m_prop);
    }

    private PropertySortCollection() {
    }

    public PropertySortCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        this.m_items = itemList;
        this.m_info = groupSortInfo;
        this.m_prop = property;
        this.m_len = itemList.size();
    }
}

