/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Catalog;
import com.starbase.starteam.EnumeratedValue;
import com.starbase.starteam.Item;
import com.starbase.starteam.Property_Data;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.Translations;
import com.starbase.starteam.Type;
import com.starbase.starteam.names.NameUtils;
import com.starbase.starteam.vts.pickle.Enum;
import com.starbase.starteam.vts.pickle.PropertyInfo2;
import com.starbase.starteam.vts.pickle.TranslationCache;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import com.starbase.util.MD5;
import com.starbase.util.OLEDate;
import com.starbase.util.OLEDateFormat;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Property
extends CacheRef {
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String HEX_VALUES = "0123456789ABCDEF";
    private static final OLEDateFormat s_LOCAL_DATE_TIME_FORMAT = OLEDateFormat.getLocalDateTimeInstance();
    private static final OLEDateFormat s_LOCAL_DATE_FORMAT = OLEDateFormat.getLocalDateInstance();
    private static final Class[] PROPERTY_TYPE_CLASSES = new Class[12];
    private Type m_type = null;
    private Method m_clientMethod = null;
    private Property[] m_dependents = new Property[0];
    private static /* synthetic */ Class class$Ljava$lang$Void;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Lcom$starbase$util$OLEDate;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class array$B;
    private static /* synthetic */ Class array$I;

    Property_Data getData() {
        return (Property_Data)this.getCachedObject();
    }

    void refreshFrom(Property property) {
        if (this.getID() != property.getID()) {
            Assert.internalError("Property.refreshFrom(), getID()=" + this.getID() + ", newProp.getID()" + property.getID());
        }
        if (!this.getName().equals(property.getName())) {
            Assert.internalError("Property.refreshFrom(), getName()=" + this.getName() + ", newProp.getName()" + property.getName());
        }
        if (this.getTypeCode() != property.getTypeCode()) {
            Assert.internalError("Property.refreshFrom(), getTypeCode()=" + this.getTypeCode() + ", newProp.getTypeCode()" + property.getTypeCode());
        }
        if (this.getClassIDOfValue() != property.getClassIDOfValue()) {
            Assert.internalError("Property.refreshFrom(), getClassIDOfValue()=" + this.getClassIDOfValue() + ", newProp.getClassIDOfValue()" + property.getClassIDOfValue());
        }
        this.setCachedObject(property.getCachedObject());
    }

    PropertyInfo2 getRawImplementation() {
        return this.getData().getData();
    }

    public Type getType() {
        return this.m_type;
    }

    void setType(Type type) {
        this.m_type = type;
    }

    public String getEnumDisplayName(int n) {
        Enum enum_ = this.getEnumForCode(n);
        if (enum_ != null) {
            this.cacheOldTranslationsIfNeeded();
            return enum_.getDisplayName();
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ENUM_CODE_FMT, new Object[]{new Integer(n), this.getName()}));
    }

    public Translations getEnumTranslations(int n) {
        Enum enum_ = this.getEnumForCode(n);
        if (enum_ != null) {
            this.cacheTranslationsIfNeeded();
            enum_ = this.getEnumForCode(n);
            if (enum_ != null) {
                Translations translations = enum_.getTranslationCache().getTranslations();
                return translations == null ? null : translations.copy();
            }
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ENUM_CODE_FMT, new Object[]{new Integer(n), this.getName()}));
    }

    public boolean getEnumDisabled(int n) {
        Enum enum_ = this.getEnumForCode(n);
        if (enum_ != null) {
            return enum_.isDisabled();
        }
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ENUM_CODE_FMT, new Object[]{new Integer(n), this.getName()}));
    }

    Enum getEnumForCode(int n) {
        if (this.getTypeCode() == 2) {
            Enum[] enumArray = this.getData().getEnums();
            int n2 = enumArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Enum enum_ = enumArray[n3];
                if (n == enum_.m_code) {
                    return enum_;
                }
                ++n3;
            }
        } else {
            throw new RuntimeException(Res.formatKey(ResIDs.INVALID_ENUM_PROPERTY_FMT, new Object[]{this.getName()}));
        }
        return null;
    }

    public int[] getEnumValues() {
        if (this.getTypeCode() != 2) {
            throw new RuntimeException(Res.formatKey(ResIDs.INVALID_ENUM_PROPERTY_FMT, new Object[]{this.getName()}));
        }
        Enum[] enumArray = this.getData().getEnums();
        int n = enumArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = enumArray[n2].m_code;
            ++n2;
        }
        return nArray;
    }

    public EnumeratedValue[] getEnumeratedValues() {
        if (this.getTypeCode() != 2) {
            throw new RuntimeException(Res.formatKey(ResIDs.INVALID_ENUM_PROPERTY_FMT, new Object[]{this.getName()}));
        }
        this.cacheTranslationsIfNeeded();
        Enum[] enumArray = this.getData().getEnums();
        int n = enumArray.length;
        EnumeratedValue[] enumeratedValueArray = new EnumeratedValue[n];
        int n2 = 0;
        while (n2 < n) {
            Enum enum_ = enumArray[n2];
            Translations translations = enum_.getTranslationCache().getTranslations().copy();
            enumeratedValueArray[n2] = new EnumeratedValue(enum_.m_code, translations);
            enumeratedValueArray[n2].setEnabled(!enum_.isDisabled());
            ++n2;
        }
        return enumeratedValueArray;
    }

    public int getID() {
        return this.getData().getID();
    }

    public String getName() {
        return this.getData().getInternalName();
    }

    public String getDisplayName() {
        this.cacheOldTranslationsIfNeeded();
        return this.getData().getDisplayName();
    }

    boolean hasCachedTranslations() {
        return this.getData().getTranslations() != null;
    }

    private boolean serverHasCustomTranslations() {
        return this.getType().getServer().getSupportedFeatures().hasCustomTranslations();
    }

    private void cacheTranslationsIfNeeded() {
        if (this.serverHasCustomTranslations()) {
            this.getType().cacheTranslationsIfNeeded(this);
        } else {
            this.cacheOldTranslationsIfNeeded();
        }
    }

    private void cacheOldTranslationsIfNeeded() {
        if (!this.serverHasCustomTranslations()) {
            Enum[] enumArray;
            if (!this.hasCachedTranslations()) {
                enumArray = this.getData().getDisplayName();
                Translations translations = NameUtils.getLocalizedPropertyName(this, (String)enumArray);
                this.getData().getData().setTranslationCache(new TranslationCache(translations));
            }
            if (!this.isClientCalculated() && this.getTypeCode() == 2) {
                enumArray = this.getData().getEnums();
                int n = 0;
                while (n < enumArray.length) {
                    Enum enum_ = enumArray[n];
                    if (enum_.getTranslationCache().getTranslations() == null) {
                        int n2 = enum_.m_code;
                        String string = enum_.getTranslationCache().getFallBack();
                        Translations translations = NameUtils.getLocalizedEnumName(this, n2, string);
                        enum_.setTranslationCache(new TranslationCache(translations));
                    }
                    ++n;
                }
            }
        }
    }

    public Translations getTranslations() {
        if (this.isClientCalculated()) {
            return this.getData().getTranslations().copy();
        }
        this.cacheTranslationsIfNeeded();
        return this.getData().getTranslations().copy();
    }

    public int getTypeCode() {
        return this.getData().getType();
    }

    public int getClassIDOfValue() {
        return this.getData().getClassID();
    }

    public int getMaxLength() {
        return this.getData().getSize();
    }

    public Object getDefaultValue() {
        return this.getData().getDefault().getData();
    }

    public boolean isStored() {
        return this.getData().isStored();
    }

    public boolean isCalculated() {
        return this.getData().isCalculated();
    }

    public boolean isHeader() {
        return this.getData().isHeader();
    }

    public boolean isSysDefined() {
        return this.getData().isSysDefined();
    }

    public boolean isUserDefined() {
        return this.getData().isUserDefined();
    }

    public boolean isClientCalculated() {
        return this.getData().isClientCalculated();
    }

    public boolean isServerCalculated() {
        return this.getData().isServerCalculated();
    }

    public boolean isGenericCalculated() {
        return this.getData().isGenericCalculated();
    }

    public boolean isPrimaryDescriptor() {
        return this.getData().isPrimaryDescriptor();
    }

    public boolean isDescriptor() {
        return this.getData().isDescriptor();
    }

    public boolean isUserModifiable() {
        return this.getData().isUserModifiable();
    }

    public boolean isAdvanced() {
        return this.getData().isAdvanced();
    }

    public boolean isDisabled() {
        return this.getData().isDisabled();
    }

    public boolean isRestricted() {
        return this.getData().isRestricted();
    }

    public boolean isUserCustomized() {
        return this.getData().isUserCustomized();
    }

    public boolean isRequired() {
        return this.getData().isRequired();
    }

    public boolean isTimeTruncated() {
        return this.getData().isTimeTruncated();
    }

    public boolean isViewSpecific() {
        return this.getData().isViewSpecific();
    }

    public boolean isRevisionIndependent() {
        return this.getData().isRevisionIndependent();
    }

    public boolean isInstance(Object object) {
        return PROPERTY_TYPE_CLASSES[this.getTypeCode()].isInstance(object);
    }

    void setDependentProperties(Property[] propertyArray) {
        this.m_dependents = propertyArray == null ? new Property[0] : propertyArray;
    }

    public Property[] getDependentProperties() {
        Property[] propertyArray = new Property[this.m_dependents.length];
        System.arraycopy(this.m_dependents, 0, propertyArray, 0, this.m_dependents.length);
        return propertyArray;
    }

    public static Property[] resolveAllDependencies(Property[] propertyArray) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        Property.resolveDependencies(hashtable, vector, propertyArray);
        Object[] objectArray = new Property[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void resolveDependencies(Hashtable hashtable, Vector vector, Property[] propertyArray) {
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (hashtable.get(property) == null) {
                hashtable.put(property, property);
                vector.addElement(property);
                Property.resolveDependencies(hashtable, vector, property.m_dependents);
            }
            ++n;
        }
    }

    public Object coerce(Object object) throws ClassCastException {
        String string = this.getName();
        Class clazz = PROPERTY_TYPE_CLASSES[this.getTypeCode()];
        return Property.coerce(string, object, clazz);
    }

    static Object coerce(String string, Object object, Class clazz) throws ClassCastException {
        if (object == null) {
            Assert.nullArgument("Object");
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer")))) {
            if (object instanceof Byte) {
                return new Integer(((Byte)object).intValue());
            }
            if (object instanceof Short) {
                return new Integer(((Short)object).intValue());
            }
        } else if (clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = Property.class$("java.lang.Double")))) {
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue());
            }
        } else if (clazz == (class$Lcom$starbase$util$OLEDate != null ? class$Lcom$starbase$util$OLEDate : (class$Lcom$starbase$util$OLEDate = Property.class$("com.starbase.util.OLEDate")))) {
            if (object instanceof Date) {
                return new OLEDate((Date)object);
            }
        } else if (clazz == (array$B != null ? array$B : (array$B = Property.class$("[B")))) {
            if (object instanceof int[]) {
                return ByteOrder.intArrayToByteArray((int[])object);
            }
        } else if (clazz == (array$I != null ? array$I : (array$I = Property.class$("[I"))) && object instanceof byte[]) {
            return ByteOrder.byteArrayToIntArray((byte[])object);
        }
        throw new ClassCastException(Res.formatKey(ResIDs.PROPERTY_CANNOT_CONVERT_VALUE_OF_TYPE_FMT, new Object[]{string, object.getClass().getName(), clazz.getName()}));
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Property:");
        stringBuffer.append(string + "   id: " + this.getID());
        stringBuffer.append(string + "   name: " + this.getName());
        stringBuffer.append(string + "   display name: " + this.getDisplayName());
        stringBuffer.append(string + "   type: " + this.getTypeCode());
        stringBuffer.append(string + "   class ID: " + this.getClassIDOfValue());
        stringBuffer.append(string + "   default: " + this.getData().getDefault());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void setMethod(Method method) {
        this.m_clientMethod = method;
    }

    Object calculate(Item item) {
        if (this.m_clientMethod == null) {
            Assert.internalError("Property.calculate(), m_clientMethod=null");
        }
        Object object = null;
        try {
            try {
                object = this.m_clientMethod.invoke((Object)item, null);
                if (object instanceof MD5) {
                    return ((MD5)object).getData();
                }
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    return new Integer(bl ? 1 : 0);
                }
                return object;
            }
            catch (Throwable throwable) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.PROBLEM_TRYING_TO_COMPUTE_VALUE_FMT, new Object[]{this.getName()}), throwable);
            }
        }
        catch (Exception exception) {
            throw new SDKRuntimeException(Res.formatKey(ResIDs.PROBLEM_TRYING_TO_COMPUTE_VALUE_FMT, new Object[]{this.getName()}));
        }
    }

    public Property copy() {
        Property property = new Property(this.m_type, this.getData());
        property.m_clientMethod = this.m_clientMethod;
        property.m_dependents = this.getDependentProperties();
        return property;
    }

    public boolean isEqualTo(Property property) {
        if (property == null) {
            return false;
        }
        if (property.getType().getClassID() != this.getType().getClassID()) {
            return false;
        }
        this.getTranslations();
        property.getTranslations();
        if (!property.getData().isEqualTo(this.getData())) {
            return false;
        }
        if (property.m_dependents == null != (this.m_dependents == null)) {
            return false;
        }
        if (property.m_dependents.length != this.m_dependents.length) {
            return false;
        }
        int n = 0;
        while (n < property.m_dependents.length) {
            int n2 = property.m_dependents[n].getID();
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.m_dependents.length) {
                if (this.m_dependents[n3].getID() == n2) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    int getCacheIndex() {
        return this.getData().getCacheIndex();
    }

    void setCacheIndex(int n) {
        this.getData().setCacheIndex(n);
    }

    public static boolean areValuesEqual(Object object, Object object2) {
        if (object == null != (object2 == null)) {
            return false;
        }
        if (object == null) {
            return true;
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Property.areValuesEqual((int[])object, (int[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Property.areValuesEqual((byte[])object, (byte[])object2);
        }
        return object.equals(object2);
    }

    private static boolean areValuesEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean areValuesEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getDisplayValue(Object object) {
        object = this.coerce(object);
        Server server = this.getType().getServer();
        int n = this.getTypeCode();
        switch (n) {
            case 3: {
                int n2 = (Integer)object;
                String string = EMPTY_STRING;
                if (n2 != -1) {
                    String string2 = server.getTypeNames().USER;
                    string = server.typeForName(string2).getCatalog().getPrimaryDescriptor(n2).toString();
                }
                return string;
            }
            case 4: {
                int n3 = (Integer)object;
                if (n3 == -2 && this.getClassIDOfValue() == server.typeForName(server.getTypeNames().LABEL).getClassID()) {
                    return Res.getString(ResIDs.NEXT_BUILD);
                }
                String string = EMPTY_STRING;
                if (n3 != -1) {
                    Property property;
                    Type type = server.typeForClassID(this.getClassIDOfValue());
                    Catalog catalog = type.getCatalog();
                    if (!catalog.hasID(n3)) {
                        catalog.refreshIDs(new int[]{n3});
                    }
                    if ((property = this.getPrimaryDescriptor(type)) == null) {
                        Assert.internalError("Property.getDisplayValue(), primary=null, typecode=" + n);
                    } else {
                        Object object2 = catalog.getPrimaryDescriptor(n3);
                        return property.getDisplayValue(object2);
                    }
                }
                return string;
            }
            case 10: {
                int n4 = (Integer)object;
                String string = EMPTY_STRING;
                if (n4 != -1) {
                    String string3 = server.getTypeNames().VIEW;
                    string = server.typeForName(string3).getCatalog().getPrimaryDescriptor(n4).toString();
                }
                return string;
            }
            case 2: {
                int n5 = (Integer)object;
                return this.getEnumDisplayName(n5);
            }
            case 7: {
                OLEDate oLEDate = (OLEDate)object;
                if (oLEDate.getDoubleValue() != 0.0) {
                    if (this.isTimeTruncated()) {
                        return s_LOCAL_DATE_FORMAT.format(oLEDate);
                    }
                    return s_LOCAL_DATE_TIME_FORMAT.format(oLEDate);
                }
                return EMPTY_STRING;
            }
            case 9: {
                byte[] byArray = (byte[])object;
                StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
                stringBuffer.append(LEFT_SQUARE_BRACKET);
                int n6 = 0;
                while (n6 < byArray.length) {
                    if (n6 != 0) {
                        stringBuffer.append(SPACE);
                    }
                    this.appendHex(byArray[n6], stringBuffer);
                    ++n6;
                }
                stringBuffer.append(RIGHT_SQUARE_BRACKET);
                return stringBuffer.toString();
            }
            case 11: {
                int[] nArray = (int[])object;
                StringBuffer stringBuffer = new StringBuffer(nArray.length * 4);
                stringBuffer.append(LEFT_SQUARE_BRACKET);
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (n7 != 0) {
                        stringBuffer.append(SPACE);
                    }
                    stringBuffer.append(Integer.toString(nArray[n7]));
                    ++n7;
                }
                stringBuffer.append(RIGHT_SQUARE_BRACKET);
                return stringBuffer.toString();
            }
            case 8: {
                return object.toString();
            }
            case 1: 
            case 5: 
            case 6: {
                return MessageFormat.format("{0}", object);
            }
        }
        Assert.internalError("Property.getDisplayValue(), typecode=" + n);
        return null;
    }

    private void appendHex(byte by, StringBuffer stringBuffer) {
        int n = by & 0xFF;
        int n2 = n >> 4;
        int n3 = n & 0xF;
        stringBuffer.append(HEX_VALUES.charAt(n2));
        stringBuffer.append(HEX_VALUES.charAt(n3));
    }

    private Property getPrimaryDescriptor(Type type) {
        Property[] propertyArray = type.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (propertyArray[n].isPrimaryDescriptor()) {
                return propertyArray[n];
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Property(Type type, Property_Data property_Data) {
        super(property_Data);
        this.m_type = type;
    }

    Property(Type type, int n, int n2, String string, Translations translations, int n3, int n4, Variant variant, Enum[] enumArray) {
        super(null);
        this.m_type = type;
        PropertyInfo2 propertyInfo2 = new PropertyInfo2();
        propertyInfo2.m_ID = n;
        propertyInfo2.m_flags = n2;
        propertyInfo2.m_internalName = string;
        propertyInfo2.setTranslationCache(new TranslationCache(translations));
        propertyInfo2.m_eType = n3;
        propertyInfo2.m_classID = n4;
        propertyInfo2.m_default = variant;
        propertyInfo2.m_rawEnums = enumArray;
        propertyInfo2.m_nSize = 0;
        this.setCachedObject(new Property_Data(propertyInfo2));
    }

    static {
        Property.PROPERTY_TYPE_CLASSES[0] = class$Ljava$lang$Void != null ? class$Ljava$lang$Void : (class$Ljava$lang$Void = Property.class$("java.lang.Void"));
        Property.PROPERTY_TYPE_CLASSES[1] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[2] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[3] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[4] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[5] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[6] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = Property.class$("java.lang.Double"));
        Property.PROPERTY_TYPE_CLASSES[7] = class$Lcom$starbase$util$OLEDate != null ? class$Lcom$starbase$util$OLEDate : (class$Lcom$starbase$util$OLEDate = Property.class$("com.starbase.util.OLEDate"));
        Property.PROPERTY_TYPE_CLASSES[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Property.class$("java.lang.String"));
        Property.PROPERTY_TYPE_CLASSES[9] = array$B != null ? array$B : (array$B = Property.class$("[B"));
        Property.PROPERTY_TYPE_CLASSES[10] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Property.class$("java.lang.Integer"));
        Property.PROPERTY_TYPE_CLASSES[11] = array$I != null ? array$I : (array$I = Property.class$("[I"));
    }

    public static interface Types {
        public static final int UNKNOWN = 0;
        public static final int INT32 = 1;
        public static final int ENUMERATED = 2;
        public static final int USER_ID = 3;
        public static final int OBJECT_ID = 4;
        public static final int COMMENT_ID = 5;
        public static final int FLOAT64 = 6;
        public static final int TIME = 7;
        public static final int TEXT = 8;
        public static final int BINARY = 9;
        public static final int VIEW_ID = 10;
        public static final int IDARRAY = 11;
    }

    static interface MetadataFlags {
        public static final int HEADER = 65536;
        public static final int SYSTEM_DEFINED = 131072;
        public static final int USER_DEFINED = 262144;
        public static final int CALCULATED = 0x100000;
        public static final int CLIENT_CALCULATED = 0x300000;
        public static final int SERVER_CALCULATED = 0x500000;
        public static final int STORED = 0;
        public static final int COMPONENT_CALCULATED = 0x800000;
        public static final int PRIMARY_DESCRIPTOR = 0x1000000;
        public static final int DESCRIPTOR = 0x2000000;
        public static final int USER_MODIFIABLE = 0x4000000;
        public static final int ADVANCED = 0x8000000;
        public static final int TRUNCATED_TIME = 0x10000000;
        public static final int DISABLED = 0x20000000;
        public static final int RESTRICTED = 0x40000000;
        public static final int USER_CUSTOMIZED = Integer.MIN_VALUE;
        public static final int INPUT_REQUIRED = 256;
        public static final int VIEW_SPECIFIC = 512;
        public static final int REVISION_INDEPENDENT = 1024;
    }
}

