/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Project;
import com.starbase.starteam.Project_Cache;
import com.starbase.starteam.Server;
import com.starbase.starteam.Server_Cmd_GetProjects;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource_Data;
import java.util.Enumeration;
import java.util.Vector;

class Project_CacheRefCollection {
    protected Server m_server = null;
    protected Type m_type = null;
    protected Project_Cache m_cache = null;
    protected Object m_repository = null;
    protected Vector m_refs = new Vector();
    protected long m_timestampIDs = 0L;
    protected long m_timestampProperties = 0L;

    protected synchronized void populateProjects() {
        if (this.m_timestampIDs == 0L) {
            this.refreshDirtyProjects();
        }
    }

    public synchronized void populate() {
        this.populateProjects();
        this.populateProperties();
    }

    public synchronized boolean isRefreshRequired() {
        return this.isRefreshProjectsRequired() || this.isRefreshPropertiesRequired();
    }

    public synchronized void refresh() {
        this.refreshProjects();
        this.refreshProperties();
    }

    public synchronized Project[] toArray() {
        Vector vector = this.getRefs();
        int n = vector.size();
        Project[] projectArray = new Project[n];
        int n2 = 0;
        while (n2 < n) {
            projectArray[n2] = (Project)vector.elementAt(n2);
            ++n2;
        }
        return projectArray;
    }

    public synchronized void clear() {
        this.m_refs.removeAllElements();
        this.m_timestampIDs = 0L;
        this.m_timestampProperties = 0L;
    }

    public synchronized void discard() {
        Project_Cache project_Cache = this.getCache();
        Enumeration enumeration = this.getRefs().elements();
        while (enumeration.hasMoreElements()) {
            Project project = (Project)enumeration.nextElement();
            project_Cache.discard(project.getCachedObject().getID());
        }
        this.clear();
    }

    public Server getServer() {
        return this.m_server;
    }

    public Project_Cache getCache() {
        return this.m_cache;
    }

    public Vector getRefs() {
        return this.m_refs;
    }

    protected boolean isRefreshProjectsRequired() {
        return this.m_timestampIDs == 0L || !this.m_cache.isMPXAvailable() || this.m_cache.isRefreshIDsRequired(this.m_timestampIDs);
    }

    protected void refreshProjects() {
        if (this.isRefreshProjectsRequired()) {
            this.refreshDirtyProjects();
        }
    }

    private void refreshDirtyProjects() {
        long l;
        Server_Cmd_GetProjects.execute(this.m_server, this);
        this.m_timestampIDs = l = this.m_server.getServerCacheManager().getTimestamp();
        this.m_timestampProperties = 0L;
    }

    protected void updateProject(int n, String string) {
        int n2;
        TypedResource_Data typedResource_Data = (TypedResource_Data)this.m_cache.getCached(n);
        if (typedResource_Data != null && !typedResource_Data.get(n2 = typedResource_Data.indexForName(this.m_type.getServer().getPropertyNames().PROJECT_NAME)).equals(string)) {
            TypedResource_Data typedResource_Data2 = (TypedResource_Data)typedResource_Data.copy();
            typedResource_Data2.put(n2, string);
            this.m_cache.set(typedResource_Data2);
        }
    }

    protected void addProject(int n, String string) {
        Project project = this.newProject(n, string);
        this.m_refs.addElement(project);
        if (this.m_cache.getCached(n) == null) {
            TypedResource_Data typedResource_Data = project.getData();
            this.m_cache.set(typedResource_Data);
        }
    }

    protected void addProject(Project project) {
        this.m_refs.addElement(project);
        if (this.m_cache.getCached(project.getID()) == null) {
            TypedResource_Data typedResource_Data = project.getData();
            this.m_cache.set(typedResource_Data);
        }
    }

    protected Project newProject(int n, String string) {
        return new Project(this.m_server, string, n);
    }

    protected void populateProperties() {
        this.refreshProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isRefreshPropertiesRequired() {
        Project_Cache project_Cache;
        Project_Cache project_Cache2 = project_Cache = this.getCache();
        synchronized (project_Cache2) {
            if (!project_Cache.isMPXAvailable()) {
                return true;
            }
            long l = project_Cache.getLastModified();
            if (this.m_timestampProperties <= l) return project_Cache.isRefreshRequired(this.getRefs());
            return false;
        }
    }

    protected void refreshProperties() {
        Project_Cache project_Cache = this.m_cache;
        synchronized (project_Cache) {
            boolean bl = this.m_cache.isMPXAvailable();
            Vector vector = new Vector();
            if (bl && this.m_timestampProperties > this.m_cache.getLastModified()) {
                Object var2_4 = null;
                return;
            }
            Project_CacheRefCollection.copyInto(this.getRefs(), vector);
            this.m_cache.refresh(this.m_server, vector);
            if (bl) {
                this.m_timestampProperties = this.m_server.getServerCacheManager().getTimestamp();
            }
        }
    }

    static void copyInto(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
    }

    public Project_CacheRefCollection(Server server) {
        this.m_server = server;
        this.m_type = server.typeForName(server.getTypeNames().PROJECT);
        this.m_cache = this.m_server.getServerCacheManager().getProjectCache(server);
    }
}

