/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.PopulateMethods;
import com.starbase.starteam.Project;
import com.starbase.starteam.Property;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import java.util.Hashtable;
import java.util.Vector;

class PopulateMethods {
    private static final PopulateMethod ITEM = new 1();
    private static final PopulateMethod PROJECT = new 2();
    private static final PopulateMethod VIEW = new 3();

    protected static void populate(Server server, Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Object e = vector.elementAt(0);
            PopulateMethod populateMethod = PopulateMethods.methodFor(e);
            populateMethod.execute(server, vector, stringArray);
        }
    }

    private static PopulateMethod methodFor(Object object) {
        if (object == null) {
            Assert.internalError("PopulateMethods.methodFor(), object=null");
        }
        PopulateMethod populateMethod = null;
        if (object instanceof Project) {
            populateMethod = PROJECT;
        } else if (object instanceof View) {
            populateMethod = VIEW;
        } else if (object instanceof Item) {
            populateMethod = ITEM;
        }
        if (populateMethod == null) {
            Assert.internalError("PopulateMethods.methodFor(), method=null");
        }
        return populateMethod;
    }

    static Hashtable getPIDsToProperties(Type type, String[] stringArray) {
        Hashtable<Integer, Property> hashtable = new Hashtable<Integer, Property>(type.getPropertyCount() + 1);
        if (stringArray != null && stringArray.length > 0) {
            Property[] propertyArray = type.propertiesForNames(stringArray);
            propertyArray = Property.resolveAllDependencies(propertyArray);
            int n = 0;
            while (n < propertyArray.length) {
                if (!propertyArray[n].isClientCalculated()) {
                    hashtable.put(new Integer(propertyArray[n].getID()), propertyArray[n]);
                }
                ++n;
            }
        } else {
            Property[] propertyArray = type.getProperties();
            int n = 0;
            while (n < propertyArray.length) {
                Property property = propertyArray[n];
                if (!property.isClientCalculated()) {
                    hashtable.put(new Integer(property.getID()), property);
                }
                ++n;
            }
        }
        return hashtable;
    }

    PopulateMethods() {
    }

    private static interface PopulateMethod {
        public void execute(Server var1, Vector var2, String[] var3);
    }
}

