/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRefCollection;
import com.starbase.starteam.NamedCacheRef;
import com.starbase.starteam.ReferenceFactoryCache;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NamedCacheRefCollection
extends CacheRefCollection {
    private Hashtable m_nameHashedRefs = new Hashtable();
    private long m_nameHashtableTimestamp = 0L;

    public void clear() {
        super.clear();
        this.m_nameHashedRefs.clear();
        this.m_nameHashtableTimestamp = 0L;
    }

    public NamedCacheRef getByName(String string) {
        this.populate();
        if (this.m_nameHashtableTimestamp < this.getTimestamp()) {
            Vector vector = this.getRefs();
            this.m_nameHashedRefs = new Hashtable(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NamedCacheRef namedCacheRef = (NamedCacheRef)enumeration.nextElement();
                this.m_nameHashedRefs.put(namedCacheRef.getRefName(), namedCacheRef);
            }
            this.m_nameHashtableTimestamp = this.getTimestamp();
        }
        return (NamedCacheRef)this.m_nameHashedRefs.get(string);
    }

    public NamedCacheRefCollection(ReferenceFactoryCache referenceFactoryCache, Object object) {
        super(referenceFactoryCache, object);
    }

    NamedCacheRefCollection(NamedCacheRefCollection namedCacheRefCollection) {
        super(namedCacheRefCollection);
        this.m_nameHashedRefs = null;
        this.m_nameHashtableTimestamp = this.getTimestamp() - 1L;
    }
}

