/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.MPXEvent;
import com.starbase.starteam.MPXEventDispatcher;
import com.starbase.starteam.MPXFolderHierarchyEvent;
import com.starbase.starteam.MPXObjectEvent;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.TypeNames;
import java.util.Enumeration;
import java.util.Vector;

class MPXNewViewEventFilter
implements MPXEventDispatcher {
    private Server_CacheManager m_mgr = null;
    private final String TYPENAME_VIEW;
    private final String TYPENAME_FOLDER;
    private final String PROPNAME_VIEWID;
    private final String PROPNAME_FLAGS;
    private final String PROPNAME_ROOTFOLDER;
    private MPXEventDispatcher m_prev = null;
    private Vector m_sequences = new Vector();

    public void dispatchMPXEvent(MPXEvent mPXEvent) {
        if (mPXEvent instanceof MPXObjectEvent) {
            MPXObjectEvent mPXObjectEvent = (MPXObjectEvent)mPXEvent;
            String string = this.m_mgr.toTypeName(mPXObjectEvent.getClassID());
            if (this.TYPENAME_VIEW.equals(string)) {
                this.handleMPXViewEvent(mPXObjectEvent);
            } else if (this.TYPENAME_FOLDER.equals(string)) {
                this.handleMPXFolderEvent(mPXObjectEvent);
            } else {
                this.m_prev.dispatchMPXEvent(mPXEvent);
            }
        } else if (mPXEvent instanceof MPXFolderHierarchyEvent) {
            MPXFolderHierarchyEvent mPXFolderHierarchyEvent = (MPXFolderHierarchyEvent)mPXEvent;
            this.handleMPXFolderHierarchyEvent(mPXFolderHierarchyEvent);
        } else {
            this.m_prev.dispatchMPXEvent(mPXEvent);
        }
    }

    private void handleMPXViewEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            EventSequence eventSequence = this.newEventSequence();
            eventSequence.m_createViewEvent = mPXObjectEvent;
            this.checkSequence(eventSequence);
        } else if (string.equals("Modify")) {
            int n = mPXObjectEvent.getObjectID();
            EventSequence eventSequence = this.findEventSequenceForView(n);
            if (eventSequence != null) {
                int n2;
                eventSequence.m_createViewEvent.setProperties(mPXObjectEvent);
                this.checkSequence(eventSequence);
                if (eventSequence.m_createFolderEvent != null && eventSequence.m_folderHierarchyEvent == null && this.isBlankView(mPXObjectEvent) && (n2 = ((Integer)mPXObjectEvent.getValue(this.PROPNAME_ROOTFOLDER)).intValue()) != -1) {
                    MPXFolderHierarchyEvent mPXFolderHierarchyEvent = new MPXFolderHierarchyEvent(n2);
                    this.dispatchMPXEvent(mPXFolderHierarchyEvent);
                }
            } else {
                this.m_prev.dispatchMPXEvent(mPXObjectEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXObjectEvent);
        }
    }

    private boolean isBlankView(MPXObjectEvent mPXObjectEvent) {
        int n = (Integer)mPXObjectEvent.getValue(this.PROPNAME_FLAGS);
        if (n == 0) {
            return true;
        }
        return (n & 8) == 8;
    }

    private void handleMPXFolderEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            int n = (Integer)mPXObjectEvent.getValue(this.PROPNAME_VIEWID);
            EventSequence eventSequence = this.findEventSequenceForView(n);
            if (eventSequence != null) {
                eventSequence.m_createFolderEvent = mPXObjectEvent;
                this.checkSequence(eventSequence);
            } else {
                this.m_prev.dispatchMPXEvent(mPXObjectEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXObjectEvent);
        }
    }

    private void handleMPXFolderHierarchyEvent(MPXFolderHierarchyEvent mPXFolderHierarchyEvent) {
        String string = mPXFolderHierarchyEvent.getEventVerb();
        if (string.equals("Modify")) {
            int n = mPXFolderHierarchyEvent.getFolderID();
            EventSequence eventSequence = this.findEventSequenceForFolder(n);
            if (eventSequence != null) {
                mPXFolderHierarchyEvent.setIsCreateViewEvent();
                eventSequence.m_folderHierarchyEvent = mPXFolderHierarchyEvent;
                this.checkSequence(eventSequence);
            } else {
                this.m_prev.dispatchMPXEvent(mPXFolderHierarchyEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXFolderHierarchyEvent);
        }
    }

    private EventSequence newEventSequence() {
        MPXNewViewEventFilter mPXNewViewEventFilter = this;
        if (mPXNewViewEventFilter == null) {
            throw null;
        }
        EventSequence eventSequence = mPXNewViewEventFilter.new EventSequence();
        Vector vector = this.m_sequences;
        synchronized (vector) {
            this.m_sequences.addElement(eventSequence);
        }
        return eventSequence;
    }

    private EventSequence findEventSequenceForView(int n) {
        Vector vector = this.m_sequences;
        synchronized (vector) {
            Enumeration enumeration = this.m_sequences.elements();
            while (enumeration.hasMoreElements()) {
                EventSequence eventSequence = (EventSequence)enumeration.nextElement();
                if (eventSequence.m_createViewEvent == null || eventSequence.m_createViewEvent.getObjectID() != n) continue;
                EventSequence eventSequence2 = eventSequence;
                Object var3_7 = null;
                return eventSequence2;
            }
            EventSequence eventSequence = null;
            Object var3_8 = null;
            return eventSequence;
        }
    }

    private EventSequence findEventSequenceForFolder(int n) {
        if (n != -1) {
            Vector vector = this.m_sequences;
            synchronized (vector) {
                Enumeration enumeration = this.m_sequences.elements();
                while (enumeration.hasMoreElements()) {
                    EventSequence eventSequence = (EventSequence)enumeration.nextElement();
                    if (n != this.getRootFolderID(eventSequence)) continue;
                    EventSequence eventSequence2 = eventSequence;
                    Object var3_6 = null;
                    return eventSequence2;
                }
            }
        }
        return null;
    }

    private int getRootFolderID(EventSequence eventSequence) {
        Integer n;
        if (eventSequence.m_createViewEvent != null && (n = (Integer)eventSequence.m_createViewEvent.getValue(this.PROPNAME_ROOTFOLDER)) != null) {
            return n;
        }
        return -1;
    }

    private void checkSequence(EventSequence eventSequence) {
        if (this.getRootFolderID(eventSequence) == -1) {
            return;
        }
        if (eventSequence.m_createFolderEvent != null && eventSequence.m_folderHierarchyEvent == null) {
            return;
        }
        this.m_prev.dispatchMPXEvent(eventSequence.m_createViewEvent);
        if (eventSequence.m_createFolderEvent != null) {
            this.m_prev.dispatchMPXEvent(eventSequence.m_createFolderEvent);
        }
        if (eventSequence.m_folderHierarchyEvent != null) {
            this.m_prev.dispatchMPXEvent(eventSequence.m_folderHierarchyEvent);
        }
        this.removeEventSequence(eventSequence);
    }

    private void removeEventSequence(EventSequence eventSequence) {
        Vector vector = this.m_sequences;
        synchronized (vector) {
            this.m_sequences.removeElement(eventSequence);
        }
    }

    public MPXNewViewEventFilter(Server_CacheManager server_CacheManager, MPXEventDispatcher mPXEventDispatcher) {
        this.m_prev = mPXEventDispatcher;
        this.m_mgr = server_CacheManager;
        TypeNames typeNames = server_CacheManager.getTypeNames();
        PropertyNames propertyNames = server_CacheManager.getPropertyNames();
        this.TYPENAME_VIEW = "View";
        this.TYPENAME_FOLDER = "Folder";
        this.PROPNAME_VIEWID = propertyNames.VIEW_ID;
        this.PROPNAME_FLAGS = propertyNames.VIEW_FLAGS;
        this.PROPNAME_ROOTFOLDER = propertyNames.VIEW_ROOT_MEMBER_ID;
    }

    private class EventSequence {
        MPXObjectEvent m_createViewEvent = null;
        MPXObjectEvent m_createFolderEvent = null;
        MPXFolderHierarchyEvent m_folderHierarchyEvent = null;

        EventSequence() {
        }
    }
}

