/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemType_CacheManager;
import com.starbase.starteam.Item_Cache;
import com.starbase.starteam.Item_Cmd_GetVMIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

class Item_CacheRefCollection {
    protected Folder m_folder = null;
    protected Type m_type = null;
    protected ItemType_CacheManager m_mgr = null;
    protected Vector m_refs = new Vector();
    protected long m_timestampIDs = 0L;
    protected boolean m_bRepopulateIDs = false;
    protected long m_timestampProperties = 0L;
    protected boolean m_bRepopulateProperties = false;
    protected BitSet m_prevBits = null;

    public boolean isPopulated() {
        return !(this.m_timestampIDs == 0L || this.m_bRepopulateIDs);
    }

    protected synchronized void populateItems() {
        if (this.m_timestampIDs == 0L || this.m_bRepopulateIDs && this.isRefreshItemsRequired()) {
            Vector<Item_CacheRefCollection> vector = new Vector<Item_CacheRefCollection>();
            vector.addElement(this);
            Item_CacheRefCollection.refreshDirtyItems(vector);
        }
        this.m_bRepopulateIDs = false;
    }

    protected static void populateItems(Vector vector) {
        Vector<Item_CacheRefCollection> vector2 = new Vector<Item_CacheRefCollection>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            if (item_CacheRefCollection.m_timestampIDs == 0L || item_CacheRefCollection.m_bRepopulateIDs && item_CacheRefCollection.isRefreshItemsRequired()) {
                vector2.addElement(item_CacheRefCollection);
            }
            item_CacheRefCollection.m_bRepopulateIDs = false;
        }
        Item_CacheRefCollection.refreshDirtyItems(vector2);
    }

    public synchronized void populate(String[] stringArray) {
        Vector<Item_CacheRefCollection> vector = new Vector<Item_CacheRefCollection>();
        vector.addElement(this);
        Item_CacheRefCollection.populate(vector, stringArray);
    }

    public static void populate(Vector vector, String[] stringArray) {
        if (vector != null && vector.size() > 0) {
            Item_CacheRefCollection.populateItems(vector);
            Item_CacheRefCollection.populateProperties(vector, stringArray);
        }
    }

    public synchronized boolean isRefreshRequired(String[] stringArray) {
        return this.isRefreshItemsRequired() || this.isRefreshPropertiesRequired(stringArray);
    }

    public static boolean isRefreshRequired(Vector vector, String[] stringArray) {
        if (vector != null && vector.size() > 0) {
            return Item_CacheRefCollection.isRefreshItemsRequired(vector) || Item_CacheRefCollection.isRefreshPropertiesRequired(vector, stringArray);
        }
        return false;
    }

    public synchronized void refresh(String[] stringArray) {
        Vector<Item_CacheRefCollection> vector = new Vector<Item_CacheRefCollection>();
        vector.addElement(this);
        Item_CacheRefCollection.refresh(vector, stringArray);
    }

    public static void refresh(Vector vector, String[] stringArray) {
        if (vector != null && vector.size() > 0) {
            Item_CacheRefCollection.refreshItems(vector);
            Item_CacheRefCollection.refreshProperties(vector, stringArray);
        }
    }

    public synchronized Item[] toArray() {
        Vector vector = this.getRefs();
        int n = vector.size();
        Item[] itemArray = new Item[n];
        int n2 = 0;
        while (n2 < n) {
            itemArray[n2] = (Item)vector.elementAt(n2);
            ++n2;
        }
        return itemArray;
    }

    public synchronized void clear() {
        this.m_refs.removeAllElements();
        this.m_timestampIDs = 0L;
        this.m_timestampProperties = 0L;
        this.m_bRepopulateIDs = false;
        this.m_bRepopulateProperties = false;
        this.m_prevBits = null;
    }

    public static void clear(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            item_CacheRefCollection.clear();
        }
    }

    public synchronized void discard() {
        this.m_mgr.setRefreshItemListRequired(this.getFolder());
        Item_Cache item_Cache = this.m_mgr.getItemCache();
        Enumeration enumeration = this.getRefs().elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            item_Cache.discard(item.getCachedObject().getID());
        }
        this.clear();
    }

    public static void discard(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            item_CacheRefCollection.discard();
        }
    }

    public void setRepopulateRequired() {
        this.m_bRepopulateIDs = true;
        this.m_bRepopulateProperties = true;
    }

    public static void setRepopulateRequired(Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            item_CacheRefCollection.setRepopulateRequired();
        }
    }

    public Type getType() {
        return this.m_type;
    }

    public Folder getFolder() {
        return this.m_folder;
    }

    public Vector getRefs() {
        return this.m_refs;
    }

    protected boolean isRefreshItemsRequired() {
        return this.m_mgr.isRefreshItemListRequired(this.m_folder, this.m_timestampIDs);
    }

    protected static boolean isRefreshItemsRequired(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            if (!item_CacheRefCollection.isRefreshItemsRequired()) continue;
            return true;
        }
        return false;
    }

    protected static void refreshItems(Vector vector) {
        Vector<Item_CacheRefCollection> vector2 = new Vector<Item_CacheRefCollection>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            if (item_CacheRefCollection.isRefreshItemsRequired()) {
                vector2.addElement(item_CacheRefCollection);
            }
            item_CacheRefCollection.m_bRepopulateIDs = false;
        }
        Item_CacheRefCollection.refreshDirtyItems(vector2);
    }

    private static void refreshDirtyItems(Vector vector) {
        if (vector.size() > 0) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)vector.elementAt(0);
            Folder folder = item_CacheRefCollection.getFolder();
            Server server = folder.getServer();
            View view = folder.getView();
            String string = item_CacheRefCollection.getType().getName();
            Item_Cmd_GetVMIDs.execute(server, view, string, vector);
            long l = item_CacheRefCollection.m_mgr.getServerCacheManager().getTimestamp();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Item_CacheRefCollection item_CacheRefCollection2 = (Item_CacheRefCollection)enumeration.nextElement();
                item_CacheRefCollection2.m_timestampIDs = l;
                item_CacheRefCollection2.m_timestampProperties = 0L;
            }
            view.clearItemsForType(string);
        }
    }

    protected void addItem(int n) {
        this.m_refs.addElement(this.newItem(n));
    }

    protected Item newItem(int n) {
        Item item = this.m_folder.getServer().newItem(this.m_type, this.m_folder.getView());
        item.setItemID(n);
        item.setParentFolder(this.m_folder);
        return item;
    }

    protected static void populateProperties(Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Object object;
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)vector.elementAt(0);
            View view = item_CacheRefCollection.getFolder().getView();
            Item_Cache item_Cache = item_CacheRefCollection.m_mgr.getItemCache();
            Vector vector2 = new Vector();
            Vector<Object> vector3 = new Vector<Object>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Item_CacheRefCollection)enumeration.nextElement();
                if (!((Item_CacheRefCollection)object).m_bRepopulateProperties) {
                    Item_CacheRefCollection.copyInto(((Item_CacheRefCollection)object).getRefs(), vector2);
                } else {
                    vector3.addElement(object);
                }
                ((Item_CacheRefCollection)object).m_bRepopulateProperties = false;
            }
            object = item_Cache.getBitsForPropertyNames(item_CacheRefCollection.getType(), stringArray);
            item_Cache.populate(view, vector2, (BitSet)object);
            Item_CacheRefCollection.refreshProperties(vector3, stringArray);
        }
    }

    protected boolean isRefreshPropertiesRequired(String[] stringArray) {
        Vector<Item_CacheRefCollection> vector = new Vector<Item_CacheRefCollection>();
        vector.addElement(this);
        return Item_CacheRefCollection.isRefreshPropertiesRequired(vector, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isRefreshPropertiesRequired(Vector vector, String[] stringArray) {
        Item_Cache item_Cache;
        if (vector.size() <= 0) return false;
        Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)vector.elementAt(0);
        Item_Cache item_Cache2 = item_Cache = item_CacheRefCollection.m_mgr.getItemCache();
        synchronized (item_Cache2) {
            if (!item_Cache.isMPXAvailable()) {
                return true;
            }
            BitSet bitSet = item_Cache.getBitsForPropertyNames(item_CacheRefCollection.getType(), stringArray);
            long l = item_Cache.getLastModified();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Item_CacheRefCollection item_CacheRefCollection2 = (Item_CacheRefCollection)enumeration.nextElement();
                if (item_CacheRefCollection2.m_timestampProperties > l && item_Cache.isSubsetOf(bitSet, item_CacheRefCollection2.m_prevBits) || !item_Cache.isRefreshRequired(item_CacheRefCollection2.getRefs(), bitSet)) continue;
                return true;
            }
            return false;
        }
    }

    protected static void refreshProperties(Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Item_Cache item_Cache;
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)vector.elementAt(0);
            Item_Cache item_Cache2 = item_Cache = item_CacheRefCollection.m_mgr.getItemCache();
            synchronized (item_Cache2) {
                Object object;
                boolean bl = item_Cache.isMPXAvailable();
                Vector vector2 = new Vector();
                BitSet bitSet = item_Cache.getBitsForPropertyNames(item_CacheRefCollection.getType(), stringArray);
                long l = item_Cache.getLastModified();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Item_CacheRefCollection)enumeration.nextElement();
                    ((Item_CacheRefCollection)object).m_bRepopulateProperties = false;
                    if (bl && ((Item_CacheRefCollection)object).m_timestampProperties > l && item_Cache.isSubsetOf(bitSet, ((Item_CacheRefCollection)object).m_prevBits)) continue;
                    Item_CacheRefCollection.copyInto(((Item_CacheRefCollection)object).getRefs(), vector2);
                }
                if (vector2.size() > 0) {
                    object = item_CacheRefCollection.getFolder().getView();
                    item_Cache.refresh((View)object, vector2, bitSet);
                    if (bl) {
                        l = item_CacheRefCollection.m_mgr.getServerCacheManager().getTimestamp();
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Item_CacheRefCollection item_CacheRefCollection2 = (Item_CacheRefCollection)enumeration.nextElement();
                            if (item_CacheRefCollection2.m_prevBits == null) {
                                item_CacheRefCollection2.m_prevBits = bitSet;
                            } else {
                                item_CacheRefCollection2.m_prevBits.or(bitSet);
                            }
                            item_CacheRefCollection2.m_timestampProperties = l;
                        }
                    }
                }
            }
        }
    }

    static void copyInto(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
    }

    public Item_CacheRefCollection(Folder folder, Type type) {
        this.m_folder = folder;
        this.m_type = type;
        this.m_mgr = folder.getView().getViewConfigCacheManager().getItemTypeCacheManager(type);
    }
}

