/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemType_CacheManager;
import com.starbase.starteam.Item_Cmd_GetData;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.MPXEventQueue;
import com.starbase.starteam.MPXItemEvent;
import com.starbase.starteam.MPXItemEvent_Marshaler;
import com.starbase.starteam.MPXItemEvent_Source;
import com.starbase.starteam.MPXObjectEvent;
import com.starbase.starteam.MPXPropertiesEvent;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.Type;
import com.starbase.starteam.Type_Data;
import com.starbase.starteam.TypedResource_Cache;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration_CacheManager;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Item_Cache
extends TypedResource_Cache
implements MPXItemEvent_Source {
    protected ItemType_CacheManager m_mgr = null;
    protected PropertyNames m_propertyNames = null;
    protected int m_nCacheableProperties = -1;
    protected String REVISION_NUMBER = null;
    protected int OBJECT_ID_INDEX = -1;
    protected int REVISION_NUMBER_INDEX = -1;
    protected int CONFIGURATION_TIME_INDEX = -1;
    protected Hashtable m_ObjectIDsToItemIDs = new Hashtable();
    protected Hashtable m_PropertyNamesToBitSets = new Hashtable();
    protected Hashtable m_PidToIsRevisionIndependent = new Hashtable();
    Vector m_MPXItemEventMarshalers = new Vector();

    public synchronized void populate(View view, Vector vector, BitSet bitSet) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Item)enumeration.nextElement();
            Item_Data item_Data = (Item_Data)((Item)object).getCachedObject();
            if (item_Data.hasValues(bitSet)) continue;
            vector2.addElement(object);
        }
        if (vector2.size() > 0) {
            Item_Cache item_Cache = this;
            if (item_Cache == null) {
                throw null;
            }
            object = item_Cache.new Repository(view, bitSet, false);
            this.internalRefresh(object, vector2);
        }
    }

    public void populate(View view, Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Item item = (Item)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(item.getType(), stringArray);
            this.populate(view, vector, bitSet);
        }
    }

    public synchronized boolean isRefreshRequired(Vector vector, BitSet bitSet) {
        if (!this.isMPXAvailable()) {
            return true;
        }
        return this.checkRefresh(vector, bitSet, null);
    }

    public boolean isRefreshRequired(Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Item item = (Item)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(item.getType(), stringArray);
            return this.isRefreshRequired(vector, bitSet);
        }
        return false;
    }

    public synchronized void refresh(View view, Vector vector, BitSet bitSet) {
        Vector vector2 = null;
        if (!this.isMPXAvailable()) {
            vector2 = vector;
        } else {
            vector2 = new Vector();
            if (!this.checkRefresh(vector, bitSet, vector2)) {
                return;
            }
        }
        Item_Cache item_Cache = this;
        if (item_Cache == null) {
            throw null;
        }
        Repository repository = item_Cache.new Repository(view, bitSet, true);
        this.internalRefresh(repository, vector2);
    }

    public void refresh(View view, Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Item item = (Item)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(item.getType(), stringArray);
            this.refresh(view, vector, bitSet);
        }
    }

    public Server_CacheManager getServerCacheManager() {
        return this.m_mgr.getServerCacheManager();
    }

    public ViewConfiguration_CacheManager getViewConfigCacheManager() {
        return this.m_mgr.getViewConfigCacheManager();
    }

    public PropertyNames getPropertyNames() {
        if (this.m_propertyNames == null) {
            this.m_propertyNames = this.getServerCacheManager().getPropertyNames();
        }
        return this.m_propertyNames;
    }

    public boolean checkRefresh(Vector vector, BitSet bitSet, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            Item_Data item_Data = (Item_Data)item.getCachedObject();
            if (!item_Data.isDirty() && item_Data.hasValues(bitSet)) continue;
            if (vector2 == null) {
                return true;
            }
            vector2.addElement(item);
        }
        return vector2 != null && vector2.size() > 0;
    }

    protected boolean isFetchRequired(Cacheable cacheable, Object object) {
        Repository repository = (Repository)object;
        if (!repository.isRefresh()) {
            return true;
        }
        if (super.isFetchRequired(cacheable, repository)) {
            return true;
        }
        Item_Data item_Data = (Item_Data)cacheable;
        BitSet bitSet = repository.getBits();
        return !item_Data.hasValues(bitSet);
    }

    protected synchronized Cacheable set(Cacheable cacheable) {
        Item_Data item_Data = (Item_Data)cacheable;
        Item_Data item_Data2 = null;
        if (cacheable != null) {
            Integer n = new Integer(item_Data.getID());
            item_Data2 = (Item_Data)this.m_contents.get(n);
            boolean bl = false;
            boolean bl2 = false;
            if (item_Data2 != null) {
                int n2 = item_Data.size();
                boolean bl3 = this.isMPXAvailable();
                int n3 = 0;
                while (n3 < n2) {
                    if (item_Data.hasValue(n3)) {
                        if (item_Data2.hasValue(n3)) {
                            Object object;
                            Object object2 = item_Data.get(n3);
                            if (!object2.equals(object = item_Data2.get(n3))) {
                                bl = true;
                                bl2 = true;
                            }
                        } else {
                            bl = true;
                            if (!bl3) {
                                bl2 = true;
                            }
                        }
                    } else if (item_Data2.hasValue(n3)) {
                        if (bl3) {
                            item_Data.put(n3, item_Data2.get(n3));
                        } else {
                            bl = true;
                            bl2 = true;
                        }
                    }
                    ++n3;
                }
            } else {
                bl = true;
            }
            if (bl2) {
                item_Data2.setDirty(true);
                this.removeItemIDForObjectID(item_Data2);
            }
            if (bl) {
                this.m_contents.put(n, item_Data);
                this.setModified();
                item_Data.setDirty(false);
                this.addItemIDForObjectID(item_Data);
                item_Data2 = item_Data;
            } else if (item_Data2 != null) {
                item_Data2.setDirty(false);
            }
        }
        return item_Data2;
    }

    protected Cacheable[] fetch(Object object, int[] nArray) {
        Repository repository = (Repository)object;
        View view = repository.getView();
        Server server = view.getServer();
        Type type = server.typeForName(this.getTypeName());
        BitSet bitSet = repository.getBits();
        return Item_Cmd_GetData.fetch(view, type, nArray, bitSet);
    }

    protected synchronized void discard(int n) {
        Item_Data item_Data = (Item_Data)this.getCached(n);
        if (item_Data != null) {
            this.removeItemIDForObjectID(item_Data);
            super.discard(n);
        }
    }

    protected synchronized void discardAll() {
        super.discardAll();
        this.m_ObjectIDsToItemIDs.clear();
    }

    BitSet getBitsForPropertyNames(Type type, String[] stringArray) {
        this.refreshTypeInfo(type);
        return this.getBitsForPropertyNames(stringArray);
    }

    private void refreshTypeInfo(Type type) {
        int n;
        if (type.getClassID() != this.getTypeData().getID()) {
            Assert.internalError("Item_Cache.refreshTypeInfo(), typeClassID=" + type.getClassID() + ", getTypeData().getID()=" + this.getTypeData().getID());
        }
        if (this.m_nCacheableProperties != (n = type.getCacheablePropertyCount())) {
            this.m_nCacheableProperties = n;
            Property[] propertyArray = type.getProperties();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                Property property = propertyArray[n2];
                this.m_PidToIsRevisionIndependent.put(new Integer(property.getID()), new Boolean(property.isRevisionIndependent()));
                BitSet bitSet = new BitSet(this.m_nCacheableProperties);
                this.setBitsForProperty(bitSet, property);
                this.m_PropertyNamesToBitSets.put(property.getName(), bitSet);
                ++n2;
            }
            PropertyNames propertyNames = this.getPropertyNames();
            this.REVISION_NUMBER = propertyNames.REVISION_NUMBER;
            this.OBJECT_ID_INDEX = type.indexForName(propertyNames.OBJECT_ID);
            this.REVISION_NUMBER_INDEX = type.indexForName(propertyNames.REVISION_NUMBER);
            this.CONFIGURATION_TIME_INDEX = type.indexForName(propertyNames.CONFIGURATION_TIME);
        }
    }

    private BitSet getBitsForPropertyNames(String[] stringArray) {
        BitSet bitSet = new BitSet(this.m_nCacheableProperties);
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                BitSet bitSet2 = (BitSet)this.m_PropertyNamesToBitSets.get(stringArray[n]);
                if (bitSet2 != null) {
                    bitSet.or(bitSet2);
                }
                ++n;
            }
            bitSet.set(this.OBJECT_ID_INDEX);
            if (this.REVISION_NUMBER_INDEX >= 0) {
                bitSet.set(this.REVISION_NUMBER_INDEX);
            }
            if (this.CONFIGURATION_TIME_INDEX >= 0) {
                bitSet.set(this.CONFIGURATION_TIME_INDEX);
            }
        } else {
            int n = 0;
            while (n < this.m_nCacheableProperties) {
                bitSet.set(n);
                ++n;
            }
        }
        return bitSet;
    }

    private void setBitsForProperty(BitSet bitSet, Property property) {
        if (!property.isClientCalculated()) {
            int n = property.getCacheIndex();
            if (n >= 0) {
                bitSet.set(n);
            }
        } else {
            Property[] propertyArray = property.getDependentProperties();
            int n = 0;
            while (n < propertyArray.length) {
                this.setBitsForProperty(bitSet, propertyArray[n]);
                ++n;
            }
        }
    }

    boolean isSubsetOf(BitSet bitSet, BitSet bitSet2) {
        if (bitSet2 != null) {
            int n = 0;
            while (n < this.m_nCacheableProperties) {
                if (bitSet.get(n) && !bitSet2.get(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return bitSet == null;
    }

    protected int[] getItemIDsForObjectID(int n) {
        return (int[])this.m_ObjectIDsToItemIDs.get(new Integer(n));
    }

    private void addItemIDForObjectID(Item_Data item_Data) {
        if (item_Data != null) {
            this.addItemIDForObjectID(this.getItemID(item_Data), this.getObjectID(item_Data));
        }
    }

    private synchronized void addItemIDForObjectID(int n, int n2) {
        int[] nArray;
        int n3;
        if (n2 != -1 && (n3 = Item_Cache.findItemID(n, nArray = this.getItemIDsForObjectID(n2))) < 0) {
            int[] nArray2 = null;
            if (nArray != null) {
                nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray.length] = n;
            } else {
                nArray2 = new int[]{n};
            }
            this.m_ObjectIDsToItemIDs.put(new Integer(n2), nArray2);
        }
    }

    private void removeItemIDForObjectID(Item_Data item_Data) {
        if (item_Data != null) {
            this.removeItemIDForObjectID(this.getItemID(item_Data), this.getObjectID(item_Data));
        }
    }

    private synchronized void removeItemIDForObjectID(int n, int n2) {
        int[] nArray = this.getItemIDsForObjectID(n2);
        int n3 = Item_Cache.findItemID(n, nArray);
        if (n3 >= 0) {
            if (nArray.length > 1) {
                int[] nArray2 = new int[nArray.length - 1];
                System.arraycopy(nArray, 0, nArray2, 0, n3);
                System.arraycopy(nArray, n3 + 1, nArray2, n3, nArray.length - n3 - 1);
                this.m_ObjectIDsToItemIDs.put(new Integer(n2), nArray2);
            } else {
                this.m_ObjectIDsToItemIDs.remove(new Integer(n2));
            }
        }
    }

    private static int findItemID(int n, int[] nArray) {
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    int getItemID(Item_Data item_Data) {
        return item_Data.getID();
    }

    int getObjectID(Item_Data item_Data) {
        Integer n = (Integer)item_Data.get(this.OBJECT_ID_INDEX);
        if (n != null) {
            return n;
        }
        return -1;
    }

    OLEDate getConfigurationTime(Item_Data item_Data) {
        if (this.CONFIGURATION_TIME_INDEX < 0) {
            Assert.internalError("Item_Cache.getConfigurationTime(), CONFIGURATION_TIME_INDE=" + this.CONFIGURATION_TIME_INDEX);
        }
        return (OLEDate)item_Data.get(this.CONFIGURATION_TIME_INDEX);
    }

    int getRevisionNumber(Item_Data item_Data) {
        Integer n = (Integer)item_Data.get(this.REVISION_NUMBER_INDEX);
        if (n != null) {
            return n;
        }
        return -1;
    }

    int getRevisionNumber(MPXPropertiesEvent mPXPropertiesEvent) {
        Integer n = (Integer)mPXPropertiesEvent.getValue(this.REVISION_NUMBER);
        if (n != null) {
            return n;
        }
        return -1;
    }

    protected int[] fetchAllIDs(Object object) {
        Assert.internalError("Item_Cache.fetchAllIDs()");
        return null;
    }

    protected CacheRef newCacheRef(Object object, Cacheable cacheable) {
        Assert.internalError("Item_Cache.newCacheRef()");
        return null;
    }

    synchronized void handleMPXObjectEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            this.OnObjectAdded(mPXObjectEvent);
        } else if (string.equals("Modify")) {
            this.OnObjectChanged(mPXObjectEvent);
        } else if (string.equals("ModifyRevision")) {
            this.OnObjectRevisionChanged(mPXObjectEvent);
        } else {
            this.setObjectDirty(mPXObjectEvent.getObjectID());
        }
    }

    protected void OnObjectAdded(MPXObjectEvent mPXObjectEvent) {
    }

    protected void OnObjectChanged(MPXObjectEvent mPXObjectEvent) {
        block11: {
            int n = mPXObjectEvent.getObjectID();
            if (this.CONFIGURATION_TIME_INDEX < 0) {
                this.setAllItemsDirty(n);
                return;
            }
            try {
                try {
                    int[] nArray = this.getItemIDsForObjectID(n);
                    if (nArray == null || nArray.length <= 0) break block11;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        try {
                            try {
                                int n4;
                                Item_Data item_Data = (Item_Data)this.getCached(n3);
                                if (item_Data != null && (n4 = this.getObjectID(item_Data)) == n) {
                                    OLEDate oLEDate = this.getConfigurationTime(item_Data);
                                    boolean bl = oLEDate == null || oLEDate.getDoubleValue() == 0.0;
                                    boolean bl2 = !bl;
                                    this.updateCachedProperties(n3, mPXObjectEvent, bl2);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                this.setItemDirty(n3);
                            }
                        }
                        catch (Exception exception) {
                            this.setItemDirty(n3);
                        }
                        ++n2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.setAllItemsDirty(n);
                }
            }
            catch (Exception exception) {
                this.setAllItemsDirty(n);
            }
        }
    }

    protected void OnObjectRevisionChanged(MPXObjectEvent mPXObjectEvent) {
        block11: {
            int n = mPXObjectEvent.getObjectID();
            try {
                try {
                    int[] nArray = this.getItemIDsForObjectID(n);
                    if (nArray == null || nArray.length <= 0) break block11;
                    int n2 = this.getRevisionNumber(mPXObjectEvent);
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        int n4 = nArray[n3];
                        try {
                            try {
                                Item_Data item_Data = (Item_Data)this.getCached(n4);
                                if (item_Data != null) {
                                    int n5 = this.getObjectID(item_Data);
                                    int n6 = this.getRevisionNumber(item_Data);
                                    if (n5 == n && n6 == n2) {
                                        this.updateCachedProperties(n4, mPXObjectEvent, false);
                                    }
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                this.setItemDirty(n4);
                            }
                        }
                        catch (Exception exception) {
                            this.setItemDirty(n4);
                        }
                        ++n3;
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.setAllItemsDirty(n);
                }
            }
            catch (Exception exception) {
                this.setAllItemsDirty(n);
            }
        }
    }

    void setAllItemsDirty(int n) {
        int[] nArray = this.getItemIDsForObjectID(n);
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                this.setItemDirty(n3);
                this.onItemEvent(n3, null);
                ++n2;
            }
        }
    }

    synchronized void handleMPXItemEvent(MPXItemEvent mPXItemEvent) {
        String string = mPXItemEvent.getEventVerb();
        if (string.equals("Modify")) {
            this.OnItemChanged(mPXItemEvent);
        } else {
            this.setItemDirty(mPXItemEvent.getItemID());
        }
    }

    private void OnItemChanged(MPXItemEvent mPXItemEvent) {
        int n = mPXItemEvent.getItemID();
        Item_Data item_Data = (Item_Data)this.getCached(n);
        if (item_Data != null) {
            boolean bl = this.getViewConfigCacheManager().isReadOnly();
            this.updateCachedProperties(n, mPXItemEvent, bl);
        }
    }

    protected void updateCachedProperties(int n, MPXPropertiesEvent mPXPropertiesEvent, boolean bl) {
        Type_Data type_Data = this.getTypeData();
        Item_Data item_Data = new Item_Data(n, type_Data);
        Enumeration enumeration = mPXPropertiesEvent.getPropertyIDs();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            if (bl && !this.isRevisionIndependent(n2)) continue;
            Object object = mPXPropertiesEvent.getValue(n2);
            item_Data.put(type_Data.indexForPid(n3), object);
        }
        this.set(item_Data);
        this.onItemEvent(n, item_Data);
    }

    private boolean isRevisionIndependent(Integer n) {
        Boolean bl = (Boolean)this.m_PidToIsRevisionIndependent.get(n);
        return bl == null ? false : bl;
    }

    protected void setItemDirty(int n) {
        Item_Data item_Data = (Item_Data)this.getCached(n);
        if (item_Data != null) {
            item_Data.setDirty(true);
        }
    }

    private void onItemEvent(int n, Item_Data item_Data) {
        MPXEventQueue[] mPXEventQueueArray = this.getEventQueues();
        int n2 = 0;
        while (n2 < mPXEventQueueArray.length) {
            MPXEventQueue mPXEventQueue = mPXEventQueueArray[n2];
            Item_Cache item_Cache = this;
            if (item_Cache == null) {
                throw null;
            }
            mPXEventQueue.postEvent(new Runnable(item_Cache, mPXEventQueue, n, item_Data){
                private final /* synthetic */ Item_Cache this$0;
                private final /* synthetic */ MPXEventQueue val$Q;
                private final /* synthetic */ int val$itemID;
                private final /* synthetic */ Item_Data val$data;

                public void run() {
                    Item_Cache.access$0(this.this$0, this.val$Q, this.val$itemID, this.val$data);
                }
                {
                    this.val$Q = mPXEventQueue;
                    this.val$itemID = n;
                    this.val$data = item_Data;
                    this.this$0 = item_Cache;
                    this.constructor$0(item_Cache);
                }

                private final void constructor$0(Item_Cache item_Cache) {
                }
            });
            ++n2;
        }
    }

    private MPXEventQueue[] getEventQueues() {
        return this.m_mgr.getServerCacheManager().getEventQueues();
    }

    private void invokeMPXItemEventMarshalers(MPXEventQueue mPXEventQueue, int n, Item_Data item_Data) {
        Vector vector = this.m_MPXItemEventMarshalers;
        synchronized (vector) {
            Enumeration enumeration = this.m_MPXItemEventMarshalers.elements();
            while (enumeration.hasMoreElements()) {
                MPXItemEvent_Marshaler mPXItemEvent_Marshaler = (MPXItemEvent_Marshaler)enumeration.nextElement();
                if (mPXItemEvent_Marshaler.getEventQueue() != mPXEventQueue) continue;
                mPXItemEvent_Marshaler.handleMPXItemEvent(n, item_Data);
            }
        }
    }

    public void addMPXItemEventMarshaler(MPXItemEvent_Marshaler mPXItemEvent_Marshaler) {
        Vector vector = this.m_MPXItemEventMarshalers;
        synchronized (vector) {
            this.m_MPXItemEventMarshalers.addElement(mPXItemEvent_Marshaler);
        }
    }

    public void removeMPXItemEventMarshaler(MPXItemEvent_Marshaler mPXItemEvent_Marshaler) {
        Vector vector = this.m_MPXItemEventMarshalers;
        synchronized (vector) {
            this.m_MPXItemEventMarshalers.removeElement(mPXItemEvent_Marshaler);
        }
    }

    static /* synthetic */ void access$0(Item_Cache item_Cache, MPXEventQueue mPXEventQueue, int n, Item_Data item_Data) {
        item_Cache.invokeMPXItemEventMarshalers(mPXEventQueue, n, item_Data);
    }

    public Item_Cache(ItemType_CacheManager itemType_CacheManager, Type_Data type_Data) {
        super(itemType_CacheManager.getServerCacheManager(), type_Data);
        this.m_mgr = itemType_CacheManager;
    }

    class Repository {
        private View m_view = null;
        private BitSet m_bits = null;
        private boolean m_bRefresh = false;

        public View getView() {
            return this.m_view;
        }

        public BitSet getBits() {
            return this.m_bits;
        }

        public boolean isRefresh() {
            return this.m_bRefresh;
        }

        public Repository(View view, BitSet bitSet, boolean bl) {
            this.m_view = view;
            this.m_bits = bitSet;
            this.m_bRefresh = bl;
        }
    }
}

