/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ByteArrayCollection;
import com.starbase.starteam.DoubleCollection;
import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.IntArrayCollection;
import com.starbase.starteam.IntCollection;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.MergeSort;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;
import com.starbase.starteam.TextCollection;
import com.starbase.starteam.TimeCollection;
import com.starbase.util.Assert;

class ItemListSortCollection
implements MergeSort.MergeSortCollection {
    private int m_length;
    private Item[] m_scratchpad;
    private ItemList m_items;
    private PropertySortCollection[] m_data;

    public void sort(GroupSortInfo[] groupSortInfoArray) {
        if (this.m_items == null) {
            return;
        }
        int n = this.m_items.size();
        if (n == 0) {
            return;
        }
        this.m_length = n;
        this.m_scratchpad = new Item[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_scratchpad[n2] = this.m_items.getAt(n2);
            ++n2;
        }
        this.m_data = new PropertySortCollection[groupSortInfoArray.length];
        n2 = 0;
        while (n2 < groupSortInfoArray.length) {
            this.m_data[n2] = ItemListSortCollection.createColumn(this.m_items, groupSortInfoArray[n2]);
            ++n2;
        }
        MergeSort.sort(this);
    }

    public int length() {
        return this.m_length;
    }

    public void swap(int n, int n2) {
        Item item = this.m_items.getAt(n);
        this.m_items.setAt(this.m_items.getAt(n2), n);
        this.m_items.setAt(item, n2);
        int n3 = 0;
        while (n3 < this.m_data.length) {
            this.m_data[n3].swap(n, n2);
            ++n3;
        }
    }

    public void copySequence(int n, int n2) {
        int n3 = n;
        while (n3 < n - n2) {
            this.m_items.setAt(this.m_scratchpad[n], n);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_data.length) {
            this.m_data[n3].copySequence(n, n2);
            ++n3;
        }
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_items.setAt(this.m_scratchpad[n], n2);
        int n3 = 0;
        while (n3 < this.m_data.length) {
            this.m_data[n3].setFromScratchpad(n, n2);
            ++n3;
        }
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_items.getAt(n);
        int n3 = 0;
        while (n3 < this.m_data.length) {
            this.m_data[n3].saveToScratchpad(n, n2);
            ++n3;
        }
    }

    public int compareScratchpad(int n, int n2) {
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = this.m_data[n3].compareScratchpad(n, n2);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = this.m_data[n3].compare(n, n2);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    private static PropertySortCollection createColumn(ItemList itemList, GroupSortInfo groupSortInfo) {
        Property property = itemList.getAt(0).getType().propertyForPID(groupSortInfo.getPropertyID());
        switch (property.getTypeCode()) {
            case 9: {
                return new ByteArrayCollection(itemList, groupSortInfo, property);
            }
            case 11: {
                return new IntArrayCollection(itemList, groupSortInfo, property);
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                if (groupSortInfo.isByTextValue()) {
                    return new TextCollection(itemList, groupSortInfo, property);
                }
                return new IntCollection(itemList, groupSortInfo, property);
            }
            case 5: {
                return new IntCollection(itemList, groupSortInfo, property);
            }
            case 1: {
                return new IntCollection(itemList, groupSortInfo, property);
            }
            case 6: {
                return new DoubleCollection(itemList, groupSortInfo, property);
            }
            case 8: {
                return new TextCollection(itemList, groupSortInfo, property);
            }
            case 7: {
                return new TimeCollection(itemList, groupSortInfo, property);
            }
        }
        Assert.internalError("ItemListSortCollection.createColumn(), prop.getTypeCode()=" + property.getTypeCode());
        return null;
    }

    public ItemListSortCollection(ItemList itemList) {
        this.m_items = itemList;
        this.m_length = this.m_items.size();
    }
}

