/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.CmdAddGroup;
import com.starbase.starteam.CmdGetGroupMemberIDs;
import com.starbase.starteam.CmdModifyGroup;
import com.starbase.starteam.CmdRemoveGroup;
import com.starbase.starteam.GroupAccount_Data;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.UserAccount;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import com.starbase.util.QuickSort;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GroupAccount
extends CacheRef {
    private static final int SCOPE_SELF = 1;
    private static final int SCOPE_PARENT_GROUP = 2;
    private static final int SCOPE_MEMBER_USERS = 4;
    private static final int SCOPE_MEMBER_GROUPS = 8;
    private static final int SCOPE_ALL = -1;
    private Server m_server;
    private GroupAccount m_parent = null;
    private Hashtable m_subgroups = new Hashtable();
    private Hashtable m_users = new Hashtable();
    private Vector m_memberUserIDs = null;
    private GroupAccount_Data m_newData = null;

    private GroupAccount_Data getData() {
        return this.m_newData == null ? (GroupAccount_Data)this.getCachedObject() : this.m_newData;
    }

    private GroupAccount_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = (GroupAccount_Data)this.getData().copy();
        }
        return this.m_newData;
    }

    private boolean isDirty() {
        return this.isNew() || this.m_newData != null;
    }

    public GroupAccount copy() {
        GroupAccount groupAccount = new GroupAccount(this.m_server, (GroupAccount_Data)this.getData().copy());
        groupAccount.m_parent = this.m_parent;
        groupAccount.m_subgroups = this.m_subgroups;
        groupAccount.m_users = this.m_users;
        groupAccount.m_memberUserIDs = this.m_memberUserIDs;
        return groupAccount;
    }

    private boolean isUserInfoPublic() {
        return this.m_server.getSupportedFeatures().hasGroupMembers();
    }

    public boolean isNew() {
        return this.getData().isNew();
    }

    public boolean isDeleted() {
        return this.getData().isDeleted();
    }

    void setDeleted(boolean bl) {
        this.getNewData().setDeleted(bl);
    }

    public int getID() {
        return this.getData().getID();
    }

    void setID(int n) {
        this.getNewData().setID(n);
    }

    public String getName() {
        return this.getData().getName();
    }

    public void setName(String string) {
        this.getNewData().setName(string);
    }

    public String getFullName() {
        String string = this.getName();
        GroupAccount groupAccount = this.getParent();
        if (groupAccount != null && !groupAccount.isRoot()) {
            string = groupAccount.getFullName() + "\\" + string;
        }
        return string;
    }

    public String getDescription() {
        return this.getData().getDescription();
    }

    public void setDescription(String string) {
        this.getNewData().setDescription(string);
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public GroupAccount getParent() {
        return this.m_parent;
    }

    int getParentID() {
        return this.getData().getParentID();
    }

    public void setParent(GroupAccount groupAccount) {
        if (groupAccount != this.m_parent) {
            if (this.m_parent != null) {
                this.m_parent.removeGroupAccount(this);
            }
            this.m_parent = groupAccount;
            if (this.m_parent != null) {
                this.m_parent.addGroupAccount(this);
                if (this.getParentID() != this.m_parent.getID()) {
                    this.getNewData().setParentID(this.m_parent.getID());
                }
            } else if (this.getParentID() != -1) {
                this.getNewData().setParentID(-1);
            }
        }
    }

    public int getPermissionsFlags() {
        return this.getData().getPermissionsFlags();
    }

    public boolean hasPermission(int n) {
        return this.getData().hasPermission(n);
    }

    public void addPermission(int n) {
        this.getNewData().addPermission(n);
    }

    public void removePermission(int n) {
        this.getNewData().removePermission(n);
    }

    public Server getServer() {
        return this.m_server;
    }

    public GroupAccount[] getSubGroupAccounts() {
        GroupAccount[] groupAccountArray = new GroupAccount[this.m_subgroups.size()];
        int n = 0;
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            groupAccountArray[n++] = (GroupAccount)enumeration.nextElement();
        }
        return groupAccountArray;
    }

    public UserAccount[] getUserAccounts() {
        UserAccount[] userAccountArray;
        if (!this.isNew()) {
            userAccountArray = this.getServer().getAdministration();
            userAccountArray.populateAccounts();
        }
        userAccountArray = new UserAccount[this.m_users.size()];
        int n = 0;
        Enumeration enumeration = this.m_users.elements();
        while (enumeration.hasMoreElements()) {
            userAccountArray[n++] = (UserAccount)enumeration.nextElement();
        }
        return userAccountArray;
    }

    public boolean isMember(int n) {
        return this.isUserInfoPublic() ? this.isMember_USERIDS_MADE_PUBLIC(n) : this.isMemberOld(n);
    }

    boolean isMemberOld(int n) {
        UserAccount[] userAccountArray = this.getUserAccounts();
        int n2 = userAccountArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UserAccount userAccount = userAccountArray[n3];
            if (userAccount.getID() == n) {
                return true;
            }
            ++n3;
        }
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            if (!((GroupAccount)enumeration.nextElement()).isMemberOld(n)) continue;
            return true;
        }
        return false;
    }

    boolean isMember_USERIDS_MADE_PUBLIC(int n) {
        if (this.getMemberUserIDs().contains(new Integer(n))) {
            return true;
        }
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            if (!((GroupAccount)enumeration.nextElement()).isMember_USERIDS_MADE_PUBLIC(n)) continue;
            return true;
        }
        return false;
    }

    public void update() throws IllegalStateException {
        if (!this.isDirty()) {
            return;
        }
        if (this.isNew()) {
            if (this.isRoot()) {
                throw new IllegalStateException(Res.getString(ResIDs.NULL_PARENT_GROUP));
            }
            CmdAddGroup cmdAddGroup = new CmdAddGroup(this.m_server, this);
            cmdAddGroup.execute();
            GroupAccount groupAccount = this.getParent();
            groupAccount.removeGroupAccountByID(-1);
            groupAccount.addGroupAccount(this);
        } else {
            CmdModifyGroup cmdModifyGroup = new CmdModifyGroup(this.m_server, this);
            cmdModifyGroup.execute();
        }
        this.setCachedObject(this.getData());
        this.m_newData = null;
    }

    public void remove() throws IllegalStateException {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.GROUP_IS_NEW));
        }
        if (!this.canRemove()) {
            if (this.isBuiltin()) {
                throw new IllegalStateException(Res.getString(ResIDs.GROUP_NO_REMOVE_BUILT_IN));
            }
            throw new IllegalStateException(Res.getString(ResIDs.GROUP_NO_GROUP_MEMBERSHIP));
        }
        Vector vector = new Vector();
        this.findAllGroups(vector);
        int n = 0;
        while (n < vector.size()) {
            GroupAccount groupAccount = (GroupAccount)vector.elementAt(n);
            Server server = groupAccount.getServer();
            CmdRemoveGroup cmdRemoveGroup = new CmdRemoveGroup(groupAccount.getID());
            cmdRemoveGroup.execute(server.useConnection(), server.getSession().getID(), 0, 0);
            groupAccount.setDeleted(true);
            groupAccount.m_parent.removeGroupAccount(groupAccount);
            groupAccount.setParent(null);
            UserAccount[] userAccountArray = groupAccount.getUserAccounts();
            int n2 = 0;
            while (n2 < userAccountArray.length) {
                UserAccount userAccount = userAccountArray[n2];
                userAccount.removeFromGroupAccount(groupAccount);
                userAccount.update();
                ++n2;
            }
            ++n;
        }
    }

    public boolean canRemove() {
        if (this.isBuiltin()) {
            return false;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.findAllGroupsAndUsers(vector, vector2);
        int n = 0;
        while (n < vector2.size()) {
            if (this.wouldOrphanUser((UserAccount)vector2.elementAt(n), vector)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isBuiltin() {
        return this.getData().isBuiltin();
    }

    private void findAllGroupsAndUsers(Vector vector, Vector vector2) {
        if (!vector.contains(this)) {
            vector.addElement(this);
        }
        UserAccount[] userAccountArray = this.getUserAccounts();
        int n = 0;
        while (n < userAccountArray.length) {
            if (!vector2.contains(userAccountArray[n])) {
                vector2.addElement(userAccountArray[n]);
            }
            ++n;
        }
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            ((GroupAccount)enumeration.nextElement()).findAllGroupsAndUsers(vector, vector2);
        }
    }

    private void findAllGroups(Vector vector) {
        if (!vector.contains(this)) {
            vector.addElement(this);
        }
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            ((GroupAccount)enumeration.nextElement()).findAllGroups(vector);
        }
    }

    private boolean wouldOrphanUser(UserAccount userAccount, Vector vector) {
        GroupAccount[] groupAccountArray = userAccount.getGroupAccounts();
        int n = 0;
        while (n < groupAccountArray.length) {
            if (!vector.contains(groupAccountArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void readGroupAccount(Command command) throws IOException {
        this.getData().read(command);
    }

    void writeGroupAccount(Command command) throws IOException {
        this.getData().write(command);
    }

    private void addGroupAccount(GroupAccount groupAccount) {
        Integer n = new Integer(groupAccount.getID());
        if (!this.m_subgroups.containsKey(n)) {
            this.m_subgroups.put(n, groupAccount);
        }
    }

    private boolean hasGroupAccount(GroupAccount groupAccount) {
        return this.m_subgroups.containsKey(new Integer(groupAccount.getID()));
    }

    private void removeGroupAccount(GroupAccount groupAccount) {
        this.removeGroupAccountByID(groupAccount.getID());
    }

    void removeGroupAccountByID(int n) {
        this.m_subgroups.remove(new Integer(n));
    }

    void print(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n * 4) {
            stringBuffer.append(" ");
            ++n2;
        }
        String string = stringBuffer.toString();
        System.out.println(string + this.getName());
        UserAccount[] userAccountArray = this.getUserAccounts();
        int n3 = 0;
        while (n3 < userAccountArray.length) {
            System.out.println(string + "  *" + userAccountArray[n3].getName());
            ++n3;
        }
        Enumeration enumeration = this.m_subgroups.elements();
        while (enumeration.hasMoreElements()) {
            ((GroupAccount)enumeration.nextElement()).print(n + 1);
        }
    }

    static void printTest(GroupAccount[] groupAccountArray) {
        int n = 0;
        while (n < groupAccountArray.length) {
            if (groupAccountArray[n].getParent() == null) {
                groupAccountArray[n].print(0);
            }
            ++n;
        }
    }

    void addUserAccount(UserAccount userAccount) {
        Integer n = new Integer(userAccount.getID());
        if (!this.m_users.containsKey(n)) {
            this.m_users.put(n, userAccount);
        }
        if (!this.getMemberUserIDs().contains(n)) {
            this.getMemberUserIDs().addElement(n);
        }
    }

    void removeUserAccount(UserAccount userAccount) {
        this.removeUserAccountByID(userAccount.getID());
    }

    void removeUserAccountByID(int n) {
        Integer n2 = new Integer(n);
        this.m_users.remove(n2);
        this.getMemberUserIDs().removeElement(n2);
    }

    private Vector getMemberUserIDs() {
        if (this.m_memberUserIDs == null) {
            if (this.isUserInfoPublic()) {
                this.setUserIDs(this.fetchMemberUserIDs(false));
            } else {
                this.m_memberUserIDs = new Vector();
            }
        }
        return this.m_memberUserIDs;
    }

    private void setUserIDs(int[] nArray) {
        this.m_memberUserIDs = new Vector();
        int n = 0;
        while (n < nArray.length) {
            this.m_memberUserIDs.addElement(new Integer(nArray[n]));
            ++n;
        }
    }

    int[] getUserIDs() {
        Vector vector = this.getMemberUserIDs();
        int n = vector.size();
        int[] nArray = new int[n];
        Object[] objectArray = new Integer[n];
        vector.copyInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)objectArray[n2];
            ++n2;
        }
        return nArray;
    }

    private int[] getIntArray(Hashtable hashtable) {
        int n = hashtable.size();
        Enumeration enumeration = hashtable.elements();
        int n2 = n;
        int[] nArray = new int[n];
        while (enumeration.hasMoreElements()) {
            nArray[--n2] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    private void getUserIDsFromAccounts(boolean bl, Hashtable hashtable) {
        int[] nArray = this.getUserIDsFromAccounts(false);
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            hashtable.put(n2, n2);
            ++n;
        }
        GroupAccount[] groupAccountArray = this.getSubGroupAccounts();
        int n3 = 0;
        while (n3 < groupAccountArray.length) {
            groupAccountArray[n3].getUserIDsFromAccounts(bl, hashtable);
            ++n3;
        }
    }

    int[] getUserIDsFromAccounts(boolean bl) {
        if (bl) {
            Hashtable hashtable = new Hashtable();
            this.getUserIDsFromAccounts(bl, hashtable);
            return this.getIntArray(hashtable);
        }
        UserAccount[] userAccountArray = this.getUserAccounts();
        int[] nArray = new int[userAccountArray.length];
        int n = 0;
        while (n < userAccountArray.length) {
            nArray[n] = userAccountArray[n].getID();
            ++n;
        }
        return nArray;
    }

    private void hashtablePutAll(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            hashtable2.put(v, v);
        }
    }

    private void getUserIDsFromFetchedHahstables(boolean bl, Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = (Hashtable)hashtable2.get(new Integer(this.getID()));
        this.hashtablePutAll(hashtable3, hashtable);
        if (bl) {
            GroupAccount[] groupAccountArray = this.getSubGroupAccounts();
            int n = 0;
            while (n < groupAccountArray.length) {
                groupAccountArray[n].getUserIDsFromFetchedHahstables(bl, hashtable, hashtable2);
                ++n;
            }
        }
    }

    int[] fetchMemberUserIDs(boolean bl) {
        if (bl) {
            CmdGetGroupMemberIDs cmdGetGroupMemberIDs = new CmdGetGroupMemberIDs(this.m_server, -1);
            cmdGetGroupMemberIDs.execute();
            int[][] nArray = cmdGetGroupMemberIDs.getMemberIDs();
            int[] nArray2 = cmdGetGroupMemberIDs.getIDs();
            Hashtable hashtable = new Hashtable();
            int n = 0;
            while (n < nArray.length) {
                Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
                int[] nArray3 = nArray[n];
                int n2 = 0;
                while (n2 < nArray3.length) {
                    Integer n3 = new Integer(nArray3[n2]);
                    hashtable2.put(n3, n3);
                    ++n2;
                }
                hashtable.put(new Integer(nArray2[n]), hashtable2);
                ++n;
            }
            Hashtable hashtable3 = new Hashtable();
            this.getUserIDsFromFetchedHahstables(bl, hashtable3, hashtable);
            return this.getIntArray(hashtable3);
        }
        CmdGetGroupMemberIDs cmdGetGroupMemberIDs = new CmdGetGroupMemberIDs(this.m_server, this.getID());
        cmdGetGroupMemberIDs.execute();
        return cmdGetGroupMemberIDs.getMemberIDs()[0];
    }

    public boolean isEqualTo(GroupAccount groupAccount) {
        return this.isEqualTo(groupAccount, 1);
    }

    private boolean isEqualTo(GroupAccount groupAccount, int n) {
        int n2;
        int n3;
        boolean bl;
        if (groupAccount == null) {
            return false;
        }
        if ((n & 1) != 0 && !this.getData().isEqualTo(groupAccount.getData())) {
            return false;
        }
        if ((n & 2) != 0 && this.isRoot() == groupAccount.isRoot() && !this.isRoot() && this.getParentID() != groupAccount.getParentID()) {
            return false;
        }
        GroupAccount[] groupAccountArray = null;
        GroupAccount[] groupAccountArray2 = null;
        UserAccount[] userAccountArray = null;
        UserAccount[] userAccountArray2 = null;
        if ((n & 8) != 0 && (groupAccountArray = this.getSubGroupAccounts()).length != (groupAccountArray2 = groupAccount.getSubGroupAccounts()).length) {
            return false;
        }
        if ((n & 4) != 0 && (userAccountArray = this.getUserAccounts()).length != (userAccountArray2 = groupAccount.getUserAccounts()).length) {
            return false;
        }
        if ((n & 8) != 0) {
            bl = false;
            n3 = groupAccountArray.length;
            int n4 = 0;
            while (n4 < n3) {
                if (groupAccountArray[n4].getID() != groupAccountArray2[n4].getID()) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) {
                int[] nArray = new int[n3];
                int n5 = 0;
                while (n5 < n3) {
                    nArray[n5] = groupAccountArray[n5].getID();
                    ++n5;
                }
                int[] nArray2 = new int[n3];
                n2 = 0;
                while (n2 < n3) {
                    nArray2[n2] = groupAccountArray2[n2].getID();
                    ++n2;
                }
                QuickSort.sortInts(nArray);
                QuickSort.sortInts(nArray2);
                n2 = 0;
                while (n2 < n3) {
                    if (nArray[n2] != nArray2[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        if ((n & 4) != 0) {
            bl = false;
            n3 = userAccountArray.length;
            int n6 = 0;
            while (n6 < userAccountArray.length) {
                if (userAccountArray[n6].getID() != userAccountArray2[n6].getID()) {
                    return false;
                }
                ++n6;
            }
            if (bl) {
                int[] nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = userAccountArray[n7].getID();
                    ++n7;
                }
                int[] nArray3 = new int[n3];
                n2 = 0;
                while (n2 < n3) {
                    nArray3[n2] = userAccountArray2[n2].getID();
                    ++n2;
                }
                QuickSort.sortInts(nArray);
                QuickSort.sortInts(nArray3);
                n2 = 0;
                while (n2 < n3) {
                    if (nArray[n2] != nArray3[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    GroupAccount(Server server, GroupAccount_Data groupAccount_Data) {
        super(groupAccount_Data);
        this.m_server = server;
    }

    public GroupAccount(Server server) {
        super(new GroupAccount_Data());
        if (server == null) {
            Assert.nullArgument("Server");
        }
        this.m_server = server;
    }
}

