/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Folder_Cmd_GetTipProperties;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemType_CacheManager;
import com.starbase.starteam.Item_Cache;
import com.starbase.starteam.Item_Cmd_GetData;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.Type_Data;
import com.starbase.starteam.View;
import com.starbase.starteam.View_Cmd_GetFolders;
import com.starbase.util.Assert;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Folder_Cache
extends Item_Cache {
    Hashtable m_foldersByID = null;

    public synchronized boolean isRefreshFoldersRequired(Vector vector) {
        if (!this.isMPXAvailable()) {
            return true;
        }
        int n = 0;
        while (n < vector.size()) {
            Folder folder = (Folder)vector.elementAt(n);
            if (this.m_mgr.isRefreshItemListRequired(folder, folder.m_timestampIDs)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean isRefreshPropertiesRequired(Vector vector, BitSet bitSet) {
        if (!this.isMPXAvailable()) {
            return true;
        }
        return this.checkRefresh(vector, bitSet, null);
    }

    public boolean isRefreshRequired(Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            if (this.isRefreshFoldersRequired(vector)) {
                return true;
            }
            Folder folder = (Folder)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(folder.getType(), stringArray);
            return this.isRefreshPropertiesRequired(vector, bitSet);
        }
        return false;
    }

    public synchronized void refreshSubtree(Folder folder, String[] stringArray, int n) {
        View view = folder.getView();
        Vector vector = new Vector();
        Folder.flattenFolderTree(folder, vector, n);
        this.refresh(view, vector, stringArray);
    }

    public synchronized void refreshProperties(View view, Vector vector, BitSet bitSet) {
        Item_Cache.Repository repository = this.getRepository(view);
        if (this.isRefreshPropertiesRequired(vector, bitSet)) {
            int n = 0;
            int[] nArray = new int[vector.size()];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = ((Folder)vector.elementAt(n)).getItemID();
                ++n;
            }
            Cacheable[] cacheableArray = this.get((Object)repository, nArray);
            this.updateInPlace(repository, vector, cacheableArray);
            long l = this.m_mgr.getServerCacheManager().getTimestamp();
            n = 0;
            while (n < vector.size()) {
                Folder folder = (Folder)vector.elementAt(n);
                folder.getCachedObject().setDirty(false);
                folder.m_timestampProperties = l;
                ++n;
            }
        }
    }

    public void refreshProperties(View view, Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Folder folder = (Folder)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(folder.getType(), stringArray);
            this.refreshProperties(view, vector, bitSet);
        }
    }

    public synchronized long refreshItems(View view, Vector vector) {
        if (vector.size() == 0 || this.isRefreshFoldersRequired(vector)) {
            int n = 0;
            Folder folder = null;
            Hashtable<Integer, Folder> hashtable = new Hashtable<Integer, Folder>();
            n = 0;
            while (n < vector.size()) {
                folder = (Folder)vector.elementAt(n);
                hashtable.put(new Integer(folder.getItemID()), folder);
                ++n;
            }
            int[] nArray = this.fetchAllIDs(view, hashtable);
            this.resolveReferencesToIDs(vector, nArray);
            long l = this.m_mgr.getServerCacheManager().getTimestamp();
            vector.removeAllElements();
            n = 0;
            while (n < nArray.length) {
                folder = (Folder)this.m_foldersByID.get(new Integer(nArray[n]));
                this.set(folder.getCacheData());
                vector.addElement(folder);
                folder.m_timestampIDs = l;
                folder.getCachedObject().setDirty(false);
                folder.m_timestampProperties = l;
                ++n;
            }
        }
        this.cleanupTempFolders();
        return this.getIDsLastModified();
    }

    public synchronized void refresh(View view, Vector vector, BitSet bitSet) {
        this.refreshItems(view, vector);
        this.refreshProperties(view, vector, bitSet);
    }

    public void refresh(View view, Vector vector, String[] stringArray) {
        if (vector.size() > 0) {
            Folder folder = (Folder)vector.elementAt(0);
            BitSet bitSet = this.getBitsForPropertyNames(folder.getType(), stringArray);
            this.refresh(view, vector, bitSet);
        }
    }

    public boolean checkRefresh(Vector vector, BitSet bitSet, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            Item_Data item_Data = (Item_Data)item.getCachedObject();
            if (!item_Data.isDirty() && item_Data.hasValues(bitSet)) continue;
            if (vector2 == null) {
                return true;
            }
            vector2.addElement(item);
        }
        return vector2 != null && vector2.size() > 0;
    }

    protected int[] fetchAllIDs(Object object) {
        return this.fetchAllIDs(object, null);
    }

    protected Cacheable[] fetch(Object object, int[] nArray) {
        Cacheable[] cacheableArray;
        Item_Cache.Repository repository = this.getRepository(object);
        View view = repository.getView();
        Server server = view.getServer();
        Type type = server.typeForName(this.getTypeName());
        BitSet bitSet = repository.getBits();
        if (nArray.length > 1) {
            cacheableArray = Item_Cmd_GetData.fetch(view, type, nArray, bitSet);
        } else {
            Item_Data item_Data = Folder_Cmd_GetTipProperties.fetch(view, nArray[0]);
            cacheableArray = new Item_Data[]{item_Data};
        }
        return cacheableArray;
    }

    protected CacheRef newCacheRef(Object object, Cacheable cacheable) {
        Item_Data item_Data = (Item_Data)cacheable;
        Folder folder = (Folder)this.m_foldersByID.get(new Integer(item_Data.getID()));
        folder.setCachedObject(item_Data);
        return folder;
    }

    private int[] fetchAllIDs(Object object, Hashtable hashtable) {
        View view = this.getRepository(object).getView();
        Server server = view.getServer();
        Folder folder = View_Cmd_GetFolders.execute(server, view, hashtable);
        Vector vector = new Vector();
        Folder.flattenFolderTree(folder, vector, -1);
        this.cleanupTempFolders();
        this.m_foldersByID = new Hashtable();
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < nArray.length) {
            int n2;
            Folder folder2 = (Folder)vector.elementAt(n);
            nArray[n] = n2 = folder2.getItemID();
            this.m_foldersByID.put(new Integer(n2), folder2);
            ++n;
        }
        this.setIDsModified();
        return nArray;
    }

    private Item_Cache.Repository getRepository(Object object) {
        if (object instanceof Item_Cache.Repository) {
            return (Item_Cache.Repository)object;
        }
        if (object instanceof View) {
            View view = (View)object;
            Server server = view.getServer();
            Type type = server.typeForName(server.getTypeNames().FOLDER);
            Folder_Cache folder_Cache = this;
            if (folder_Cache == null) {
                throw null;
            }
            return new Item_Cache.Repository(folder_Cache, view, this.getBitsForPropertyNames(type, null), true);
        }
        Assert.internalError("Folder_Cache.getRepository()");
        return (Item_Cache.Repository)object;
    }

    private void cleanupTempFolders() {
        if (this.m_foldersByID != null) {
            this.m_foldersByID.clear();
        }
    }

    public Folder_Cache(ItemType_CacheManager itemType_CacheManager, Type_Data type_Data) {
        super(itemType_CacheManager, type_Data);
    }
}

