/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.DirectoryOverrides;
import com.starbase.starteam.Folder;
import com.starbase.starteam.OverrideProperties;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.starteam.StatusMethod;
import com.starbase.starteam.View;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

class FolderTreeReaderImpl {
    private DirectoryOverrides m_dirmap = null;
    private StarTeamClientOptions m_opts = null;
    private Server m_server;
    private View m_view;
    private Folder m_rootFolder;
    private Hashtable m_folders;

    public void start() throws IOException {
        this.m_rootFolder = null;
    }

    public Folder readFolder(Command command) throws IOException {
        Folder folder = Folder.read(command, this.m_server, this.m_view, this.m_folders);
        if (this.m_rootFolder == null) {
            this.m_rootFolder = folder;
            this.m_rootFolder.setParentFolder(null);
        }
        this.doFolderOverride(folder);
        return folder;
    }

    public void setChildren(Folder folder, Folder[] folderArray) throws IOException {
        folder.setChildren(folderArray);
    }

    public void end() throws IOException {
        this.doViewOverride();
    }

    private void doViewOverride() throws IOException {
        Object object;
        String string = null;
        if (this.m_dirmap != null && (object = this.m_dirmap.getViewOverrideProperties(this.m_view)) != null) {
            string = ((OverrideProperties)object).getPathOverride();
        }
        this.m_rootFolder.setAlternatePathFragment(string);
        object = this.m_opts.getViewStatusMethodOverride(this.m_view);
        if (object != null) {
            this.m_view.setStatusMethodOverride((StatusMethod)object);
        } else {
            this.m_view.setStatusMethodOverride(StatusMethod.DEFAULT);
        }
        StatusMethod statusMethod = this.m_opts.getDefaultStatusMethod();
        if (statusMethod == null) {
            statusMethod = StatusMethod.CENTRAL;
        }
        StatusMethod.setDefaultStatusMethod(statusMethod);
        String string2 = this.m_opts.getCentralStatusDirectory();
        if (string2 != null) {
            StatusMethod.setCentralStatusDirectory(string2);
        }
    }

    protected void doFolderOverride(Folder folder) {
        if (this.m_dirmap == null) {
            return;
        }
        OverrideProperties overrideProperties = this.m_dirmap.getFolderOverrideProperties(folder);
        if (overrideProperties != null) {
            folder.setAlternatePathFragment(overrideProperties.getPathOverride());
            folder.setFileEOL(overrideProperties.getEOLOverride());
            folder.setCaseSensitiveFileNames(overrideProperties.getCaseSensitivityOverride());
            folder.setUserVisible(overrideProperties.getVisibleOverride());
        }
    }

    FolderTreeReaderImpl(Server server, View view, Hashtable hashtable) {
        this.m_server = server;
        this.m_view = view;
        this.m_folders = hashtable;
        this.m_dirmap = server.getClientContext().getDirectoryOverrides();
        try {
            this.m_dirmap.reloadIfNeeded();
        }
        catch (IOException iOException) {
            File file = this.m_dirmap.getSourceFile();
            if (file == null) {
                Assert.internalError("FolderTreeReaderImpl(), IOException, overrides=null");
            }
            throw new SDKRuntimeException(Res.formatKey(ResIDs.FAILED_TO_RELOAD_DIRECTORY_OVERRIDES_FMT, new Object[]{file.getPath()}), iOException);
        }
        try {
            this.m_opts = StarTeamClientOptions.getDefault();
            this.m_opts.reloadIfNeeded();
        }
        catch (IOException iOException) {
            throw new SDKRuntimeException(Res.getString(ResIDs.FAILED_TO_LOAD_STARTEAM_INI), iOException);
        }
    }
}

